/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNodeAndFunctionFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public abstract class EqNode
implements IEqNodeIdentifier<EqNode>,
ICongruenceClosureElement<EqNode> {
    protected final EqNodeAndFunctionFactory mEqNodeFactory;
    protected final Term mTerm;
    private final boolean mDependsOnUntrackedArray;

    public EqNode(Term term, EqNodeAndFunctionFactory eqNodeAndFunctionFactory, boolean bl) {
        assert (term != null);
        this.mTerm = term;
        this.mEqNodeFactory = eqNodeAndFunctionFactory;
        this.mDependsOnUntrackedArray = bl;
    }

    public abstract boolean isLiteral();

    public Collection<TermVariable> getFreeVariables() {
        return Arrays.asList(this.mTerm.getFreeVars());
    }

    @Override
    public Term getTerm() {
        return this.mTerm;
    }

    @Override
    public final EqNode renameVariables(Map<Term, Term> map) {
        Term term = Substitution.apply((ManagedScript)this.mEqNodeFactory.getScript(), map, (Term)this.getTerm());
        return this.mEqNodeFactory.getOrConstructNode(term);
    }

    public boolean isDependentNonFunctionApplication() {
        return false;
    }

    public Set<EqNode> getSupportingNodes() {
        throw new UnsupportedOperationException("check isDependent first");
    }

    public String toString() {
        return this.mTerm.toString();
    }

    @Override
    public Sort getSort() {
        return this.mTerm.getSort();
    }

    public boolean hasSameTypeAs(EqNode eqNode) {
        return this.mTerm.getSort().equals(eqNode.mTerm.getSort());
    }

    public EqNode getArgument() {
        throw new UnsupportedOperationException();
    }

    public EqNode replaceAppliedFunction(EqNode eqNode) {
        throw new UnsupportedOperationException();
    }

    public EqNode replaceArgument(EqNode eqNode) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean dependsOnUntrackedArray() {
        return this.mDependsOnUntrackedArray;
    }

    public final int hashCode() {
        return this.mTerm.hashCode();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        EqNode eqNode = (EqNode)object;
        return eqNode.mTerm == this.mTerm;
    }
}

