/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.TermTransducer;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.List;

public abstract class CondisTermTransducer<E>
extends TermTransducer<E> {
    protected abstract E transduceAtom(Term var1);

    protected abstract E transduceConjunction(ApplicationTerm var1, List<E> var2);

    protected abstract E transduceDisjunction(ApplicationTerm var1, List<E> var2);

    private static boolean isConjunction(Term term) {
        return term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("and");
    }

    private static boolean isDisjunction(Term term) {
        return term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("or");
    }

    @Override
    protected E transduceImmediately(Term term) {
        Object var2_2 = CondisTermTransducer.isConjunction(term) ? null : (CondisTermTransducer.isDisjunction(term) ? null : this.transduceAtom(term));
        return var2_2;
    }

    @Override
    protected E transduce(ApplicationTerm applicationTerm, List<E> list) {
        E e;
        if (CondisTermTransducer.isConjunction((Term)applicationTerm)) {
            e = this.transduceConjunction(applicationTerm, list);
        } else if (CondisTermTransducer.isDisjunction((Term)applicationTerm)) {
            e = this.transduceDisjunction(applicationTerm, list);
        } else {
            throw new AssertionError((Object)"neither conjunction nor disjunction");
        }
        return e;
    }
}

