/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cli;

import de.uni_freiburg.informatik.ultimate.cli.exceptions.InvalidFileArgumentException;
import de.uni_freiburg.informatik.ultimate.cli.options.OptionBuilder;
import de.uni_freiburg.informatik.ultimate.core.lib.toolchain.RunDefinition;
import de.uni_freiburg.informatik.ultimate.core.model.ICore;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainData;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.KeyValueUtil;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.PreferenceType;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.UltimatePreferenceItem;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import jakarta.xml.bind.JAXBException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.cli.AlreadySelectedException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.ParseException;
import org.xml.sax.SAXException;

public class ParsedParameter {
    private final CommandLine mCli;
    private final ICore<RunDefinition> mCore;
    private final ILogger mLogger;
    private final OptionBuilder mOptionFactory;
    private String mCsvPrefix;

    ParsedParameter(ICore<RunDefinition> iCore, CommandLine commandLine, OptionBuilder optionBuilder) {
        this.mCore = iCore;
        this.mCli = commandLine;
        this.mOptionFactory = optionBuilder;
        this.mLogger = iCore.getCoreLoggingService().getControllerLogger();
    }

    public void applyCliSettings(IUltimateServiceProvider iUltimateServiceProvider) throws ParseException {
        List<Option> list = Arrays.asList(this.mCli.getOptions());
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        for (Option option : list) {
            String string = option.getLongOpt();
            Triple<String, String, UltimatePreferenceItem<?>> triple = this.mOptionFactory.getUltimatePreference(string);
            if (triple == null) continue;
            String string2 = (String)triple.getFirst();
            String string3 = (String)triple.getSecond();
            UltimatePreferenceItem ultimatePreferenceItem = (UltimatePreferenceItem)triple.getThird();
            if (!linkedHashSet.add(option.getLongOpt())) {
                if (ultimatePreferenceItem.getType() == PreferenceType.KeyValue) continue;
                String string4 = String.format("You already specified option %s for an option of type %s. Only options of type %s can be specified multiple times.", string, ultimatePreferenceItem.getType(), PreferenceType.KeyValue);
                throw new AlreadySelectedException(string4);
            }
            this.applyCliSetting(string, iUltimateServiceProvider, string2, string3, ultimatePreferenceItem);
        }
    }

    private void applyCliSetting(String string, IUltimateServiceProvider iUltimateServiceProvider, String string2, String string3, UltimatePreferenceItem<?> ultimatePreferenceItem) throws ParseException {
        String string4;
        IPreferenceProvider iPreferenceProvider = iUltimateServiceProvider.getPreferenceProvider(string2);
        if (ultimatePreferenceItem.getType() == PreferenceType.KeyValue) {
            Object[] objectArray = this.getParsedOptions(string);
            string4 = KeyValueUtil.toKeyValueString((Object[])objectArray);
        } else {
            Object t = this.getParsedOption(string);
            string4 = String.valueOf(t);
        }
        this.mLogger.info((Object)("Applying setting for plugin " + string2 + ": " + string3 + " -> " + string4));
        iPreferenceProvider.put(string3, string4);
    }

    public boolean isHelpRequested() {
        return this.mCli.hasOption("h");
    }

    public boolean isVersionRequested() {
        return this.mCli.hasOption("version");
    }

    public boolean isFrontendSettingsRequested() {
        return this.mCli.hasOption("generate-frontend-json-from-defaults");
    }

    public boolean isBackendWhitelistRequested() {
        return this.mCli.hasOption("generate-backend-json-from-defaults");
    }

    public boolean isFrontendSettingsDeltaRequested() {
        return this.mCli.hasOption("generate-frontend-json-from-delta");
    }

    public boolean isBackendWhitelistDeltaRequested() {
        return this.mCli.hasOption("generate-backend-json-from-delta");
    }

    public boolean showExperimentals() {
        return this.mCli.hasOption("experimental");
    }

    public String getSettingsFile() throws ParseException, InvalidFileArgumentException {
        File file = (File)this.getParsedOption("s");
        ParsedParameter.checkFileReadable(file, "settings");
        return file.getAbsolutePath();
    }

    public boolean hasSettings() {
        return this.mCli.hasOption("s");
    }

    public boolean hasToolchain() {
        return this.mCli.hasOption("tc");
    }

    public boolean hasInputFiles() {
        return this.mCli.hasOption("i");
    }

    public boolean generateCsvs() {
        return this.mCli.hasOption("generate-csv");
    }

    private boolean hasCsvDirectory() {
        return this.mCli.hasOption("csv-dir");
    }

    public String getCsvPrefix() throws ParseException, InvalidFileArgumentException {
        if (this.generateCsvs() && this.mCsvPrefix == null) {
            this.mCsvPrefix = this.generateCsvPrefix();
        }
        return this.mCsvPrefix;
    }

    public File getCsvDirectory() throws ParseException, InvalidFileArgumentException {
        File file = (File)this.getParsedOption("csv-dir");
        ParsedParameter.checkFileRW(file, "csv-dir");
        return file;
    }

    public File getToolchainFile() throws ParseException, InvalidFileArgumentException {
        File file = (File)this.getParsedOption("tc");
        ParsedParameter.checkFileReadable(file, "toolchain");
        return file;
    }

    public IToolchainData<RunDefinition> createToolchainData() throws InvalidFileArgumentException, ParseException {
        File file = this.getToolchainFile();
        try {
            return this.mCore.createToolchainData(file.getAbsolutePath());
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new InvalidFileArgumentException("Toolchain file not found at specified path: " + file.getAbsolutePath());
        }
        catch (JAXBException | SAXException throwable) {
            throw new InvalidFileArgumentException("Toolchain file at path " + file.getAbsolutePath() + " was malformed: " + throwable.getMessage());
        }
    }

    public File[] getInputFiles() throws InvalidFileArgumentException, ParseException {
        File[] fileArray;
        try {
            fileArray = this.getInputFileArgument();
        }
        catch (IOException iOException) {
            throw new InvalidFileArgumentException(iOException.getMessage(), iOException);
        }
        if (fileArray == null || fileArray.length == 0) {
            throw new InvalidFileArgumentException("No input file specified");
        }
        return fileArray;
    }

    private String generateCsvPrefix() throws ParseException, InvalidFileArgumentException {
        String string = this.hasCsvDirectory() ? this.getCsvDirectory().getAbsolutePath() : new File(".").getAbsolutePath();
        ArrayList<File> arrayList = new ArrayList<File>(Arrays.asList(this.getInputFiles()));
        if (this.hasSettings()) {
            arrayList.add(new File(this.getSettingsFile()));
        }
        arrayList.add(this.getToolchainFile());
        String string2 = arrayList.stream().map(File::getName).collect(Collectors.joining("_"));
        return Paths.get(string, string2).toString();
    }

    private File[] getInputFileArgument() throws IOException {
        String[] stringArray = this.mCli.getOptionValues("i");
        ArrayList<File> arrayList = new ArrayList<File>();
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                String string = stringArray2[n2];
                if (string.contains("*")) {
                    int n3 = string.indexOf("*");
                    Throwable throwable = null;
                    Object var9_10 = null;
                    try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(Paths.get(string.substring(0, n3 - 1), new String[0]), string.substring(n3));){
                        directoryStream.forEach(path -> {
                            boolean bl = arrayList.add(path.toFile());
                        });
                        break block11;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                arrayList.add(new File(string));
            }
            ++n2;
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    private static void checkFileReadable(File file, String string) throws InvalidFileArgumentException {
        if (file == null) {
            throw new IllegalArgumentException("file");
        }
        if (!file.exists()) {
            throw new InvalidFileArgumentException("Argument of \"" + string + "\" has invalid value \"" + file.getAbsolutePath() + "\": File/Dir does not exist");
        }
        if (!file.canRead()) {
            throw new InvalidFileArgumentException("Argument of \"" + string + "\" has invalid value \"" + file.getAbsolutePath() + "\": File/Dir cannot be read");
        }
    }

    private static void checkFileRW(File file, String string) throws InvalidFileArgumentException {
        ParsedParameter.checkFileReadable(file, string);
        if (!file.canWrite()) {
            throw new InvalidFileArgumentException("Argument of \"" + string + "\" has invalid value \"" + file.getAbsolutePath() + "\": File/Dir cannot be written");
        }
    }

    private <T> T[] getParsedOptions(String string) throws ParseException {
        Object[] objectArray = this.mCli.getParsedOptionValues(string);
        if (objectArray == null) {
            return null;
        }
        return objectArray;
    }

    private <T> T getParsedOption(String string) throws ParseException {
        return (T)this.mCli.getParsedOptionValue(string);
    }
}

