/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.TranslationSettings;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryModelDeclarations;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public final class RequiredMemoryModelFeatures {
    private boolean mMemoryModelInfrastructureRequired;
    private final Set<CPrimitive.CPrimitives> mDataOnHeapRequired = new HashSet<CPrimitive.CPrimitives>();
    private final Set<CPrimitive.CPrimitives> mDataUncheckedWriteRequired;
    private final Set<CPrimitive.CPrimitives> mDataInitWriteRequired;
    private boolean mPointerOnHeapRequired;
    private boolean mPointerUncheckedWriteRequired;
    private boolean mPointerInitWriteRequired;
    private final Set<MemoryModelDeclarations> mRequiredMemoryModelDeclarations = new HashSet<MemoryModelDeclarations>();
    private final Set<CPrimitive.CPrimitives> mDataOnHeapInitFunctionRequired;
    private boolean mPointerOnHeapInitFunctionRequired;
    private final Set<CPrimitive.CPrimitives> mDataOnHeapStoreFunctionRequired;
    private boolean mPointerOnHeapStoreFunctionRequired;
    private boolean mIsFrozen;
    private boolean mMemoryModelInfrastructureRequiredHasBeenQueried;

    public RequiredMemoryModelFeatures() {
        this.mDataUncheckedWriteRequired = new HashSet<CPrimitive.CPrimitives>();
        this.mDataInitWriteRequired = new HashSet<CPrimitive.CPrimitives>();
        this.mDataOnHeapInitFunctionRequired = new HashSet<CPrimitive.CPrimitives>();
        this.mDataOnHeapStoreFunctionRequired = new HashSet<CPrimitive.CPrimitives>();
    }

    public boolean requireMemoryModelInfrastructure() {
        if (this.mMemoryModelInfrastructureRequired) {
            return false;
        }
        if (this.mMemoryModelInfrastructureRequiredHasBeenQueried) assert (false) : "someone already asked if memory model infrastructure was required and we said no";
        this.mMemoryModelInfrastructureRequired = true;
        this.require(MemoryModelDeclarations.ULTIMATE_LENGTH);
        this.require(MemoryModelDeclarations.ULTIMATE_VALID);
        return true;
    }

    public boolean reportPointerOnHeapRequired() {
        if (this.mPointerOnHeapRequired) {
            return false;
        }
        this.checkNotFrozen();
        this.requireMemoryModelInfrastructure();
        this.mPointerOnHeapRequired = true;
        return true;
    }

    public boolean reportPointerUncheckedWriteRequired() {
        if (this.mPointerUncheckedWriteRequired) {
            return false;
        }
        this.checkNotFrozen();
        this.reportPointerOnHeapRequired();
        this.mPointerUncheckedWriteRequired = true;
        return true;
    }

    public boolean reportPointerInitWriteRequired() {
        if (this.mPointerInitWriteRequired) {
            return false;
        }
        this.checkNotFrozen();
        this.reportPointerOnHeapRequired();
        this.mPointerInitWriteRequired = true;
        return true;
    }

    public boolean reportDataOnHeapRequired(CPrimitive.CPrimitives cPrimitives) {
        if (this.mDataOnHeapRequired.contains((Object)cPrimitives)) {
            return false;
        }
        this.checkNotFrozen();
        this.requireMemoryModelInfrastructure();
        this.mDataOnHeapRequired.add(cPrimitives);
        return true;
    }

    public boolean reportUncheckedWriteRequired(CPrimitive.CPrimitives cPrimitives) {
        if (this.mDataUncheckedWriteRequired.contains((Object)cPrimitives)) {
            return false;
        }
        this.checkNotFrozen();
        this.reportDataOnHeapRequired(cPrimitives);
        this.mDataUncheckedWriteRequired.add(cPrimitives);
        return true;
    }

    public boolean reportInitWriteRequired(CPrimitive.CPrimitives cPrimitives) {
        if (this.mDataInitWriteRequired.contains((Object)cPrimitives)) {
            return false;
        }
        this.checkNotFrozen();
        this.reportDataOnHeapRequired(cPrimitives);
        this.mDataInitWriteRequired.add(cPrimitives);
        return true;
    }

    public boolean reportDataOnHeapInitFunctionRequired(CPrimitive.CPrimitives cPrimitives) {
        if (this.mDataOnHeapInitFunctionRequired.contains((Object)cPrimitives)) {
            return false;
        }
        this.checkNotFrozen();
        this.reportDataOnHeapRequired(cPrimitives);
        this.mDataOnHeapInitFunctionRequired.add(cPrimitives);
        return true;
    }

    public boolean reportPointerOnHeapInitFunctionRequired() {
        if (this.mPointerOnHeapInitFunctionRequired) {
            return false;
        }
        this.checkNotFrozen();
        this.reportPointerOnHeapRequired();
        this.mPointerOnHeapInitFunctionRequired = true;
        return true;
    }

    public boolean reportDataOnHeapStoreFunctionRequired(CPrimitive.CPrimitives cPrimitives) {
        if (this.mDataOnHeapStoreFunctionRequired.contains((Object)cPrimitives)) {
            return false;
        }
        this.checkNotFrozen();
        this.reportDataOnHeapRequired(cPrimitives);
        this.mDataOnHeapStoreFunctionRequired.add(cPrimitives);
        return true;
    }

    public boolean reportPointerOnHeapStoreFunctionRequired() {
        if (this.mPointerOnHeapStoreFunctionRequired) {
            return false;
        }
        this.checkNotFrozen();
        this.reportPointerOnHeapRequired();
        this.mPointerOnHeapStoreFunctionRequired = true;
        return true;
    }

    public boolean isPointerOnHeapRequired() {
        this.checkIsFrozen();
        return this.mPointerOnHeapRequired;
    }

    public boolean isPointerUncheckedWriteRequired() {
        this.checkIsFrozen();
        return this.mPointerUncheckedWriteRequired;
    }

    public boolean isPointerInitRequired() {
        this.checkIsFrozen();
        return this.mPointerInitWriteRequired;
    }

    public Set<CPrimitive.CPrimitives> getDataOnHeapRequired() {
        this.checkIsFrozen();
        return this.mDataOnHeapRequired;
    }

    public boolean isPointerOnHeapInitFunctionRequired() {
        this.checkIsFrozen();
        return this.mPointerOnHeapInitFunctionRequired;
    }

    public boolean isDataOnHeapInitFunctionRequired(CPrimitive.CPrimitives cPrimitives) {
        this.checkIsFrozen();
        return this.mDataOnHeapInitFunctionRequired.contains((Object)cPrimitives);
    }

    public boolean isPointerOnHeapStoreFunctionRequired() {
        this.checkIsFrozen();
        return this.mPointerOnHeapStoreFunctionRequired;
    }

    public boolean isDataOnHeapStoreFunctionRequired(CPrimitive.CPrimitives cPrimitives) {
        this.checkIsFrozen();
        return this.mDataOnHeapStoreFunctionRequired.contains((Object)cPrimitives);
    }

    public Set<CPrimitive.CPrimitives> getUncheckedWriteRequired() {
        this.checkIsFrozen();
        return this.mDataUncheckedWriteRequired;
    }

    public Set<CPrimitive.CPrimitives> getInitWriteRequired() {
        this.checkIsFrozen();
        return this.mDataInitWriteRequired;
    }

    public boolean isMemoryModelInfrastructureRequired() {
        this.mMemoryModelInfrastructureRequiredHasBeenQueried = true;
        return this.mMemoryModelInfrastructureRequired;
    }

    public boolean require(MemoryModelDeclarations memoryModelDeclarations) {
        if (this.mRequiredMemoryModelDeclarations.contains((Object)memoryModelDeclarations)) {
            return false;
        }
        this.checkNotFrozen();
        this.requireMemoryModelInfrastructure();
        return this.mRequiredMemoryModelDeclarations.add(memoryModelDeclarations);
    }

    public Set<MemoryModelDeclarations> getRequiredMemoryModelDeclarations() {
        this.checkIsFrozen();
        return Collections.unmodifiableSet(this.mRequiredMemoryModelDeclarations);
    }

    public void finish(TranslationSettings translationSettings) {
        boolean bl = true;
        while (bl) {
            bl = false;
            for (MemoryModelDeclarations memoryModelDeclarations : new HashSet<MemoryModelDeclarations>(this.mRequiredMemoryModelDeclarations)) {
                bl |= memoryModelDeclarations.resolveDependencies(this, translationSettings);
            }
        }
        this.mIsFrozen = true;
    }

    private void checkIsFrozen() {
        if (!this.mIsFrozen) {
            throw new AssertionError((Object)"attempt to query before this has been frozen -- results might be wrong");
        }
    }

    private void checkNotFrozen() {
        if (this.mIsFrozen) {
            throw new AssertionError((Object)"attempt to modify, although this has been frozen already, note that if some memory model feature relies on another one, this has to be declared inMemoryModelDeclarations.resolveDependencies(..)perhaps we need to update a method there");
        }
    }

    Set<CPrimitive.CPrimitives> getDataOnHeapRequiredUnchecked() {
        return this.mDataOnHeapRequired;
    }

    boolean isPointerOnHeapRequiredUnchecked() {
        return this.mPointerOnHeapRequired;
    }
}

