/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.SMTAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.ArrayInterpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.CCInterpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.DatatypeInterpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.EQInterpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolantChecker;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolantPurifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAffineTerm;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorAtomInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.InterpolatorClauseInfo;
import de.uni_freiburg.informatik.ultimate.smtinterpol.interpolate.LAInterpolator;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.TerminationRequest;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import java.io.Serializable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Interpolator
extends NonRecursive {
    public static final String EQ = "@EQ";
    private final TerminationRequest mCancel;
    InterpolantChecker mChecker;
    final Collection<Term> mAllAssertions;
    LogProxy mLogger;
    Theory mTheory;
    int mNumInterpolants;
    Occurrence mFullOccurrence;
    int[] mStartOfSubtrees;
    HashMap<Term, Occurrence> mSymbolPartition;
    HashMap<String, Integer> mPartitions;
    HashMap<Term, LitInfo> mAtomOccurenceInfos;
    HashMap<Term, Term[]> mInterpolants;
    HashMap<Term, InterpolatorClauseInfo> mClauseTermInfos;
    HashMap<Term, InterpolatorAtomInfo> mLiteralTermInfos;
    HashMap<FunctionSymbol, Occurrence> mFunctionSymbolOccurrenceInfos;
    HashMap<Term, TermVariable> mMixedTermAuxEq;
    HashMap<TermVariable, Term> mPurifyDefinitions;
    private final HashMap<Term, Term[]> mProvedClauses = new HashMap();
    private final ArrayDeque<Term[]> mProvedClauseStack = new ArrayDeque();
    private final ArrayDeque<Term[]> mInterpolated = new ArrayDeque();

    public Interpolator(LogProxy logProxy, Script script, Collection<Term> collection, Theory theory, Set<String>[] setArray, int[] nArray, TerminationRequest terminationRequest) {
        assert (setArray.length == nArray.length);
        this.mPartitions = new HashMap();
        int n = 0;
        while (n < setArray.length) {
            Integer n2 = n;
            for (String string : setArray[n]) {
                this.mPartitions.put(string, n2);
            }
            ++n;
        }
        this.mLogger = logProxy;
        this.mCancel = terminationRequest;
        if (script != null) {
            this.mChecker = new InterpolantChecker(this, script);
            this.mChecker.assertUnpartitionedFormulas(collection, this.mPartitions.keySet());
        }
        this.mAllAssertions = collection;
        this.mTheory = theory;
        this.mNumInterpolants = setArray.length - 1;
        this.mFullOccurrence = new Occurrence();
        this.mFullOccurrence.occursIn(-1);
        this.mStartOfSubtrees = nArray;
        this.mSymbolPartition = new HashMap();
        this.mAtomOccurenceInfos = new HashMap();
        this.mInterpolants = new HashMap();
        this.mClauseTermInfos = new HashMap();
        this.mLiteralTermInfos = new HashMap();
        this.mFunctionSymbolOccurrenceInfos = new HashMap();
        this.mMixedTermAuxEq = new HashMap();
        this.mPurifyDefinitions = new HashMap();
    }

    public LogProxy getLogger() {
        return this.mLogger;
    }

    public Term[] getInterpolants(Term term) {
        this.colorTermsInAssertions();
        this.colorLiterals(term);
        Term[] termArray = this.interpolate(term);
        int n = 0;
        while (n < termArray.length) {
            termArray[n] = this.unfoldLAs(termArray[n]);
            ++n;
        }
        if (this.mChecker != null && !this.mChecker.checkFinalInterpolants(this.mPartitions, termArray)) {
            throw new SMTLIBException("generated interpolants did not pass sanity check");
        }
        return termArray;
    }

    public Term[] interpolate(Term term) {
        if (this.mInterpolants.containsKey(term)) {
            this.mLogger.debug("Proof term %s has been interpolated before.", term.hashCode());
            return this.mInterpolants.get(term);
        }
        if (this.mCancel.isTerminationRequested()) {
            throw new SMTLIBException("Termination requested (timeout or resource limit)");
        }
        Term[] termArray = null;
        this.run(new ProofTreeWalker(term));
        termArray = this.collectInterpolated();
        return termArray;
    }

    private void walkResolutionNode(Term term) {
        if (this.mCancel.isTerminationRequested()) {
            throw new SMTLIBException("Termination requested (timeout or resource limit)");
        }
        Term term2 = term instanceof AnnotatedTerm ? ((AnnotatedTerm)term).getSubterm() : term;
        Term[] termArray = ((ApplicationTerm)term2).getParameters();
        Term term3 = termArray[0];
        Term term4 = termArray[1];
        Term term5 = termArray[2];
        if (term instanceof AnnotatedTerm) {
            this.enqueueWalker(new SummarizeResolution(term));
        }
        this.enqueueWalker(new CombineInterpolants(term3));
        this.enqueueWalker(new ProofTreeWalker(term5));
        this.enqueueWalker(new ProofTreeWalker(term4));
    }

    private void walkLeafNode(Term term) {
        Term[] termArray;
        Term[] termArray2;
        InterpolatorClauseInfo interpolatorClauseInfo;
        block55: {
            block56: {
                block54: {
                    if (this.mCancel.isTerminationRequested()) {
                        throw new SMTLIBException("Termination requested (timeout or resource limit)");
                    }
                    interpolatorClauseInfo = this.getClauseTermInfo(term);
                    termArray2 = interpolatorClauseInfo.getLiterals();
                    if (interpolatorClauseInfo.getLeafKind() != InterpolatorClauseInfo.ClauseKind.INPUT) break block54;
                    if (this.isSkolemizedFormula(term)) {
                        throw new UnsupportedOperationException("Interpolation not supported for quantified formulae.");
                    }
                    String string = interpolatorClauseInfo.getSource();
                    int n = this.mPartitions.containsKey(string) ? this.mPartitions.get(string) : 0;
                    termArray = new Term[this.mNumInterpolants];
                    int n2 = 0;
                    while (n2 < this.mNumInterpolants) {
                        termArray[n2] = this.mStartOfSubtrees[n2] <= n && n <= n2 ? this.mTheory.mFalse : this.mTheory.mTrue;
                        ++n2;
                    }
                    break block55;
                }
                if (interpolatorClauseInfo.getLeafKind() != InterpolatorClauseInfo.ClauseKind.LEMMA) break block56;
                switch (interpolatorClauseInfo.getLemmaType()) {
                    case ":EQ": {
                        termArray = new EQInterpolator(this).computeInterpolants(interpolatorClauseInfo);
                        break block55;
                    }
                    case ":cong": 
                    case ":trans": {
                        CCInterpolator cCInterpolator = new CCInterpolator(this);
                        termArray = cCInterpolator.computeInterpolants(interpolatorClauseInfo);
                        InterpolantPurifier interpolantPurifier = new InterpolantPurifier(this);
                        int n = 0;
                        while (n < termArray.length) {
                            termArray[n] = interpolantPurifier.purify(termArray[n], n);
                            ++n;
                        }
                        break block55;
                    }
                    case ":LA": {
                        LAInterpolator lAInterpolator = new LAInterpolator(this);
                        termArray = lAInterpolator.computeInterpolants(interpolatorClauseInfo);
                        break block55;
                    }
                    case ":trichotomy": {
                        LAInterpolator lAInterpolator = new LAInterpolator(this);
                        termArray = lAInterpolator.computeTrichotomyInterpolants(interpolatorClauseInfo);
                        break block55;
                    }
                    case ":read-const-weakeq": 
                    case ":weakeq-ext": 
                    case ":read-over-weakeq": 
                    case ":const-weakeq": {
                        ArrayInterpolator arrayInterpolator = new ArrayInterpolator(this);
                        termArray = arrayInterpolator.computeInterpolants(interpolatorClauseInfo);
                        break block55;
                    }
                    case ":inst": {
                        CCInterpolator cCInterpolator = new CCInterpolator(this);
                        termArray = cCInterpolator.interpolateInstantiation(interpolatorClauseInfo);
                        InterpolantPurifier interpolantPurifier = new InterpolantPurifier(this);
                        int n = 0;
                        while (n < termArray.length) {
                            termArray[n] = interpolantPurifier.purify(termArray[n], n);
                            termArray[n] = this.addQuantifier(termArray[n], n, termArray2);
                            ++n;
                        }
                        break block55;
                    }
                    case ":dt-project": 
                    case ":dt-constructor": 
                    case ":dt-disjoint": 
                    case ":dt-tester": 
                    case ":dt-unique": 
                    case ":dt-cases": 
                    case ":dt-cycle": 
                    case ":dt-injective": {
                        DatatypeInterpolator datatypeInterpolator = new DatatypeInterpolator(this);
                        termArray = datatypeInterpolator.computeDatatypeInterpolants(interpolatorClauseInfo);
                        break block55;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown lemma type!");
                    }
                }
            }
            throw new UnsupportedOperationException("Cannot interpolate " + String.valueOf(term));
        }
        this.mInterpolated.add(termArray);
        this.mProvedClauseStack.add(termArray2);
        this.mInterpolants.put(term, termArray);
        this.mProvedClauses.put(term, termArray2);
        this.mLogger.debug("Interpolating leaf %s %s yields ...", term.hashCode(), term);
        int n = 0;
        while (n <= this.mNumInterpolants - 1) {
            this.mLogger.debug(termArray[n]);
            ++n;
        }
        if (this.mChecker != null) {
            this.mChecker.checkInductivity(interpolatorClauseInfo.getLiterals(), termArray);
        }
    }

    private Term[] computeResolution(Term[] termArray, Term[] termArray2, Term term) {
        Term term2;
        LinkedHashSet<Term> linkedHashSet = new LinkedHashSet<Term>(termArray2.length + termArray.length);
        Term[] termArray3 = termArray;
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            term2 = termArray3[n2];
            if (term2 != term) {
                linkedHashSet.add(term2);
            }
            ++n2;
        }
        term2 = term.getTheory().not(term);
        Term[] termArray4 = termArray2;
        int n3 = termArray2.length;
        n = 0;
        while (n < n3) {
            Term term3 = termArray4[n];
            if (term3 != term2) {
                linkedHashSet.add(term3);
            }
            ++n;
        }
        return linkedHashSet.toArray(new Term[linkedHashSet.size()]);
    }

    private void combine(Term term) {
        LitInfo litInfo = this.mAtomOccurenceInfos.get(term);
        Term[] termArray = this.collectInterpolated();
        Term[] termArray2 = this.collectInterpolated();
        Term[] termArray3 = new Term[this.mNumInterpolants];
        Term[] termArray4 = this.mProvedClauseStack.removeLast();
        Term[] termArray5 = this.mProvedClauseStack.removeLast();
        Term[] termArray6 = this.computeResolution(termArray5, termArray4, term);
        InterpolantPurifier interpolantPurifier = new InterpolantPurifier(this);
        int n = 0;
        while (n < this.mNumInterpolants) {
            this.mLogger.debug("Pivot %3$s%4$s on interpolants %1$s and %2$s gives...", termArray2[n], termArray[n], term, litInfo);
            if (litInfo.isALocal(n)) {
                termArray3[n] = this.mTheory.or(new Term[]{termArray2[n], termArray[n]});
            } else if (litInfo.isBLocal(n)) {
                termArray3[n] = this.mTheory.and(new Term[]{termArray2[n], termArray[n]});
            } else if (litInfo.isAB(n)) {
                termArray3[n] = this.mTheory.ifthenelse(term, termArray[n], termArray2[n]);
            } else {
                InterpolatorAtomInfo interpolatorAtomInfo = this.getAtomTermInfo(term);
                if (interpolatorAtomInfo.isCCEquality() || interpolatorAtomInfo.isLAEquality()) {
                    Term term2 = termArray2[n];
                    Term term3 = termArray[n];
                    termArray3[n] = this.mixedEqInterpolate(term2, term3, litInfo.mMixedVar);
                } else if (interpolatorAtomInfo.isBoundConstraint()) {
                    termArray3[n] = this.mixedPivotLA(termArray[n], termArray2[n], litInfo.mMixedVar);
                } else {
                    throw new UnsupportedOperationException("Cannot handle mixed literal " + String.valueOf(term));
                }
            }
            termArray3[n] = interpolantPurifier.purify(termArray3[n], n);
            termArray3[n] = this.addQuantifier(termArray3[n], n, termArray6);
            this.mLogger.debug(termArray3[n]);
            ++n;
        }
        this.mProvedClauseStack.add(termArray6);
        this.mInterpolated.add(termArray3);
    }

    private void summarize(Term term) {
        Term[] termArray = null;
        termArray = this.mInterpolated.getLast();
        this.mInterpolants.put(term, termArray);
        this.mProvedClauses.put(term, this.mProvedClauseStack.getLast());
        this.mLogger.debug("...which is the resulting interpolant for Term %s ", term.hashCode());
    }

    protected final Term[] collectInterpolated() {
        return this.mInterpolated.removeLast();
    }

    public boolean checkCacheForInterpolants(Term term) {
        Term[] termArray = this.mInterpolants.get(term);
        if (termArray != null) {
            this.mInterpolated.add(termArray);
            this.mProvedClauseStack.add(this.mProvedClauses.get(term));
            return true;
        }
        return false;
    }

    Term unfoldLAs(Term term) {
        TermTransformer termTransformer = new TermTransformer(){

            public void convert(Term term) {
                if (LAInterpolator.isLATerm(term)) {
                    term = ((AnnotatedTerm)term).getSubterm();
                }
                super.convert(term);
            }
        };
        return termTransformer.transform(term);
    }

    private void colorTermsInAssertions() {
        for (Term term : this.mAllAssertions) {
            int n = -1;
            Term term2 = term;
            if (term instanceof AnnotatedTerm) {
                AnnotatedTerm annotatedTerm = (AnnotatedTerm)term;
                Annotation[] annotationArray = annotatedTerm.getAnnotations();
                int n2 = annotationArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Annotation annotation = annotationArray[n3];
                    if (":named".equals(annotation.getKey()) && this.mPartitions.containsKey(annotation.getValue())) {
                        n = this.mPartitions.get(annotation.getValue());
                    }
                    ++n3;
                }
                term2 = annotatedTerm.getSubterm();
            }
            new ColorAssertion().color(term2, n);
        }
    }

    private void colorLiterals(Term term) {
        HashSet<Term> hashSet = new HashSet<Term>();
        ArrayDeque<Term> arrayDeque = new ArrayDeque<Term>();
        arrayDeque.add(term);
        while (!arrayDeque.isEmpty()) {
            Term[] termArray;
            Object object;
            if (this.mCancel.isTerminationRequested()) {
                throw new SMTLIBException("Termination requested (timeout or resource limit)");
            }
            Term term2 = (Term)arrayDeque.pop();
            if (!hashSet.add(term2)) continue;
            InterpolatorClauseInfo interpolatorClauseInfo = this.getClauseTermInfo(term2);
            if (interpolatorClauseInfo.isResolution()) {
                object = term2 instanceof AnnotatedTerm ? ((AnnotatedTerm)term2).getSubterm() : term2;
                termArray = ((ApplicationTerm)object).getParameters();
                arrayDeque.add(termArray[1]);
                arrayDeque.add(termArray[2]);
                continue;
            }
            assert (interpolatorClauseInfo.isLeaf());
            if (interpolatorClauseInfo.getLeafKind() != InterpolatorClauseInfo.ClauseKind.INPUT) continue;
            object = interpolatorClauseInfo.getSource();
            termArray = interpolatorClauseInfo.getLiterals();
            int n = this.mPartitions.containsKey(object) ? this.mPartitions.get(object) : -1;
            int n2 = 0;
            while (n2 < termArray.length) {
                Term term3 = this.getAtom(termArray[n2]);
                LitInfo litInfo = this.mAtomOccurenceInfos.get(term3);
                if (litInfo == null) {
                    litInfo = new LitInfo();
                    this.mAtomOccurenceInfos.put(term3, litInfo);
                }
                if (!litInfo.contains(n)) {
                    litInfo.occursIn(n);
                    this.addOccurrence(term3, n);
                }
                this.colorSymbols(term3, n);
                ++n2;
            }
        }
    }

    Occurrence getOccurrence(FunctionSymbol functionSymbol) {
        if (functionSymbol.isIntern() && !functionSymbol.getName().startsWith("@AUX") && !functionSymbol.getName().startsWith("@skolem")) {
            return this.mFullOccurrence;
        }
        return this.mFunctionSymbolOccurrenceInfos.get(functionSymbol);
    }

    Occurrence getOccurrence(Term term) {
        if (term instanceof ConstantTerm) {
            return this.mFullOccurrence;
        }
        Occurrence occurrence = this.mSymbolPartition.get(term);
        if (occurrence == null) {
            BitSet bitSet;
            Occurrence occurrence2;
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            FunctionSymbol functionSymbol = applicationTerm.getFunction();
            occurrence = occurrence2 = this.getOccurrence(functionSymbol);
            Term[] termArray = applicationTerm.getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                bitSet = termArray[n2];
                occurrence = occurrence.intersect(this.getOccurrence((Term)bitSet));
                ++n2;
            }
            bitSet = new BitSet();
            bitSet.set(0, this.mNumInterpolants + 1);
            bitSet.andNot(occurrence.mInA);
            bitSet.andNot(occurrence.mInB);
            if (bitSet.nextSetBit(0) >= 0) {
                BitSet bitSet2 = (BitSet)occurrence.mInA.clone();
                BitSet bitSet3 = (BitSet)occurrence.mInB.clone();
                bitSet2.or(bitSet);
                bitSet2.and(occurrence2.mInA);
                bitSet3.or(bitSet);
                bitSet3.and(occurrence2.mInB);
                occurrence = new Occurrence(bitSet2, bitSet3);
            }
            this.mSymbolPartition.put(term, occurrence);
        }
        return occurrence;
    }

    void addOccurrence(Term term, int n) {
        if (term instanceof ConstantTerm) {
            return;
        }
        Occurrence occurrence = this.mSymbolPartition.get(term);
        if (occurrence != null && occurrence.contains(n)) {
            return;
        }
        if (term instanceof ApplicationTerm) {
            FunctionSymbol functionSymbol;
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            Term[] termArray = applicationTerm.getParameters();
            int n2 = termArray.length;
            int n3 = 0;
            while (n3 < n2) {
                functionSymbol = termArray[n3];
                this.addOccurrence((Term)functionSymbol, n);
                ++n3;
            }
            functionSymbol = applicationTerm.getFunction();
            if (!functionSymbol.isIntern() || functionSymbol.getName().startsWith("@AUX") || functionSymbol.getName().contains("skolem")) {
                this.addOccurrence(functionSymbol, n);
            }
            return;
        }
        if (occurrence == null) {
            occurrence = new Occurrence();
            this.mSymbolPartition.put(term, occurrence);
        }
        occurrence.occursIn(n);
    }

    void addOccurrence(FunctionSymbol functionSymbol, int n) {
        Occurrence occurrence = this.mFunctionSymbolOccurrenceInfos.get(functionSymbol);
        if (occurrence == null) {
            occurrence = new Occurrence();
            this.mFunctionSymbolOccurrenceInfos.put(functionSymbol, occurrence);
        } else if (occurrence.contains(n)) {
            return;
        }
        occurrence.occursIn(n);
    }

    HashSet<Term> getSubTerms(Term term) {
        HashSet<Term> hashSet = new HashSet<Term>();
        ArrayDeque<Term> arrayDeque = new ArrayDeque<Term>();
        arrayDeque.addLast(term);
        while (!arrayDeque.isEmpty()) {
            Term term2 = (Term)arrayDeque.removeLast();
            if (!hashSet.add(term2) || !(term2 instanceof ApplicationTerm)) continue;
            ApplicationTerm applicationTerm = (ApplicationTerm)term2;
            Term[] termArray = applicationTerm.getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term3 = termArray[n2];
                arrayDeque.addLast(term3);
                ++n2;
            }
        }
        return hashSet;
    }

    HashSet<Term> getAllSubTerms(Term term) {
        HashSet<Term> hashSet = new HashSet<Term>();
        ArrayDeque<Term> arrayDeque = new ArrayDeque<Term>();
        arrayDeque.addLast(term);
        while (!arrayDeque.isEmpty()) {
            Term term2 = (Term)arrayDeque.removeLast();
            if (term2 instanceof ApplicationTerm) {
                ApplicationTerm applicationTerm = (ApplicationTerm)term2;
                if (!applicationTerm.getFunction().equals(this.mTheory.mNot)) {
                    hashSet.add((Term)applicationTerm);
                }
                Term[] termArray = applicationTerm.getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term term3 = termArray[n2];
                    arrayDeque.addLast(term3);
                    ++n2;
                }
            }
            if (!(term2 instanceof AnnotatedTerm)) continue;
            arrayDeque.add(((AnnotatedTerm)term2).getSubterm());
        }
        return hashSet;
    }

    LitInfo getAtomOccurenceInfo(Term term) {
        assert (!this.isNegatedTerm(term));
        LitInfo litInfo = this.mAtomOccurenceInfos.get(term);
        if (litInfo == null) {
            this.mLogger.info("colorLiteral: " + String.valueOf(term));
            litInfo = this.colorMixedLiteral(term);
        }
        return litInfo;
    }

    public List<Term> getSubTermsForAtom(Term term) {
        InterpolatorAtomInfo interpolatorAtomInfo = this.getAtomTermInfo(term);
        if (interpolatorAtomInfo.isCCEquality()) {
            ApplicationTerm applicationTerm = interpolatorAtomInfo.getEquality();
            return Arrays.asList(applicationTerm.getParameters());
        }
        assert (interpolatorAtomInfo.isLAEquality() || interpolatorAtomInfo.isBoundConstraint());
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.addAll(interpolatorAtomInfo.getAffineTerm().getSummands().keySet());
        return arrayList;
    }

    public LitInfo colorMixedLiteral(Term term) {
        assert (!this.isNegatedTerm(term));
        assert (!this.mAtomOccurenceInfos.containsKey(term));
        InterpolatorAtomInfo interpolatorAtomInfo = this.getAtomTermInfo(term);
        List<Term> list = this.getSubTermsForAtom(term);
        LitInfo litInfo = this.computeMixedOccurrence(list);
        this.mAtomOccurenceInfos.put(term, litInfo);
        BitSet bitSet = new BitSet();
        bitSet.or(litInfo.mInA);
        bitSet.or(litInfo.mInB);
        if (bitSet.nextClearBit(0) >= this.mNumInterpolants) {
            return litInfo;
        }
        litInfo.mMixedVar = this.mTheory.createFreshTermVariable("litaux", list.get(0).getSort());
        if (interpolatorAtomInfo.isCCEquality()) {
            ApplicationTerm applicationTerm = interpolatorAtomInfo.getEquality();
            litInfo.mLhsOccur = this.getOccurrence(applicationTerm.getParameters()[0]);
        } else if (interpolatorAtomInfo.isBoundConstraint() || interpolatorAtomInfo.isLAEquality()) {
            InterpolatorAffineTerm interpolatorAffineTerm = interpolatorAtomInfo.getAffineTerm();
            assert (interpolatorAffineTerm.getSummands().size() > 1) : "Mixed Literal with only one subterm: " + String.valueOf(interpolatorAffineTerm) + " atom: " + String.valueOf(term);
            litInfo.mAPart = new InterpolatorAffineTerm[this.mNumInterpolants];
            int n = 0;
            while (n < this.mNumInterpolants) {
                if (litInfo.isMixed(n)) {
                    InterpolatorAffineTerm interpolatorAffineTerm2 = new InterpolatorAffineTerm();
                    for (Map.Entry<Term, Rational> entry : interpolatorAffineTerm.getSummands().entrySet()) {
                        Term term2 = entry.getKey();
                        Occurrence occurrence = this.getOccurrence(term2);
                        if (!occurrence.isALocal(n)) continue;
                        Rational rational = entry.getValue();
                        interpolatorAffineTerm2.add(rational, term2);
                    }
                    litInfo.mAPart[n] = interpolatorAffineTerm2;
                }
                ++n;
            }
        }
        return litInfo;
    }

    private LitInfo computeMixedOccurrence(List<Term> list) {
        BitSet bitSet = new BitSet(this.mNumInterpolants + 1);
        bitSet.set(0, this.mNumInterpolants + 1);
        BitSet bitSet2 = new BitSet(this.mNumInterpolants + 1);
        bitSet2.set(0, this.mNumInterpolants);
        for (Term term : list) {
            Occurrence occurrence = this.getOccurrence(term);
            bitSet.and(occurrence.mInA);
            bitSet2.and(occurrence.mInB);
        }
        LitInfo litInfo = new LitInfo(bitSet, bitSet2);
        return litInfo;
    }

    Term substitute(Term term, TermVariable termVariable, Term term2) {
        return new Substitutor(termVariable, term2).transform(term);
    }

    private Term mixedEqInterpolate(Term term, Term term2, TermVariable termVariable) {
        EQSubstitutor eQSubstitutor = new EQSubstitutor(term2, termVariable);
        return eQSubstitutor.transform(term);
    }

    public Term mixedPivotLA(Term term, Term term2, TermVariable termVariable) {
        MixedLAInterpolator mixedLAInterpolator = termVariable.getSort().getName().equals("Real") ? new RealInterpolator(term2, termVariable) : new IntegerInterpolator(term2, termVariable);
        Term term3 = mixedLAInterpolator.transform(term);
        return term3;
    }

    InterpolatorClauseInfo getClauseTermInfo(Term term) {
        if (this.mClauseTermInfos.containsKey(term)) {
            return this.mClauseTermInfos.get(term);
        }
        InterpolatorClauseInfo interpolatorClauseInfo = new InterpolatorClauseInfo(term);
        this.mClauseTermInfos.put(term, interpolatorClauseInfo);
        return interpolatorClauseInfo;
    }

    InterpolatorAtomInfo getAtomTermInfo(Term term) {
        assert (!this.isNegatedTerm(term));
        if (this.mLiteralTermInfos.containsKey(term)) {
            return this.mLiteralTermInfos.get(term);
        }
        InterpolatorAtomInfo interpolatorAtomInfo = new InterpolatorAtomInfo(term);
        this.mLiteralTermInfos.put(term, interpolatorAtomInfo);
        return interpolatorAtomInfo;
    }

    public HashSet<FunctionSymbol> getSymbols(Term term) {
        assert (term != null);
        HashSet<FunctionSymbol> hashSet = new HashSet<FunctionSymbol>();
        HashSet<Term> hashSet2 = new HashSet<Term>();
        ArrayDeque<Term> arrayDeque = new ArrayDeque<Term>();
        arrayDeque.add(term);
        while (!arrayDeque.isEmpty()) {
            Term term2 = (Term)arrayDeque.pop();
            while (term2 instanceof AnnotatedTerm || term2 instanceof QuantifiedFormula) {
                if (term2 instanceof QuantifiedFormula) {
                    term2 = ((QuantifiedFormula)term2).getSubformula();
                }
                if (!(term2 instanceof AnnotatedTerm)) continue;
                term2 = ((AnnotatedTerm)term2).getSubterm();
            }
            if (term2 instanceof TermVariable || term2 instanceof ConstantTerm || !hashSet2.add(term2)) continue;
            ApplicationTerm applicationTerm = (ApplicationTerm)term2;
            FunctionSymbol functionSymbol = applicationTerm.getFunction();
            if (!functionSymbol.isIntern() || functionSymbol.getName().startsWith("@AUX") || functionSymbol.getName().contains("skolem")) {
                hashSet.add(functionSymbol);
            }
            arrayDeque.addAll(Arrays.asList(applicationTerm.getParameters()));
        }
        return hashSet;
    }

    int getNestingDepth(ApplicationTerm applicationTerm, int n) {
        if (applicationTerm.getParameters().length == 0) {
            return n;
        }
        int n2 = n;
        int n3 = 0;
        while (n3 < applicationTerm.getParameters().length) {
            if (!(applicationTerm.getParameters()[n3] instanceof TermVariable)) {
                int n4 = this.getNestingDepth((ApplicationTerm)applicationTerm.getParameters()[n3], n + 1);
                n2 = n4 > n2 ? n4 : n2;
            }
            ++n3;
        }
        return n2;
    }

    ArrayList<Term> orderTerms(HashSet<Term> hashSet) {
        ApplicationTerm applicationTerm;
        ArrayList<Term> arrayList = new ArrayList<Term>();
        HashMap<ApplicationTerm, Integer> hashMap = new HashMap<ApplicationTerm, Integer>();
        for (Term term : hashSet) {
            applicationTerm = (ApplicationTerm)term;
            if (hashMap.get(applicationTerm) != null) continue;
            hashMap.put(applicationTerm, this.getNestingDepth(applicationTerm, 0));
        }
        for (Term term : hashSet) {
            applicationTerm = (ApplicationTerm)term;
            int n = 0;
            int n2 = 0;
            while (n2 < arrayList.size()) {
                if ((Integer)hashMap.get(applicationTerm) > (Integer)hashMap.get(arrayList.get(n2))) {
                    n = n2;
                    break;
                }
                ++n2;
            }
            arrayList.add(n, (Term)applicationTerm);
        }
        return arrayList;
    }

    public void colorSymbols(Term term, int n) {
        assert (term != null);
        HashSet<FunctionSymbol> hashSet = this.getSymbols(term);
        for (FunctionSymbol functionSymbol : hashSet) {
            Occurrence occurrence = new Occurrence();
            if (this.mFunctionSymbolOccurrenceInfos.containsKey(functionSymbol)) {
                occurrence = this.mFunctionSymbolOccurrenceInfos.get(functionSymbol);
            }
            occurrence.occursIn(n);
            this.mFunctionSymbolOccurrenceInfos.put(functionSymbol, occurrence);
        }
    }

    public TermVariable getOrCreatePurificationVariable(Term term) {
        TermVariable termVariable = this.mMixedTermAuxEq.get(term);
        if (termVariable == null) {
            termVariable = this.mTheory.createFreshTermVariable("purAux", term.getSort());
            this.mMixedTermAuxEq.put(term, termVariable);
            this.mPurifyDefinitions.put(termVariable, term);
        }
        return termVariable;
    }

    private HashSet<TermVariable> getSupportedVariables(Term[] term, int n) {
        Term term2;
        HashSet<ApplicationTerm> hashSet = new HashSet<ApplicationTerm>();
        Term term32 = term;
        int n2 = ((Term[])term32).length;
        int n3 = 0;
        while (n3 < n2) {
            term2 = term32[n3];
            Term term4 = this.getAtom(term2);
            LitInfo litInfo = this.getAtomOccurenceInfo(term4);
            if (litInfo.isMixed(n)) {
                for (Term term5 : this.getSubTermsForAtom(term4)) {
                    this.addMixedSubTerms(term5, this.getOccurrence(term5), n, hashSet);
                }
            } else {
                this.addMixedSubTerms(term4, litInfo, n, hashSet);
            }
            ++n3;
        }
        term2 = new HashSet();
        ArrayList<ApplicationTerm> arrayList = new ArrayList<ApplicationTerm>();
        arrayList.addAll(hashSet);
        while (!arrayList.isEmpty()) {
            ApplicationTerm applicationTerm = (ApplicationTerm)arrayList.remove(arrayList.size() - 1);
            if (!term2.add(this.mMixedTermAuxEq.get(applicationTerm))) continue;
            for (Term term32 : Arrays.asList(applicationTerm.getParameters())) {
                if (!(term32 instanceof ApplicationTerm)) continue;
                arrayList.add((ApplicationTerm)term32);
            }
        }
        return term2;
    }

    private void addMixedSubTerms(Term term, Occurrence occurrence, int n, HashSet<ApplicationTerm> hashSet) {
        HashSet<Term> hashSet2 = new HashSet<Term>();
        ArrayList<Term> arrayList = new ArrayList<Term>();
        arrayList.add(term);
        while (!arrayList.isEmpty()) {
            Term term2 = (Term)arrayList.remove(arrayList.size() - 1);
            if (!(term2 instanceof ApplicationTerm) || !hashSet2.add(term2)) continue;
            ApplicationTerm applicationTerm = (ApplicationTerm)term2;
            Occurrence occurrence2 = this.getOccurrence(applicationTerm.getFunction());
            if (occurrence2.isALocal(n) && occurrence.isBorShared(n) || occurrence2.isBLocal(n) && occurrence.isAorShared(n)) {
                hashSet.add(applicationTerm);
                continue;
            }
            arrayList.addAll(Arrays.asList(applicationTerm.getParameters()));
        }
    }

    private List<TermVariable> sortVariables(Map<TermVariable, Term> map) {
        Serializable serializable;
        Term term;
        HashMap hashMap = new HashMap();
        for (Map.Entry<TermVariable, Term> object22 : map.entrySet()) {
            term = object22.getValue();
            serializable = new HashSet();
            for (Map.Entry<TermVariable, Term> entry : map.entrySet()) {
                if (object22.equals(entry)) continue;
                Term term2 = entry.getValue();
                HashSet<Term> hashSet = this.getAllSubTerms(term);
                if (!hashSet.contains(term2)) continue;
                ((HashSet)serializable).add(entry.getKey());
            }
            hashMap.put(object22.getKey(), serializable);
        }
        ArrayDeque<TermVariable> arrayDeque = new ArrayDeque<TermVariable>(map.keySet());
        ArrayList arrayList = new ArrayList();
        term = null;
        serializable = Boolean.valueOf(true);
        while (!arrayDeque.isEmpty()) {
            TermVariable termVariable = (TermVariable)arrayDeque.pop();
            if (termVariable == term) {
                throw new IllegalArgumentException("Variable dependencies must not contain cycles.");
            }
            if (((HashSet)hashMap.get(termVariable)).isEmpty() || arrayList.containsAll((Collection)hashMap.get(termVariable))) {
                arrayList.add(termVariable);
                serializable = Boolean.valueOf(true);
                term = termVariable;
                continue;
            }
            arrayDeque.add(termVariable);
            if (!((Boolean)serializable).booleanValue()) continue;
            term = termVariable;
            serializable = Boolean.valueOf(false);
        }
        return arrayList;
    }

    private Term addQuantifier(Term term, int n, Term[] termArray) {
        TermVariable termVariable;
        HashSet<TermVariable> hashSet = this.getSupportedVariables(termArray, n);
        LinkedHashMap<TermVariable, Term> linkedHashMap = new LinkedHashMap<TermVariable, Term>();
        FunctionSymbol functionSymbol = term.getFreeVars();
        int n2 = ((TermVariable[])functionSymbol).length;
        int n3 = 0;
        while (n3 < n2) {
            termVariable = functionSymbol[n3];
            Term term2 = this.mPurifyDefinitions.get(termVariable);
            if (term2 != null) {
                boolean bl = false;
                HashSet<Term> hashSet2 = new HashSet<Term>();
                ArrayList<Term> arrayList = new ArrayList<Term>();
                arrayList.add(term2);
                while (!arrayList.isEmpty()) {
                    Term term3 = (Term)arrayList.remove(arrayList.size() - 1);
                    if (hashSet.contains(this.mMixedTermAuxEq.get(term3))) {
                        bl = true;
                        break;
                    }
                    if (!(term3 instanceof ApplicationTerm) || !hashSet2.add(term3)) continue;
                    arrayList.addAll(Arrays.asList(((ApplicationTerm)term3).getParameters()));
                }
                if (!bl) {
                    linkedHashMap.put(termVariable, term2);
                }
            }
            ++n3;
        }
        termVariable = this.sortVariables(linkedHashMap);
        Collections.reverse(termVariable);
        for (TermVariable termVariable2 : termVariable) {
            functionSymbol = ((ApplicationTerm)this.mPurifyDefinitions.get(termVariable2)).getFunction();
            term = this.mFunctionSymbolOccurrenceInfos.get(functionSymbol).isALocal(n) ? this.mTheory.exists(new TermVariable[]{termVariable2}, term) : this.mTheory.forall(new TermVariable[]{termVariable2}, term);
        }
        return term;
    }

    public boolean isNegatedTerm(Term term) {
        return term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("not");
    }

    public Term getAtom(Term term) {
        return this.isNegatedTerm(term) ? ((ApplicationTerm)term).getParameters()[0] : term;
    }

    private boolean isSkolemizedFormula(Term term) {
        InterpolatorClauseInfo interpolatorClauseInfo = this.getClauseTermInfo(term);
        Term[] termArray = interpolatorClauseInfo.getLiterals();
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term term2 = termArray[n2];
            if (this.containsSkolemVar(term2)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean containsSkolemVar(Term term) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            String string = applicationTerm.getFunction().getName();
            if (string.matches("@.*skolem.*")) {
                return true;
            }
            Term[] termArray = applicationTerm.getParameters();
            int n = termArray.length;
            int n2 = 0;
            while (n2 < n) {
                Term term2 = termArray[n2];
                if (this.containsSkolemVar(term2)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private class ColorAssertion
    extends NonRecursive {
        private HashSet<Term> mSeen;

        private ColorAssertion() {
        }

        void color(Term term, int n) {
            this.mSeen = new HashSet();
            this.run((NonRecursive.Walker)new ColorTerm(term, n));
        }

        private class ColorTerm
        extends NonRecursive.TermWalker {
            final int mPart;

            public ColorTerm(Term term, int n) {
                super(term);
                this.mPart = n;
            }

            public void walk(NonRecursive nonRecursive) {
                if (ColorAssertion.this.mSeen.add(this.mTerm)) {
                    super.walk(nonRecursive);
                }
            }

            public void walk(NonRecursive nonRecursive, ConstantTerm constantTerm) {
            }

            public void walk(NonRecursive nonRecursive, AnnotatedTerm annotatedTerm) {
                nonRecursive.enqueueWalker((NonRecursive.Walker)new ColorTerm(annotatedTerm.getSubterm(), this.mPart));
            }

            public void walk(NonRecursive nonRecursive, ApplicationTerm applicationTerm) {
                FunctionSymbol functionSymbol = applicationTerm.getFunction();
                Term term = functionSymbol.getDefinition();
                if (term != null) {
                    Term[] termArray = applicationTerm.getParameters();
                    HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
                    int n = 0;
                    while (n < termArray.length) {
                        hashMap.put(applicationTerm.getFunction().getDefinitionVars()[n], termArray[n]);
                        ++n;
                    }
                    FormulaUnLet formulaUnLet = new FormulaUnLet();
                    formulaUnLet.addSubstitutions(hashMap);
                    Term term2 = formulaUnLet.unlet(term);
                    nonRecursive.enqueueWalker((NonRecursive.Walker)new ColorTerm(term2, this.mPart));
                } else {
                    if (!applicationTerm.getFunction().isIntern()) {
                        if (applicationTerm.getFreeVars().length == 0) {
                            Interpolator.this.addOccurrence((Term)applicationTerm, this.mPart);
                        }
                        Interpolator.this.addOccurrence(functionSymbol, this.mPart);
                    }
                    Term[] termArray = ((ApplicationTerm)this.mTerm).getParameters();
                    int n = termArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Term term3 = termArray[n2];
                        nonRecursive.enqueueWalker((NonRecursive.Walker)new ColorTerm(term3, this.mPart));
                        ++n2;
                    }
                }
            }

            public void walk(NonRecursive nonRecursive, LetTerm letTerm) {
                nonRecursive.enqueueWalker((NonRecursive.Walker)new ColorTerm(new FormulaUnLet().unlet((Term)letTerm), this.mPart));
            }

            public void walk(NonRecursive nonRecursive, LambdaTerm lambdaTerm) {
                nonRecursive.enqueueWalker((NonRecursive.Walker)new ColorTerm(lambdaTerm.getSubterm(), this.mPart));
            }

            public void walk(NonRecursive nonRecursive, QuantifiedFormula quantifiedFormula) {
                nonRecursive.enqueueWalker((NonRecursive.Walker)new ColorTerm(quantifiedFormula.getSubformula(), this.mPart));
            }

            public void walk(NonRecursive nonRecursive, TermVariable termVariable) {
            }

            public void walk(NonRecursive nonRecursive, MatchTerm matchTerm) {
                nonRecursive.enqueueWalker((NonRecursive.Walker)new ColorTerm(matchTerm.getDataTerm(), this.mPart));
                Term[] termArray = matchTerm.getCases();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term term = termArray[n2];
                    nonRecursive.enqueueWalker((NonRecursive.Walker)new ColorTerm(term, this.mPart));
                    ++n2;
                }
            }
        }
    }

    public static class CombineInterpolants
    implements NonRecursive.Walker {
        private final Term mPivot;

        public CombineInterpolants(Term term) {
            this.mPivot = term;
        }

        public void walk(NonRecursive nonRecursive) {
            ((Interpolator)nonRecursive).combine(this.mPivot);
        }
    }

    class EQSubstitutor
    extends TermTransformer {
        Term mI2;
        TermVariable mAuxVar;

        EQSubstitutor(Term term, TermVariable termVariable) {
            this.mI2 = term;
            this.mAuxVar = termVariable;
        }

        public void convert(Term term) {
            assert (term != this.mAuxVar);
            if (term instanceof ApplicationTerm) {
                ApplicationTerm applicationTerm = (ApplicationTerm)term;
                FunctionSymbol functionSymbol = applicationTerm.getFunction();
                Term[] termArray = applicationTerm.getParameters();
                if (functionSymbol.isIntern() && functionSymbol.getName().equals(Interpolator.EQ) && termArray[0] == this.mAuxVar) {
                    assert (termArray.length == 2);
                    this.setResult(Interpolator.this.substitute(this.mI2, this.mAuxVar, termArray[1]));
                    return;
                }
            }
            super.convert(term);
        }
    }

    class IntegerInterpolator
    extends MixedLAInterpolator {
        public IntegerInterpolator(Term term, TermVariable termVariable) {
            super(term, termVariable);
        }

        @Override
        public Term interpolate(AnnotatedTerm annotatedTerm, AnnotatedTerm annotatedTerm2) {
            Rational rational;
            InterpolatorAffineTerm interpolatorAffineTerm;
            Rational rational2;
            Rational rational3;
            InterpolatorAffineTerm interpolatorAffineTerm2 = LAInterpolator.getS((Term)annotatedTerm);
            Rational rational4 = interpolatorAffineTerm2.getSummands().get(this.mMixedVar);
            InfinitesimalNumber infinitesimalNumber = LAInterpolator.getK((Term)annotatedTerm);
            InterpolatorAffineTerm interpolatorAffineTerm3 = LAInterpolator.getS((Term)annotatedTerm2);
            Rational rational5 = interpolatorAffineTerm3.getSummands().get(this.mMixedVar);
            InfinitesimalNumber infinitesimalNumber2 = LAInterpolator.getK((Term)annotatedTerm2);
            assert (rational4.isIntegral() && rational5.isIntegral());
            assert (rational4.signum() * rational5.signum() == -1);
            Rational rational6 = rational4.abs();
            Rational rational7 = rational5.abs();
            InterpolatorAffineTerm interpolatorAffineTerm4 = new InterpolatorAffineTerm();
            interpolatorAffineTerm4.add(rational6, interpolatorAffineTerm3);
            interpolatorAffineTerm4.add(rational7, interpolatorAffineTerm2);
            assert (!interpolatorAffineTerm4.getSummands().containsKey(this.mMixedVar));
            Rational rational8 = rational6.mul(rational7);
            InfinitesimalNumber infinitesimalNumber3 = infinitesimalNumber.mul(rational7).add(infinitesimalNumber2.mul(rational6)).add(new InfinitesimalNumber(rational8, 0));
            assert (infinitesimalNumber3.isIntegral());
            Rational rational9 = infinitesimalNumber.mReal.add(Rational.ONE).div(rational6).ceil();
            if (rational9.compareTo(rational3 = infinitesimalNumber2.mReal.add(Rational.ONE).div(rational7).ceil()) < 0) {
                rational2 = rational4;
                interpolatorAffineTerm = interpolatorAffineTerm2;
                rational = rational9;
            } else {
                rational2 = rational5;
                interpolatorAffineTerm = interpolatorAffineTerm3;
                rational = rational3;
            }
            ApplicationTerm applicationTerm = Interpolator.this.mTheory.mFalse;
            InterpolatorAffineTerm interpolatorAffineTerm5 = new InterpolatorAffineTerm();
            interpolatorAffineTerm5.add(rational2.signum() > 0 ? Rational.MONE : Rational.ONE, interpolatorAffineTerm);
            interpolatorAffineTerm5.getSummands().remove(this.mMixedVar);
            Rational rational10 = Rational.ZERO;
            Rational rational11 = rational2.abs();
            if (rational2.signum() < 0) {
                interpolatorAffineTerm5.add(rational11.add(Rational.MONE));
            }
            while (rational10.compareTo(rational) <= 0) {
                if (Interpolator.this.mCancel.isTerminationRequested()) {
                    throw new SMTLIBException("Termination requested (timeout or resource limit)");
                }
                Term term = interpolatorAffineTerm5.toSMTLib(Interpolator.this.mTheory, true);
                if (rational11 != Rational.ONE) {
                    term = Interpolator.this.mTheory.term("div", new Term[]{term, rational11.toTerm(Interpolator.this.mTheory.getNumericSort())});
                }
                Term term2 = Interpolator.this.substitute(annotatedTerm.getSubterm(), this.mMixedVar, term);
                Term term3 = Interpolator.this.substitute(annotatedTerm2.getSubterm(), this.mMixedVar, term);
                if (rational10.compareTo(rational) == 0) {
                    if (interpolatorAffineTerm == interpolatorAffineTerm2) {
                        term2 = Interpolator.this.mTheory.mTrue;
                    } else {
                        term3 = Interpolator.this.mTheory.mTrue;
                    }
                }
                applicationTerm = Interpolator.this.mTheory.or(new Term[]{applicationTerm, Interpolator.this.mTheory.and(new Term[]{term2, term3})});
                interpolatorAffineTerm5.add(rational2.negate());
                rational10 = rational10.add(Rational.ONE);
            }
            return LAInterpolator.createLATerm(interpolatorAffineTerm4, infinitesimalNumber3, (Term)applicationTerm);
        }
    }

    class LitInfo
    extends Occurrence {
        TermVariable mMixedVar;
        Occurrence mLhsOccur;
        InterpolatorAffineTerm[] mAPart;

        public LitInfo() {
        }

        public LitInfo(BitSet bitSet, BitSet bitSet2) {
            super(bitSet, bitSet2);
        }

        public TermVariable getMixedVar() {
            return this.mMixedVar;
        }

        public Occurrence getLhsOccur() {
            return this.mLhsOccur;
        }

        public InterpolatorAffineTerm getAPart(int n) {
            return this.mAPart[n];
        }
    }

    static abstract class MixedLAInterpolator
    extends TermTransformer {
        TermVariable mMixedVar;
        Term mI2;
        AnnotatedTerm mLA1;

        public MixedLAInterpolator(Term term, TermVariable termVariable) {
            this.mMixedVar = termVariable;
            this.mLA1 = null;
            this.mI2 = term;
        }

        abstract Term interpolate(AnnotatedTerm var1, AnnotatedTerm var2);

        public void convert(Term term) {
            assert (term != this.mMixedVar);
            if (LAInterpolator.isLATerm(term)) {
                AnnotatedTerm annotatedTerm = (AnnotatedTerm)term;
                InterpolatorAffineTerm interpolatorAffineTerm = LAInterpolator.getS(term);
                if (interpolatorAffineTerm.getSummands().get(this.mMixedVar) != null) {
                    if (this.mLA1 == null) {
                        this.beginScope(new TermVariable[]{this.mMixedVar});
                        this.mLA1 = annotatedTerm;
                        this.enqueueWalker(new NonRecursive.Walker(){

                            public void walk(NonRecursive nonRecursive) {
                                ((MixedLAInterpolator)nonRecursive).mLA1 = null;
                                ((MixedLAInterpolator)nonRecursive).endScope();
                            }
                        });
                        this.pushTerm(this.mI2);
                        return;
                    }
                    this.setResult(this.interpolate(this.mLA1, annotatedTerm));
                    return;
                }
            }
            super.convert(term);
        }
    }

    class Occurrence {
        BitSet mInA;
        BitSet mInB;

        public Occurrence() {
            this.mInA = new BitSet(Interpolator.this.mNumInterpolants + 1);
            this.mInA.set(Interpolator.this.mNumInterpolants);
            this.mInB = new BitSet(Interpolator.this.mNumInterpolants + 1);
        }

        public Occurrence(BitSet bitSet, BitSet bitSet2) {
            this.mInA = bitSet;
            this.mInB = bitSet2;
        }

        public void occursIn(int n) {
            int n2 = 0;
            while (n2 <= Interpolator.this.mNumInterpolants) {
                if (n == -1) {
                    this.mInA.set(n2);
                    if (n2 != Interpolator.this.mNumInterpolants) {
                        this.mInB.set(n2);
                    }
                } else if (n2 < n || Interpolator.this.mStartOfSubtrees[n2] > n) {
                    this.mInB.set(n2);
                } else {
                    this.mInA.set(n2);
                }
                ++n2;
            }
        }

        public boolean isALocalInSomeChild(int n) {
            int n2 = n - 1;
            while (n2 >= Interpolator.this.mStartOfSubtrees[n]) {
                if (this.mInA.get(n2)) {
                    return true;
                }
                n2 = Interpolator.this.mStartOfSubtrees[n2] - 1;
            }
            return false;
        }

        public boolean contains(int n) {
            if (n == -1) {
                int n2 = 0;
                while (n2 <= Interpolator.this.mNumInterpolants) {
                    if (!this.mInA.get(n2) || !this.mInB.get(n2)) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
            if (!this.mInA.get(n)) {
                return false;
            }
            if (this.mInB.get(n)) {
                return true;
            }
            int n3 = n - 1;
            while (n3 >= Interpolator.this.mStartOfSubtrees[n]) {
                if (!this.mInB.get(n3)) {
                    return false;
                }
                n3 = Interpolator.this.mStartOfSubtrees[n3] - 1;
            }
            return true;
        }

        public Occurrence intersect(Occurrence occurrence) {
            BitSet bitSet = (BitSet)this.mInA.clone();
            BitSet bitSet2 = (BitSet)this.mInB.clone();
            bitSet.and(occurrence.mInA);
            bitSet2.and(occurrence.mInB);
            return new Occurrence(bitSet, bitSet2);
        }

        public boolean isAorShared(int n) {
            return this.mInA.get(n);
        }

        public boolean isBorShared(int n) {
            return this.mInB.get(n);
        }

        public boolean isALocal(int n) {
            return this.mInA.get(n) && !this.mInB.get(n);
        }

        public boolean isBLocal(int n) {
            return this.mInB.get(n) && !this.mInA.get(n);
        }

        public boolean isAB(int n) {
            return this.mInA.get(n) && this.mInB.get(n);
        }

        public boolean isMixed(int n) {
            return !this.mInA.get(n) && !this.mInB.get(n);
        }

        public String toString() {
            return "[" + String.valueOf(this.mInA) + "|" + String.valueOf(this.mInB) + "]";
        }

        public int getALocalColor() {
            int n = this.mInA.nextSetBit(0);
            if (this.mInB.get(n)) {
                n = this.mInB.nextClearBit(n);
            }
            return n;
        }
    }

    public static class ProofTreeWalker
    implements NonRecursive.Walker {
        private final Term mProofTerm;

        public ProofTreeWalker(Term term) {
            this.mProofTerm = term;
        }

        public void walk(NonRecursive nonRecursive) {
            Interpolator interpolator = (Interpolator)nonRecursive;
            if (interpolator.checkCacheForInterpolants(this.mProofTerm)) {
                return;
            }
            InterpolatorClauseInfo interpolatorClauseInfo = ((Interpolator)nonRecursive).getClauseTermInfo(this.mProofTerm);
            if (interpolatorClauseInfo.isResolution()) {
                ((Interpolator)nonRecursive).walkResolutionNode(this.mProofTerm);
            } else {
                ((Interpolator)nonRecursive).walkLeafNode(this.mProofTerm);
            }
        }
    }

    class RealInterpolator
    extends MixedLAInterpolator {
        public RealInterpolator(Term term, TermVariable termVariable) {
            super(term, termVariable);
        }

        @Override
        public Term interpolate(AnnotatedTerm annotatedTerm, AnnotatedTerm annotatedTerm2) {
            Term term;
            InterpolatorAffineTerm interpolatorAffineTerm = LAInterpolator.getS((Term)annotatedTerm);
            Rational rational = interpolatorAffineTerm.getSummands().get(this.mMixedVar);
            InfinitesimalNumber infinitesimalNumber = LAInterpolator.getK((Term)annotatedTerm);
            InterpolatorAffineTerm interpolatorAffineTerm2 = LAInterpolator.getS((Term)annotatedTerm2);
            Rational rational2 = interpolatorAffineTerm2.getSummands().get(this.mMixedVar);
            InfinitesimalNumber infinitesimalNumber2 = LAInterpolator.getK((Term)annotatedTerm2);
            assert (rational.signum() * rational2.signum() == -1);
            InfinitesimalNumber infinitesimalNumber3 = infinitesimalNumber.mul(rational2.abs()).add(infinitesimalNumber2.mul(rational.abs()));
            InterpolatorAffineTerm interpolatorAffineTerm3 = new InterpolatorAffineTerm();
            interpolatorAffineTerm3.add(rational.abs(), interpolatorAffineTerm2);
            interpolatorAffineTerm3.add(rational2.abs(), interpolatorAffineTerm);
            assert (!interpolatorAffineTerm3.getSummands().containsKey(this.mMixedVar));
            if (interpolatorAffineTerm.getConstant().mEps > 0 || interpolatorAffineTerm2.getConstant().mEps > 0) {
                term = interpolatorAffineTerm3.toLeq0(Interpolator.this.mTheory);
                infinitesimalNumber3 = InfinitesimalNumber.EPSILON.negate();
            } else if (infinitesimalNumber.less(InfinitesimalNumber.ZERO)) {
                InterpolatorAffineTerm interpolatorAffineTerm4 = new InterpolatorAffineTerm(interpolatorAffineTerm);
                interpolatorAffineTerm4.getSummands().remove(this.mMixedVar);
                interpolatorAffineTerm4.mul(rational.inverse().negate());
                Term term2 = interpolatorAffineTerm4.toSMTLib(Interpolator.this.mTheory, false);
                term = Interpolator.this.substitute(annotatedTerm2.getSubterm(), this.mMixedVar, term2);
                infinitesimalNumber3 = infinitesimalNumber2;
            } else if (infinitesimalNumber2.less(InfinitesimalNumber.ZERO)) {
                InterpolatorAffineTerm interpolatorAffineTerm5 = new InterpolatorAffineTerm(interpolatorAffineTerm2);
                interpolatorAffineTerm5.getSummands().remove(this.mMixedVar);
                interpolatorAffineTerm5.mul(rational2.inverse().negate());
                Term term3 = interpolatorAffineTerm5.toSMTLib(Interpolator.this.mTheory, false);
                term = Interpolator.this.substitute(annotatedTerm.getSubterm(), this.mMixedVar, term3);
                infinitesimalNumber3 = infinitesimalNumber;
            } else {
                InterpolatorAffineTerm interpolatorAffineTerm6 = new InterpolatorAffineTerm(interpolatorAffineTerm);
                interpolatorAffineTerm6.getSummands().remove(this.mMixedVar);
                interpolatorAffineTerm6.mul(rational.inverse().negate());
                Term term4 = interpolatorAffineTerm6.toSMTLib(Interpolator.this.mTheory, false);
                Term term5 = Interpolator.this.substitute(annotatedTerm.getSubterm(), this.mMixedVar, term4);
                Term term6 = Interpolator.this.substitute(annotatedTerm2.getSubterm(), this.mMixedVar, term4);
                term = Interpolator.this.mTheory.and(new Term[]{term5, term6});
                if (interpolatorAffineTerm3.isConstant()) {
                    if (interpolatorAffineTerm3.getConstant().less(InfinitesimalNumber.ZERO)) {
                        term = Interpolator.this.mTheory.mTrue;
                    }
                } else {
                    InterpolatorAffineTerm interpolatorAffineTerm7 = new InterpolatorAffineTerm(interpolatorAffineTerm3);
                    interpolatorAffineTerm7.add(InfinitesimalNumber.EPSILON);
                    term = Interpolator.this.mTheory.or(new Term[]{interpolatorAffineTerm7.toLeq0(Interpolator.this.mTheory), term});
                }
                infinitesimalNumber3 = InfinitesimalNumber.ZERO;
            }
            return LAInterpolator.createLATerm(interpolatorAffineTerm3, infinitesimalNumber3, term);
        }
    }

    public static class Substitutor
    extends TermTransformer {
        TermVariable mTermVar;
        Term mReplacement;

        public Substitutor(TermVariable termVariable, Term term) {
            this.mTermVar = termVariable;
            this.mReplacement = term;
        }

        private static boolean isSMTAffineTerm(Term term) {
            if (!term.getSort().isNumericSort()) {
                return false;
            }
            if (term instanceof ApplicationTerm) {
                FunctionSymbol functionSymbol = ((ApplicationTerm)term).getFunction();
                return functionSymbol.isIntern() && (functionSymbol.getName() == "+" || functionSymbol.getName() == "-" || functionSymbol.getName() == "*" || functionSymbol.getName() == "to_real");
            }
            return term instanceof ConstantTerm;
        }

        public void convert(final Term term) {
            if (Substitutor.isSMTAffineTerm(term)) {
                final SMTAffineTerm sMTAffineTerm = new SMTAffineTerm(term);
                final Term[] termArray = sMTAffineTerm.getSummands().keySet().toArray(new Term[sMTAffineTerm.getSummands().size()]);
                this.enqueueWalker(new NonRecursive.Walker(){

                    public void walk(NonRecursive nonRecursive) {
                        Substitutor substitutor = (Substitutor)nonRecursive;
                        Term[] termArray2 = substitutor.getConverted(termArray);
                        if (termArray2 == termArray) {
                            substitutor.setResult(term);
                            return;
                        }
                        SMTAffineTerm sMTAffineTerm2 = new SMTAffineTerm();
                        int n = 0;
                        while (n < termArray.length) {
                            sMTAffineTerm2.add(sMTAffineTerm.getSummands().get(termArray[n]), termArray2[n]);
                            ++n;
                        }
                        sMTAffineTerm2.add(sMTAffineTerm.getConstant());
                        substitutor.setResult(sMTAffineTerm2.toTerm(term.getSort()));
                    }
                });
                this.pushTerms(termArray);
                return;
            }
            if (LAInterpolator.isLATerm(term)) {
                final InterpolatorAffineTerm interpolatorAffineTerm = LAInterpolator.getS(term);
                final InfinitesimalNumber infinitesimalNumber = LAInterpolator.getK(term);
                final Term term2 = LAInterpolator.getF(term);
                final Term[] termArray = interpolatorAffineTerm.getSummands().keySet().toArray(new Term[interpolatorAffineTerm.getSummands().size()]);
                this.enqueueWalker(new NonRecursive.Walker(){

                    public void walk(NonRecursive nonRecursive) {
                        Substitutor substitutor = (Substitutor)nonRecursive;
                        Term term3 = substitutor.getConverted();
                        Term[] termArray2 = substitutor.getConverted(termArray);
                        if (term3 == term2 && termArray2 == termArray) {
                            substitutor.setResult(term);
                            return;
                        }
                        InterpolatorAffineTerm interpolatorAffineTerm2 = new InterpolatorAffineTerm();
                        int n = 0;
                        while (n < termArray.length) {
                            interpolatorAffineTerm2.add(interpolatorAffineTerm.getSummands().get(termArray[n]), termArray2[n]);
                            ++n;
                        }
                        interpolatorAffineTerm2.add(interpolatorAffineTerm.getConstant());
                        substitutor.setResult(LAInterpolator.createLATerm(interpolatorAffineTerm2, infinitesimalNumber, term3));
                    }
                });
                this.pushTerm(term2);
                this.pushTerms(termArray);
                return;
            }
            if (term.equals(this.mTermVar)) {
                this.setResult(this.mReplacement);
            } else {
                super.convert(term);
            }
        }
    }

    public static class SummarizeResolution
    implements NonRecursive.Walker {
        private final Term mProofTerm;

        public SummarizeResolution(Term term) {
            this.mProofTerm = term;
        }

        public void walk(NonRecursive nonRecursive) {
            ((Interpolator)nonRecursive).summarize(this.mProofTerm);
        }
    }

    class TermSubstitutor
    extends TermTransformer {
        Term mTerm;
        Term mReplacement;

        TermSubstitutor(Term term, Term term2) {
            this.mTerm = term;
            this.mReplacement = term2;
        }

        public void convert(final Term term) {
            if (term == this.mTerm) {
                this.setResult(this.mReplacement);
            } else {
                if (term instanceof ApplicationTerm) {
                    final Term[] termArray = ((ApplicationTerm)term).getParameters();
                    this.enqueueWalker(new NonRecursive.Walker(){

                        public void walk(NonRecursive nonRecursive) {
                            TermSubstitutor termSubstitutor = (TermSubstitutor)nonRecursive;
                            String string = ((ApplicationTerm)term).getFunction().getName();
                            Term[] termArray2 = termSubstitutor.getConverted(termArray);
                            if (termArray2 == termArray) {
                                termSubstitutor.setResult(term);
                                return;
                            }
                            Term term2 = ((TermSubstitutor)TermSubstitutor.this).Interpolator.this.mTheory.term(string, termArray2);
                            termSubstitutor.setResult(term2);
                        }
                    });
                    this.pushTerms(termArray);
                    return;
                }
                super.convert(term);
            }
        }
    }
}

