/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.option;

import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.smtinterpol.ChannelUtil;
import de.uni_freiburg.informatik.ultimate.smtinterpol.option.Option;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;

public class ChannelOption
extends Option {
    private String mName;
    private String mDefaultName;
    private PrintWriter mWriter;

    public ChannelOption(String string, boolean bl, String string2) {
        super(bl, string2);
        this.createChannel(string);
        this.mName = this.mDefaultName = string;
    }

    @Override
    public Option copy() {
        return this;
    }

    @Override
    public void set(Object object) {
        if (object instanceof Writer) {
            this.mWriter = new PrintWriter((Writer)object);
            this.mName = "@" + object.toString();
        } else {
            if (object instanceof QuotedObject) {
                object = ((QuotedObject)object).getValue();
            }
            String string = object.toString();
            this.createChannel(string);
            this.mName = string;
        }
    }

    @Override
    public Object get() {
        return new QuotedObject(this.mName);
    }

    @Override
    public void reset() {
        this.createChannel(this.mName);
        this.mName = this.mDefaultName;
    }

    @Override
    public Object defaultValue() {
        return new QuotedObject(this.mDefaultName);
    }

    private void createChannel(String string) {
        try {
            this.mWriter = ChannelUtil.createChannel(string);
        }
        catch (IOException iOException) {
            throw new SMTLIBException((Throwable)iOException);
        }
    }

    @Override
    public void started() {
        this.mDefaultName = this.mName;
    }

    public PrintWriter getChannel() {
        return this.mWriter;
    }
}

