/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.poset;

import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.TopologicalSorter;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.statistics.BenchmarkWithCounters;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;

public class PartialOrderCache<E> {
    private static final boolean BENCHMARK = true;
    private final IPartialComparator<E> mComparator;
    private final HashRelation<E, E> mStrictlySmaller;
    private final HashRelation<E, E> mNotStrictlySmaller;
    private final UnionFind<E> mEquivalences;
    private final Set<E> mMaximalElements;
    private final BenchmarkWithCounters mBenchmark;

    public PartialOrderCache(IPartialComparator<E> iPartialComparator) {
        this.mComparator = iPartialComparator;
        this.mStrictlySmaller = new HashRelation();
        this.mNotStrictlySmaller = new HashRelation();
        this.mEquivalences = new UnionFind();
        this.mMaximalElements = new HashSet();
        this.mBenchmark = new BenchmarkWithCounters();
        this.mBenchmark.registerCountersAndWatches(PocBmNames.getNames());
    }

    public E addElement(E e) {
        this.bmStart(PocBmNames.ELEMENTS_ADDED);
        E e2 = this.mEquivalences.find(e);
        if (e2 != null) {
            this.bmEnd(PocBmNames.ELEMENTS_ADDED);
            return e2;
        }
        e2 = this.mEquivalences.findAndConstructEquivalenceClassIfNeeded(e);
        assert (e2 == e);
        this.mMaximalElements.add(e2);
        for (E e3 : new ArrayList<E>(this.mEquivalences.getAllRepresentatives())) {
            if (e3 == e2) continue;
            this.bmStart(PocBmNames.ORDER_REQUESTS_MADE);
            IPartialComparator.ComparisonResult comparisonResult = this.mComparator.compare(e, e3);
            this.bmEnd(PocBmNames.ORDER_REQUESTS_MADE);
            switch (comparisonResult) {
                case EQUAL: {
                    this.mEquivalences.union(e2, e3);
                    E e4 = this.mEquivalences.find(e2);
                    if (e4 == e2) {
                        assert (this.mEquivalences.find(e3) == e2);
                        this.mMaximalElements.remove(e3);
                        this.mStrictlySmaller.replaceDomainElement(e3, e4);
                        this.mStrictlySmaller.replaceRangeElement(e3, e4);
                    } else {
                        this.mMaximalElements.remove(e2);
                        this.mStrictlySmaller.replaceDomainElement(e2, e4);
                        this.mStrictlySmaller.replaceRangeElement(e2, e4);
                    }
                    assert (this.assertInvariants());
                    this.bmEnd(PocBmNames.ELEMENTS_ADDED);
                    return e4;
                }
                case STRICTLY_SMALLER: {
                    this.addStrictlySmaller(e, e3);
                    break;
                }
                case STRICTLY_GREATER: {
                    this.addStrictlySmaller(e3, e);
                    break;
                }
                case INCOMPARABLE: {
                    this.mNotStrictlySmaller.addPair(e, e3);
                    this.mNotStrictlySmaller.addPair(e3, e);
                }
            }
        }
        this.bmEnd(PocBmNames.ELEMENTS_ADDED);
        assert (this.assertInvariants());
        return e2;
    }

    private void addStrictlySmaller(E e, E e2) {
        assert (this.mEquivalences.find(e) == e);
        assert (this.mEquivalences.find(e2) == e2);
        E e3 = this.mEquivalences.find(e);
        E e4 = this.mEquivalences.find(e2);
        this.mStrictlySmaller.addPair(e3, e4);
        this.mNotStrictlySmaller.addPair(e4, e3);
        assert (this.assertStrictlySmaller(e3, e4));
        this.mMaximalElements.remove(e3);
        assert (this.assertInvariants());
    }

    public boolean isSmallerOrEqual(E e, E e2) {
        E e3;
        this.bmStart(PocBmNames.ORDER_REQUESTS_ANSWERED);
        if (e == e2) {
            return true;
        }
        assert (this.assertInvariants());
        E e4 = this.addElement(e);
        if (e4 == (e3 = this.addElement(e2))) {
            this.bmEnd(PocBmNames.ORDER_REQUESTS_ANSWERED);
            return true;
        }
        boolean bl = this.isStrictlySmaller(e4, e3);
        this.bmEnd(PocBmNames.ORDER_REQUESTS_ANSWERED);
        return bl;
    }

    private boolean isStrictlySmaller(E e, E e2) {
        if (this.mStrictlySmaller.containsPair(e, e2)) {
            return true;
        }
        if (this.mNotStrictlySmaller.containsPair(e, e2)) {
            return false;
        }
        ArrayDeque<Object> arrayDeque = new ArrayDeque<Object>();
        arrayDeque.add(e);
        while (!arrayDeque.isEmpty()) {
            Object e3 = arrayDeque.pop();
            if (e3 == e2 && e3 != e) {
                this.mStrictlySmaller.addPair(e, e2);
                assert (this.assertStrictlySmaller(e, e2));
                assert (this.assertInvariants());
                return true;
            }
            arrayDeque.addAll(this.mStrictlySmaller.getImage(e3));
        }
        this.mNotStrictlySmaller.addPair(e, e2);
        return false;
    }

    public Set<E> getMaximalRepresentatives(Collection<E> collection) {
        Object object2;
        HashSet<E> hashSet = new HashSet<E>();
        for (Object object2 : collection) {
            hashSet.add(this.addElement(object2));
        }
        object2 = new HashSet(hashSet);
        for (Iterator<E> iterator : hashSet) {
            for (Object e : hashSet) {
                if (!this.isStrictlySmaller(iterator, e)) continue;
                object2.remove(iterator);
            }
        }
        return object2;
    }

    public Set<E> getMaximalRepresentatives() {
        return this.mMaximalElements;
    }

    public List<E> getTopologicalOrdering() {
        return this.topSortIntern(TopologicalSorter::topologicalOrdering);
    }

    public List<E> getReverseTopologicalOrdering() {
        return this.topSortIntern(TopologicalSorter::reversedTopologicalOrdering);
    }

    private List<E> topSortIntern(BiFunction<TopologicalSorter<E>, Collection<E>, Optional<List<E>>> biFunction) {
        TopologicalSorter<Object> topologicalSorter = new TopologicalSorter<Object>(this::successor);
        return biFunction.apply(topologicalSorter, this.mMaximalElements).orElseThrow(() -> new AssertionError((Object)"Cycle in partial order"));
    }

    private Collection<E> successor(E e) {
        return this.mEquivalences.getAllElements().stream().filter(object2 -> this.isStrictlySmaller(e, object2)).collect(Collectors.toList());
    }

    private boolean assertStrictlySmaller(E e, E e2) {
        IPartialComparator.ComparisonResult comparisonResult = this.mComparator.compare(e, e2);
        if (comparisonResult != IPartialComparator.ComparisonResult.STRICTLY_SMALLER) {
            assert (false);
            return false;
        }
        return true;
    }

    private boolean assertInvariants() {
        E e;
        for (E object : this.mMaximalElements) {
            if (object == (e = this.mEquivalences.find(object))) continue;
            assert (false);
            return false;
        }
        for (Map.Entry entry : this.mStrictlySmaller) {
            e = this.mEquivalences.find(entry.getKey());
            if (e != entry.getKey()) {
                assert (false);
                return false;
            }
            E e2 = this.mEquivalences.find(entry.getValue());
            if (e2 == entry.getValue()) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public boolean hasElement(E e) {
        return this.mEquivalences.find(e) != null;
    }

    public boolean hasBenchmark() {
        return true;
    }

    public BenchmarkWithCounters getBenchmark() {
        if (!this.hasBenchmark()) {
            throw new IllegalStateException();
        }
        return this.mBenchmark;
    }

    private void bmStart(PocBmNames pocBmNames) {
        this.mBenchmark.incrementCounter(pocBmNames.name());
        this.mBenchmark.unpauseWatch(pocBmNames.name());
    }

    private void bmEnd(PocBmNames pocBmNames) {
        this.mBenchmark.pauseWatch(pocBmNames.name());
    }

    private static enum PocBmNames {
        ORDER_REQUESTS_MADE,
        ORDER_REQUESTS_ANSWERED,
        ELEMENTS_ADDED;


        static String[] getNames() {
            String[] stringArray = new String[PocBmNames.values().length];
            int n = 0;
            while (n < PocBmNames.values().length) {
                stringArray[n] = PocBmNames.values()[n].name();
                ++n;
            }
            return stringArray;
        }
    }
}

