/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.chc;

import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcHeadVar;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcPredicateSymbol;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.chc.HcVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.PureSubstitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class HornClause
implements IRankedLetter {
    private final List<HcPredicateSymbol> mBodyPreds;
    private final List<List<Term>> mBodyPredToArgs;
    private final List<HcHeadVar> mHeadPredVariables;
    private final HcPredicateSymbol mHeadPredicate;
    private final HcSymbolTable mHornClauseSymbolTable;
    private final Term mFormula;
    private final boolean mHeadIsFalse;
    private final Set<HcVar> mBodyVariables;
    private String mComment;

    public HornClause(ManagedScript managedScript, HcSymbolTable hcSymbolTable, Term term, List<HcPredicateSymbol> list, List<List<Term>> list2, Set<HcVar> set) {
        this(managedScript, hcSymbolTable, term, null, Collections.emptyList(), list, list2, set, false);
    }

    public HornClause(ManagedScript managedScript, HcSymbolTable hcSymbolTable, Term term, HcPredicateSymbol hcPredicateSymbol, List<HcHeadVar> list, List<HcPredicateSymbol> list2, List<List<Term>> list3, Set<HcVar> set) {
        this(managedScript, hcSymbolTable, term, hcPredicateSymbol, list, list2, list3, set, false);
        assert (hcPredicateSymbol != null) : "use other constructor for '... -> False' case";
    }

    private HornClause(ManagedScript managedScript, HcSymbolTable hcSymbolTable, Term term, HcPredicateSymbol hcPredicateSymbol, List<HcHeadVar> list, List<HcPredicateSymbol> list2, List<List<Term>> list3, Set<HcVar> set, boolean bl) {
        this.mHornClauseSymbolTable = hcSymbolTable;
        this.mFormula = term;
        this.mHeadIsFalse = hcPredicateSymbol == null;
        this.mHeadPredicate = hcPredicateSymbol;
        this.mHeadPredVariables = this.mHeadIsFalse ? Collections.emptyList() : Collections.unmodifiableList(list);
        this.mBodyPreds = Collections.unmodifiableList(list2);
        this.mBodyPredToArgs = Collections.unmodifiableList(list3);
        this.mBodyVariables = Collections.unmodifiableSet(set);
    }

    public HcPredicateSymbol getHeadPredicate() {
        if (this.mHeadIsFalse) {
            throw new AssertionError((Object)"Check for isHeadFalse() before calling this");
        }
        return this.mHeadPredicate;
    }

    public boolean isHeadFalse() {
        return this.mHeadIsFalse;
    }

    public List<HcPredicateSymbol> getBodyPredicates() {
        return this.mBodyPreds;
    }

    public int getNoBodyPredicates() {
        return this.mBodyPreds.size();
    }

    public Term getPredArgTermVariable(int n, int n2) {
        return this.mBodyPredToArgs.get(n).get(n2);
    }

    public List<Term> getTermVariablesForPredPos(int n) {
        return this.mBodyPredToArgs.get(n);
    }

    public List<List<Term>> getBodyPredToArgs() {
        return Collections.unmodifiableList(this.mBodyPredToArgs);
    }

    public List<HcHeadVar> getTermVariablesForHeadPred() {
        return this.mHeadPredVariables;
    }

    public void setComment(String string) {
        this.mComment = string;
    }

    public String getComment() {
        return this.mComment;
    }

    public boolean hasComment() {
        return this.mComment != null;
    }

    /*
     * WARNING - void declaration
     */
    public String debugString() {
        void var3_10;
        if (this.mFormula == null) {
            return "unintialized HornClause";
        }
        boolean bl = this.mBodyVariables.stream().allMatch(HcVar::hasComment) && this.mHeadPredVariables.stream().allMatch(HcVar::hasComment);
        HashMap<TermVariable, TermVariable> hashMap = new HashMap<TermVariable, TermVariable>();
        if (bl) {
            for (HcVar object2 : this.mBodyVariables) {
                hashMap.put(object2.getTermVariable(), this.mHornClauseSymbolTable.createPrettyTermVariable(object2.getComment(), object2.getSort()));
            }
            for (HcHeadVar hcHeadVar2 : this.mHeadPredVariables) {
                hashMap.put(hcHeadVar2.getTermVariable(), this.mHornClauseSymbolTable.createPrettyTermVariable(hcHeadVar2.getComment(), hcHeadVar2.getSort()));
            }
        }
        Object object3 = new StringBuilder();
        int n = 0;
        while (n < this.mBodyPredToArgs.size()) {
            ((StringBuilder)object3).append(" ");
            ((StringBuilder)object3).append(this.mBodyPreds.get(n));
            ((StringBuilder)object3).append(this.mBodyPredToArgs.get(n).stream().map(term -> PureSubstitution.apply((ManagedScript)this.mHornClauseSymbolTable.getManagedScript(), (Map)hashMap, (Term)term)).collect(Collectors.toList()));
            ++n;
        }
        String string = ((StringBuilder)object3).toString();
        if (string.length() > 0) {
            String string2 = "/\\" + string;
        } else {
            String string3 = "true";
        }
        String string4 = this.mHeadIsFalse ? "false" : this.mHeadPredicate.getName();
        object3 = string4 + String.valueOf(this.mHeadPredVariables.stream().map(hcHeadVar -> PureSubstitution.apply((ManagedScript)this.mHornClauseSymbolTable.getManagedScript(), (Map)hashMap, (Term)hcHeadVar.getTermVariable())).collect(Collectors.toList()));
        return String.format("%s(%s) /\\ (%s) --> %s", this.hasComment() ? this.getComment() + "| " : "", var3_10, PureSubstitution.apply((ManagedScript)this.mHornClauseSymbolTable.getManagedScript(), hashMap, (Term)this.mFormula).toString(), object3);
    }

    public String toString() {
        return this.debugString();
    }

    public HcSymbolTable getHornClauseSymbolTable() {
        return this.mHornClauseSymbolTable;
    }

    public int getRank() {
        return this.mBodyPreds.size();
    }

    public Term getConstraintFormula() {
        return this.mFormula;
    }

    public Set<HcVar> getBodyVariables() {
        return this.mBodyVariables;
    }

    public Term constructFormula(ManagedScript managedScript, boolean bl) {
        Object object;
        Term term = this.getTermVariablesForHeadPred();
        Term term2 = this.getBodyVariables();
        List<Term> list = term.stream().map(hcHeadVar -> hcHeadVar.getTermVariable()).collect(Collectors.toList());
        ArrayList<Object> arrayList = new ArrayList<TermVariable>(list);
        term2.forEach(hcVar -> {
            boolean bl = arrayList.add(hcVar.getTermVariable());
        });
        TermVariable[] termVariableArray = arrayList.toArray(new TermVariable[arrayList.size()]);
        managedScript.lock((Object)this);
        term = this.isHeadFalse() ? managedScript.term((Object)this, "false", new Term[0]) : managedScript.term((Object)this, this.getHeadPredicate().getName(), list.toArray(new Term[list.size()]));
        arrayList = new ArrayList();
        int n = 0;
        while (n < this.getNoBodyPredicates()) {
            object = this.getBodyPredicates().get(n);
            List<Term> list2 = this.getBodyPredToArgs().get(n).stream().collect(Collectors.toList());
            arrayList.add(managedScript.term((Object)this, ((HcPredicateSymbol)object).getName(), list2.toArray(new Term[list2.size()])));
            ++n;
        }
        arrayList.add(this.getConstraintFormula());
        term2 = SmtUtils.and((Script)managedScript.getScript(), arrayList);
        arrayList = managedScript.term((Object)this, "=>", new Term[]{term2, term});
        Object object2 = termVariableArray.length == 0 ? arrayList : managedScript.getScript().quantifier(1, termVariableArray, arrayList, (Term[][])new Term[0][]);
        object = bl ? this.nameTerm(managedScript, (Term)object2) : object2;
        managedScript.unlock((Object)this);
        return object;
    }

    private Term nameTerm(ManagedScript managedScript, Term term) {
        String string = "t" + this.hashCode();
        int n = 0;
        while (true) {
            String string2 = string + (String)(n == 0 ? "" : "_" + n);
            String string3 = "Function " + string2 + " is already defined.";
            try {
                return managedScript.getScript().annotate(term, new Annotation[]{new Annotation(":named", (Object)string2)});
            }
            catch (SMTLIBException sMTLIBException) {
                if (!string3.equals(sMTLIBException.getMessage())) {
                    throw sMTLIBException;
                }
                ++n;
                continue;
            }
            break;
        }
    }

    public int hashCode() {
        return Objects.hash(this.mBodyPredToArgs, this.mBodyPreds, this.mFormula, this.mHeadIsFalse, this.mHeadPredicate);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        HornClause hornClause = (HornClause)object;
        if (this.mBodyPredToArgs == null ? hornClause.mBodyPredToArgs != null : !this.mBodyPredToArgs.equals(hornClause.mBodyPredToArgs)) {
            return false;
        }
        if (this.mBodyPreds == null ? hornClause.mBodyPreds != null : !this.mBodyPreds.equals(hornClause.mBodyPreds)) {
            return false;
        }
        if (this.mFormula == null ? hornClause.mFormula != null : !this.mFormula.equals(hornClause.mFormula)) {
            return false;
        }
        if (this.mHeadIsFalse != hornClause.mHeadIsFalse) {
            return false;
        }
        return !(this.mHeadPredicate == null ? hornClause.mHeadPredicate != null : !this.mHeadPredicate.equals(hornClause.mHeadPredicate));
    }
}

