/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword;

public class InCaReTimer {
    private long mInternal = 0L;
    private long mCall = 0L;
    private long mReturn = 0L;
    private long mStartTime = 0L;

    private void run() {
        assert (this.mStartTime == 0L) : "timer already running";
        this.mStartTime = System.nanoTime();
    }

    public void runIn() {
        this.run();
    }

    public void runCa() {
        this.run();
    }

    public void runRe() {
        this.run();
    }

    public void stopIn() {
        this.mInternal += System.nanoTime() - this.mStartTime;
        this.mStartTime = 0L;
    }

    public void stopCa() {
        this.mCall += System.nanoTime() - this.mStartTime;
        this.mStartTime = 0L;
    }

    public void stopRe() {
        this.mReturn += System.nanoTime() - this.mStartTime;
        this.mStartTime = 0L;
    }

    public long getInternal() {
        return this.mInternal;
    }

    public long getCall() {
        return this.mCall;
    }

    public long getReturn() {
        return this.mReturn;
    }

    public static String prettyprintNanoseconds(long l) {
        long l2 = l / 1000000000L;
        long l3 = l / 100000000L % 10L;
        return Long.toString(l2) + "." + Long.toString(l3) + "s";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(InCaReTimer.prettyprintNanoseconds(this.mInternal)).append("In").append(InCaReTimer.prettyprintNanoseconds(this.mCall)).append("Ca").append(InCaReTimer.prettyprintNanoseconds(this.mReturn)).append("Re");
        return stringBuilder.toString();
    }
}

