/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IMLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.ISLPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsFuns;
import de.uni_freiburg.informatik.ultimate.lib.proofs.PrePostConditionSpecification;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.FloydHoareMapping;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.HoareAnnotationFragments;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.HoareAnnotationStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.IFloydHoareAnnotation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

class HoareAnnotationComposer {
    private static final boolean AVOID_IMPLICATIONS = true;
    private static final boolean USE_ENTRY = true;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final CfgSmtToolkit mCsToolkit;
    private final PredicateFactory mPredicateFactory;
    private final HoareAnnotationFragments<?> mHoareAnnotationFragments;
    private final HoareAnnotationStatisticsGenerator mHoareAnnotationStatisticsGenerator;
    private final NestedMap2<IPredicate, IPredicate, Term> mLoc2callPred2disjunction;
    private int mNumberOfFragments = 0;
    private final Map<IPredicate, IPredicate> mLoc2hoare;
    private final IPredicate mSurrogateForEmptyCallPred;

    public HoareAnnotationComposer(CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, HoareAnnotationFragments<?> hoareAnnotationFragments, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(this.getClass());
        this.mCsToolkit = cfgSmtToolkit;
        this.mPredicateFactory = predicateFactory;
        this.mHoareAnnotationFragments = hoareAnnotationFragments;
        this.mHoareAnnotationStatisticsGenerator = new HoareAnnotationStatisticsGenerator();
        this.mSurrogateForEmptyCallPred = this.mPredicateFactory.newPredicate(this.mCsToolkit.getManagedScript().getScript().term("true", new Term[0]));
        HashRelation3<IPredicate, IPredicate, Term> hashRelation3 = this.constructLoc2CallPred2DisjunctsMapping();
        this.mLoc2callPred2disjunction = this.constructLoc2Callpred2DisjunctionMapping(hashRelation3);
        this.mHoareAnnotationStatisticsGenerator.setNumberOfFragments(this.mNumberOfFragments);
        this.mHoareAnnotationStatisticsGenerator.setLocationsWithHoareAnnotation(this.mLoc2callPred2disjunction.keySet().size());
        this.mHoareAnnotationStatisticsGenerator.setPreInvPairs(this.mLoc2callPred2disjunction.size());
        this.mLoc2hoare = this.combineInter(this.mLoc2callPred2disjunction);
    }

    private Map<IPredicate, IPredicate> combineInter(NestedMap2<IPredicate, IPredicate, Term> nestedMap2) {
        HashMap<IPredicate, IPredicate> hashMap = new HashMap<IPredicate, IPredicate>();
        for (IPredicate iPredicate : nestedMap2.keySet()) {
            Term term;
            Term term2;
            Object object;
            ArrayList<Term> arrayList = new ArrayList<Term>();
            Map map = nestedMap2.get((Object)iPredicate);
            ArrayList<Term> arrayList2 = new ArrayList<Term>(map.size());
            for (Map.Entry entry : map.entrySet()) {
                object = entry.getKey() == this.mSurrogateForEmptyCallPred ? this.mSurrogateForEmptyCallPred : this.mHoareAnnotationFragments.getCallpred2Entry().get(entry.getKey());
                assert (object != null) : "no post for callpred";
                term2 = HoareAnnotationComposer.renameGlobalsToOldGlobals(object, this.mServices, this.mCsToolkit.getManagedScript());
                arrayList.add(term2);
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)("In " + String.valueOf(iPredicate) + " holds " + String.valueOf(entry.getValue()) + " for precond " + String.valueOf(term2)));
                }
                term = Util.implies((Script)this.mCsToolkit.getManagedScript().getScript(), (Term[])new Term[]{term2, (Term)entry.getValue()});
                term = new NnfTransformer(this.mCsToolkit.getManagedScript(), this.mServices, NnfTransformer.QuantifierHandling.KEEP).transform(term);
                arrayList2.add(term);
            }
            Term term32 = SmtUtils.or((Script)this.mCsToolkit.getManagedScript().getScript(), arrayList);
            arrayList2.add(term32);
            Term term3 = SmtUtils.and((Script)this.mCsToolkit.getManagedScript().getScript(), arrayList2);
            object = TermVarsFuns.computeTermVarsFuns((Term)term3, (ManagedScript)this.mCsToolkit.getManagedScript(), (IIcfgSymbolTable)this.mCsToolkit.getSymbolTable()).getVars();
            term3 = HoareAnnotationComposer.substituteOldVarsOfNonModifiableGlobals(HoareAnnotationComposer.getRelevantProcedure(iPredicate), (Set<IProgramVar>)object, term3, this.mCsToolkit.getModifiableGlobalsTable(), this.mCsToolkit.getManagedScript());
            term2 = SmtUtils.simplifyWithStatistics((ManagedScript)this.mCsToolkit.getManagedScript(), (Term)term3, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
            this.mHoareAnnotationStatisticsGenerator.reportSimplificationInter();
            this.mHoareAnnotationStatisticsGenerator.reportReductionInter(term2.getReductionOfTreeSize());
            this.mHoareAnnotationStatisticsGenerator.reportSimplificationTimeInter(term2.getSimplificationTimeNano());
            this.mHoareAnnotationStatisticsGenerator.reportAnnotationSize(new DAGSize().treesize(term2.getSimplifiedTerm()));
            term = term2.getSimplifiedTerm();
            Term term4 = SmtUtils.constructPositiveNormalForm((Script)this.mCsToolkit.getManagedScript().getScript(), (Term)term);
            BasicPredicate basicPredicate = this.mPredicateFactory.newPredicate(term4);
            hashMap.put(iPredicate, (IPredicate)basicPredicate);
        }
        return hashMap;
    }

    private static String getRelevantProcedure(IPredicate iPredicate) {
        if (iPredicate instanceof ISLPredicate) {
            return ((ISLPredicate)iPredicate).getProgramPoint().getProcedure();
        }
        if (iPredicate instanceof IMLPredicate) {
            IcfgLocation[] icfgLocationArray = ((IMLPredicate)iPredicate).getProgramPoints();
            if (icfgLocationArray.length == 1) {
                return icfgLocationArray[0].getProcedure();
            }
            return "ULTIMATE.init";
        }
        throw new IllegalArgumentException("unsupported type: " + String.valueOf(iPredicate.getClass()));
    }

    private NestedMap2<IPredicate, IPredicate, Term> constructLoc2Callpred2DisjunctionMapping(HashRelation3<IPredicate, IPredicate, Term> hashRelation3) {
        NestedMap2 nestedMap2 = new NestedMap2();
        for (IPredicate iPredicate : hashRelation3.projectToFst()) {
            for (IPredicate iPredicate2 : hashRelation3.projectToSnd((Object)iPredicate)) {
                Set set = hashRelation3.projectToTrd((Object)iPredicate, (Object)iPredicate2);
                this.mNumberOfFragments += set.size();
                Term term = this.or(set);
                nestedMap2.put((Object)iPredicate, (Object)iPredicate2, (Object)term);
            }
        }
        return nestedMap2;
    }

    private Term or(Set<Term> set) {
        Term term = SmtUtils.or((Script)this.mCsToolkit.getManagedScript().getScript(), set);
        SmtUtils.ExtendedSimplificationResult extendedSimplificationResult = SmtUtils.simplifyWithStatistics((ManagedScript)this.mCsToolkit.getManagedScript(), (Term)term, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.POLY_PAC);
        this.mHoareAnnotationStatisticsGenerator.reportSimplification();
        this.mHoareAnnotationStatisticsGenerator.reportReduction(extendedSimplificationResult.getReductionOfTreeSize());
        this.mHoareAnnotationStatisticsGenerator.reportSimplificationTime(extendedSimplificationResult.getSimplificationTimeNano());
        return extendedSimplificationResult.getSimplifiedTerm();
    }

    public HashRelation3<IPredicate, IPredicate, Term> constructLoc2CallPred2DisjunctsMapping() {
        HashRelation<IPredicate, IPredicate> hashRelation;
        HashRelation3 hashRelation3 = new HashRelation3();
        HoareAnnotationComposer.addHoareAnnotationForCallPred((HashRelation3<IPredicate, IPredicate, Term>)hashRelation3, this.mSurrogateForEmptyCallPred, this.mHoareAnnotationFragments.getProgPoint2StatesWithEmptyContext());
        for (IPredicate iPredicate : this.mHoareAnnotationFragments.getDeadContexts2ProgPoint2Preds().keySet()) {
            hashRelation = this.mHoareAnnotationFragments.getDeadContexts2ProgPoint2Preds().get(iPredicate);
            HoareAnnotationComposer.addHoareAnnotationForCallPred((HashRelation3<IPredicate, IPredicate, Term>)hashRelation3, iPredicate, hashRelation);
        }
        for (IPredicate iPredicate : this.mHoareAnnotationFragments.getLiveContexts2ProgPoint2Preds().keySet()) {
            hashRelation = this.mHoareAnnotationFragments.getLiveContexts2ProgPoint2Preds().get(iPredicate);
            HoareAnnotationComposer.addHoareAnnotationForCallPred((HashRelation3<IPredicate, IPredicate, Term>)hashRelation3, iPredicate, hashRelation);
        }
        return hashRelation3;
    }

    public HashRelation3<IPredicate, IPredicate, Term> constructMappingOld() {
        HashRelation<IPredicate, IPredicate> hashRelation;
        IPredicate iPredicate;
        HashRelation3 hashRelation3 = new HashRelation3();
        HoareAnnotationComposer.addHoareAnnotationForCallPred((HashRelation3<IPredicate, IPredicate, Term>)hashRelation3, this.mSurrogateForEmptyCallPred, this.mHoareAnnotationFragments.getProgPoint2StatesWithEmptyContext());
        for (IPredicate iPredicate2 : this.mHoareAnnotationFragments.getDeadContexts2ProgPoint2Preds().keySet()) {
            iPredicate = this.mHoareAnnotationFragments.getCallpred2Entry().get(iPredicate2);
            iPredicate = HoareAnnotationComposer.renameGlobalsToOldGlobals(iPredicate, this.mServices, this.mCsToolkit.getManagedScript(), (BasicPredicateFactory)this.mPredicateFactory, SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
            hashRelation = this.mHoareAnnotationFragments.getDeadContexts2ProgPoint2Preds().get(iPredicate2);
            HoareAnnotationComposer.addHoareAnnotationForCallPred((HashRelation3<IPredicate, IPredicate, Term>)hashRelation3, iPredicate, hashRelation);
        }
        for (IPredicate iPredicate2 : this.mHoareAnnotationFragments.getLiveContexts2ProgPoint2Preds().keySet()) {
            iPredicate = this.mHoareAnnotationFragments.getCallpred2Entry().get(iPredicate2);
            iPredicate = HoareAnnotationComposer.renameGlobalsToOldGlobals(iPredicate, this.mServices, this.mCsToolkit.getManagedScript(), (BasicPredicateFactory)this.mPredicateFactory, SmtUtils.SimplificationTechnique.SIMPLIFY_DDA);
            hashRelation = this.mHoareAnnotationFragments.getLiveContexts2ProgPoint2Preds().get(iPredicate2);
            HoareAnnotationComposer.addHoareAnnotationForCallPred((HashRelation3<IPredicate, IPredicate, Term>)hashRelation3, iPredicate, hashRelation);
        }
        return hashRelation3;
    }

    private static <DOM extends IPredicate> void addHoareAnnotationForCallPred(HashRelation3<IPredicate, IPredicate, Term> hashRelation3, IPredicate iPredicate, HashRelation<DOM, IPredicate> hashRelation) {
        for (IPredicate iPredicate2 : hashRelation.getDomain()) {
            Set set = hashRelation.getImage((Object)iPredicate2);
            for (IPredicate iPredicate3 : set) {
                hashRelation3.addTriple((Object)iPredicate2, (Object)iPredicate, (Object)iPredicate3.getFormula());
            }
        }
    }

    private static boolean containsAnOldVar(IPredicate iPredicate) {
        return iPredicate.getVars().stream().anyMatch(IProgramVar::isOldvar);
    }

    public HoareAnnotationStatisticsGenerator getHoareAnnotationStatisticsGenerator() {
        return this.mHoareAnnotationStatisticsGenerator;
    }

    public Map<IPredicate, IPredicate> getLoc2hoare() {
        return this.mLoc2hoare;
    }

    public IFloydHoareAnnotation<IPredicate> extractAnnotation(PrePostConditionSpecification<IPredicate> prePostConditionSpecification) {
        return new FloydHoareMapping<IPredicate>(prePostConditionSpecification, this.mLoc2hoare);
    }

    private static IPredicate renameGlobalsToOldGlobals(IPredicate iPredicate, IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, BasicPredicateFactory basicPredicateFactory, SmtUtils.SimplificationTechnique simplificationTechnique) {
        IProgramVar iProgramVar2;
        if (basicPredicateFactory.isDontCare(iPredicate)) {
            throw new UnsupportedOperationException("don't cat not expected");
        }
        HashMap<TermVariable, TermVariable> hashMap = new HashMap<TermVariable, TermVariable>();
        for (IProgramVar iProgramVar2 : iPredicate.getVars()) {
            if (!(iProgramVar2 instanceof IProgramNonOldVar)) continue;
            IProgramOldVar iProgramOldVar = ((IProgramNonOldVar)iProgramVar2).getOldVar();
            hashMap.put(iProgramVar2.getTermVariable(), iProgramOldVar.getTermVariable());
        }
        iProgramVar2 = Substitution.apply((ManagedScript)managedScript, hashMap, (Term)iPredicate.getFormula());
        iProgramVar2 = SmtUtils.simplify((ManagedScript)managedScript, (Term)iProgramVar2, (IUltimateServiceProvider)iUltimateServiceProvider, (SmtUtils.SimplificationTechnique)simplificationTechnique);
        BasicPredicate basicPredicate = basicPredicateFactory.newPredicate((Term)iProgramVar2);
        return basicPredicate;
    }

    private static Term renameGlobalsToOldGlobals(IPredicate iPredicate, IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript) {
        IProgramVar iProgramVar2;
        HashMap<TermVariable, TermVariable> hashMap = new HashMap<TermVariable, TermVariable>();
        for (IProgramVar iProgramVar2 : iPredicate.getVars()) {
            if (!(iProgramVar2 instanceof IProgramNonOldVar)) continue;
            IProgramOldVar iProgramOldVar = ((IProgramNonOldVar)iProgramVar2).getOldVar();
            hashMap.put(iProgramVar2.getTermVariable(), iProgramOldVar.getTermVariable());
        }
        iProgramVar2 = Substitution.apply((ManagedScript)managedScript, hashMap, (Term)iPredicate.getFormula());
        return iProgramVar2;
    }

    private static Term substituteOldVarsOfNonModifiableGlobals(String string, Set<IProgramVar> set, Term term, ModifiableGlobalsTable modifiableGlobalsTable, ManagedScript managedScript) {
        IProgramVar iProgramVar2;
        Set set2 = modifiableGlobalsTable.getModifiedBoogieVars(string);
        ArrayList<IProgramVar> arrayList = new ArrayList<IProgramVar>();
        HashMap<TermVariable, TermVariable> hashMap = new HashMap<TermVariable, TermVariable>();
        for (IProgramVar iProgramVar2 : set) {
            IProgramNonOldVar iProgramNonOldVar;
            if (!(iProgramVar2 instanceof IProgramOldVar) || set2.contains(iProgramNonOldVar = ((IProgramOldVar)iProgramVar2).getNonOldVar())) continue;
            hashMap.put(iProgramVar2.getTermVariable(), ((IProgramOldVar)iProgramVar2).getNonOldVar().getTermVariable());
            arrayList.add(iProgramVar2);
        }
        iProgramVar2 = Substitution.apply((ManagedScript)managedScript, hashMap, (Term)term);
        for (IProgramVar iProgramVar3 : arrayList) {
            set.remove(iProgramVar3);
            set.add((IProgramVar)((IProgramOldVar)iProgramVar3).getNonOldVar());
        }
        return iProgramVar2;
    }
}

