/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ReasonUnknown;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.HashSet;
import java.util.Set;

public class MonolithicHoareTripleChecker
implements IHoareTripleChecker {
    private final CfgSmtToolkit mCsToolkit;
    private final ManagedScript mManagedScript;
    private final ModifiableGlobalsTable mModifiableGlobals;
    private final HoareTripleCheckerStatisticsGenerator mHoareTripleCheckerStatistics;
    private ScopedHashMap<String, Term> mIndexedConstants;
    private int mTrivialSatQueries = 0;
    private int mNontrivialSatQueries = 0;
    private long mSatCheckSolverTime = 0L;
    private final int mTrivialCoverQueries = 0;
    private final int mNontrivialCoverQueries = 0;
    private long mSatCheckTime = 0L;

    public MonolithicHoareTripleChecker(CfgSmtToolkit cfgSmtToolkit) {
        this.mCsToolkit = cfgSmtToolkit;
        this.mManagedScript = cfgSmtToolkit.getManagedScript();
        this.mModifiableGlobals = cfgSmtToolkit.getModifiableGlobalsTable();
        this.mHoareTripleCheckerStatistics = new HoareTripleCheckerStatisticsGenerator();
    }

    @Override
    public IncrementalPlicationChecker.Validity checkInternal(IPredicate iPredicate, IInternalAction iInternalAction, IPredicate iPredicate2) {
        this.mHoareTripleCheckerStatistics.continueEdgeCheckerTime();
        IncrementalPlicationChecker.Validity validity = IncrementalPlicationChecker.convertLBool2Validity((Script.LBool)this.isInductive(iPredicate, iInternalAction, iPredicate2));
        this.mHoareTripleCheckerStatistics.stopEdgeCheckerTime();
        this.mHoareTripleCheckerStatistics.getSolverCounter(validity).incIn();
        return validity;
    }

    @Override
    public IncrementalPlicationChecker.Validity checkCall(IPredicate iPredicate, ICallAction iCallAction, IPredicate iPredicate2) {
        this.mHoareTripleCheckerStatistics.continueEdgeCheckerTime();
        IncrementalPlicationChecker.Validity validity = IncrementalPlicationChecker.convertLBool2Validity((Script.LBool)this.isInductiveCall(iPredicate, iCallAction, iPredicate2));
        this.mHoareTripleCheckerStatistics.stopEdgeCheckerTime();
        this.mHoareTripleCheckerStatistics.getSolverCounter(validity).incCa();
        return validity;
    }

    @Override
    public IncrementalPlicationChecker.Validity checkReturn(IPredicate iPredicate, IPredicate iPredicate2, IReturnAction iReturnAction, IPredicate iPredicate3) {
        this.mHoareTripleCheckerStatistics.continueEdgeCheckerTime();
        IncrementalPlicationChecker.Validity validity = IncrementalPlicationChecker.convertLBool2Validity((Script.LBool)this.isInductiveReturn(iPredicate, iPredicate2, iReturnAction, iPredicate3));
        this.mHoareTripleCheckerStatistics.stopEdgeCheckerTime();
        this.mHoareTripleCheckerStatistics.getSolverCounter(validity).incRe();
        return validity;
    }

    @Override
    public HoareTripleCheckerStatisticsGenerator getStatistics() {
        return this.mHoareTripleCheckerStatistics;
    }

    public void releaseLock() {
    }

    public Script.LBool isInductive(IPredicate iPredicate, IInternalAction iInternalAction, IPredicate iPredicate2) {
        return this.isInductive(iPredicate, iInternalAction, iPredicate2, false);
    }

    public Script.LBool isInductive(IPredicate iPredicate, IInternalAction iInternalAction, IPredicate iPredicate2, boolean bl) {
        this.mManagedScript.lock((Object)this);
        long l = System.nanoTime();
        if (MonolithicHoareTripleChecker.isDontCare(iPredicate) || MonolithicHoareTripleChecker.isDontCare(iPredicate2)) {
            ++this.mTrivialSatQueries;
            this.mManagedScript.unlock((Object)this);
            return Script.LBool.UNKNOWN;
        }
        if (SmtUtils.isFalseLiteral((Term)iPredicate.getFormula()) || SmtUtils.isTrueLiteral((Term)iPredicate2.getFormula())) {
            ++this.mTrivialSatQueries;
            this.mManagedScript.unlock((Object)this);
            return Script.LBool.UNSAT;
        }
        UnmodifiableTransFormula unmodifiableTransFormula = iInternalAction.getTransformula();
        String string = iInternalAction.getPrecedingProcedure();
        String string2 = iInternalAction.getSucceedingProcedure();
        Set<IProgramNonOldVar> set = this.mModifiableGlobals.getModifiedBoogieVars(string);
        Set<IProgramNonOldVar> set2 = this.mModifiableGlobals.getModifiedBoogieVars(string2);
        Script.LBool lBool = PredicateUtils.isInductiveHelper(this.mManagedScript.getScript(), iPredicate, iPredicate2, unmodifiableTransFormula, set, set2);
        if (bl) assert (lBool == Script.LBool.UNSAT || lBool == Script.LBool.UNKNOWN) : "From " + iPredicate.getFormula().toStringDirect() + "Statements " + iInternalAction.toString() + "To " + iPredicate2.getFormula().toStringDirect() + "Not inductive!";
        this.mSatCheckTime += System.nanoTime() - l;
        this.mManagedScript.unlock((Object)this);
        return lBool;
    }

    public Script.LBool isInductiveCall(IPredicate iPredicate, ICallAction iCallAction, IPredicate iPredicate2) {
        return this.isInductiveCall(iPredicate, iCallAction, iPredicate2, false);
    }

    public Script.LBool isInductiveCall(IPredicate iPredicate, ICallAction iCallAction, IPredicate iPredicate2, boolean bl) {
        this.mManagedScript.lock((Object)this);
        long l = System.nanoTime();
        if (MonolithicHoareTripleChecker.isDontCare(iPredicate) || MonolithicHoareTripleChecker.isDontCare(iPredicate2)) {
            ++this.mTrivialSatQueries;
            this.mManagedScript.unlock((Object)this);
            return Script.LBool.UNKNOWN;
        }
        if (SmtUtils.isFalseLiteral((Term)iPredicate.getFormula()) || SmtUtils.isTrueLiteral((Term)iPredicate2.getFormula())) {
            ++this.mTrivialSatQueries;
            this.mManagedScript.unlock((Object)this);
            return Script.LBool.UNSAT;
        }
        this.mManagedScript.getScript().push(1);
        this.mIndexedConstants = new ScopedHashMap();
        String string = iCallAction.getPrecedingProcedure();
        Set<IProgramNonOldVar> set = this.mModifiableGlobals.getModifiedBoogieVars(string);
        Term term = PredicateUtils.formulaWithIndexedVars(iPredicate, new HashSet<IProgramVar>(0), 4, 0, Integer.MIN_VALUE, null, -5, 0, this.mIndexedConstants, this.mManagedScript.getScript(), set);
        UnmodifiableTransFormula unmodifiableTransFormula = iCallAction.getLocalVarsAssignment();
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
        Term term2 = PredicateUtils.formulaWithIndexedVars(unmodifiableTransFormula, 0, 1, hashSet, this.mIndexedConstants, this.mManagedScript.getScript());
        String string2 = iCallAction.getSucceedingProcedure();
        Set<IProgramNonOldVar> set2 = this.mModifiableGlobals.getModifiedBoogieVars(string2);
        Term term3 = PredicateUtils.formulaWithIndexedVars(iPredicate2, new HashSet<IProgramVar>(0), 4, 1, 0, null, 23, 0, this.mIndexedConstants, this.mManagedScript.getScript(), set2);
        Term term4 = SmtUtils.not((Script)this.mManagedScript.getScript(), (Term)term3);
        term4 = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])new Term[]{term2, term4});
        term4 = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])new Term[]{term, term4});
        Script.LBool lBool = this.checkSatisfiable(term4);
        this.mIndexedConstants = null;
        this.mManagedScript.getScript().pop(1);
        if (bl) assert (lBool == Script.LBool.UNSAT || lBool == Script.LBool.UNKNOWN) : "call statement not inductive";
        this.mSatCheckTime += System.nanoTime() - l;
        this.mManagedScript.unlock((Object)this);
        return lBool;
    }

    public Script.LBool isInductiveReturn(IPredicate iPredicate, IPredicate iPredicate2, IReturnAction iReturnAction, IPredicate iPredicate3) {
        return this.isInductiveReturn(iPredicate, iPredicate2, iReturnAction, iPredicate3, false);
    }

    public Script.LBool isInductiveReturn(IPredicate iPredicate, IPredicate iPredicate2, IReturnAction iReturnAction, IPredicate iPredicate3, boolean bl) {
        IProgramVar iProgramVar2;
        this.mManagedScript.lock((Object)this);
        long l = System.nanoTime();
        if (MonolithicHoareTripleChecker.isDontCare(iPredicate) || MonolithicHoareTripleChecker.isDontCare(iPredicate3) || MonolithicHoareTripleChecker.isDontCare(iPredicate2)) {
            ++this.mTrivialSatQueries;
            this.mManagedScript.unlock((Object)this);
            return Script.LBool.UNKNOWN;
        }
        if (SmtUtils.isFalseLiteral((Term)iPredicate.getFormula()) || SmtUtils.isFalseLiteral((Term)iPredicate2.getFormula()) || SmtUtils.isTrueLiteral((Term)iPredicate3.getFormula())) {
            ++this.mTrivialSatQueries;
            this.mManagedScript.unlock((Object)this);
            return Script.LBool.UNSAT;
        }
        this.mManagedScript.getScript().push(1);
        this.mIndexedConstants = new ScopedHashMap();
        UnmodifiableTransFormula unmodifiableTransFormula = iReturnAction.getAssignmentOfReturn();
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
        Term term = PredicateUtils.formulaWithIndexedVars(unmodifiableTransFormula, 1, 2, hashSet, this.mIndexedConstants, this.mManagedScript.getScript());
        UnmodifiableTransFormula unmodifiableTransFormula2 = iReturnAction.getLocalVarsAssignmentOfCall();
        HashSet<IProgramVar> hashSet2 = new HashSet<IProgramVar>();
        Term term2 = PredicateUtils.formulaWithIndexedVars(unmodifiableTransFormula2, 0, 1, hashSet2, this.mIndexedConstants, this.mManagedScript.getScript());
        String string = iReturnAction.getPrecedingProcedure();
        Set<IProgramNonOldVar> set = this.mModifiableGlobals.getModifiedBoogieVars(string);
        String string2 = iReturnAction.getSucceedingProcedure();
        Set<IProgramNonOldVar> set2 = this.mModifiableGlobals.getModifiedBoogieVars(string2);
        Term term3 = PredicateUtils.formulaWithIndexedVars(iPredicate2, new HashSet<IProgramVar>(0), 23, 0, Integer.MIN_VALUE, null, 23, 0, this.mIndexedConstants, this.mManagedScript.getScript(), set2);
        HashSet<IProgramVar> hashSet3 = new HashSet<IProgramVar>();
        for (IProgramVar iProgramVar2 : unmodifiableTransFormula.getOutVars().keySet()) {
            if (!set.contains(iProgramVar2)) continue;
            hashSet3.add(iProgramVar2);
        }
        iProgramVar2 = PredicateUtils.formulaWithIndexedVars(iPredicate, hashSet3, 1, 1, 0, set, 2, 0, this.mIndexedConstants, this.mManagedScript.getScript(), set);
        Term term4 = PredicateUtils.formulaWithIndexedVars(iPredicate3, hashSet, 2, 0, Integer.MIN_VALUE, set, 2, 0, this.mIndexedConstants, this.mManagedScript.getScript(), set2);
        Term term5 = SmtUtils.not((Script)this.mManagedScript.getScript(), (Term)term4);
        term5 = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])new Term[]{term, term5});
        term5 = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])new Term[]{iProgramVar2, term5});
        term5 = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])new Term[]{term2, term5});
        term5 = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])new Term[]{term3, term5});
        Script.LBool lBool = this.checkSatisfiable(term5);
        this.mManagedScript.getScript().pop(1);
        this.mIndexedConstants = null;
        if (bl) assert (lBool == Script.LBool.UNSAT || lBool == Script.LBool.UNKNOWN) : "From " + iPredicate.getFormula().toStringDirect() + "Caller " + iPredicate2.getFormula().toStringDirect() + "Statements " + String.valueOf(iReturnAction) + "To " + iPredicate3.getFormula().toStringDirect() + "Not inductive!";
        this.mSatCheckTime += System.nanoTime() - l;
        this.mManagedScript.unlock((Object)this);
        return lBool;
    }

    public Script.LBool assertTerm(Term term) {
        long l = System.nanoTime();
        Script.LBool lBool = null;
        lBool = this.mManagedScript.getScript().assertTerm(term);
        this.mSatCheckSolverTime += System.nanoTime() - l;
        return lBool;
    }

    Script.LBool checkSatisfiable(Term term) {
        long l = System.nanoTime();
        Script.LBool lBool = null;
        try {
            this.assertTerm(term);
        }
        catch (SMTLIBException sMTLIBException) {
            if (sMTLIBException.getMessage().equals("Unsupported non-linear arithmetic")) {
                return Script.LBool.UNKNOWN;
            }
            throw sMTLIBException;
        }
        lBool = this.mManagedScript.getScript().checkSat();
        this.mSatCheckSolverTime += System.nanoTime() - l;
        ++this.mNontrivialSatQueries;
        if (lBool == Script.LBool.UNKNOWN) {
            Object object = this.mManagedScript.getScript().getInfo(":reason-unknown");
            if (!(object instanceof ReasonUnknown)) {
                this.mManagedScript.getScript().getInfo(":reason-unknown");
            }
            ReasonUnknown reasonUnknown = (ReasonUnknown)object;
            switch (reasonUnknown) {
                case CRASHED: {
                    throw new AssertionError((Object)"Solver crashed");
                }
                case MEMOUT: {
                    throw new AssertionError((Object)"Solver out of memory, solver might be in inconsistent state");
                }
            }
        }
        return lBool;
    }

    private static boolean isDontCare(IPredicate iPredicate) {
        return false;
    }
}

