/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.callgraph;

import de.uni_freiburg.informatik.ultimate.boogie.ast.AtomicStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ForkStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.WhileStatement;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.callgraph.CallGraphEdgeLabel;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.callgraph.CallGraphNode;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.exceptions.CancelToolchainException;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.exceptions.MultipleImplementationsException;
import de.uni_freiburg.informatik.ultimate.boogie.procedureinliner.exceptions.ProcedureAlreadyDeclaredException;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.TarjanSCC;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CallGraphBuilder {
    private boolean mProgramIsConcurrent;
    private Collection<Declaration> mNonProcedureDeclarations;
    private Map<String, CallGraphNode> mCallGraphNodes;
    private ImmutableSet<ImmutableSet<String>> mRecursiveComponents;
    private Set<String> mRecursiveProcedures;

    public void buildCallGraph(Unit unit) throws CancelToolchainException {
        this.init();
        Declaration[] declarationArray = unit.getDeclarations();
        int n = declarationArray.length;
        int n2 = 0;
        while (n2 < n) {
            Declaration declaration = declarationArray[n2];
            if (declaration instanceof Procedure) {
                this.processProcedure((Procedure)declaration);
            } else {
                this.mNonProcedureDeclarations.add(declaration);
            }
            ++n2;
        }
        this.finish();
    }

    public Map<String, CallGraphNode> getCallGraph() {
        return this.mCallGraphNodes;
    }

    public boolean getProgramIsConcurrent() {
        return this.mProgramIsConcurrent;
    }

    public Collection<Declaration> getNonProcedureDeclarations() {
        return this.mNonProcedureDeclarations;
    }

    public void init() {
        this.mProgramIsConcurrent = false;
        this.mNonProcedureDeclarations = new ArrayList<Declaration>();
        this.mCallGraphNodes = new HashMap<String, CallGraphNode>();
        this.mRecursiveComponents = null;
        this.mRecursiveProcedures = null;
    }

    public void finish() {
        this.mNonProcedureDeclarations = Collections.unmodifiableCollection(this.mNonProcedureDeclarations);
        this.mCallGraphNodes = Collections.unmodifiableMap(this.mCallGraphNodes);
        this.findRecursiveComponents();
        this.setAllEdgeTypes();
    }

    private void processProcedure(Procedure procedure) throws CancelToolchainException {
        String string = procedure.getIdentifier();
        CallGraphNode callGraphNode = this.getOrCreateNode(string);
        if (procedure.getSpecification() != null) {
            if (callGraphNode.getProcedureWithSpecification() != null) {
                throw new ProcedureAlreadyDeclaredException(procedure);
            }
            callGraphNode.setProcedureWithSpecification(procedure);
        }
        if (procedure.getBody() != null) {
            if (callGraphNode.getProcedureWithBody() != null) {
                throw new MultipleImplementationsException(procedure);
            }
            callGraphNode.setProcedureWithBody(procedure);
            this.registerCallStatementsInGraph(callGraphNode, procedure.getBody().getBlock());
        }
    }

    private CallGraphNode getOrCreateNode(String string) {
        return this.mCallGraphNodes.computeIfAbsent(string, CallGraphNode::new);
    }

    private void registerCallStatementsInGraph(CallGraphNode callGraphNode, Statement[] statementArray) {
        Statement[] statementArray2 = statementArray;
        int n = statementArray.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray2[n2];
            if (statement instanceof CallStatement) {
                var7_7 = (CallStatement)statement;
                CallGraphEdgeLabel.EdgeType edgeType = var7_7.isForall() ? CallGraphEdgeLabel.EdgeType.CALL_FORALL : null;
                this.addEdge(callGraphNode, edgeType, var7_7.getMethodName());
            } else if (statement instanceof ForkStatement) {
                this.mProgramIsConcurrent = true;
                this.addEdge(callGraphNode, CallGraphEdgeLabel.EdgeType.FORK, ((ForkStatement)statement).getProcedureName());
            } else if (statement instanceof IfStatement) {
                var7_7 = (IfStatement)statement;
                this.registerCallStatementsInGraph(callGraphNode, var7_7.getThenPart());
                this.registerCallStatementsInGraph(callGraphNode, var7_7.getElsePart());
            } else if (statement instanceof WhileStatement) {
                var7_7 = (WhileStatement)statement;
                this.registerCallStatementsInGraph(callGraphNode, var7_7.getBody());
            } else if (statement instanceof AtomicStatement) {
                var7_7 = (AtomicStatement)statement;
                this.registerCallStatementsInGraph(callGraphNode, var7_7.getBody());
            }
            ++n2;
        }
    }

    private void addEdge(CallGraphNode callGraphNode, CallGraphEdgeLabel.EdgeType edgeType, String string) {
        CallGraphNode callGraphNode2 = this.getOrCreateNode(string);
        callGraphNode.addOutgoingNode(callGraphNode2, new CallGraphEdgeLabel(callGraphNode2.getId(), edgeType));
        callGraphNode2.addIncomingNode(callGraphNode);
    }

    private void findRecursiveComponents() {
        HashSet<ImmutableSet> hashSet = new HashSet<ImmutableSet>();
        this.mRecursiveProcedures = new HashSet<String>();
        for (ImmutableSet immutableSet : new TarjanSCC().getSCCs(this.buildSimpleGraphRepresentation())) {
            if (immutableSet.size() <= 1 && !this.isDirectlyRecursive((String)immutableSet.iterator().next())) continue;
            hashSet.add(immutableSet);
            this.mRecursiveProcedures.addAll((Collection<String>)immutableSet);
        }
        this.mRecursiveComponents = ImmutableSet.of(hashSet);
        this.mRecursiveProcedures = Collections.unmodifiableSet(this.mRecursiveProcedures);
    }

    private boolean isDirectlyRecursive(String string) {
        CallGraphNode callGraphNode = this.mCallGraphNodes.get(string);
        for (CallGraphNode callGraphNode2 : callGraphNode.getOutgoingNodes()) {
            if (!string.equals(callGraphNode2.getId())) continue;
            return true;
        }
        return false;
    }

    private Map<String, Set<String>> buildSimpleGraphRepresentation() {
        LinkedHashMap<String, Set<String>> linkedHashMap = new LinkedHashMap<String, Set<String>>();
        for (CallGraphNode callGraphNode : this.mCallGraphNodes.values()) {
            String string = callGraphNode.getId();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            List list = callGraphNode.getOutgoingNodes();
            List list2 = callGraphNode.getOutgoingEdgeLabels();
            int n = 0;
            while (n < list.size()) {
                CallGraphEdgeLabel.EdgeType edgeType = ((CallGraphEdgeLabel)list2.get(n)).getEdgeType();
                if (edgeType == null) {
                    linkedHashSet.add(((CallGraphNode)((Object)list.get(n))).getId());
                }
                ++n;
            }
            linkedHashMap.put(string, linkedHashSet);
        }
        return linkedHashMap;
    }

    private void setAllEdgeTypes() {
        for (CallGraphNode callGraphNode : this.mCallGraphNodes.values()) {
            Set<String> set = this.recursiveComponentOf(callGraphNode.getId());
            for (CallGraphEdgeLabel callGraphEdgeLabel : callGraphNode.getOutgoingEdgeLabels()) {
                String string = callGraphEdgeLabel.getCalleeProcedureId();
                if (callGraphEdgeLabel.getEdgeType() != null) continue;
                callGraphEdgeLabel.setEdgeType(this.findEdgeTypeForNormalCall(set, string));
            }
        }
    }

    private CallGraphEdgeLabel.EdgeType findEdgeTypeForNormalCall(Set<String> set, String string) {
        CallGraphNode callGraphNode = this.mCallGraphNodes.get(string);
        Set<String> set2 = this.recursiveComponentOf(string);
        if (set2 == null) {
            return callGraphNode.getProcedureWithBody() == null ? CallGraphEdgeLabel.EdgeType.SIMPLE_CALL_UNIMPLEMENTED : CallGraphEdgeLabel.EdgeType.SIMPLE_CALL_IMPLEMENTED;
        }
        return set == set2 ? CallGraphEdgeLabel.EdgeType.INTERN_RECURSIVE_CALL : CallGraphEdgeLabel.EdgeType.EXTERN_RECURSIVE_CALL;
    }

    private Set<String> recursiveComponentOf(String string) {
        for (Set set : this.mRecursiveComponents) {
            if (!set.contains(string)) continue;
            return set;
        }
        return null;
    }
}

