/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.LibraryIdentifiers;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.NwaApproximateSimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.NwaApproximateXsimulation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.maxsat.collections.ScopedTransitivityGenerator;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.util.ISetOfPairs;
import de.uni_freiburg.informatik.ultimate.automata.util.MapBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Stream;

public class NwaApproximateDelayedSimulation<LETTER, STATE> {
    private final AutomataLibraryServices mServices;
    private final ILogger mLogger;
    private final INestedWordAutomaton<LETTER, STATE> mOperand;
    private final ISetOfPairs<STATE, ?> mDuplicatorEventuallyAccepting;
    private final ISetOfPairs<STATE, ?> mSpoilerWinningStates;
    private final BiPredicate<STATE, STATE> mAreStatesMerged;
    private final Map<STATE, ScopedTransitivityGenerator.NormalNode<STATE>> mMergeStatus = new HashMap<STATE, ScopedTransitivityGenerator.NormalNode<STATE>>();

    public NwaApproximateDelayedSimulation(AutomataLibraryServices automataLibraryServices, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, BiPredicate<STATE, STATE> biPredicate) throws AutomataOperationCanceledException {
        this.mServices = automataLibraryServices;
        this.mLogger = automataLibraryServices.getLoggingService().getLogger(LibraryIdentifiers.PLUGIN_ID);
        this.mOperand = iNestedWordAutomaton;
        this.mAreStatesMerged = biPredicate;
        MapBackedSetOfPairs<STATE> mapBackedSetOfPairs = this.computeOrdinarySimulation();
        this.mLogger.info((Object)("Simulation: \n" + String.valueOf(mapBackedSetOfPairs)));
        this.mDuplicatorEventuallyAccepting = this.computeDuplicatorFollowing(mapBackedSetOfPairs);
        this.mLogger.info((Object)("mDuplicatorEventuallyAccepting: \n" + String.valueOf(this.mDuplicatorEventuallyAccepting)));
        this.mSpoilerWinningStates = this.computeSpoilerWinning(this.mDuplicatorEventuallyAccepting);
        this.mLogger.info((Object)("mSpoilerWinningStates: \n" + String.valueOf(this.mSpoilerWinningStates)));
    }

    public ISetOfPairs<STATE, ?> getDuplicatorEventuallyAcceptingStates() {
        return this.mDuplicatorEventuallyAccepting;
    }

    public ISetOfPairs<STATE, ?> getSpoilerWinningStates() {
        return this.mSpoilerWinningStates;
    }

    public MapBackedSetOfPairs<STATE> computeOrdinarySimulation() throws AutomataOperationCanceledException {
        return new NwaApproximateSimulation<LETTER, STATE>(this.mServices, this.mOperand, NwaApproximateXsimulation.SimulationType.ORDINARY).getResult();
    }

    private ISetOfPairs<STATE, ?> computeDuplicatorFollowing(ISetOfPairs<STATE, ?> iSetOfPairs) {
        HashMap hashMap = new HashMap();
        LinkedHashSet<Pair<STATE, STATE>> linkedHashSet = new LinkedHashSet<Pair<STATE, STATE>>();
        for (Pair pair : iSetOfPairs) {
            if (!this.mOperand.isFinal(pair.getSecond())) continue;
            this.markPair(hashMap, linkedHashSet, pair);
        }
        block1: while (!linkedHashSet.isEmpty()) {
            Pair pair = (Pair)linkedHashSet.iterator().next();
            linkedHashSet.remove(pair);
            block2: for (Pair<STATE, LETTER> pair2 : this.getOutgoingGameLetters(pair)) {
                for (Pair<STATE, STATE> pair3 : this.getSuccessors(pair, pair2, iSetOfPairs)) {
                    if (this.isMarked(pair3, hashMap) && (!this.mOperand.getVpAlphabet().getReturnAlphabet().contains(pair2.getSecond()) || this.mAreStatesMerged.test(pair3.getFirst(), pair3.getSecond()))) continue block2;
                }
                continue block1;
            }
            this.markPair(hashMap, linkedHashSet, pair);
        }
        return new MapBackedSetOfPairs(hashMap);
    }

    private ISetOfPairs<STATE, ?> computeSpoilerWinning(ISetOfPairs<STATE, ?> iSetOfPairs) {
        HashMap hashMap = new HashMap();
        LinkedHashSet<Pair<STATE, STATE>> linkedHashSet = new LinkedHashSet<Pair<STATE, STATE>>();
        for (Object object : this.mOperand.getStates()) {
            for (Object object2 : this.mOperand.getStates()) {
                if (iSetOfPairs.containsPair(object, object2)) continue;
                this.markPair(hashMap, linkedHashSet, new Pair(object2, object));
            }
        }
        block2: while (!linkedHashSet.isEmpty()) {
            Object object;
            object = (Pair)linkedHashSet.iterator().next();
            linkedHashSet.remove(object);
            assert (!this.isMarked((Pair<STATE, STATE>)object, hashMap)) : String.valueOf(object) + " is already marked";
            block3: for (Pair pair : this.getOutgoingGameLetters((Pair<STATE, STATE>)object)) {
                Collection<Pair<STATE, STATE>> collection = this.getSuccessors((Pair<STATE, STATE>)object, (Pair<STATE, LETTER>)pair, null);
                assert (!collection.isEmpty());
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    Pair pair2 = (Pair)iterator.next();
                    if (!this.isMarked(pair2, hashMap) || !this.mAreStatesMerged.test(pair2.getFirst(), pair2.getSecond())) continue block3;
                }
                this.markPair(hashMap, (Set<Pair<STATE, STATE>>)linkedHashSet, (Pair<STATE, STATE>)object);
                continue block2;
            }
        }
        return new MapBackedSetOfPairs(hashMap);
    }

    private void markPair(Map<STATE, Set<STATE>> map, Set<Pair<STATE, STATE>> set, Pair<STATE, STATE> pair) {
        assert (!this.isMarked(pair, map)) : String.valueOf(pair) + " is already marked";
        this.mark(pair, map);
        set.remove(pair);
        for (Pair<STATE, STATE> pair2 : this.getPredecessors(pair)) {
            if (this.isMarked(pair2, map)) continue;
            set.add(pair2);
        }
    }

    private boolean isMarked(Pair<STATE, STATE> pair, Map<STATE, Set<STATE>> map) {
        Set<STATE> set = map.get(pair.getFirst());
        if (set == null) {
            return false;
        }
        return set.contains(pair.getSecond());
    }

    private void mark(Pair<STATE, STATE> pair, Map<STATE, Set<STATE>> map) {
        Object object;
        Set<STATE> set;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("marking " + String.valueOf(pair)));
        }
        if ((set = map.get(object = pair.getFirst())) == null) {
            set = new HashSet<STATE>();
            map.put(object, set);
        }
        set.add(pair.getSecond());
    }

    private Collection<Pair<STATE, STATE>> getPredecessors(Pair<STATE, STATE> pair) {
        HashSet<Pair<STATE, STATE>> hashSet = new HashSet<Pair<STATE, STATE>>();
        Object object = pair.getFirst();
        Object object2 = pair.getSecond();
        Set<LETTER> set = this.mOperand.lettersInternalIncoming(object2);
        for (LETTER LETTER : this.mOperand.lettersInternalIncoming(object)) {
            if (!set.contains(LETTER)) continue;
            for (IncomingInternalTransition<LETTER, Object> iTransitionlet : this.mOperand.internalPredecessors(object, LETTER)) {
                for (IncomingInternalTransition<LETTER, Object> incomingInternalTransition : this.mOperand.internalPredecessors(object2, LETTER)) {
                    hashSet.add(new Pair(iTransitionlet.getPred(), incomingInternalTransition.getPred()));
                }
            }
        }
        for (LETTER LETTER : this.mOperand.lettersCallIncoming(object)) {
            if (!set.contains(LETTER)) continue;
            for (IncomingCallTransition incomingCallTransition : this.mOperand.callPredecessors(object, LETTER)) {
                for (IncomingCallTransition incomingCallTransition2 : this.mOperand.callPredecessors(object2, LETTER)) {
                    hashSet.add(new Pair(incomingCallTransition.getPred(), incomingCallTransition2.getPred()));
                }
            }
        }
        for (LETTER LETTER : this.mOperand.lettersReturnIncoming(object)) {
            if (!set.contains(LETTER)) continue;
            for (IncomingReturnTransition incomingReturnTransition : this.mOperand.returnPredecessors(object, LETTER)) {
                for (IncomingReturnTransition incomingReturnTransition2 : this.mOperand.returnPredecessors(object2, LETTER)) {
                    hashSet.add(new Pair(incomingReturnTransition.getLinPred(), incomingReturnTransition2.getLinPred()));
                }
            }
        }
        return hashSet;
    }

    private Collection<Pair<STATE, LETTER>> getOutgoingGameLetters(Pair<STATE, STATE> pair) {
        HashSet<Pair<STATE, LETTER>> hashSet = new HashSet<Pair<STATE, LETTER>>();
        Object object3 = pair.getFirst();
        Object object4 = pair.getSecond();
        Set set = this.mOperand.lettersInternal(object4);
        Set set2 = this.mOperand.lettersCall(object4);
        Set set3 = this.mOperand.lettersReturn(object4);
        Stream stream = Stream.concat(set.parallelStream(), Stream.concat(set2.parallelStream(), set3.parallelStream()));
        stream.filter(object -> set.contains(object) || set2.contains(object) || set3.contains(object)).forEach(object2 -> {
            for (OutgoingInternalTransition<Object, Object> iOutgoingTransitionlet : this.mOperand.internalSuccessors(object3, object2)) {
                hashSet.add(new Pair(iOutgoingTransitionlet.getSucc(), object2));
            }
            for (OutgoingCallTransition outgoingCallTransition : this.mOperand.callSuccessors(object3, object2)) {
                hashSet.add(new Pair(outgoingCallTransition.getSucc(), object2));
            }
            for (OutgoingReturnTransition outgoingReturnTransition : this.mOperand.returnSuccessors(object3, object2)) {
                hashSet.add(new Pair(outgoingReturnTransition.getSucc(), object2));
            }
        });
        return hashSet;
    }

    private Collection<Pair<STATE, STATE>> getSuccessors(Pair<STATE, STATE> pair, Pair<STATE, LETTER> pair2, ISetOfPairs<STATE, ?> iSetOfPairs) {
        Object object;
        Object object2;
        HashSet<Pair<STATE, STATE>> hashSet = new HashSet<Pair<STATE, STATE>>();
        for (OutgoingInternalTransition<Object, Object> iOutgoingTransitionlet : this.mOperand.internalSuccessors(pair.getSecond(), pair2.getSecond())) {
            object2 = pair2.getFirst();
            object = iOutgoingTransitionlet.getSucc();
            if (iSetOfPairs != null && !iSetOfPairs.containsPair(object2, object)) continue;
            hashSet.add(new Pair(object2, object));
        }
        for (OutgoingCallTransition outgoingCallTransition : this.mOperand.callSuccessors(pair.getSecond(), pair2.getSecond())) {
            object2 = pair2.getFirst();
            object = outgoingCallTransition.getSucc();
            if (iSetOfPairs != null && !iSetOfPairs.containsPair(object2, object)) continue;
            hashSet.add(new Pair(object2, object));
        }
        for (OutgoingReturnTransition outgoingReturnTransition : this.mOperand.returnSuccessors(pair.getSecond(), pair2.getSecond())) {
            object2 = pair2.getFirst();
            object = outgoingReturnTransition.getSucc();
            if (iSetOfPairs != null && !iSetOfPairs.containsPair(object2, object)) continue;
            hashSet.add(new Pair(object2, object));
        }
        return hashSet;
    }
}

