/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.StatementFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Body;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ConstDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.PrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RequiresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ReturnStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.TypeDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.CACSLLocation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.FlatSymbolTable;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CTranslationResultReporter;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.CTranslationUtil;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.TranslationSettings;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.FunctionHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.InitializationHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.ProcedureManager;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.ProcedureSignature;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.StaticObjectsHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizes;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.BitvectorTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.FenvLibraryModel;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CFunction;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.CDeclaration;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.InitializerResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ResultWithSideEffects;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.cdt.translation.interfaces.handler.ITypeHandler;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BitvectorConstant;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class PostProcessor {
    private final ILogger mLogger;
    private final ExpressionTranslation mExpressionTranslation;
    private final CTranslationResultReporter mReporter;
    private final boolean mDeclareToIntFunction = false;
    private final ITypeHandler mTypeHandler;
    private final AuxVarInfoBuilder mAuxVarInfoBuilder;
    private final FlatSymbolTable mSymboltable;
    private final MemoryHandler mMemoryHandler;
    private final ProcedureManager mProcedureManager;
    private final CHandler mCHandler;
    private final TypeSizes mTypeSize;
    private final StaticObjectsHandler mStaticObjectsHandler;
    private final InitializationHandler mInitHandler;
    private final TranslationSettings mSettings;
    private final FunctionHandler mFunctionhandler;
    private final Set<String> mFunctions;

    public PostProcessor(ILogger iLogger, ExpressionTranslation expressionTranslation, ITypeHandler iTypeHandler, CTranslationResultReporter cTranslationResultReporter, AuxVarInfoBuilder auxVarInfoBuilder, Set<String> set, TypeSizes typeSizes, FlatSymbolTable flatSymbolTable, StaticObjectsHandler staticObjectsHandler, TranslationSettings translationSettings, ProcedureManager procedureManager, MemoryHandler memoryHandler, InitializationHandler initializationHandler, FunctionHandler functionHandler, CHandler cHandler) {
        this.mLogger = iLogger;
        this.mExpressionTranslation = expressionTranslation;
        this.mReporter = cTranslationResultReporter;
        this.mTypeHandler = iTypeHandler;
        this.mAuxVarInfoBuilder = auxVarInfoBuilder;
        this.mFunctions = set;
        this.mTypeSize = typeSizes;
        this.mSymboltable = flatSymbolTable;
        this.mStaticObjectsHandler = staticObjectsHandler;
        this.mSettings = translationSettings;
        this.mProcedureManager = procedureManager;
        this.mMemoryHandler = memoryHandler;
        this.mInitHandler = initializationHandler;
        this.mFunctionhandler = functionHandler;
        this.mCHandler = cHandler;
    }

    public List<Declaration> postProcess(ILocation iLocation, IASTNode iASTNode, List<Statement> list) {
        BitvectorConstant.BvOp[] bvOpArray;
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        Set<String> set = this.mTypeHandler.getUndefinedTypes();
        arrayList.addAll(PostProcessor.declareUndefinedTypes(iLocation, set));
        String string = this.mSettings.getEntryFunction();
        if (!string.equals("") && this.mProcedureManager.hasProcedure(string)) {
            this.mLogger.info((Object)("Analyzing one entry point: " + string));
            bvOpArray = this.createUltimateInitProcedure(iLocation, iASTNode, list);
            arrayList.add(bvOpArray.getUltimateInitImplementation());
            UltimateStartProcedure ultimateStartProcedure = this.createUltimateStartProcedure(iLocation, iASTNode);
            arrayList.add(ultimateStartProcedure.getUltimateStartImplementation());
        } else {
            this.mStaticObjectsHandler.freeze();
            this.mLogger.info((Object)"Analyzing all entry points");
            if (this.mProcedureManager.hasProcedure("main")) {
                this.mReporter.warn(iLocation, "You selected the library mode (i.e., each procedure can be starting procedure and global variables are not initialized). This program contains a \"main\" procedure. Maybe you wanted to select the \"main\" procedure as starting procedure.");
            }
        }
        arrayList.addAll(this.declareFunctionPointerProcedures());
        arrayList.addAll(this.declareConversionFunctions());
        if (this.mSettings.isBitvectorTranslation()) {
            arrayList.addAll(this.declarePrimitiveDataTypeSynonyms(iLocation));
            if (this.mTypeHandler.areFloatingTypesNeeded()) {
                arrayList.addAll(this.declareRoundingModeDataTypes(iLocation));
                arrayList.addAll(this.declareFloatDataTypes(iLocation));
                if (this.mSettings.isFesetroundEnabled()) {
                    arrayList.addAll(this.createUltimateSetCurrentRoundingProcedure(iLocation, iASTNode));
                    arrayList.addAll(PostProcessor.declareCurrentRoundingModeVar(iLocation));
                }
            }
            bvOpArray = new BitvectorConstant.BvOp[]{BitvectorConstant.BvOp.bvadd, BitvectorConstant.BvOp.bvneg};
            this.mExpressionTranslation.declareBinaryBitvectorFunctionsForAllIntegerDatatypes(iLocation, bvOpArray);
        }
        assert (arrayList.stream().allMatch(Objects::nonNull));
        return arrayList;
    }

    public ArrayList<Declaration> declarePrimitiveDataTypeSynonyms(ILocation iLocation) {
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        CPrimitive.CPrimitives[] cPrimitivesArray = CPrimitive.CPrimitives.values();
        int n = cPrimitivesArray.length;
        int n2 = 0;
        while (n2 < n) {
            CPrimitive.CPrimitives cPrimitives = cPrimitivesArray[n2];
            CPrimitive cPrimitive = new CPrimitive(cPrimitives);
            if (cPrimitive.getGeneralType() == CPrimitive.CPrimitiveCategory.INTTYPE) {
                Attribute[] attributeArray = new Attribute[2];
                attributeArray[0] = new NamedAttribute(iLocation, "isUnsigned", new Expression[]{ExpressionFactory.createBooleanLiteral((ILocation)iLocation, (boolean)this.mTypeSize.isUnsigned(cPrimitive))});
                int n3 = this.mTypeSize.getSize(cPrimitives);
                int n4 = n3 * 8;
                attributeArray[1] = new NamedAttribute(iLocation, "bitsize", new Expression[]{ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)String.valueOf(n4))});
                String string = "C_" + cPrimitives.name();
                String[] stringArray = new String[]{};
                ASTType aSTType = this.mTypeHandler.byteSize2AstType(iLocation, CPrimitive.CPrimitiveCategory.INTTYPE, n3);
                arrayList.add((Declaration)new TypeDeclaration(iLocation, attributeArray, false, string, stringArray, aSTType));
            }
            ++n2;
        }
        return arrayList;
    }

    public ArrayList<Declaration> declareFloatDataTypes(ILocation iLocation) {
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        CPrimitive.CPrimitives[] cPrimitivesArray = CPrimitive.CPrimitives.values();
        int n = cPrimitivesArray.length;
        int n2 = 0;
        while (n2 < n) {
            CPrimitive.CPrimitives cPrimitives = cPrimitivesArray[n2];
            CPrimitive cPrimitive = new CPrimitive(cPrimitives);
            if (cPrimitive.getGeneralType() == CPrimitive.CPrimitiveCategory.FLOATTYPE && !cPrimitive.isComplexType()) {
                Object object;
                Attribute[] attributeArray;
                if (!this.mSettings.overapproximateFloatingPointOperations()) {
                    this.mExpressionTranslation.declareFloatingPointConstructors(iLocation, new CPrimitive(cPrimitives));
                    this.mExpressionTranslation.declareFloatConstant(iLocation, "-oo", new CPrimitive(cPrimitives));
                    this.mExpressionTranslation.declareFloatConstant(iLocation, "+oo", new CPrimitive(cPrimitives));
                    this.mExpressionTranslation.declareFloatConstant(iLocation, "NaN", new CPrimitive(cPrimitives));
                    this.mExpressionTranslation.declareFloatConstant(iLocation, "-zero", new CPrimitive(cPrimitives));
                    this.mExpressionTranslation.declareFloatConstant(iLocation, "+zero", new CPrimitive(cPrimitives));
                }
                if (this.mSettings.overapproximateFloatingPointOperations()) {
                    attributeArray = new Attribute[]{};
                } else {
                    attributeArray = new Attribute[2];
                    attributeArray[0] = new NamedAttribute(iLocation, "builtin", new Expression[]{ExpressionFactory.createStringLiteral((ILocation)iLocation, (String)"FloatingPoint")});
                    object = this.mTypeSize.getFloatingPointSize(cPrimitives).getIndices();
                    attributeArray[1] = new NamedAttribute(iLocation, "indices", new Expression[]{ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)String.valueOf((int)object[0])), ExpressionFactory.createIntegerLiteral((ILocation)iLocation, (String)String.valueOf((int)object[1]))});
                }
                object = "C_" + cPrimitives.name();
                String[] stringArray = new String[]{};
                arrayList.add((Declaration)new TypeDeclaration(iLocation, attributeArray, false, (String)object, stringArray));
            }
            ++n2;
        }
        return arrayList;
    }

    public ArrayList<Declaration> declareRoundingModeDataTypes(ILocation iLocation) {
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        Attribute[] attributeArray = this.mSettings.overapproximateFloatingPointOperations() ? new Attribute[]{} : new Attribute[]{new NamedAttribute(iLocation, "builtin", new Expression[]{ExpressionFactory.createStringLiteral((ILocation)iLocation, (String)"RoundingMode")})};
        String[] stringArray = new String[]{};
        arrayList.add((Declaration)new TypeDeclaration(iLocation, attributeArray, false, "FloatRoundingMode", stringArray));
        BitvectorTranslation.SmtRoundingMode[] smtRoundingModeArray = BitvectorTranslation.SmtRoundingMode.values();
        int n = smtRoundingModeArray.length;
        int n2 = 0;
        while (n2 < n) {
            BitvectorTranslation.SmtRoundingMode smtRoundingMode = smtRoundingModeArray[n2];
            Attribute[] attributeArray2 = this.mSettings.overapproximateFloatingPointOperations() ? new Attribute[]{} : new Attribute[]{new NamedAttribute(iLocation, "builtin", new Expression[]{ExpressionFactory.createStringLiteral((ILocation)iLocation, (String)smtRoundingMode.getSmtIdentifier())})};
            ConstDeclaration constDeclaration = new ConstDeclaration(iLocation, attributeArray2, false, smtRoundingMode.getBoogieVarlist(), null, false);
            arrayList.add((Declaration)constDeclaration);
            ++n2;
        }
        return arrayList;
    }

    private static ArrayList<Declaration> declareCurrentRoundingModeVar(ILocation iLocation) {
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        VarList[] varListArray = new VarList[]{new VarList(iLocation, new String[]{"currentRoundingMode"}, BitvectorTranslation.ROUNDING_MODE_BOOGIE_AST_TYPE)};
        Attribute[] attributeArray = new Attribute[]{};
        arrayList.add((Declaration)new VariableDeclaration(iLocation, attributeArray, varListArray));
        return arrayList;
    }

    private ArrayList<Declaration> createUltimateSetCurrentRoundingProcedure(ILocation iLocation, IASTNode iASTNode) {
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        ArrayList<Statement> arrayList2 = new ArrayList<Statement>();
        CPrimitive cPrimitive = new CPrimitive(CPrimitive.CPrimitives.INT);
        ASTType aSTType = this.mTypeHandler.cType2AstType(iLocation, cPrimitive);
        BoogieType boogieType = (BoogieType)aSTType.getBoogieType();
        VarList[] varListArray = new VarList[]{new VarList(iLocation, new String[]{"i"}, aSTType)};
        VarList[] varListArray2 = new VarList[]{new VarList(iLocation, new String[]{"r"}, aSTType)};
        Expression expression = this.mTypeSize.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.ZERO);
        Expression expression2 = this.mTypeSize.constructLiteralForIntegerType(iLocation, cPrimitive, BigInteger.valueOf(-1L));
        Expression expression3 = this.mTypeSize.constructLiteralForIntegerType(iLocation, cPrimitive, FenvLibraryModel.FE_TOWARDZERO);
        Expression expression4 = this.mTypeSize.constructLiteralForIntegerType(iLocation, cPrimitive, FenvLibraryModel.FE_TONEAREST);
        Expression expression5 = this.mTypeSize.constructLiteralForIntegerType(iLocation, cPrimitive, FenvLibraryModel.FE_UPWARD);
        Expression expression6 = this.mTypeSize.constructLiteralForIntegerType(iLocation, cPrimitive, FenvLibraryModel.FE_DOWNWARD);
        IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)boogieType, (String)"i", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, "ULTIMATE.setCurrentRoundingMode"));
        VariableLHS variableLHS = ExpressionFactory.constructVariableLHS((ILocation)iLocation, (BoogieType)BitvectorTranslation.ROUNDING_MODE_BOOGIE_TYPE, (String)"currentRoundingMode", (DeclarationInformation)DeclarationInformation.DECLARATIONINFO_GLOBAL);
        VariableLHS variableLHS2 = ExpressionFactory.constructVariableLHS((ILocation)iLocation, (BoogieType)boogieType, (String)"r", (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM, "ULTIMATE.setCurrentRoundingMode"));
        AssignmentStatement assignmentStatement = StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)variableLHS, (Expression)BitvectorTranslation.SmtRoundingMode.RTZ.getBoogieIdentifierExpression());
        AssignmentStatement assignmentStatement2 = StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)variableLHS, (Expression)BitvectorTranslation.SmtRoundingMode.RNE.getBoogieIdentifierExpression());
        AssignmentStatement assignmentStatement3 = StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)variableLHS, (Expression)BitvectorTranslation.SmtRoundingMode.RTP.getBoogieIdentifierExpression());
        AssignmentStatement assignmentStatement4 = StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)variableLHS, (Expression)BitvectorTranslation.SmtRoundingMode.RTN.getBoogieIdentifierExpression());
        AssignmentStatement assignmentStatement5 = StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)variableLHS2, (Expression)expression);
        AssignmentStatement assignmentStatement6 = StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)variableLHS2, (Expression)expression2);
        Statement[] statementArray = new Statement[2];
        Statement[] statementArray2 = new Statement[2];
        Statement[] statementArray3 = new Statement[2];
        Statement[] statementArray4 = new Statement[2];
        statementArray[0] = assignmentStatement;
        statementArray2[0] = assignmentStatement2;
        statementArray3[0] = assignmentStatement3;
        statementArray4[0] = assignmentStatement4;
        statementArray[1] = assignmentStatement5;
        statementArray2[1] = assignmentStatement5;
        statementArray3[1] = assignmentStatement5;
        statementArray4[1] = assignmentStatement5;
        Statement[] statementArray5 = new Statement[]{assignmentStatement6};
        Expression expression7 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 28, (Expression)identifierExpression, cPrimitive, expression3, cPrimitive);
        Expression expression8 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 28, (Expression)identifierExpression, cPrimitive, expression4, cPrimitive);
        Expression expression9 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 28, (Expression)identifierExpression, cPrimitive, expression5, cPrimitive);
        Expression expression10 = this.mExpressionTranslation.constructBinaryComparisonExpression(iLocation, 28, (Expression)identifierExpression, cPrimitive, expression6, cPrimitive);
        Statement statement = StatementFactory.constructIfStatement((ILocation)iLocation, (Expression)expression10, (Statement[])statementArray4, (Statement[])statementArray5);
        Statement statement2 = StatementFactory.constructIfStatement((ILocation)iLocation, (Expression)expression9, (Statement[])statementArray3, (Statement[])new Statement[]{statement});
        Statement statement3 = StatementFactory.constructIfStatement((ILocation)iLocation, (Expression)expression8, (Statement[])statementArray2, (Statement[])new Statement[]{statement2});
        Statement statement4 = StatementFactory.constructIfStatement((ILocation)iLocation, (Expression)expression7, (Statement[])statementArray, (Statement[])new Statement[]{statement3});
        arrayList2.add(statement4);
        Procedure procedure = new Procedure(iLocation, new Attribute[0], "ULTIMATE.setCurrentRoundingMode", new String[0], varListArray, varListArray2, new Specification[0], null);
        this.mProcedureManager.beginCustomProcedure(this.mCHandler, iLocation, "ULTIMATE.setCurrentRoundingMode", procedure);
        Body body = this.mProcedureManager.constructBody(iLocation, new VariableDeclaration[0], arrayList2.toArray(new Statement[arrayList2.size()]), "ULTIMATE.setCurrentRoundingMode");
        Procedure procedure2 = new Procedure(iLocation, new Attribute[0], "ULTIMATE.setCurrentRoundingMode", new String[0], varListArray, varListArray2, null, body);
        this.mProcedureManager.endCustomProcedure(this.mCHandler, "ULTIMATE.setCurrentRoundingMode");
        arrayList.add((Declaration)procedure2);
        return arrayList;
    }

    private ArrayList<Declaration> declareConversionFunctions() {
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        VarList varList = new VarList((ILocation)cACSLLocation, new String[0], (ASTType)new PrimitiveType((ILocation)cACSLLocation, (IBoogieType)BoogieType.TYPE_REAL, "real"));
        VarList[] varListArray = new VarList[]{varList};
        VarList varList2 = new VarList((ILocation)cACSLLocation, new String[]{"outInt"}, (ASTType)new PrimitiveType((ILocation)cACSLLocation, (IBoogieType)BoogieType.TYPE_INT, "int"));
        return arrayList;
    }

    private ArrayList<Declaration> declareFunctionPointerProcedures() {
        CACSLLocation cACSLLocation = LocationFactory.createIgnoreCLocation();
        ArrayList<Declaration> arrayList = new ArrayList<Declaration>();
        for (ProcedureSignature procedureSignature : this.mFunctionhandler.getFunctionsSignaturesWithFunctionPointers()) {
            String string = procedureSignature.toString();
            VarList[] varListArray = this.mProcedureManager.getProcedureDeclaration(string).getInParams();
            VarList[] varListArray2 = this.mProcedureManager.getProcedureDeclaration(string).getOutParams();
            assert (varListArray2.length <= 1);
            Body body = this.getFunctionPointerFunctionBody(cACSLLocation, string, procedureSignature, varListArray, varListArray2);
            Procedure procedure = new Procedure((ILocation)cACSLLocation, new Attribute[0], string, new String[0], varListArray, varListArray2, null, body);
            arrayList.add((Declaration)procedure);
        }
        return arrayList;
    }

    private static Collection<? extends Declaration> declareUndefinedTypes(ILocation iLocation, Set<String> set) {
        ArrayList<TypeDeclaration> arrayList = new ArrayList<TypeDeclaration>();
        for (String string : set) {
            arrayList.add(new TypeDeclaration(iLocation, new Attribute[0], false, string, new String[0]));
        }
        return arrayList;
    }

    /*
     * WARNING - void declaration
     */
    private Body getFunctionPointerFunctionBody(ILocation iLocation, String string, ProcedureSignature procedureSignature, VarList[] varListArray, VarList[] varListArray2) {
        VariableLHS variableLHS;
        ASTType aSTType;
        Object object;
        Object object2;
        this.mProcedureManager.beginProcedureScope(this.mCHandler, this.mProcedureManager.getProcedureInfo(string));
        boolean bl = procedureSignature.getReturnType() == null;
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        int n = 0;
        while (n < varListArray.length - 1) {
            VarList object42 = varListArray[n];
            assert (object42.getIdentifiers().length == 1);
            object2 = object42.getIdentifiers()[0];
            object = ((String)object2).replaceFirst("in", "");
            expressionResultBuilder.addDeclaration((Declaration)new VariableDeclaration(iLocation, new Attribute[0], new VarList[]{new VarList(iLocation, new String[]{object}, object42.getType())}));
            IdentifierExpression identifierExpression = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(object42.getType()), (String)object2, (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, string));
            aSTType = ExpressionFactory.constructVariableLHS((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(object42.getType()), (String)object, (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.LOCAL, string));
            expressionResultBuilder.addStatement((Statement)StatementFactory.constructAssignmentStatement((ILocation)iLocation, (LeftHandSide[])new LeftHandSide[]{aSTType}, (Expression[])new Expression[]{identifierExpression}));
            variableLHS = ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(object42.getType()), (String)object, (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.LOCAL, string));
            arrayList.add((Expression)variableLHS);
            ++n;
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string2 : this.mFunctions) {
            object = this.mProcedureManager.getCFunctionType(string2);
            if (!new ProcedureSignature(this.mTypeHandler, (CFunction)object).equals(procedureSignature)) continue;
            arrayList2.add(string2);
        }
        Object var10_14 = null;
        if (arrayList2.isEmpty()) {
            return this.mProcedureManager.constructBody(iLocation, expressionResultBuilder.getDeclarations().toArray(new VariableDeclaration[expressionResultBuilder.getDeclarations().size()]), expressionResultBuilder.getStatements().toArray(new Statement[expressionResultBuilder.getStatements().size()]), string);
        }
        if (arrayList2.size() == 1) {
            boolean bl2;
            object2 = this.mFunctionhandler.createFunctionCall(iLocation, (String)arrayList2.get(0), arrayList);
            boolean bl3 = bl2 = varListArray2.length == 0;
            if (!bl2) {
                IdentifierExpression identifierExpression = (IdentifierExpression)((ExpressionResult)object2).getLrValue().getValue();
            }
            expressionResultBuilder.addAllExceptLrValue((ExpressionResult)object2);
            assert (varListArray2.length <= 1);
            if (varListArray2.length == 1) {
                String string3 = varListArray2[0].getIdentifiers()[0];
                aSTType = varListArray2[0].getType();
                variableLHS = ExpressionFactory.constructVariableLHS((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(aSTType), (String)string3, (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM, string));
                if (!bl2) {
                    void var10_16;
                    expressionResultBuilder.addStatement((Statement)StatementFactory.constructAssignmentStatement((ILocation)iLocation, (LeftHandSide[])new LeftHandSide[]{variableLHS}, (Expression[])new Expression[]{var10_16}));
                }
            }
            expressionResultBuilder.addStatements(CTranslationUtil.createHavocsForAuxVars(((ResultWithSideEffects)object2).getAuxVars()));
            expressionResultBuilder.addStatement((Statement)new ReturnStatement(iLocation));
            Body body = this.mProcedureManager.constructBody(iLocation, expressionResultBuilder.getDeclarations().toArray(new VariableDeclaration[expressionResultBuilder.getDeclarations().size()]), expressionResultBuilder.getStatements().toArray(new Statement[expressionResultBuilder.getStatements().size()]), string);
            this.mProcedureManager.endProcedureScope(this.mCHandler);
            return body;
        }
        object2 = null;
        if (!bl) {
            object2 = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, procedureSignature.getReturnType(), SFO.AUXVAR.FUNCPTRRES);
            expressionResultBuilder.addAuxVarWithDeclaration((AuxVarInfo)object2);
            IdentifierExpression identifierExpression = ((AuxVarInfo)object2).getExp();
        }
        object = this.mFunctionhandler.createFunctionCall(iLocation, (String)arrayList2.get(0), arrayList);
        for (Declaration declaration : ((ResultWithSideEffects)object).getDeclarations()) {
            expressionResultBuilder.addDeclaration(declaration);
        }
        expressionResultBuilder.addAuxVars(((ResultWithSideEffects)object).getAuxVars());
        ArrayList<Statement> arrayList3 = new ArrayList<Statement>(((ResultWithSideEffects)object).getStatements());
        if (!bl) {
            aSTType = StatementFactory.constructAssignmentStatement((ILocation)iLocation, (LeftHandSide[])new VariableLHS[]{((AuxVarInfo)object2).getLhs()}, (Expression[])new Expression[]{((ExpressionResult)object).getLrValue().getValue()});
            arrayList3.add((Statement)aSTType);
        }
        aSTType = null;
        int n2 = 1;
        while (n2 < arrayList2.size()) {
            AssignmentStatement assignmentStatement;
            ExpressionResult expressionResult = this.mFunctionhandler.createFunctionCall(iLocation, (String)arrayList2.get(n2), arrayList);
            for (Declaration declaration : expressionResult.getDeclarations()) {
                expressionResultBuilder.addDeclaration(declaration);
            }
            expressionResultBuilder.addAuxVars(expressionResult.getAuxVars());
            ArrayList<Statement> arrayList4 = new ArrayList<Statement>(expressionResult.getStatements());
            if (!bl) {
                assignmentStatement = StatementFactory.constructAssignmentStatement((ILocation)iLocation, (LeftHandSide[])new VariableLHS[]{((AuxVarInfo)object2).getLhs()}, (Expression[])new Expression[]{expressionResult.getLrValue().getValue()});
                arrayList4.add((Statement)assignmentStatement);
            }
            assignmentStatement = this.constructIdentifierExpression(iLocation, varListArray[varListArray.length - 1].getType(), varListArray[varListArray.length - 1].getIdentifiers()[0], DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, string);
            IdentifierExpression identifierExpression = PostProcessor.constructIdentifierExpression(iLocation, this.mTypeHandler.getBoogiePointerType(), "#funAddr~" + (String)arrayList2.get(n2), DeclarationInformation.StorageClass.GLOBAL, null);
            Expression expression = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)assignmentStatement, (Expression)identifierExpression);
            aSTType = n2 == 1 ? new IfStatement(iLocation, expression, arrayList4.toArray(new Statement[arrayList4.size()]), arrayList3.toArray(new Statement[arrayList3.size()])) : new IfStatement(iLocation, expression, arrayList4.toArray(new Statement[arrayList4.size()]), new Statement[]{aSTType});
            ++n2;
        }
        expressionResultBuilder.addStatement((Statement)aSTType);
        if (varListArray2.length == 1) {
            void var10_18;
            VariableLHS variableLHS2 = ExpressionFactory.constructVariableLHS((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(varListArray2[0].getType()), (String)varListArray2[0].getIdentifiers()[0], (DeclarationInformation)new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM, string));
            expressionResultBuilder.addStatement((Statement)StatementFactory.constructAssignmentStatement((ILocation)iLocation, (LeftHandSide[])new LeftHandSide[]{variableLHS2}, (Expression[])new Expression[]{var10_18}));
        }
        expressionResultBuilder.addStatements(CTranslationUtil.createHavocsForAuxVars(expressionResultBuilder.getAuxVars()));
        expressionResultBuilder.addStatement((Statement)new ReturnStatement(iLocation));
        Body body = this.mProcedureManager.constructBody(iLocation, expressionResultBuilder.getDeclarations().toArray(new VariableDeclaration[expressionResultBuilder.getDeclarations().size()]), expressionResultBuilder.getStatements().toArray(new Statement[expressionResultBuilder.getStatements().size()]), string);
        this.mProcedureManager.endProcedureScope(this.mCHandler);
        return body;
    }

    private UltimateInitProcedure createUltimateInitProcedure(ILocation iLocation, IASTNode iASTNode, List<Statement> list) {
        Object object;
        InitializerResult initializerResult;
        ILocation iLocation2;
        Procedure procedure = new Procedure(iLocation, new Attribute[0], "ULTIMATE.init", new String[0], new VarList[0], new VarList[0], new Specification[0], null);
        this.mProcedureManager.beginCustomProcedure(this.mCHandler, iLocation, "ULTIMATE.init", procedure);
        ArrayList<InitializerResult> arrayList = new ArrayList<InitializerResult>();
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<VariableDeclaration> arrayList2 = new ArrayList<VariableDeclaration>();
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        for (Pair<VariableDeclaration, CDeclaration> object22 : this.mStaticObjectsHandler.computeSuitableGlobalVarDecls()) {
            iLocation2 = ((VariableDeclaration)object22.getKey()).getLocation();
            initializerResult = ((CDeclaration)object22.getValue()).getInitializer();
            if (((CDeclaration)object22.getValue()).isExtern()) continue;
            VarList[] varListArray = ((VariableDeclaration)object22.getKey()).getVariables();
            int n = varListArray.length;
            int n2 = 0;
            while (n2 < n) {
                VarList varList = varListArray[n2];
                String[] stringArray = varList.getIdentifiers();
                int n3 = stringArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    Object object2;
                    String string = stringArray[n4];
                    VariableLHS variableLHS = ExpressionFactory.constructVariableLHS((ILocation)iLocation2, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(varList.getType()), (String)string, (DeclarationInformation)DeclarationInformation.DECLARATIONINFO_GLOBAL);
                    if (this.mCHandler.isHeapVar(string)) {
                        object2 = this.mMemoryHandler.getUltimateMemAllocInitCall(iLocation2, ((CDeclaration)object22.getValue()).getType());
                        RValue rValue = (RValue)object2.getFirst();
                        CallStatement callStatement = (CallStatement)object2.getSecond();
                        arrayList3.add(callStatement);
                        AssignmentStatement assignmentStatement = new AssignmentStatement(iLocation2, new LeftHandSide[]{variableLHS}, new Expression[]{rValue.getValue()});
                        arrayList3.add(assignmentStatement);
                    }
                    object2 = this.mInitHandler.initialize(iLocation2, (LeftHandSide)variableLHS, ((CDeclaration)object22.getValue()).getType(), initializerResult, iASTNode);
                    for (Statement statement : ((ResultWithSideEffects)object2).getStatements()) {
                        if (statement instanceof CallStatement) {
                            hashSet.add(((CallStatement)statement).getMethodName());
                        }
                        arrayList3.add(statement);
                    }
                    arrayList3.addAll(CTranslationUtil.createHavocsForAuxVars(((ResultWithSideEffects)object2).getAuxVars()));
                    for (Declaration declaration : ((ResultWithSideEffects)object2).getDeclarations()) {
                        arrayList2.add((VariableDeclaration)declaration);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        if (this.mMemoryHandler.getRequiredMemoryModelFeatures().isMemoryModelInfrastructureRequired()) {
            Expression expression = this.mTypeSize.constructLiteralForIntegerType(iLocation, this.mExpressionTranslation.getCTypeOfPointerComponents(), BigInteger.ZERO);
            object = this.mMemoryHandler.getBooleanArrayHelper().constructFalse();
            iLocation2 = ExpressionFactory.newBinaryExpression((ILocation)iLocation, (BinaryExpression.Operator)BinaryExpression.Operator.COMPEQ, (Expression)ExpressionFactory.constructNestedArrayAccessExpression((ILocation)iLocation, (Expression)this.mMemoryHandler.getValidArray(iLocation), (Expression[])new Expression[]{expression}), (Expression)object);
            initializerResult = new AssumeStatement(iLocation, (Expression)iLocation2);
            arrayList.add(0, initializerResult);
            Expression expression2 = this.mTypeSize.constructLiteralForIntegerType(iLocation, this.mExpressionTranslation.getCTypeOfPointerComponents(), BigInteger.ZERO);
            object = this.mExpressionTranslation.constructBinaryComparisonIntegerExpression(iLocation, 8, expression2, this.mExpressionTranslation.getCTypeOfPointerComponents(), this.mMemoryHandler.getStackHeapBarrier(iLocation), this.mExpressionTranslation.getCTypeOfPointerComponents());
            arrayList.add((InitializerResult)new AssumeStatement(iLocation, object));
        }
        if (this.mSettings.isBitvectorTranslation() && this.mTypeHandler.areFloatingTypesNeeded() && this.mSettings.isFesetroundEnabled()) {
            IdentifierExpression identifierExpression = this.mSettings.getInitialRoundingMode().getSmtRoundingMode().getBoogieIdentifierExpression();
            object = ExpressionFactory.constructVariableLHS((ILocation)iLocation, (BoogieType)BitvectorTranslation.ROUNDING_MODE_BOOGIE_TYPE, (String)"currentRoundingMode", (DeclarationInformation)DeclarationInformation.DECLARATIONINFO_GLOBAL);
            iLocation2 = StatementFactory.constructSingleAssignmentStatement((ILocation)iLocation, (LeftHandSide)object, (Expression)identifierExpression);
            arrayList.add((InitializerResult)iLocation2);
        }
        this.mStaticObjectsHandler.freeze();
        Comparator comparator = (boogieASTNode, boogieASTNode2) -> Integer.compare(boogieASTNode.getLocation().getStartLine(), boogieASTNode2.getLocation().getStartLine());
        arrayList2.sort(comparator);
        arrayList.sort(comparator);
        object = this.mStaticObjectsHandler.getStatementsForUltimateInit();
        arrayList.addAll((Collection<InitializerResult>)object);
        arrayList.addAll(arrayList3);
        arrayList.addAll(list);
        iLocation2 = this.mProcedureManager.constructBody(iLocation, arrayList2.toArray(new VariableDeclaration[arrayList2.size()]), arrayList.toArray(new Statement[arrayList.size()]), "ULTIMATE.init");
        initializerResult = new Procedure(iLocation, new Attribute[0], "ULTIMATE.init", new String[0], new VarList[0], new VarList[0], null, (Body)iLocation2);
        this.mProcedureManager.endCustomProcedure(this.mCHandler, "ULTIMATE.init");
        return new UltimateInitProcedure((Declaration)initializerResult);
    }

    private UltimateStartProcedure createUltimateStartProcedure(ILocation iLocation, IASTNode iASTNode) {
        Object object;
        Procedure procedure = null;
        Procedure procedure2 = new Procedure(iLocation, new Attribute[0], "ULTIMATE.start", new String[0], new VarList[0], new VarList[0], new Specification[0], null);
        this.mProcedureManager.beginCustomProcedure(this.mCHandler, iLocation, "ULTIMATE.start", procedure2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        ArrayList<VariableDeclaration> arrayList2 = new ArrayList<VariableDeclaration>();
        arrayList.add(StatementFactory.constructCallStatement((ILocation)iLocation, (boolean)false, (VariableLHS[])new VariableLHS[0], (String)"ULTIMATE.init", (Expression[])new Expression[0]));
        String string = this.mSettings.getEntryFunction();
        VarList[] varListArray = this.mProcedureManager.getProcedureDeclaration(string).getOutParams();
        VarList[] varListArray2 = this.mProcedureManager.getProcedureDeclaration(string).getInParams();
        Specification[] specificationArray = this.mProcedureManager.getProcedureDeclaration(string).getSpecification();
        ArrayList<AssumeStatement> arrayList3 = new ArrayList<AssumeStatement>();
        Specification[] specificationArray2 = specificationArray;
        int n = specificationArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = specificationArray2[n2];
            if (object instanceof RequiresSpecification) {
                arrayList3.add(new AssumeStatement(iLocation, ((RequiresSpecification)object).getFormula()));
            }
            ++n2;
        }
        arrayList.addAll(arrayList3);
        object = new ArrayList();
        if (varListArray2.length > 0) {
            arrayList2.add(new VariableDeclaration(iLocation, new Attribute[0], varListArray2));
            VarList[] varListArray3 = varListArray2;
            int n3 = varListArray2.length;
            n = 0;
            while (n < n3) {
                VarList varList = varListArray3[n];
                assert (varList.getIdentifiers().length == 1);
                String string2 = varList.getIdentifiers()[0];
                IdentifierExpression identifierExpression = this.constructIdentifierExpression(iLocation, varList.getType(), string2, DeclarationInformation.StorageClass.LOCAL, "ULTIMATE.start");
                ((ArrayList)object).add(identifierExpression);
                ++n;
            }
        }
        if (varListArray.length != 0) {
            assert (varListArray.length == 1);
            ICType iCType = this.mProcedureManager.getCFunctionType(string).getResultType();
            AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, iCType, SFO.AUXVAR.RETURNED);
            this.mSymboltable.addBoogieCIdPair(auxVarInfo.getExp().getIdentifier(), "NO_REAL_C_VAR" + auxVarInfo.getExp().getIdentifier(), iLocation);
            arrayList2.add(auxVarInfo.getVarDec());
            arrayList.add(StatementFactory.constructCallStatement((ILocation)iLocation, (boolean)false, (VariableLHS[])new VariableLHS[]{auxVarInfo.getLhs()}, (String)string, (Expression[])((ArrayList)object).toArray(new Expression[((ArrayList)object).size()])));
        } else {
            arrayList.add(StatementFactory.constructCallStatement((ILocation)iLocation, (boolean)false, (VariableLHS[])new VariableLHS[0], (String)string, (Expression[])((ArrayList)object).toArray(new Expression[((ArrayList)object).size()])));
        }
        Body body = this.mProcedureManager.constructBody(iLocation, arrayList2.toArray(new VariableDeclaration[arrayList2.size()]), arrayList.toArray(new Statement[arrayList.size()]), "ULTIMATE.start");
        procedure = new Procedure(iLocation, new Attribute[0], "ULTIMATE.start", new String[0], new VarList[0], new VarList[0], null, body);
        this.mProcedureManager.endCustomProcedure(this.mCHandler, "ULTIMATE.start");
        return new UltimateStartProcedure(procedure);
    }

    private IdentifierExpression constructIdentifierExpression(ILocation iLocation, ASTType aSTType, String string, DeclarationInformation.StorageClass storageClass, String string2) {
        return ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)this.mTypeHandler.getBoogieTypeForBoogieASTType(aSTType), (String)string, (DeclarationInformation)new DeclarationInformation(storageClass, string2));
    }

    private static IdentifierExpression constructIdentifierExpression(ILocation iLocation, BoogieType boogieType, String string, DeclarationInformation.StorageClass storageClass, String string2) {
        assert (storageClass != DeclarationInformation.StorageClass.GLOBAL || string2 == null);
        return ExpressionFactory.constructIdentifierExpression((ILocation)iLocation, (BoogieType)boogieType, (String)string, (DeclarationInformation)new DeclarationInformation(storageClass, string2));
    }

    private static final class UltimateInitProcedure {
        private final Declaration mUltimateInitImplementation;

        private UltimateInitProcedure(Declaration declaration) {
            this.mUltimateInitImplementation = declaration;
        }

        public Declaration getUltimateInitImplementation() {
            assert (this.mUltimateInitImplementation != null);
            return this.mUltimateInitImplementation;
        }
    }

    private static final class UltimateStartProcedure {
        private final Procedure mStartProcedure;

        private UltimateStartProcedure(Procedure procedure) {
            this.mStartProcedure = procedure;
        }

        public Declaration getUltimateStartImplementation() {
            assert (this.mStartProcedure != null);
            return this.mStartProcedure;
        }
    }
}

