/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.AnnotationRemover;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.AnnotatedProgramPoint;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.AppEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.appgraph.AppHyperEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.codecheck.GraphViz;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GraphWriter {
    private boolean mAnnotateEdges = true;
    private boolean mAnnotateNodes = true;
    private boolean mShowUnreachableEdges = false;
    private final boolean mShowNodeToCopy = true;
    private boolean mHideUnreachableOnce = true;
    private boolean mDontWrite = true;
    private final AnnotationRemover mAnnotationRemover;
    private final String mImagePath;
    private int mGraphCounter = 0;
    private final ILogger mLogger;

    public GraphWriter(ILogger iLogger, String string, boolean bl, boolean bl2, boolean bl3) {
        this.mLogger = iLogger;
        this.mImagePath = string;
        if (string == "") {
            this.mDontWrite = true;
        }
        this.mAnnotateEdges = bl;
        this.mAnnotateNodes = bl2;
        this.mShowUnreachableEdges = bl3;
        this.mAnnotationRemover = new AnnotationRemover();
    }

    public void writeGraphAsImage(AnnotatedProgramPoint annotatedProgramPoint, String string) {
        if (this.mDontWrite) {
            return;
        }
        GraphViz graphViz = new GraphViz(this.mLogger);
        graphViz.addLine("digraph G {");
        Set<AnnotatedProgramPoint> set = this.collectNodes(annotatedProgramPoint);
        List<GraphEdge> list = GraphWriter.collectEdges(set);
        graphViz.addLine(this.writeNodesToString(set).toString());
        graphViz.addLine(this.writeEdgesToString(list).toString());
        graphViz.addLine("}");
        GraphViz.writeGraphToFile(graphViz.getGraph(graphViz.getDotSource(), "png"), new File(this.mImagePath + "/" + string + ".png"));
        ++this.mGraphCounter;
    }

    public void writeGraphAsImage(AnnotatedProgramPoint annotatedProgramPoint, String string, AnnotatedProgramPoint[] annotatedProgramPointArray) {
        if (this.mDontWrite) {
            return;
        }
        GraphViz graphViz = new GraphViz(this.mLogger);
        graphViz.addLine("digraph G {");
        Set<AnnotatedProgramPoint> set = this.collectNodes(annotatedProgramPoint);
        List<GraphEdge> list = GraphWriter.collectEdges(set);
        graphViz.addLine(this.writeNodesToString(set).toString());
        HashSet<AnnotatedProgramPoint> hashSet = new HashSet<AnnotatedProgramPoint>();
        Collections.addAll(hashSet, annotatedProgramPointArray);
        graphViz.addLine(this.writeEdgesToString(list, hashSet).toString());
        graphViz.addLine("}");
        GraphViz.writeGraphToFile(graphViz.getGraph(graphViz.getDotSource(), "png"), new File(this.mImagePath + "/" + string + ".png"));
        ++this.mGraphCounter;
    }

    public void writeGraphAsImage(AnnotatedProgramPoint annotatedProgramPoint, String string, Map<AnnotatedProgramPoint, AnnotatedProgramPoint> map, Map<AnnotatedProgramPoint, AnnotatedProgramPoint> map2) {
        if (this.mDontWrite) {
            return;
        }
        GraphViz graphViz = new GraphViz(this.mLogger);
        graphViz.addLine("digraph G {");
        Set<AnnotatedProgramPoint> set = this.collectNodes(annotatedProgramPoint);
        List<GraphEdge> list = GraphWriter.collectEdges(set);
        graphViz.addLine(this.writeString(set, list, map, map2));
        graphViz.addLine("}");
        GraphViz.writeGraphToFile(graphViz.getGraph(graphViz.getDotSource(), "png"), new File(this.mImagePath + "/" + string + ".png"));
        ++this.mGraphCounter;
    }

    private Set<AnnotatedProgramPoint> collectNodes(AnnotatedProgramPoint annotatedProgramPoint) {
        ArrayList<AnnotatedProgramPoint> arrayList = new ArrayList<AnnotatedProgramPoint>();
        HashSet<AnnotatedProgramPoint> hashSet = new HashSet<AnnotatedProgramPoint>();
        boolean bl = true;
        arrayList.add(annotatedProgramPoint);
        hashSet.add(annotatedProgramPoint);
        while (bl) {
            bl = false;
            ArrayList arrayList2 = new ArrayList(arrayList);
            for (AnnotatedProgramPoint annotatedProgramPoint2 : arrayList2) {
                ArrayList arrayList3;
                ArrayList arrayList4 = arrayList3 = annotatedProgramPoint2.getOutgoingNodes() == null ? new ArrayList() : new ArrayList(annotatedProgramPoint2.getOutgoingNodes());
                if (this.mShowUnreachableEdges && !this.mHideUnreachableOnce && annotatedProgramPoint2.getIncomingNodes() != null) {
                    arrayList3.addAll(annotatedProgramPoint2.getIncomingNodes());
                }
                for (AnnotatedProgramPoint annotatedProgramPoint3 : arrayList3) {
                    if (hashSet.contains((Object)annotatedProgramPoint3)) continue;
                    hashSet.add(annotatedProgramPoint3);
                    arrayList.add(annotatedProgramPoint3);
                    bl = true;
                }
                arrayList.remove((Object)annotatedProgramPoint2);
            }
        }
        return hashSet;
    }

    private static List<GraphEdge> collectEdges(Set<AnnotatedProgramPoint> set) {
        ArrayList<GraphEdge> arrayList = new ArrayList<GraphEdge>();
        for (AnnotatedProgramPoint annotatedProgramPoint : set) {
            for (AppEdge appEdge : annotatedProgramPoint.getOutgoingEdges()) {
                arrayList.add(new GraphEdge(annotatedProgramPoint, appEdge instanceof AppHyperEdge ? ((AppHyperEdge)appEdge).getHier() : null, appEdge.getStatement(), (AnnotatedProgramPoint)appEdge.getTarget()));
            }
        }
        return arrayList;
    }

    private StringBuilder writeNodesToString(Set<AnnotatedProgramPoint> set) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<AnnotatedProgramPoint> iterator = set.iterator();
        while (iterator.hasNext()) {
            if (this.mAnnotateNodes) {
                stringBuilder.append(this.getLabeledNode(iterator.next()) + "\n");
                continue;
            }
            stringBuilder.append(GraphWriter.convertNodeNameQuot(iterator.next()) + "\n");
        }
        return stringBuilder;
    }

    private StringBuilder writeEdgesToString(List<GraphEdge> list) {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<GraphEdge> iterator = list.iterator();
        while (iterator.hasNext()) {
            stringBuilder.append(this.convertEdgeName(iterator.next()) + "\n");
        }
        return stringBuilder;
    }

    private Object writeEdgesToString(List<GraphEdge> list, Set<AnnotatedProgramPoint> set) {
        if (set == null) {
            return this.writeEdgesToString(list);
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = "";
        for (GraphEdge graphEdge : list) {
            if (set.contains((Object)graphEdge.mSource) && set.contains((Object)graphEdge.mTarget) && !((Object)((Object)graphEdge.mSource)).equals((Object)graphEdge.mTarget)) {
                string = "[color=blue]";
            }
            stringBuilder.append(this.convertEdgeName(graphEdge) + string + "\n");
            string = "";
        }
        return stringBuilder;
    }

    private StringBuilder writeEdgesToString(List<GraphEdge> list, Map<AnnotatedProgramPoint, AnnotatedProgramPoint> map) {
        StringBuilder stringBuilder = new StringBuilder();
        for (GraphEdge graphEdge : list) {
            stringBuilder.append(this.convertEdgeName(graphEdge) + (map.containsValue((Object)graphEdge.mSource) ? " [style=dashed] " : "") + "\n");
        }
        return stringBuilder;
    }

    private String writeString(Set<AnnotatedProgramPoint> set, List<GraphEdge> list, Map<AnnotatedProgramPoint, AnnotatedProgramPoint> map, Map<AnnotatedProgramPoint, AnnotatedProgramPoint> map2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append((CharSequence)this.writeNodesToString(set));
        stringBuilder.append((CharSequence)this.writeEdgesToString(list, map));
        for (Map.Entry<AnnotatedProgramPoint, AnnotatedProgramPoint> entry : map.entrySet()) {
            stringBuilder.append("{ rank=same; rankdir=LR; " + (String)(this.mAnnotateNodes ? this.getLabeledNode(entry.getKey(), "color=grey, style=filled") : GraphWriter.convertNodeNameQuot(entry.getKey()) + " [color=grey, style=filled] ; ") + (String)(this.mAnnotateNodes ? this.getLabeledNode(entry.getValue(), "color=lightblue, style=filled") : GraphWriter.convertNodeNameQuot(entry.getValue()) + " [color=lightblue, style=filled] ;") + "}");
        }
        for (Map.Entry<AnnotatedProgramPoint, AnnotatedProgramPoint> entry : map2.entrySet()) {
            stringBuilder.append(GraphWriter.convertNodeNameQuot(entry.getKey()) + " -> " + GraphWriter.convertNodeNameQuot(entry.getValue()) + "[weight=0, color=red] ;");
        }
        return stringBuilder.toString();
    }

    private String getLabeledNode(AnnotatedProgramPoint annotatedProgramPoint) {
        return this.getLabeledNode(annotatedProgramPoint, "");
    }

    private String getLabeledNode(AnnotatedProgramPoint annotatedProgramPoint, String string) {
        String string2;
        String string3 = GraphWriter.convertNodeName(annotatedProgramPoint);
        String string4 = GraphWriter.convertNodeNameQuot(annotatedProgramPoint);
        if (annotatedProgramPoint.getPredicate() != null) {
            Term term = annotatedProgramPoint.getPredicate().getFormula();
            FormulaUnLet formulaUnLet = new FormulaUnLet();
            term = formulaUnLet.unlet(term);
            string2 = this.prettifyFormula(term);
        } else {
            string2 = "noAssertion";
        }
        return "\n" + string4 + "[label = \"" + string3 + "\\n" + string2 + "\\n" + String.valueOf(annotatedProgramPoint.getOutgoingHyperEdges()) + "\" , " + string + "];\n";
    }

    private static String convertNodeName(AnnotatedProgramPoint annotatedProgramPoint) {
        return annotatedProgramPoint.toString();
    }

    private static String convertNodeNameQuot(AnnotatedProgramPoint annotatedProgramPoint) {
        return "\"" + GraphWriter.convertNodeName(annotatedProgramPoint) + "\"";
    }

    private String convertEdgeName(GraphEdge graphEdge) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(GraphWriter.convertNodeNameQuot(graphEdge.mSource) + " -> " + GraphWriter.convertNodeNameQuot(graphEdge.mTarget));
        if (this.mAnnotateEdges) {
            Object object = graphEdge.mLabel == null ? "-" : (graphEdge.mLabel instanceof IIcfgCallTransition ? "IIcfgCallTransition<?>" : (graphEdge.mLabel instanceof IIcfgReturnTransition ? "IIcfgReturnTransition<?,?>\\n" + GraphWriter.convertNodeName(graphEdge.mHier) : graphEdge.mLabel.toString()));
            stringBuilder.append("[label=\"" + (String)object + "\"]");
        }
        return stringBuilder.toString();
    }

    private String prettifyFormula(Term term) {
        Term term2 = this.mAnnotationRemover.transform(term);
        return term2.toString();
    }

    public boolean getHideUnreachableOnce() {
        return this.mHideUnreachableOnce;
    }

    public void setHideUnreachableOnce(boolean bl) {
        this.mHideUnreachableOnce = bl;
    }

    public int getGraphCounter() {
        return this.mGraphCounter;
    }

    private static final class GraphEdge {
        private final AnnotatedProgramPoint mSource;
        private final AnnotatedProgramPoint mTarget;
        private final AnnotatedProgramPoint mHier;
        private final IIcfgTransition<?> mLabel;

        public GraphEdge(AnnotatedProgramPoint annotatedProgramPoint, AnnotatedProgramPoint annotatedProgramPoint2, IIcfgTransition<?> iIcfgTransition, AnnotatedProgramPoint annotatedProgramPoint3) {
            this.mSource = annotatedProgramPoint;
            this.mHier = annotatedProgramPoint2;
            this.mLabel = iIcfgTransition;
            this.mTarget = annotatedProgramPoint3;
        }

        public String toString() {
            return this.mSource.toString() + " --" + (this.mHier == null ? "" : this.mHier.toString()) + "-" + (this.mLabel == null ? "null" : this.mLabel.toString()) + "--> " + this.mTarget.toString();
        }
    }
}

