/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.RelationSymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolyPoNe;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class PolyPoNeWithContext
extends PolyPoNe {
    final PolyPoNe mContext;

    PolyPoNeWithContext(Script script, SmtUtils.Junction junction, PolyPoNe polyPoNe) {
        super(script, junction);
        if (polyPoNe.isInconsistent()) {
            throw new AssertionError((Object)"must not add inconsistent context");
        }
        this.mContext = polyPoNe;
    }

    Term and(Term term, List<Term> list) {
        if (SmtUtils.isFalseLiteral(term)) {
            return this.mScript.term("false", new Term[0]);
        }
        return this.and(Arrays.asList(SmtUtils.getConjuncts(term)), list);
    }

    private Term and(Collection<Term> collection, List<Term> list) {
        this.addContext(collection);
        return super.and(list);
    }

    Term or(Term term, List<Term> list) {
        if (SmtUtils.isFalseLiteral(term)) {
            return this.mScript.term("true", new Term[0]);
        }
        return this.or(Arrays.asList(SmtUtils.getConjuncts(term)), list);
    }

    private Term or(Collection<Term> collection, List<Term> list) {
        this.addContext(collection);
        return super.or(list);
    }

    private boolean addContext(Collection<Term> collection) {
        for (Term term : collection) {
            boolean bl;
            PolynomialRelation polynomialRelation = PolynomialRelation.of(this.mScript, term, PolynomialRelation.TransformInequality.STRICT2NONSTRICT);
            if (!(polynomialRelation != null ? (bl = this.mContext.addPolyRel(this.mScript, polynomialRelation, true)) : (bl = this.mContext.addNonPolynomial(term)))) continue;
            return true;
        }
        return false;
    }

    @Override
    protected final boolean addPolyRel(Script script, PolynomialRelation polynomialRelation, boolean bl) {
        if (this.isInconsistent()) {
            throw new AssertionError((Object)"must not add if already inconsistent");
        }
        PolyPoNe.Check check = this.mContext.checkPolyRel(script, polynomialRelation, false);
        if (check == PolyPoNe.Check.MAYBE_USEFUL) {
            PolynomialRelation polynomialRelation2 = this.tryToFuseWithContext(polynomialRelation);
            return super.addPolyRel(script, polynomialRelation2, bl);
        }
        if (check == PolyPoNe.Check.REDUNDANT) {
            return false;
        }
        if (check == PolyPoNe.Check.INCONSISTENT) {
            return true;
        }
        throw new AssertionError((Object)("unknown value " + String.valueOf((Object)check)));
    }

    public PolynomialRelation tryToFuseWithContext(PolynomialRelation polynomialRelation) {
        PolynomialRelation polynomialRelation2;
        PolynomialRelation polynomialRelation3;
        if (!polynomialRelation.getRelationSymbol().isConvexInequality()) {
            return polynomialRelation;
        }
        if (this.mJunction == SmtUtils.Junction.OR) {
            polynomialRelation3 = polynomialRelation.negate().tryToConvertToEquivalentNonStrictRelation();
        } else {
            assert (!polynomialRelation.getRelationSymbol().isStrictRelation() || !SmtSortUtils.isIntSort(polynomialRelation.getPolynomialTerm().getSort())) : "Inequalities in conjunctions are non-strict";
            polynomialRelation3 = polynomialRelation;
        }
        PolynomialRelation polynomialRelation4 = this.mContext.isFusibleWithExistingRelations(this.mScript, SmtUtils.Junction.AND, polynomialRelation3);
        if (polynomialRelation4 == null) {
            polynomialRelation2 = polynomialRelation;
        } else {
            PolynomialRelation polynomialRelation5;
            if (this.mJunction == SmtUtils.Junction.OR) {
                polynomialRelation5 = PolynomialRelation.of(polynomialRelation3.getPolynomialTerm(), RelationSymbol.DISTINCT);
            } else {
                assert (this.mJunction == SmtUtils.Junction.AND);
                polynomialRelation5 = PolynomialRelation.of(polynomialRelation3.getPolynomialTerm(), RelationSymbol.EQ);
            }
            polynomialRelation2 = polynomialRelation5;
        }
        return polynomialRelation2;
    }

    @Override
    protected PolyPoNe.Check checkNegative(Term term) {
        PolyPoNe.Check check = this.mContext.checkNegative(term);
        if (check != PolyPoNe.Check.MAYBE_USEFUL) {
            return check;
        }
        return super.checkNegative(term);
    }

    @Override
    protected PolyPoNe.Check checkPositive(Term term) {
        PolyPoNe.Check check = this.mContext.checkPositive(term);
        if (check != PolyPoNe.Check.MAYBE_USEFUL) {
            return check;
        }
        return super.checkPositive(term);
    }
}

