/*
 * Decompiled with CFR 0.152.
 */
package com.github.jhoenicke.javacup;

import com.github.jhoenicke.javacup.CombRow;
import com.github.jhoenicke.javacup.Grammar;
import java.util.BitSet;
import java.util.TreeSet;

public class parse_action_table {
    public final int[][] table;
    public static final int ERROR = 0;
    public static final int SHIFT = 1;
    public static final int REDUCE = 2;

    public parse_action_table(Grammar grammar) {
        int n = grammar.lalr_states().size();
        int n2 = grammar.num_terminals();
        this.table = new int[n][n2 + 1];
    }

    public static int action(int n, int n2) {
        return 2 * n2 + n;
    }

    public static boolean isReduce(int n) {
        return n != 0 && (n & 1) == 0;
    }

    public static boolean isShift(int n) {
        return (n & 1) != 0;
    }

    public static int index(int n) {
        return n - 1 >> 1;
    }

    public static String toString(int n) {
        if (n == 0) {
            return "ERROR";
        }
        if (parse_action_table.isShift(n)) {
            return "SHIFT(" + parse_action_table.index(n) + ")";
        }
        return "REDUCE(" + parse_action_table.index(n) + ")";
    }

    public short[] compress(int[] nArray) {
        int n;
        int[] nArray2 = new int[this.table.length];
        TreeSet<CombRow> treeSet = new TreeSet<CombRow>();
        int n2 = 0;
        while (n2 < this.table.length) {
            int[] nArray3 = this.table[n2];
            nArray2[n2] = nArray3[nArray3.length - 1];
            int n3 = 0;
            int n4 = 0;
            while (n4 < nArray3.length - 1) {
                if (nArray3[n4] != nArray2[n2]) {
                    ++n3;
                }
                ++n4;
            }
            if (n3 != 0) {
                int[] nArray4 = new int[n3];
                n3 = 0;
                n = 0;
                while (n < nArray3.length - 1) {
                    if (nArray3[n] != nArray2[n2]) {
                        nArray4[n3++] = n;
                    }
                    ++n;
                }
                treeSet.add(new CombRow(n2, nArray4));
            }
            ++n2;
        }
        BitSet bitSet = new BitSet();
        int n5 = 0;
        for (CombRow combRow : treeSet) {
            combRow.fitInComb(bitSet);
            n = combRow.base + this.table[combRow.index].length;
            if (n <= n5) continue;
            n5 = n;
        }
        int n6 = this.table.length;
        Object object = new short[n6 + 2 * n5];
        n = 0;
        while (n < n6) {
            nArray[n] = (short)n6;
            object[n] = (short)nArray2[n];
            ++n;
        }
        n = 0;
        while (n < n5) {
            object[n6 + 2 * n] = (short)n6;
            object[n6 + 2 * n + 1] = true;
            ++n;
        }
        for (CombRow combRow : treeSet) {
            int n7;
            nArray[combRow.index] = n7 = this.table.length + 2 * combRow.base;
            int n8 = 0;
            while (n8 < combRow.comb.length) {
                int n9 = combRow.comb[n8];
                object[n7 + 2 * n9] = (short)combRow.index;
                object[n7 + 2 * n9 + 1] = (short)this.table[combRow.index][n9];
                ++n8;
            }
        }
        return object;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("-------- ACTION_TABLE --------\n");
        int n = 0;
        while (n < this.table.length) {
            stringBuilder.append("From state #").append(n).append("\n");
            int n2 = 0;
            int n3 = this.table[n][this.table[n].length - 1];
            stringBuilder.append(" [default:").append(parse_action_table.toString(n3)).append("]\n");
            int n4 = 0;
            while (n4 < this.table[n].length) {
                if (this.table[n][n4] != n3) {
                    stringBuilder.append(" [term ").append(n4).append(":").append(parse_action_table.toString(this.table[n][n4])).append("]");
                    if (++n2 == 2) {
                        stringBuilder.append("\n");
                        n2 = 0;
                    }
                }
                ++n4;
            }
            if (n2 != 0) {
                stringBuilder.append("\n");
            }
            ++n;
        }
        stringBuilder.append("------------------------------");
        return stringBuilder.toString();
    }
}

