/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IncrementalHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.MonolithicImplicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.proofs.PrePostConditionSpecification;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.IFloydHoareAnnotation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;

public abstract class FloydHoareValidityCheck<S> {
    protected final ILogger mLogger;
    private final MonolithicImplicationChecker mImplChecker;
    private final IHoareTripleChecker mHoareTripleChecker;
    private final IFloydHoareAnnotation<S> mAnnotation;
    private final PrePostConditionSpecification<S> mSpec;
    private final boolean mAssertValidity;
    private final MissingAnnotationBehaviour mMissingAnnotations;
    private final boolean mCheckSafety;
    private int mProven;
    private int mRefuted;
    private int mUnknown;
    private int mMissing;
    private final ArrayDeque<S> mWorklist = new ArrayDeque();
    private final Set<S> mVisited = new HashSet<S>();
    private IncrementalPlicationChecker.Validity mIsInitial;
    private IncrementalPlicationChecker.Validity mIsInductive;
    private IncrementalPlicationChecker.Validity mIsSafe = IncrementalPlicationChecker.Validity.VALID;

    protected FloydHoareValidityCheck(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, IHoareTripleChecker iHoareTripleChecker, IFloydHoareAnnotation<S> iFloydHoareAnnotation, boolean bl, MissingAnnotationBehaviour missingAnnotationBehaviour, boolean bl2) {
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(FloydHoareValidityCheck.class);
        this.mImplChecker = new MonolithicImplicationChecker(iUltimateServiceProvider, managedScript);
        this.mHoareTripleChecker = iHoareTripleChecker;
        this.mAnnotation = iFloydHoareAnnotation;
        this.mSpec = this.mAnnotation.getSpecification();
        this.mAssertValidity = bl;
        this.mMissingAnnotations = missingAnnotationBehaviour;
        this.mCheckSafety = bl2;
        if (!this.mCheckSafety) {
            this.mIsSafe = IncrementalPlicationChecker.Validity.NOT_CHECKED;
        }
    }

    protected final void performCheck() {
        this.mIsInitial = this.checkInitial();
        this.mIsInductive = this.checkInductivity();
    }

    public IncrementalPlicationChecker.Validity isInitial() {
        return this.mIsInitial;
    }

    public IncrementalPlicationChecker.Validity isInductive() {
        return this.mIsInductive;
    }

    public IncrementalPlicationChecker.Validity isSafe() {
        return this.mIsSafe;
    }

    public IncrementalPlicationChecker.Validity isValid() {
        if (this.mCheckSafety) {
            return this.mIsInitial.and(this.mIsInductive).and(this.mIsSafe);
        }
        return this.mIsInitial.and(this.mIsInductive);
    }

    public boolean getResult() {
        return this.isValid() != IncrementalPlicationChecker.Validity.INVALID;
    }

    protected abstract Iterable<Pair<IInternalAction, S>> getInternalSuccessors(S var1);

    protected abstract Iterable<Pair<ICallAction, S>> getCallSuccessors(S var1);

    protected abstract Iterable<Triple<IReturnAction, S, S>> getReturnSuccessors(S var1);

    private IncrementalPlicationChecker.Validity checkInitial() {
        IncrementalPlicationChecker.Validity validity = IncrementalPlicationChecker.Validity.VALID;
        for (S s : this.mSpec.getInitialStates()) {
            IPredicate iPredicate = this.getAnnotation(s);
            if (iPredicate != null) {
                IPredicate iPredicate2 = this.mSpec.getPrecondition(s);
                IncrementalPlicationChecker.Validity validity2 = this.mImplChecker.checkImplication(iPredicate2, false, iPredicate, false);
                assert (!this.mAssertValidity || validity2 != IncrementalPlicationChecker.Validity.INVALID) : "condition " + String.valueOf(iPredicate) + " at initial location " + String.valueOf(s) + " not entailed by corresponding precondition " + String.valueOf(iPredicate2);
                validity = validity.and(validity2);
            }
            this.mWorklist.add(s);
            this.mVisited.add(s);
        }
        return validity;
    }

    private IncrementalPlicationChecker.Validity checkInductivity() {
        IncrementalPlicationChecker.Validity validity = IncrementalPlicationChecker.Validity.VALID;
        while (!this.mWorklist.isEmpty()) {
            IncrementalPlicationChecker.Validity validity2;
            S s = this.mWorklist.pop();
            IPredicate iPredicate = this.getAnnotation(s);
            this.checkSafe(s, iPredicate);
            for (Pair<IInternalAction, S> pair : this.getInternalSuccessors(s)) {
                validity2 = this.checkInductivity(s, iPredicate, pair, (arg_0, arg_1, arg_2) -> ((IHoareTripleChecker)this.mHoareTripleChecker).checkInternal(arg_0, arg_1, arg_2));
                validity = validity.and(validity2);
            }
            for (Pair<IInternalAction, S> pair : this.getCallSuccessors(s)) {
                validity2 = this.checkInductivity(s, iPredicate, pair, (arg_0, arg_1, arg_2) -> ((IHoareTripleChecker)this.mHoareTripleChecker).checkCall(arg_0, arg_1, arg_2));
                validity = validity.and(validity2);
            }
            for (Triple triple : this.getReturnSuccessors(s)) {
                validity2 = this.checkReturnInductivity(s, iPredicate, triple);
                validity = validity.and(validity2);
            }
        }
        if (this.mHoareTripleChecker instanceof IncrementalHoareTripleChecker) {
            ((IncrementalHoareTripleChecker)this.mHoareTripleChecker).clearAssertionStack();
        }
        this.mLogger.info("Floyd-Hoare annotation has %d edges. %d inductive. %d not inductive. %d times theorem prover too weak to decide inductivity. %d times interpolants missing.", new Object[]{this.mProven + this.mRefuted + this.mUnknown + this.mMissing, this.mProven, this.mRefuted, this.mUnknown, this.mMissing});
        return validity;
    }

    private <A extends IAction> IncrementalPlicationChecker.Validity checkInductivity(S s, IPredicate iPredicate, Pair<A, S> pair, ISimpleHoareCheck<A> iSimpleHoareCheck) {
        Object object = pair.getSecond();
        if (this.mVisited.add(object)) {
            this.mWorklist.push(object);
        }
        IPredicate iPredicate2 = this.getAnnotation(object);
        if (iPredicate == null || iPredicate2 == null) {
            ++this.mMissing;
            return this.mMissingAnnotations == MissingAnnotationBehaviour.IGNORE ? IncrementalPlicationChecker.Validity.VALID : IncrementalPlicationChecker.Validity.UNKNOWN;
        }
        IncrementalPlicationChecker.Validity validity = iSimpleHoareCheck.check(iPredicate, (IAction)pair.getFirst(), iPredicate2);
        this.evaluateInductivityResult(validity, s, (IAction)pair.getFirst(), object, null);
        return validity;
    }

    private IncrementalPlicationChecker.Validity checkReturnInductivity(S s, IPredicate iPredicate, Triple<IReturnAction, S, S> triple) {
        Object object = triple.getSecond();
        if (this.mVisited.add(object)) {
            this.mWorklist.push(object);
        }
        IPredicate iPredicate2 = this.getAnnotation(object);
        IPredicate iPredicate3 = this.getAnnotation(triple.getThird());
        if (iPredicate == null || iPredicate2 == null || iPredicate3 == null) {
            ++this.mMissing;
            return this.mMissingAnnotations == MissingAnnotationBehaviour.IGNORE ? IncrementalPlicationChecker.Validity.VALID : IncrementalPlicationChecker.Validity.UNKNOWN;
        }
        IncrementalPlicationChecker.Validity validity = this.mHoareTripleChecker.checkReturn(iPredicate, iPredicate3, (IReturnAction)triple.getFirst(), iPredicate2);
        this.evaluateInductivityResult(validity, s, (IAction)triple.getFirst(), object, triple.getThird());
        return validity;
    }

    private void evaluateInductivityResult(IncrementalPlicationChecker.Validity validity, S s, IAction iAction, S s2, S s3) {
        switch (validity) {
            case VALID: {
                ++this.mProven;
                break;
            }
            case INVALID: {
                ++this.mRefuted;
                String string = s3 == null ? "" : " (hier: " + String.valueOf(s3) + ")";
                this.mLogger.warn("Transition %s %s %s%s not inductive", new Object[]{s, iAction, s2, string});
                assert (!this.mAssertValidity) : "inductivity violated";
                break;
            }
            case UNKNOWN: {
                ++this.mUnknown;
                break;
            }
            case NOT_CHECKED: {
                throw new IllegalArgumentException("unexpected validity: " + String.valueOf(validity));
            }
        }
    }

    private void checkSafe(S s, IPredicate iPredicate) {
        if (!this.mCheckSafety) {
            return;
        }
        if (iPredicate == null && this.mMissingAnnotations == MissingAnnotationBehaviour.UNKNOWN) {
            this.mIsSafe = this.mIsSafe.and(IncrementalPlicationChecker.Validity.UNKNOWN);
            return;
        }
        if (iPredicate == null || !this.mSpec.isFinalState(s)) {
            return;
        }
        IncrementalPlicationChecker.Validity validity = this.mImplChecker.checkImplication(iPredicate, false, this.mSpec.getPostcondition(), false);
        assert (!this.mAssertValidity || validity != IncrementalPlicationChecker.Validity.INVALID) : "post condition " + String.valueOf(this.mSpec.getPostcondition()) + "not entailed by condition " + String.valueOf(iPredicate) + " at state " + String.valueOf(s);
        this.mIsSafe = this.mIsSafe.and(validity);
    }

    private IPredicate getAnnotation(S s) {
        IPredicate iPredicate = this.mAnnotation.getAnnotation(s);
        if (iPredicate == null) {
            this.mLogger.warn("%s has no Hoare annotation", new Object[]{s});
            if (this.mMissingAnnotations == MissingAnnotationBehaviour.THROW) {
                throw new IllegalArgumentException(String.valueOf(s) + " has no Hoare annotation");
            }
        }
        return iPredicate;
    }

    private static interface ISimpleHoareCheck<A extends IAction> {
        public IncrementalPlicationChecker.Validity check(IPredicate var1, A var2, IPredicate var3);
    }

    public static enum MissingAnnotationBehaviour {
        IGNORE,
        THROW,
        UNKNOWN;

    }
}

