/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ThreeValuedEquivalenceRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CCLiteralSetConstraints;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IEqualityReportingTarget;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IRemovalInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.RemoveCcElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraint;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintConjunction;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintManager;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.PartialOrderCache;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.AbstractRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.statistics.BenchmarkWithCounters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BinaryOperator;
import java.util.function.Function;

public class CcManager<ELEM extends ICongruenceClosureElement<ELEM>> {
    private final IPartialComparator<CongruenceClosure<ELEM>> mCcComparator;
    private final ILogger mLogger;
    private final CongruenceClosure<ELEM> mInconsistentCc;
    private final CongruenceClosure<ELEM> mEmptyFrozenCc;
    private final PartialOrderCache<CongruenceClosure<ELEM>> mPartialOrderCache;
    private final boolean mBenchmarkMode;
    private BenchmarkWithCounters mBenchmark;
    private final SetConstraintManager<ELEM> mSetConstraintManager;

    public CcManager(ILogger iLogger, IPartialComparator<CongruenceClosure<ELEM>> iPartialComparator) {
        this.mLogger = iLogger;
        this.mCcComparator = iPartialComparator;
        this.mSetConstraintManager = new SetConstraintManager(this);
        this.mInconsistentCc = new CongruenceClosure(true);
        this.mInconsistentCc.freezeAndClose();
        this.mEmptyFrozenCc = new CongruenceClosure(this);
        this.mEmptyFrozenCc.freezeAndClose();
        this.mPartialOrderCache = null;
        this.mBenchmarkMode = false;
        if (this.mBenchmarkMode) {
            this.mBenchmark = new BenchmarkWithCounters();
            this.mBenchmark.registerCountersAndWatches(CcBmNames.getNames());
        } else {
            this.mBenchmark = null;
        }
    }

    private CongruenceClosure<ELEM> addToPartialOrderCache(CongruenceClosure<ELEM> congruenceClosure) {
        assert (this.mPartialOrderCache != null);
        this.freezeIfNecessary(congruenceClosure);
        CongruenceClosure<ELEM> congruenceClosure2 = this.mPartialOrderCache.addElement(congruenceClosure);
        return congruenceClosure;
    }

    public CongruenceClosure<ELEM> meet(CongruenceClosure<ELEM> congruenceClosure, CongruenceClosure<ELEM> congruenceClosure2, boolean bl) {
        CongruenceClosure<ELEM> congruenceClosure3 = this.meet(congruenceClosure, congruenceClosure2, null, bl);
        congruenceClosure3 = this.postProcessCcResult(congruenceClosure3);
        return congruenceClosure3;
    }

    private CongruenceClosure<ELEM> postProcessCcResult(CongruenceClosure<ELEM> congruenceClosure) {
        CongruenceClosure<ELEM> congruenceClosure2 = congruenceClosure;
        return congruenceClosure2;
    }

    public CongruenceClosure<ELEM> meet(CongruenceClosure<ELEM> congruenceClosure, CongruenceClosure<ELEM> congruenceClosure2, IRemovalInfo<ELEM> iRemovalInfo, boolean bl) {
        this.bmStart(CcBmNames.MEET);
        if (!bl) {
            this.freezeIfNecessary(congruenceClosure);
            this.freezeIfNecessary(congruenceClosure2);
        }
        assert (bl != congruenceClosure.isFrozen());
        if (congruenceClosure.isTautological() && !bl) {
            this.freezeIfNecessary(congruenceClosure2);
            this.bmEnd(CcBmNames.MEET);
            return congruenceClosure2;
        }
        if (congruenceClosure2.isTautological()) {
            this.bmEnd(CcBmNames.MEET);
            return congruenceClosure;
        }
        if (congruenceClosure.isInconsistent()) {
            this.bmEnd(CcBmNames.MEET);
            return congruenceClosure;
        }
        if (congruenceClosure2.isInconsistent() && !bl) {
            this.bmEnd(CcBmNames.MEET);
            return this.getInconsistentCc();
        }
        CongruenceClosure<ELEM> congruenceClosure3 = iRemovalInfo == null ? congruenceClosure.meetRec(congruenceClosure2, bl) : congruenceClosure.meetRec(congruenceClosure2, iRemovalInfo, bl);
        CongruenceClosure<ELEM> congruenceClosure4 = this.postProcessCcResult(congruenceClosure3);
        this.bmEnd(CcBmNames.MEET);
        return congruenceClosure4;
    }

    private CongruenceClosure<ELEM> merge(CongruenceClosure<ELEM> congruenceClosure, CongruenceClosure<ELEM> congruenceClosure2, boolean bl, BinaryOperator<Set<SetConstraint<ELEM>>> binaryOperator) {
        this.bmStart(CcBmNames.JOIN);
        this.freezeIfNecessary(congruenceClosure);
        this.freezeIfNecessary(congruenceClosure2);
        if (congruenceClosure.isInconsistent()) {
            this.bmEnd(CcBmNames.JOIN);
            return congruenceClosure2;
        }
        if (congruenceClosure2.isInconsistent()) {
            this.bmEnd(CcBmNames.JOIN);
            return congruenceClosure;
        }
        if (congruenceClosure.isTautological() || congruenceClosure2.isTautological()) {
            this.bmEnd(CcBmNames.JOIN);
            return this.getEmptyCc(bl);
        }
        CongruenceClosure<ELEM> congruenceClosure3 = congruenceClosure.merge(congruenceClosure2, binaryOperator);
        if (!bl) {
            congruenceClosure3.freezeAndClose();
        }
        assert (bl != congruenceClosure3.isFrozen());
        CongruenceClosure<ELEM> congruenceClosure4 = this.postProcessCcResult(congruenceClosure3);
        this.bmEnd(CcBmNames.JOIN);
        return congruenceClosure4;
    }

    public CongruenceClosure<ELEM> join(CongruenceClosure<ELEM> congruenceClosure, CongruenceClosure<ELEM> congruenceClosure2, boolean bl) {
        return this.merge(congruenceClosure, congruenceClosure2, bl, this.mSetConstraintManager::join);
    }

    public CongruenceClosure<ELEM> widen(CongruenceClosure<ELEM> congruenceClosure, CongruenceClosure<ELEM> congruenceClosure2, boolean bl) {
        return this.merge(congruenceClosure, congruenceClosure2, bl, this.mSetConstraintManager::widen);
    }

    public Set<CongruenceClosure<ELEM>> filterRedundantCcs(Set<CongruenceClosure<ELEM>> set) {
        PartialOrderCache<CongruenceClosure<ELEM>> partialOrderCache = new PartialOrderCache<CongruenceClosure<ELEM>>(this.mCcComparator);
        Set<CongruenceClosure<ELEM>> set2 = this.filterRedundantCcs(set, partialOrderCache);
        return set2;
    }

    public IPartialComparator<CongruenceClosure<ELEM>> getCcComparator() {
        return this.mCcComparator;
    }

    public Set<CongruenceClosure<ELEM>> filterRedundantCcs(Set<CongruenceClosure<ELEM>> set, PartialOrderCache<CongruenceClosure<ELEM>> partialOrderCache) {
        this.bmStart(CcBmNames.FILTERREDUNDANT);
        if (set.isEmpty()) {
            this.bmEnd(CcBmNames.FILTERREDUNDANT);
            return set;
        }
        Set<CongruenceClosure<ELEM>> set2 = partialOrderCache.getMaximalRepresentatives(set);
        assert (!set2.stream().anyMatch(congruenceClosure -> congruenceClosure.isInconsistent()) || set2.size() == 1);
        if (set2.iterator().next().isInconsistent()) {
            this.bmEnd(CcBmNames.FILTERREDUNDANT);
            return Collections.emptySet();
        }
        this.bmEnd(CcBmNames.FILTERREDUNDANT);
        return set2;
    }

    public CongruenceClosure<ELEM> reportEquality(ELEM ELEM, ELEM ELEM2, CongruenceClosure<ELEM> congruenceClosure, boolean bl) {
        this.bmStart(CcBmNames.REPORT_EQUALITY);
        if (bl) {
            congruenceClosure.reportEquality(ELEM, ELEM2);
            this.bmEnd(CcBmNames.REPORT_EQUALITY);
            return congruenceClosure;
        }
        CongruenceClosure<ELEM> congruenceClosure2 = this.unfreeze(congruenceClosure);
        congruenceClosure2.reportEquality(ELEM, ELEM2);
        congruenceClosure2.freezeAndClose();
        CongruenceClosure<ELEM> congruenceClosure3 = this.postProcessCcResult(congruenceClosure2);
        this.bmEnd(CcBmNames.REPORT_EQUALITY);
        return congruenceClosure3;
    }

    public CongruenceClosure<ELEM> reportDisequality(ELEM ELEM, ELEM ELEM2, CongruenceClosure<ELEM> congruenceClosure, boolean bl) {
        this.bmStart(CcBmNames.REPORT_DISEQUALITY);
        if (bl) {
            congruenceClosure.reportDisequality(ELEM, ELEM2);
            this.bmEnd(CcBmNames.REPORT_DISEQUALITY);
            return congruenceClosure;
        }
        CongruenceClosure<ELEM> congruenceClosure2 = this.unfreeze(congruenceClosure);
        congruenceClosure2.reportDisequality(ELEM, ELEM2);
        congruenceClosure2.freezeAndClose();
        assert (congruenceClosure2.isInconsistent() || congruenceClosure2.getEqualityStatus(ELEM, ELEM2) == EqualityStatus.NOT_EQUAL);
        CongruenceClosure<ELEM> congruenceClosure3 = this.postProcessCcResult(congruenceClosure2);
        this.bmEnd(CcBmNames.REPORT_DISEQUALITY);
        return congruenceClosure3;
    }

    public CongruenceClosure<ELEM> reportContainsConstraint(ELEM ELEM, Collection<ELEM> collection, CongruenceClosure<ELEM> congruenceClosure, boolean bl) {
        return this.reportContainsConstraint(ELEM, Collections.singleton(this.mSetConstraintManager.buildSetConstraint(collection)), congruenceClosure, bl);
    }

    public CongruenceClosure<ELEM> reportContainsConstraint(ELEM ELEM, Set<SetConstraint<ELEM>> set, CongruenceClosure<ELEM> congruenceClosure, boolean bl) {
        this.bmStart(CcBmNames.REPORTCONTAINS);
        if (bl) {
            congruenceClosure.reportContainsConstraint(ELEM, (Collection<SetConstraint<ELEM>>)set);
            this.bmEnd(CcBmNames.REPORTCONTAINS);
            return congruenceClosure;
        }
        CongruenceClosure<ELEM> congruenceClosure2 = this.unfreeze(congruenceClosure);
        congruenceClosure2.reportContainsConstraint(ELEM, (Collection<SetConstraint<ELEM>>)set);
        congruenceClosure2.freezeAndClose();
        CongruenceClosure<ELEM> congruenceClosure3 = this.postProcessCcResult(congruenceClosure2);
        this.bmEnd(CcBmNames.REPORTCONTAINS);
        return congruenceClosure3;
    }

    public CongruenceClosure<ELEM> removeSimpleElement(ELEM ELEM, CongruenceClosure<ELEM> congruenceClosure, boolean bl) {
        this.freezeIfNecessary(congruenceClosure);
        CongruenceClosure<ELEM> congruenceClosure2 = this.unfreeze(congruenceClosure);
        RemoveCcElement.removeSimpleElement(congruenceClosure2, ELEM);
        if (!bl) {
            congruenceClosure2.freezeAndClose();
        }
        assert (bl != congruenceClosure2.isFrozen());
        CongruenceClosure<ELEM> congruenceClosure3 = this.postProcessCcResult(congruenceClosure2);
        return congruenceClosure3;
    }

    public CongruenceClosure<ELEM> removeSimpleElementDontIntroduceNewNodes(ELEM ELEM, CongruenceClosure<ELEM> congruenceClosure, boolean bl) {
        this.freezeIfNecessary(congruenceClosure);
        CongruenceClosure<ELEM> congruenceClosure2 = this.unfreeze(congruenceClosure);
        RemoveCcElement.removeSimpleElementDontIntroduceNewNodes(congruenceClosure2, ELEM);
        if (!bl) {
            congruenceClosure2.freezeAndClose();
        }
        assert (bl != congruenceClosure2.isFrozen());
        CongruenceClosure<ELEM> congruenceClosure3 = this.postProcessCcResult(congruenceClosure2);
        return congruenceClosure3;
    }

    public CongruenceClosure<ELEM> unfreeze(CongruenceClosure<ELEM> congruenceClosure) {
        assert (congruenceClosure.isFrozen());
        return new CongruenceClosure<ELEM>(congruenceClosure);
    }

    private CongruenceClosure<ELEM> unfreeze(CongruenceClosure<ELEM> congruenceClosure, IRemovalInfo<ELEM> iRemovalInfo) {
        assert (congruenceClosure.isFrozen());
        return new CongruenceClosure<ELEM>(congruenceClosure, iRemovalInfo);
    }

    public CongruenceClosure<ELEM> addElement(CongruenceClosure<ELEM> congruenceClosure, ELEM ELEM, boolean bl, boolean bl2) {
        return this.addElement(congruenceClosure, ELEM, congruenceClosure, bl, bl2);
    }

    public CongruenceClosure<ELEM> addElement(CongruenceClosure<ELEM> congruenceClosure, ELEM ELEM, IEqualityReportingTarget<ELEM> iEqualityReportingTarget, boolean bl, boolean bl2) {
        assert (bl != congruenceClosure.isFrozen());
        if (bl) {
            congruenceClosure.addElement(ELEM, iEqualityReportingTarget, bl2);
            return congruenceClosure;
        }
        CongruenceClosure<ELEM> congruenceClosure2 = this.unfreeze(congruenceClosure);
        congruenceClosure2.addElement(ELEM, iEqualityReportingTarget, bl2);
        congruenceClosure2.freezeAndClose();
        CongruenceClosure<ELEM> congruenceClosure3 = this.postProcessCcResult(congruenceClosure2);
        return congruenceClosure3;
    }

    public boolean addElementReportChange(CongruenceClosure<ELEM> congruenceClosure, ELEM ELEM, boolean bl) {
        return congruenceClosure.addElement(ELEM, congruenceClosure, bl);
    }

    public boolean isDebugMode() {
        return true;
    }

    public ILogger getLogger() {
        return this.mLogger;
    }

    public CongruenceClosure<ELEM> getSingleEqualityCc(ELEM ELEM, ELEM ELEM2, boolean bl) {
        CongruenceClosure<ELEM> congruenceClosure = this.getEmptyCc(bl);
        CongruenceClosure<ELEM> congruenceClosure2 = this.reportEquality(ELEM, ELEM2, congruenceClosure, bl);
        CongruenceClosure<ELEM> congruenceClosure3 = this.postProcessCcResult(congruenceClosure2);
        return congruenceClosure3;
    }

    public CongruenceClosure<ELEM> getSingleDisequalityCc(ELEM ELEM, ELEM ELEM2, boolean bl) {
        CongruenceClosure<ELEM> congruenceClosure = this.getEmptyCc(bl);
        CongruenceClosure<ELEM> congruenceClosure2 = this.reportDisequality(ELEM, ELEM2, congruenceClosure, bl);
        CongruenceClosure<ELEM> congruenceClosure3 = this.postProcessCcResult(congruenceClosure2);
        return congruenceClosure3;
    }

    public CongruenceClosure<ELEM> getEmptyCc(boolean bl) {
        if (bl) {
            return new CongruenceClosure(this);
        }
        return this.mEmptyFrozenCc;
    }

    public CongruenceClosure<ELEM> getInconsistentCc() {
        return this.mInconsistentCc;
    }

    public CongruenceClosure<ELEM> getCongruenceClosureFromTver(ThreeValuedEquivalenceRelation<ELEM> threeValuedEquivalenceRelation, boolean bl) {
        CongruenceClosure<ELEM> congruenceClosure = new CongruenceClosure<ELEM>(this, threeValuedEquivalenceRelation);
        if (!bl) {
            congruenceClosure.freezeAndClose();
        }
        return congruenceClosure;
    }

    public CongruenceClosure<ELEM> getCongruenceClosureFromTver(ThreeValuedEquivalenceRelation<ELEM> threeValuedEquivalenceRelation, IRemovalInfo<ELEM> iRemovalInfo, CCLiteralSetConstraints<ELEM> cCLiteralSetConstraints, boolean bl) {
        CongruenceClosure<ELEM> congruenceClosure = new CongruenceClosure<ELEM>(this, threeValuedEquivalenceRelation, cCLiteralSetConstraints, iRemovalInfo);
        if (!bl) {
            congruenceClosure.freezeAndClose();
        }
        return congruenceClosure;
    }

    public CongruenceClosure<ELEM> getCopyWithRemovalInfo(CongruenceClosure<ELEM> congruenceClosure, IRemovalInfo<ELEM> iRemovalInfo) {
        return new CongruenceClosure<ELEM>(congruenceClosure, iRemovalInfo);
    }

    public CongruenceClosure<ELEM> copyNoRemInfo(CongruenceClosure<ELEM> congruenceClosure) {
        if (congruenceClosure.isInconsistent()) {
            return congruenceClosure;
        }
        CongruenceClosure<ELEM> congruenceClosure2 = new CongruenceClosure<ELEM>(congruenceClosure);
        if (congruenceClosure.isFrozen()) {
            congruenceClosure2.freezeAndClose();
        }
        return congruenceClosure2;
    }

    public CongruenceClosure<ELEM> copyNoRemInfoUnfrozen(CongruenceClosure<ELEM> congruenceClosure) {
        return new CongruenceClosure<ELEM>(congruenceClosure);
    }

    public CongruenceClosure<ELEM> transformElements(CongruenceClosure<ELEM> congruenceClosure, Function<ELEM, ELEM> function, boolean bl) {
        CongruenceClosure<ELEM> congruenceClosure2;
        CongruenceClosure<ELEM> congruenceClosure3;
        if (bl) {
            congruenceClosure.transformElementsAndFunctions(function);
            congruenceClosure3 = congruenceClosure;
        } else {
            congruenceClosure2 = this.unfreezeIfNecessary(congruenceClosure);
            congruenceClosure2.transformElementsAndFunctions(function);
            congruenceClosure2.freezeAndClose();
            congruenceClosure3 = congruenceClosure2;
        }
        assert (congruenceClosure3.sanityCheck());
        congruenceClosure2 = this.postProcessCcResult(congruenceClosure3);
        return congruenceClosure2;
    }

    public CongruenceClosure<ELEM> projectToElements(CongruenceClosure<ELEM> congruenceClosure, Set<ELEM> set, IRemovalInfo<ELEM> iRemovalInfo) {
        this.bmStart(CcBmNames.PROJECT_TO_ELEMENTS);
        CongruenceClosure<ELEM> congruenceClosure2 = this.unfreezeIfNecessary(congruenceClosure);
        CongruenceClosure<ELEM> congruenceClosure3 = congruenceClosure2.projectToElements(set, iRemovalInfo);
        congruenceClosure3.freezeAndClose();
        CongruenceClosure<ELEM> congruenceClosure4 = this.postProcessCcResult(congruenceClosure3);
        this.bmEnd(CcBmNames.PROJECT_TO_ELEMENTS);
        return congruenceClosure4;
    }

    public CongruenceClosure<ELEM> addAllElements(CongruenceClosure<ELEM> congruenceClosure, Collection<ELEM> collection, IRemovalInfo<ELEM> iRemovalInfo, boolean bl) {
        Object object2;
        CongruenceClosure<ELEM> congruenceClosure2;
        this.bmStart(CcBmNames.ADD_ALL_ELEMENTS);
        assert (!congruenceClosure.isInconsistent());
        if (bl) {
            congruenceClosure2 = congruenceClosure;
        } else {
            this.freezeIfNecessary(congruenceClosure);
            congruenceClosure2 = this.unfreeze(congruenceClosure, iRemovalInfo);
        }
        for (Object object2 : collection) {
            this.addElement(congruenceClosure2, object2, true, true);
        }
        if (!bl) {
            congruenceClosure2.freezeAndClose();
        }
        object2 = this.postProcessCcResult(congruenceClosure2);
        this.bmEnd(CcBmNames.ADD_ALL_ELEMENTS);
        return object2;
    }

    public CongruenceClosure<ELEM> unfreezeIfNecessary(CongruenceClosure<ELEM> congruenceClosure) {
        if (congruenceClosure.isFrozen()) {
            return this.unfreeze(congruenceClosure);
        }
        return congruenceClosure;
    }

    public void freezeIfNecessary(CongruenceClosure<ELEM> congruenceClosure) {
        if (!congruenceClosure.isFrozen()) {
            congruenceClosure.freezeAndClose();
        }
    }

    public CongruenceClosure<ELEM> getCopy(CongruenceClosure<ELEM> congruenceClosure, boolean bl) {
        CongruenceClosure<ELEM> congruenceClosure2 = new CongruenceClosure<ELEM>(congruenceClosure);
        if (!bl) {
            congruenceClosure2.freezeAndClose();
        }
        return congruenceClosure2;
    }

    public boolean isStrongerThan(CongruenceClosure<ELEM> congruenceClosure, CongruenceClosure<ELEM> congruenceClosure2) {
        return this.isStrongerThanNoCaching(congruenceClosure, congruenceClosure2);
    }

    public boolean isStrongerThanNoCaching(CongruenceClosure<ELEM> congruenceClosure, CongruenceClosure<ELEM> congruenceClosure2) {
        this.bmStart(CcBmNames.IS_STRONGER_THAN_NO_CACHING);
        if (congruenceClosure.isInconsistent()) {
            this.bmEnd(CcBmNames.IS_STRONGER_THAN_NO_CACHING);
            return true;
        }
        if (congruenceClosure2.isInconsistent()) {
            this.bmEnd(CcBmNames.IS_STRONGER_THAN_NO_CACHING);
            return false;
        }
        if (congruenceClosure2.isTautological()) {
            this.bmEnd(CcBmNames.IS_STRONGER_THAN_NO_CACHING);
            return true;
        }
        if (congruenceClosure.isTautological()) {
            this.bmEnd(CcBmNames.IS_STRONGER_THAN_NO_CACHING);
            return false;
        }
        Pair<CongruenceClosure<ELEM>, CongruenceClosure<ELEM>> pair = this.alignElements(congruenceClosure, congruenceClosure2, !congruenceClosure.isFrozen() && !congruenceClosure2.isFrozen());
        CongruenceClosure<ELEM> congruenceClosure3 = pair.getFirst();
        CongruenceClosure<ELEM> congruenceClosure4 = pair.getSecond();
        assert (this.assertElementsAreSuperset(congruenceClosure3, congruenceClosure4));
        assert (this.assertElementsAreSuperset(congruenceClosure4, congruenceClosure3));
        boolean bl = this.checkIsStrongerThan(congruenceClosure3, congruenceClosure4);
        this.bmEnd(CcBmNames.IS_STRONGER_THAN_NO_CACHING);
        return bl;
    }

    private boolean checkIsStrongerThan(CongruenceClosure<ELEM> congruenceClosure, CongruenceClosure<ELEM> congruenceClosure2) {
        assert (!congruenceClosure.isInconsistent() && !congruenceClosure2.isInconsistent());
        assert (this.assertElementsAreSuperset(congruenceClosure, congruenceClosure2));
        assert (this.assertElementsAreSuperset(congruenceClosure2, congruenceClosure));
        if (!CcManager.isPartitionStronger(congruenceClosure.mElementTVER, congruenceClosure2.mElementTVER)) {
            return false;
        }
        if (!CcManager.areDisequalitiesStrongerThan(congruenceClosure, congruenceClosure2)) {
            return false;
        }
        return congruenceClosure.getLiteralSetConstraints().isStrongerThan(congruenceClosure2.getLiteralSetConstraints());
    }

    public boolean isEquivalent(CongruenceClosure<ELEM> congruenceClosure, CongruenceClosure<ELEM> congruenceClosure2) {
        CongruenceClosure<ELEM> congruenceClosure3;
        if (congruenceClosure.isInconsistent() && congruenceClosure2.isInconsistent()) {
            return true;
        }
        if (congruenceClosure.isTautological() && congruenceClosure2.isTautological()) {
            return true;
        }
        if (congruenceClosure2.isInconsistent() || congruenceClosure.isInconsistent()) {
            return false;
        }
        if (congruenceClosure2.isTautological() || congruenceClosure.isTautological()) {
            return false;
        }
        Pair<CongruenceClosure<ELEM>, CongruenceClosure<ELEM>> pair = this.alignElements(congruenceClosure, congruenceClosure2, !congruenceClosure.isFrozen() && !congruenceClosure2.isFrozen());
        CongruenceClosure<ELEM> congruenceClosure4 = pair.getFirst();
        return this.checkIsStrongerThan(congruenceClosure4, congruenceClosure3 = pair.getSecond()) && this.checkIsStrongerThan(congruenceClosure3, congruenceClosure4);
    }

    public Pair<CongruenceClosure<ELEM>, CongruenceClosure<ELEM>> alignElements(CongruenceClosure<ELEM> congruenceClosure, CongruenceClosure<ELEM> congruenceClosure2, boolean bl) {
        assert (!bl || !congruenceClosure.isFrozen());
        assert (!bl || !congruenceClosure2.isFrozen());
        if (bl) {
            this.bmStart(CcBmNames.ALIGN_ELEMENTS);
            while (!congruenceClosure.getAllElements().containsAll(congruenceClosure2.getAllElements()) || !congruenceClosure2.getAllElements().containsAll(congruenceClosure.getAllElements())) {
                this.addAllElements(congruenceClosure, congruenceClosure2.getAllElements(), null, true);
                this.addAllElements(congruenceClosure2, congruenceClosure.getAllElements(), null, true);
            }
            this.bmEnd(CcBmNames.ALIGN_ELEMENTS);
            return new Pair<CongruenceClosure<ELEM>, CongruenceClosure<ELEM>>(congruenceClosure, congruenceClosure2);
        }
        this.bmStart(CcBmNames.ALIGN_ELEMENTS);
        CongruenceClosure<ELEM> congruenceClosure3 = this.copyNoRemInfoUnfrozen(congruenceClosure);
        CongruenceClosure<ELEM> congruenceClosure4 = this.copyNoRemInfoUnfrozen(congruenceClosure2);
        while (!congruenceClosure3.getAllElements().containsAll(congruenceClosure4.getAllElements()) || !congruenceClosure4.getAllElements().containsAll(congruenceClosure3.getAllElements())) {
            this.addAllElements(congruenceClosure3, congruenceClosure4.getAllElements(), null, true);
            this.addAllElements(congruenceClosure4, congruenceClosure3.getAllElements(), null, true);
        }
        congruenceClosure3.freezeAndClose();
        congruenceClosure4.freezeAndClose();
        this.bmEnd(CcBmNames.ALIGN_ELEMENTS);
        return new Pair<CongruenceClosure<ELEM>, CongruenceClosure<ELEM>>(congruenceClosure3, congruenceClosure4);
    }

    private static <E extends ICongruenceClosureElement<E>> boolean areDisequalitiesStrongerThan(CongruenceClosure<E> congruenceClosure, CongruenceClosure<E> congruenceClosure2) {
        for (ICongruenceClosureElement iCongruenceClosureElement : congruenceClosure2.getAllRepresentatives()) {
            for (ICongruenceClosureElement iCongruenceClosureElement2 : congruenceClosure2.getRepresentativesUnequalTo(iCongruenceClosureElement)) {
                if (congruenceClosure.getEqualityStatus(iCongruenceClosureElement, iCongruenceClosureElement2) == EqualityStatus.NOT_EQUAL) continue;
                return false;
            }
        }
        return true;
    }

    private boolean assertElementsAreSuperset(Set<ELEM> set, Set<ELEM> set2) {
        Set<ELEM> set3 = DataStructureUtils.difference(set2, set);
        if (!set3.isEmpty()) {
            assert (false);
            return false;
        }
        return true;
    }

    private boolean assertElementsAreSuperset(CongruenceClosure<ELEM> congruenceClosure, CongruenceClosure<ELEM> congruenceClosure2) {
        Set<ELEM> set = DataStructureUtils.difference(congruenceClosure2.getAllElements(), congruenceClosure.getAllElements());
        if (!set.isEmpty()) {
            assert (false);
            return false;
        }
        return true;
    }

    static <E> boolean isPartitionStronger(ThreeValuedEquivalenceRelation<E> threeValuedEquivalenceRelation, ThreeValuedEquivalenceRelation<E> threeValuedEquivalenceRelation2) {
        ArrayList<E> arrayList = new ArrayList<E>(threeValuedEquivalenceRelation.getAllRepresentatives().size() + threeValuedEquivalenceRelation2.getAllRepresentatives().size());
        arrayList.addAll(threeValuedEquivalenceRelation.getAllRepresentatives());
        arrayList.addAll(threeValuedEquivalenceRelation2.getAllRepresentatives());
        for (Object e : arrayList) {
            Set<E> set = threeValuedEquivalenceRelation2.getEquivalenceClass(e);
            Set<E> set2 = threeValuedEquivalenceRelation.getEquivalenceClass(e);
            if (set2.containsAll(set)) continue;
            return false;
        }
        return true;
    }

    public SetConstraintConjunction<ELEM> buildSetConstraintConjunction(CCLiteralSetConstraints<ELEM> cCLiteralSetConstraints, ELEM ELEM, Set<SetConstraint<ELEM>> set) {
        SetConstraint<ELEM> setConstraint22;
        this.bmStart(CcBmNames.BUILD_SET_CONSTRAINT_CONJUNCTION);
        Set<SetConstraint<ELEM>> set2 = this.mSetConstraintManager.updateOnChangedRepresentative(set, cCLiteralSetConstraints.getCongruenceClosure());
        Set<SetConstraint<ELEM>> set3 = this.normalizeSetConstraintConjunction(cCLiteralSetConstraints, set2);
        HashSet hashSet = new HashSet();
        for (SetConstraint<ELEM> setConstraint22 : set3) {
            if (setConstraint22.isSingleton() || SetConstraint.isTautological(ELEM, setConstraint22)) continue;
            hashSet.add(setConstraint22);
        }
        assert (!hashSet.stream().anyMatch(setConstraint -> setConstraint.isInconsistent()) || hashSet.size() == 1) : "not correctly normalized: there is a 'false' conjunct, but it is not the only conjunct";
        if (hashSet.size() == 1 && ((SetConstraint)hashSet.iterator().next()).isInconsistent()) {
            this.bmEnd(CcBmNames.BUILD_SET_CONSTRAINT_CONJUNCTION);
            return new SetConstraintConjunction(true);
        }
        setConstraint22 = new SetConstraintConjunction<ELEM>(cCLiteralSetConstraints, ELEM, hashSet);
        this.bmEnd(CcBmNames.BUILD_SET_CONSTRAINT_CONJUNCTION);
        return setConstraint22;
    }

    /*
     * WARNING - void declaration
     */
    public Set<SetConstraint<ELEM>> normalizeSetConstraintConjunction(CCLiteralSetConstraints<ELEM> cCLiteralSetConstraints, Collection<SetConstraint<ELEM>> collection) {
        void var5_15;
        Object object2;
        this.bmStart(CcBmNames.NORMALIZE_SET_CONSTRAINT_CONJUNCTION);
        if (collection.isEmpty()) {
            this.bmEnd(CcBmNames.NORMALIZE_SET_CONSTRAINT_CONJUNCTION);
            return Collections.emptySet();
        }
        HashSet<SetConstraint<ELEM>> hashSet = new HashSet<SetConstraint<ELEM>>(collection);
        Iterable iterable = cCLiteralSetConstraints.getElemToExpansion();
        for (SetConstraint<ELEM> setConstraint : collection) {
            for (Object object2 : setConstraint.getNonLiterals()) {
                Set set = ((AbstractRelation)iterable).getImage(object2);
                if (set.isEmpty()) continue;
                hashSet.add(this.mSetConstraintManager.expandNonLiteral(setConstraint, object2, set));
            }
        }
        iterable = null;
        for (SetConstraint setConstraint : hashSet) {
            if (setConstraint.isInconsistent()) {
                this.bmEnd(CcBmNames.NORMALIZE_SET_CONSTRAINT_CONJUNCTION);
                return Collections.singleton(setConstraint);
            }
            if (!setConstraint.hasOnlyLiterals()) continue;
            if (iterable == null) {
                iterable = new HashSet(setConstraint.getLiterals());
                continue;
            }
            iterable.retainAll(setConstraint.getLiterals());
            if (!iterable.isEmpty()) continue;
            this.bmEnd(CcBmNames.NORMALIZE_SET_CONSTRAINT_CONJUNCTION);
            return Collections.singleton(setConstraint);
        }
        if (iterable != null) {
            HashSet<SetConstraint<ELEM>> hashSet2 = new HashSet<SetConstraint<ELEM>>();
            hashSet2.add(this.mSetConstraintManager.buildSetConstraint(iterable, Collections.emptySet()));
            for (SetConstraint setConstraint : hashSet) {
                if (setConstraint.hasOnlyLiterals()) continue;
                Set set = DataStructureUtils.intersection(iterable, setConstraint.getLiterals());
                hashSet2.add(this.mSetConstraintManager.buildSetConstraint(set, setConstraint.getNonLiterals()));
            }
        } else {
            HashSet<SetConstraint<ELEM>> hashSet3 = hashSet;
        }
        PartialOrderCache<SetConstraint<ELEM>> partialOrderCache = new PartialOrderCache<SetConstraint<ELEM>>(this.mSetConstraintManager.getSetConstraintComparator());
        object2 = partialOrderCache.getMaximalRepresentatives((Collection<SetConstraint<ELEM>>)var5_15);
        assert (SetConstraintConjunction.sanityCheck(object2));
        this.bmEnd(CcBmNames.NORMALIZE_SET_CONSTRAINT_CONJUNCTION);
        return object2;
    }

    public BenchmarkWithCounters getBenchmark() {
        return this.mBenchmark;
    }

    private void bmStartOverall() {
        if (!this.mBenchmarkMode) {
            return;
        }
        this.mBenchmark.incrementCounter(CcBmNames.OVERALL.name());
        this.mBenchmark.unpauseWatch(CcBmNames.OVERALL.name());
    }

    private void bmEndOverall() {
        if (!this.mBenchmarkMode) {
            return;
        }
        this.mBenchmark.pauseWatch(CcBmNames.OVERALL.name());
    }

    void bmStart(CcBmNames ccBmNames) {
        if (!this.mBenchmarkMode) {
            return;
        }
        this.bmStartOverall();
        this.mBenchmark.incrementCounter(ccBmNames.name());
        this.mBenchmark.unpauseWatch(ccBmNames.name());
    }

    void bmEnd(CcBmNames ccBmNames) {
        if (!this.mBenchmarkMode) {
            return;
        }
        this.bmEndOverall();
        this.mBenchmark.pauseWatch(ccBmNames.name());
    }

    public boolean hasPartialOrderCacheBenchmark() {
        if (this.mPartialOrderCache == null) {
            return false;
        }
        return this.mPartialOrderCache.hasBenchmark();
    }

    public BenchmarkWithCounters getPartialOrderCacheBenchmark() {
        return this.mPartialOrderCache.getBenchmark();
    }

    public SetConstraintManager<ELEM> getSetConstraintManager() {
        return this.mSetConstraintManager;
    }

    public static <ELEM extends ICongruenceClosureElement<ELEM>> HashRelation<ELEM, ELEM> computeSplitInfo(CongruenceClosure<ELEM> congruenceClosure, CongruenceClosure<ELEM> congruenceClosure2) {
        assert (CcManager.isPartitionStronger(congruenceClosure.mElementTVER, congruenceClosure2.mElementTVER)) : "assuming this has been checked already";
        HashRelation<ICongruenceClosureElement, ICongruenceClosureElement> hashRelation = new HashRelation<ICongruenceClosureElement, ICongruenceClosureElement>();
        for (ICongruenceClosureElement iCongruenceClosureElement : congruenceClosure2.getAllRepresentatives()) {
            ICongruenceClosureElement iCongruenceClosureElement2 = congruenceClosure.getRepresentativeElement(iCongruenceClosureElement);
            hashRelation.addPair(iCongruenceClosureElement2, iCongruenceClosureElement);
        }
        return hashRelation;
    }

    static enum CcBmNames {
        FILTERREDUNDANT,
        UNFREEZE,
        COPY,
        MEET,
        JOIN,
        REMOVE,
        IS_STRONGER_THAN_NO_CACHING,
        ADDNODE,
        REPORTCONTAINS,
        REPORT_EQUALITY,
        REPORT_DISEQUALITY,
        PROJECT_TO_ELEMENTS,
        ADD_ALL_ELEMENTS,
        ALIGN_ELEMENTS,
        OVERALL,
        IS_STRONGER_THAN_W_CACHING,
        BUILD_SET_CONSTRAINT_CONJUNCTION,
        NORMALIZE_SET_CONSTRAINT_CONJUNCTION,
        GET_EQUALITY_STATUS,
        MEET_IS_INCONSISTENT;


        static String[] getNames() {
            String[] stringArray = new String[CcBmNames.values().length];
            int n = 0;
            while (n < CcBmNames.values().length) {
                stringArray[n] = CcBmNames.values()[n].name();
                ++n;
            }
            return stringArray;
        }
    }
}

