/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FunctionalMap<K, V>
extends AbstractMap<K, V>
implements Map.Entry<K, V> {
    private static FunctionalMap<?, ?> EMPTY = new FunctionalMap();
    FunctionalMap<K, V> mLeft;
    FunctionalMap<K, V> mRight;
    K mKey;
    V mValue;
    int mSizeColor;

    public static <K, V> FunctionalMap<K, V> empty() {
        return EMPTY;
    }

    private FunctionalMap() {
        this.mLeft = null;
        this.mRight = null;
        this.mKey = null;
        this.mValue = null;
        this.mSizeColor = 0;
    }

    private FunctionalMap(FunctionalMap<K, V> functionalMap, FunctionalMap<K, V> functionalMap2, K k, V v, int n) {
        this.mLeft = functionalMap;
        this.mRight = functionalMap2;
        this.mKey = k;
        this.mValue = v;
        this.mSizeColor = n;
        assert (functionalMap != null && functionalMap2 != null);
        assert (k != null && v != null);
        assert (this.isTwoNode() || functionalMap2.isTwoNode());
        assert (this.size() == functionalMap.size() + functionalMap2.size() + 1);
        assert (this.mRight.getHeight() == this.getHeight() - (this.isTwoNode() ? 1 : 0));
    }

    private FunctionalMap(FunctionalMap<K, V> functionalMap, FunctionalMap<K, V> functionalMap2, K k, V v, boolean bl) {
        this.mLeft = functionalMap;
        this.mRight = functionalMap2;
        this.mKey = k;
        this.mValue = v;
        int n = functionalMap.size() + functionalMap2.size() + 1;
        int n2 = this.mSizeColor = bl ? n : -n;
        assert (this.isTwoNode() || functionalMap2.isTwoNode());
        assert (functionalMap == null && functionalMap2 == null || k != null && v != null);
        assert (functionalMap == null && functionalMap2 == null || this.mRight.getHeight() == this.getHeight() - (this.isTwoNode() ? 1 : 0));
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public V get(Object object) {
        int n = object.hashCode();
        FunctionalMap<K, V> functionalMap = this;
        while (functionalMap != EMPTY) {
            if (n < functionalMap.mKey.hashCode()) {
                functionalMap = functionalMap.mLeft;
                continue;
            }
            if (n == functionalMap.mKey.hashCode()) {
                if (functionalMap.mKey.equals(object)) {
                    return functionalMap.mValue;
                }
                V v = functionalMap.mLeft.get(object);
                if (v != null) {
                    return v;
                }
            }
            functionalMap = functionalMap.mRight;
        }
        return null;
    }

    public FunctionalMap<K, V> insert(K k, V v) {
        int n = k.hashCode();
        FunctionalMap<K, V> functionalMap = this;
        ArrayDeque<FunctionalMap<K, V>> arrayDeque = new ArrayDeque<FunctionalMap<K, V>>();
        boolean bl = false;
        while (functionalMap != EMPTY) {
            arrayDeque.add(functionalMap);
            if (n < functionalMap.mKey.hashCode()) {
                functionalMap = functionalMap.mLeft;
                bl = true;
                continue;
            }
            functionalMap = functionalMap.mRight;
            bl = false;
        }
        FunctionalMap<K, V> functionalMap2 = new FunctionalMap<K, V>(FunctionalMap.empty(), FunctionalMap.empty(), k, v, 1);
        boolean bl2 = true;
        while (!arrayDeque.isEmpty()) {
            FunctionalMap functionalMap3 = (FunctionalMap)arrayDeque.removeLast();
            if (!bl2) {
                functionalMap2 = new FunctionalMap<K, V>(bl ? functionalMap2 : functionalMap3.mLeft, bl ? functionalMap3.mRight : functionalMap2, functionalMap3.mKey, functionalMap3.mValue, functionalMap3.mSizeColor < 0 ? functionalMap3.mSizeColor - 1 : functionalMap3.mSizeColor + 1);
            } else {
                FunctionalMap<K, V> functionalMap4;
                boolean bl3;
                FunctionalMap functionalMap5 = functionalMap3;
                boolean bl4 = bl3 = !functionalMap3.isTwoNode();
                if (!(bl3 || arrayDeque.isEmpty() || (functionalMap4 = (FunctionalMap<K, V>)arrayDeque.getLast()).isTwoNode() || functionalMap4.mRight != functionalMap3)) {
                    bl3 = true;
                    functionalMap5 = (FunctionalMap)arrayDeque.removeLast();
                }
                if (bl3) {
                    if (functionalMap3 == functionalMap5) {
                        functionalMap2 = new FunctionalMap<K, V>(functionalMap2, functionalMap5.mRight, functionalMap5.mKey, functionalMap5.mValue, true);
                    } else if (bl) {
                        functionalMap4 = new FunctionalMap<K, V>(functionalMap5.mLeft, functionalMap2.mLeft, functionalMap5.mKey, functionalMap5.mValue, true);
                        FunctionalMap<K, V> functionalMap6 = new FunctionalMap<K, V>(functionalMap2.mRight, functionalMap3.mRight, functionalMap3.mKey, functionalMap3.mValue, true);
                        functionalMap2 = new FunctionalMap<K, V>(functionalMap4, functionalMap6, functionalMap2.mKey, functionalMap2.mValue, true);
                    } else {
                        functionalMap4 = new FunctionalMap<K, V>(functionalMap5.mLeft, functionalMap3.mLeft, functionalMap5.mKey, functionalMap5.mValue, true);
                        functionalMap2 = new FunctionalMap<K, V>(functionalMap4, functionalMap2, functionalMap3.mKey, functionalMap3.mValue, true);
                    }
                    functionalMap3 = functionalMap5;
                } else {
                    bl2 = false;
                    if (bl) {
                        functionalMap4 = new FunctionalMap<K, V>(functionalMap2.mRight, functionalMap3.mRight, functionalMap3.mKey, functionalMap3.mValue, true);
                        functionalMap2 = new FunctionalMap<K, V>(functionalMap2.mLeft, functionalMap4, functionalMap2.mKey, functionalMap2.mValue, false);
                    } else {
                        functionalMap2 = new FunctionalMap<K, V>(functionalMap3.mLeft, functionalMap2, functionalMap3.mKey, functionalMap3.mValue, false);
                    }
                }
            }
            if (arrayDeque.isEmpty()) continue;
            boolean bl5 = bl = ((FunctionalMap)arrayDeque.getLast()).mLeft == functionalMap3;
        }
        return functionalMap2;
    }

    public FunctionalMap<K, V> delete(K k) {
        boolean bl;
        FunctionalMap<K, V> functionalMap;
        int n = k.hashCode();
        FunctionalMap<K, V> functionalMap2 = this;
        ArrayList<FunctionalMap<K, V>> arrayList = new ArrayList<FunctionalMap<K, V>>();
        BitSet bitSet = new BitSet();
        while (functionalMap2 != EMPTY) {
            boolean bl2;
            arrayList.add(functionalMap2);
            if (n < functionalMap2.mKey.hashCode()) {
                functionalMap2 = functionalMap2.mLeft;
                bl2 = true;
            } else if (n == functionalMap2.mKey.hashCode()) {
                if (k.equals(functionalMap2.mKey)) break;
                if (functionalMap2.mLeft.get(k) != null) {
                    functionalMap2 = functionalMap2.mLeft;
                    bl2 = true;
                } else {
                    functionalMap2 = functionalMap2.mRight;
                    bl2 = false;
                }
            } else {
                functionalMap2 = functionalMap2.mRight;
                bl2 = false;
            }
            bitSet.set(arrayList.size() - 1, bl2);
        }
        if (functionalMap2 == EMPTY) {
            return this;
        }
        if (functionalMap2.mLeft == EMPTY) {
            arrayList.remove(arrayList.size() - 1);
            functionalMap = functionalMap2.mRight;
            assert (functionalMap == EMPTY == functionalMap2.isTwoNode());
            bl = functionalMap2.isTwoNode();
        } else {
            int n2 = arrayList.size() - 1;
            FunctionalMap<K, V> functionalMap3 = functionalMap2;
            functionalMap2 = functionalMap2.mLeft;
            bitSet.set(arrayList.size() - 1, true);
            while (functionalMap2.mRight != EMPTY) {
                arrayList.add(functionalMap2);
                functionalMap2 = functionalMap2.mRight;
                bitSet.set(arrayList.size() - 1, false);
            }
            assert (functionalMap2.mLeft == EMPTY);
            functionalMap = FunctionalMap.empty();
            arrayList.set(n2, new FunctionalMap<K, V>(functionalMap3.mLeft, functionalMap3.mRight, functionalMap2.mKey, functionalMap2.mValue, functionalMap3.mSizeColor));
            bl = true;
        }
        while (!arrayList.isEmpty()) {
            FunctionalMap<K, V> functionalMap4;
            FunctionalMap<K, V> functionalMap5;
            boolean bl3;
            FunctionalMap functionalMap6 = (FunctionalMap)arrayList.remove(arrayList.size() - 1);
            boolean bl4 = bitSet.get(arrayList.size());
            if (!bl) {
                functionalMap = new FunctionalMap<K, V>(bl4 ? functionalMap : functionalMap6.mLeft, bl4 ? functionalMap6.mRight : functionalMap, functionalMap6.mKey, functionalMap6.mValue, functionalMap6.mSizeColor < 0 ? functionalMap6.mSizeColor + 1 : functionalMap6.mSizeColor - 1);
                continue;
            }
            FunctionalMap functionalMap7 = functionalMap6;
            boolean bl5 = bl3 = !functionalMap6.isTwoNode();
            if (!(bl3 || arrayList.isEmpty() || (functionalMap5 = (FunctionalMap<K, V>)arrayList.get(arrayList.size() - 1)).isTwoNode() || functionalMap5.mRight != functionalMap6)) {
                bl3 = true;
                functionalMap7 = (FunctionalMap)arrayList.remove(arrayList.size() - 1);
            }
            if (bl3) {
                bl = false;
                if (functionalMap6 == functionalMap7) {
                    if (bl4) {
                        functionalMap5 = functionalMap6.mRight;
                        if (functionalMap5.mLeft.isTwoNode()) {
                            functionalMap4 = new FunctionalMap<K, V>(functionalMap, functionalMap5.mLeft, functionalMap6.mKey, functionalMap6.mValue, false);
                            functionalMap = new FunctionalMap<K, V>(functionalMap4, functionalMap5.mRight, functionalMap5.mKey, functionalMap5.mValue, true);
                        } else {
                            functionalMap4 = new FunctionalMap<K, V>(functionalMap, functionalMap5.mLeft.mLeft, functionalMap6.mKey, functionalMap6.mValue, true);
                            var14_17 = new FunctionalMap<K, V>(functionalMap5.mLeft.mRight, functionalMap5.mRight, functionalMap5.mKey, functionalMap5.mValue, true);
                            functionalMap = new FunctionalMap<K, V>(functionalMap4, var14_17, functionalMap5.mLeft.mKey, functionalMap5.mLeft.mValue, false);
                        }
                    } else {
                        functionalMap = new FunctionalMap<K, V>(functionalMap6.mLeft, functionalMap, functionalMap6.mKey, functionalMap6.mValue, true);
                    }
                } else if (bl4) {
                    if (functionalMap6.mRight.isTwoNode()) {
                        functionalMap5 = new FunctionalMap<K, V>(functionalMap, functionalMap6.mRight, functionalMap6.mKey, functionalMap6.mValue, false);
                        functionalMap = new FunctionalMap<K, V>(functionalMap7.mLeft, functionalMap5, functionalMap7.mKey, functionalMap7.mValue, true);
                    } else {
                        functionalMap5 = new FunctionalMap<K, V>(functionalMap, functionalMap6.mRight.mLeft, functionalMap6.mKey, functionalMap6.mValue, true);
                        functionalMap4 = new FunctionalMap<K, V>(functionalMap5, functionalMap6.mRight.mRight, functionalMap6.mRight.mKey, functionalMap6.mRight.mValue, true);
                        functionalMap = new FunctionalMap<K, V>(functionalMap7.mLeft, functionalMap4, functionalMap7.mKey, functionalMap7.mValue, false);
                    }
                } else if (functionalMap6.mLeft.isTwoNode()) {
                    functionalMap5 = new FunctionalMap<K, V>(functionalMap6.mLeft.mRight, functionalMap, functionalMap6.mKey, functionalMap6.mValue, true);
                    functionalMap4 = new FunctionalMap<K, V>(functionalMap6.mLeft.mLeft, functionalMap5, functionalMap6.mLeft.mKey, functionalMap6.mLeft.mValue, false);
                    functionalMap = new FunctionalMap<K, V>(functionalMap7.mLeft, functionalMap4, functionalMap7.mKey, functionalMap7.mValue, true);
                } else {
                    functionalMap5 = new FunctionalMap<K, V>(functionalMap6.mLeft.mRight.mRight, functionalMap, functionalMap6.mKey, functionalMap6.mValue, true);
                    functionalMap4 = new FunctionalMap<K, V>(functionalMap6.mLeft.mLeft, functionalMap6.mLeft.mRight.mLeft, functionalMap6.mLeft.mKey, functionalMap6.mLeft.mValue, true);
                    var14_17 = new FunctionalMap<K, V>(functionalMap4, functionalMap5, functionalMap6.mLeft.mRight.mKey, functionalMap6.mLeft.mRight.mValue, true);
                    functionalMap = new FunctionalMap<K, V>(functionalMap7.mLeft, var14_17, functionalMap7.mKey, functionalMap7.mValue, false);
                }
                functionalMap6 = functionalMap7;
                continue;
            }
            bl = true;
            if (bl4) {
                if (functionalMap6.mRight.isTwoNode()) {
                    functionalMap = new FunctionalMap<K, V>(functionalMap, functionalMap6.mRight, functionalMap6.mKey, functionalMap6.mValue, false);
                    continue;
                }
                functionalMap5 = new FunctionalMap<K, V>(functionalMap, functionalMap6.mRight.mLeft, functionalMap6.mKey, functionalMap6.mValue, true);
                functionalMap = new FunctionalMap<K, V>(functionalMap5, functionalMap6.mRight.mRight, functionalMap6.mRight.mKey, functionalMap6.mRight.mValue, true);
                bl = false;
                continue;
            }
            if (functionalMap6.mLeft.isTwoNode()) {
                functionalMap5 = new FunctionalMap<K, V>(functionalMap6.mLeft.mRight, functionalMap, functionalMap6.mKey, functionalMap6.mValue, true);
                functionalMap = new FunctionalMap<K, V>(functionalMap6.mLeft.mLeft, functionalMap5, functionalMap6.mLeft.mKey, functionalMap6.mLeft.mValue, false);
                continue;
            }
            functionalMap5 = new FunctionalMap<K, V>(functionalMap6.mLeft.mLeft, functionalMap6.mLeft.mRight.mLeft, functionalMap6.mLeft.mKey, functionalMap6.mLeft.mValue, true);
            functionalMap4 = new FunctionalMap<K, V>(functionalMap6.mLeft.mRight.mRight, functionalMap, functionalMap6.mKey, functionalMap6.mValue, true);
            functionalMap = new FunctionalMap<K, V>(functionalMap5, functionalMap4, functionalMap6.mLeft.mRight.mKey, functionalMap6.mLeft.mRight.mValue, true);
            bl = false;
        }
        return functionalMap;
    }

    public int getHeight() {
        int n = 0;
        FunctionalMap<K, V> functionalMap = this;
        while (functionalMap != EMPTY) {
            ++n;
            functionalMap = functionalMap.mLeft;
        }
        return n;
    }

    @Override
    public K getKey() {
        return this.mKey;
    }

    @Override
    public V getValue() {
        return this.mValue;
    }

    @Override
    public V setValue(V v) {
        throw new UnsupportedOperationException("Functional Maps are read-only");
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public int size() {
        return Math.abs(this.mSizeColor);
    }

    private boolean isTwoNode() {
        return this.mSizeColor >= 0;
    }

    static class EntryIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        ArrayDeque<FunctionalMap<K, V>> mPathFromRoot = new ArrayDeque();

        EntryIterator(FunctionalMap<K, V> functionalMap) {
            while (functionalMap != EMPTY) {
                this.mPathFromRoot.add(functionalMap);
                functionalMap = functionalMap.mLeft;
            }
        }

        @Override
        public boolean hasNext() {
            return !this.mPathFromRoot.isEmpty();
        }

        @Override
        public Map.Entry<K, V> next() {
            FunctionalMap<K, V> functionalMap = this.mPathFromRoot.removeLast();
            FunctionalMap functionalMap2 = functionalMap.mRight;
            while (functionalMap2 != EMPTY) {
                this.mPathFromRoot.add(functionalMap2);
                functionalMap2 = functionalMap2.mLeft;
            }
            return functionalMap;
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(FunctionalMap.this);
        }

        @Override
        public int size() {
            return FunctionalMap.this.size();
        }
    }
}

