/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.abstraction;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.abstraction.IAbstraction;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.ILattice;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;

public class CachedAbstraction<H, L>
implements IAbstraction<H, L> {
    private final IAbstraction<H, L> mUnderlying;
    private final NestedMap2<L, H, L> mCache = new NestedMap2();

    public CachedAbstraction(IAbstraction<H, L> iAbstraction) {
        this.mUnderlying = iAbstraction;
    }

    @Override
    public ILattice<H> getHierarchy() {
        return this.mUnderlying.getHierarchy();
    }

    @Override
    public L abstractLetter(L l, H h) {
        if (this.mCache.containsKey(l, h)) {
            return (L)this.mCache.get(l, h);
        }
        H h2 = this.restrict(l, h);
        assert (this.getHierarchy().compare(h2, h).isLessOrEqual()) : "restrict must return smaller or equal abstraction level";
        if (this.mCache.containsKey(l, h2)) {
            Object object = this.mCache.get(l, h2);
            this.mCache.put(l, h, object);
            return (L)object;
        }
        L l2 = this.mUnderlying.abstractLetter(l, h2);
        this.mCache.put(l, h2, l2);
        return l2;
    }

    @Override
    public H restrict(L l, H h) {
        return this.mUnderlying.restrict(l, h);
    }
}

