/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.PetriNetNot1SafeException;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.UnaryNetOperation;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.CopySubnet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.BranchingProcess;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Condition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.Event;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.FinitePrefix;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IPetriNet2FiniteAutomatonStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.stream.Collectors;

public class RemoveDeadBuchi<LETTER, PLACE, CRSF extends IStateFactory<PLACE> & IPetriNet2FiniteAutomatonStateFactory<PLACE>>
extends UnaryNetOperation<LETTER, PLACE, CRSF> {
    private final IPetriNet<LETTER, PLACE> mOperand;
    private BranchingProcess<LETTER, PLACE> mFinPre;
    private Collection<Condition<LETTER, PLACE>> mAcceptingConditions;
    private final Set<Transition<LETTER, PLACE>> mVitalTransitions;
    private final BoundedPetriNet<LETTER, PLACE> mResult;

    public RemoveDeadBuchi(AutomataLibraryServices automataLibraryServices, IPetriNet<LETTER, PLACE> iPetriNet, BranchingProcess<LETTER, PLACE> branchingProcess) throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        super(automataLibraryServices);
        this.mOperand = iPetriNet;
        this.mFinPre = branchingProcess != null ? branchingProcess : new FinitePrefix<LETTER, PLACE>(automataLibraryServices, iPetriNet).getResult();
        this.printStartMessage();
        this.mVitalTransitions = this.vitalTransitions();
        this.mResult = CopySubnet.copy(automataLibraryServices, this.mOperand, this.mVitalTransitions, this.mOperand.getAlphabet(), true);
        this.printExitMessage();
    }

    private Set<Transition<LETTER, PLACE>> vitalTransitions() throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        Set set = this.transitivePredecessors(this.mOperand.getAcceptingPlaces());
        if (set.size() == this.mOperand.getTransitions().size()) {
            this.mLogger.debug((Object)"Skipping co-relation queries. All transitions lead to accepting places.");
        } else {
            this.ensureFinPreExists();
            this.mAcceptingConditions = this.acceptingConditions();
            this.mFinPre.getEvents().stream().filter(event -> event != this.mFinPre.getDummyRoot()).filter(event -> !set.contains(event.getTransition())).filter(event -> !this.timeout()).filter(this::coRelatedToAnyAccCond).map(Event::getTransition).forEach(set::add);
            if (this.timeout()) {
                throw new AutomataOperationCanceledException(this.getClass());
            }
        }
        return set;
    }

    private void ensureFinPreExists() throws AutomataOperationCanceledException, PetriNetNot1SafeException {
        if (this.mFinPre == null) {
            this.mLogger.info((Object)("Computing finite prefix for " + this.getOperationName()));
            this.mFinPre = new FinitePrefix<LETTER, PLACE>(this.mServices, this.mOperand).getResult();
        }
    }

    private boolean timeout() {
        return !this.mServices.getProgressAwareTimer().continueProcessing();
    }

    private boolean coRelatedToAnyAccCond(Event<LETTER, PLACE> event) {
        return this.mAcceptingConditions.stream().anyMatch(condition -> this.mFinPre.getCoRelation().isInCoRelation((Condition<LETTER, PLACE>)condition, event));
    }

    private Set<Transition<LETTER, PLACE>> transitivePredecessors(Collection<PLACE> collection) {
        HashSet<Transition<LETTER, PLACE>> hashSet = new HashSet<Transition<LETTER, PLACE>>();
        HashSet hashSet2 = new HashSet();
        LinkedList<PLACE> linkedList = new LinkedList<PLACE>(collection);
        while (!linkedList.isEmpty()) {
            Object e = linkedList.poll();
            for (Transition transition : this.mOperand.getPredecessors(e)) {
                hashSet.add(transition);
                transition.getPredecessors().stream().filter(hashSet2::add).forEach(linkedList::add);
            }
        }
        return hashSet;
    }

    private Collection<Condition<LETTER, PLACE>> acceptingConditions() {
        assert (this.mFinPre != null) : "Finite prefix not computed yet.";
        return this.mOperand.getAcceptingPlaces().stream().map(this.mFinPre::place2cond).flatMap(Collection::stream).collect(Collectors.toList());
    }

    @Override
    public BoundedPetriNet<LETTER, PLACE> getResult() {
        return this.mResult;
    }

    @Override
    protected IPetriNet<LETTER, PLACE> getOperand() {
        return this.mOperand;
    }

    @Override
    public boolean checkResult(CRSF CRSF) throws AutomataLibraryException {
        this.mLogger.warn((Object)"checkResult not implemented-");
        return true;
    }

    @Override
    public String exitMessage() {
        return "Finished " + this.getClass().getSimpleName() + ", result has " + this.mResult.sizeInformation();
    }
}

