/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea;

import de.uni_freiburg.informatik.ultimate.lib.pea.CDD;
import de.uni_freiburg.informatik.ultimate.lib.pea.Decision;
import de.uni_freiburg.informatik.ultimate.lib.pea.util.z.PrimeVisitor;
import de.uni_freiburg.informatik.ultimate.lib.pea.util.z.ZTerm;
import de.uni_freiburg.informatik.ultimate.lib.pea.util.z.ZWrapper;
import java.util.Set;
import net.sourceforge.czt.parser.util.ParseException;
import net.sourceforge.czt.util.Visitor;
import net.sourceforge.czt.z.util.ZString;

public final class ZDecision
extends Decision<ZDecision> {
    private String mPredicate;

    private ZDecision(String string) {
        this.mPredicate = string;
    }

    @Deprecated
    public static CDD createSimplified(String string) {
        return ZDecision.getSimplifiedCDD(string);
    }

    public static CDD create(String string) {
        return ZDecision.createWithChildren(string, CDD.TRUE_CHILDS);
    }

    public static CDD createWithChildren(String string, CDD[] cDDArray) {
        if (string.trim().equals("true")) {
            return CDD.TRUE;
        }
        if (string.trim().equals("false")) {
            return CDD.FALSE;
        }
        return CDD.create(new ZDecision(string), cDDArray);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof ZDecision)) {
            return false;
        }
        ZDecision zDecision = (ZDecision)object;
        return zDecision.mPredicate.equals(this.mPredicate);
    }

    @Override
    public int hashCode() {
        return this.mPredicate.hashCode();
    }

    public String getPredicate() {
        return this.mPredicate;
    }

    @Override
    public String toString(int n) {
        return n == 0 ? this.mPredicate : ZString.NOT + this.mPredicate;
    }

    @Override
    public String toSmtString(int n) {
        return this.toString(n);
    }

    @Override
    public String toTexString(int n) {
        return this.toString(n);
    }

    @Override
    public String toBoogieString(int n) {
        return n == 0 ? this.mPredicate : "!" + this.mPredicate;
    }

    @Override
    public String toUppaalString(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String toUppaalStringDOM(int n) {
        throw new UnsupportedOperationException();
    }

    public String getZML() throws ParseException, InstantiationException {
        return ZWrapper.INSTANCE.predicateToZml(this.mPredicate);
    }

    public boolean equals(ZDecision zDecision) {
        return this.mPredicate.equals(zDecision.mPredicate);
    }

    public ZDecision negate() {
        StringBuilder stringBuilder = new StringBuilder(ZString.NOT);
        stringBuilder.append(ZString.LPAREN);
        stringBuilder.append(this.mPredicate);
        stringBuilder.append(ZString.RPAREN);
        return new ZDecision(stringBuilder.toString());
    }

    public static boolean cddContainsZDecisionWith(CDD cDD, String string) {
        if (cDD == CDD.TRUE || cDD == CDD.FALSE) {
            return false;
        }
        if (cDD.getDecision() instanceof ZDecision && ((ZDecision)cDD.getDecision()).mPredicate.contains(string)) {
            return true;
        }
        CDD[] cDDArray = cDD.getChilds();
        int n = cDDArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDD cDD2 = cDDArray[n2];
            if (ZDecision.cddContainsZDecisionWith(cDD2, string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static void renameVariableInCDD(CDD cDD, String string, String string2) {
        Object object;
        if (cDD == CDD.TRUE || cDD == CDD.FALSE) {
            return;
        }
        if (cDD.getDecision() instanceof ZDecision) {
            object = (ZDecision)cDD.getDecision();
            ((ZDecision)object).mPredicate = ((ZDecision)object).mPredicate.replace(string, string2);
        }
        CDD[] cDDArray = cDD.getChilds();
        int n = cDDArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = cDDArray[n2];
            ZDecision.renameVariableInCDD((CDD)object, string, string2);
            ++n2;
        }
    }

    @Deprecated
    static CDD simplifyDecision(String string) {
        if ((string = string.trim()).contains(ZString.GEQ)) {
            String[] stringArray = string.split(ZString.GEQ);
            return ZDecision.create(stringArray[0].trim() + "<" + stringArray[1].trim()).negate();
        }
        if (string.contains(">=")) {
            String[] stringArray = string.split(">=");
            return ZDecision.create(stringArray[0].trim() + "<" + stringArray[1].trim()).negate();
        }
        if (string.contains(">")) {
            String[] stringArray = string.split(">");
            return ZDecision.create(stringArray[0].trim() + ZString.LEQ + stringArray[1].trim()).negate();
        }
        string = string.replaceAll("(\\s*)<(\\s*)", "<");
        string = string.replaceAll("(\\s*)" + ZString.LEQ + "(\\s*)", ZString.LEQ);
        string = string.replaceAll("(\\s*)<=(\\s*)", ZString.LEQ);
        return ZDecision.create(string);
    }

    @Deprecated
    static CDD parseAND(String string) {
        String[] stringArray = string.split(ZString.AND);
        CDD cDD = ZDecision.simplifyDecision(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            cDD = cDD.and(ZDecision.simplifyDecision(stringArray[n]));
            ++n;
        }
        return cDD;
    }

    @Deprecated
    static CDD parseOR(String string) {
        String[] stringArray = string.split(ZString.OR);
        CDD cDD = ZDecision.parseAND(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            cDD = cDD.or(ZDecision.parseAND(stringArray[n]));
            ++n;
        }
        return cDD;
    }

    @Deprecated
    static CDD resolveImpls(String string) {
        String[] stringArray = string.split(ZString.IMP);
        if (stringArray.length == 1) {
            return ZDecision.parseOR(stringArray[0]);
        }
        if (stringArray.length == 2) {
            CDD cDD = ZDecision.parseOR(stringArray[0]).negate();
            cDD = cDD.or(ZDecision.parseOR(stringArray[1]));
            return cDD;
        }
        throw new RuntimeException("implication with more than two parts");
    }

    @Deprecated
    static CDD getSimplifiedCDD(String string) {
        String[] stringArray = string.split("\n");
        CDD cDD = ZDecision.resolveImpls(stringArray[0]);
        int n = 1;
        while (n < stringArray.length) {
            cDD = cDD.and(ZDecision.resolveImpls(stringArray[n]));
            ++n;
        }
        return cDD;
    }

    @Override
    public ZDecision prime(Set<String> set) {
        String string = this.mPredicate;
        try {
            ZTerm zTerm = ZWrapper.INSTANCE.predicateToTerm(this.mPredicate);
            PrimeVisitor primeVisitor = new PrimeVisitor();
            zTerm.getTerm().accept((Visitor)primeVisitor);
            string = ZWrapper.INSTANCE.termToUnicode(zTerm);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        return new ZDecision(string);
    }

    @Override
    public ZDecision unprime(Set<String> set) {
        String string = this.mPredicate;
        try {
            ZTerm zTerm = ZWrapper.INSTANCE.predicateToTerm(this.mPredicate);
            PrimeVisitor primeVisitor = new PrimeVisitor();
            zTerm.getTerm().accept((Visitor)primeVisitor);
            string = ZWrapper.INSTANCE.termToUnicode(zTerm);
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        return new ZDecision(string);
    }

    @Override
    public String getVar() {
        return "";
    }

    @Override
    public int compareToSimilar(Decision<?> decision) {
        return this.mPredicate.compareTo(((ZDecision)decision).mPredicate);
    }
}

