/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.decorator;

import de.uni_freiburg.informatik.ultimate.cdt.decorator.DecoratorIteratorBreadthFirstSearch;
import de.uni_freiburg.informatik.ultimate.cdt.decorator.DecoratorIteratorDepthFirstSearch;
import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class DecoratorNode
implements Iterable<DecoratorNode> {
    protected IASTNode mCNode;
    protected ACSLNode mAcslNode;
    private final List<DecoratorNode> mChildren = new ArrayList<DecoratorNode>();
    private final DecoratorNode mParent;

    public DecoratorNode(DecoratorNode decoratorNode, ACSLNode aCSLNode) {
        this(decoratorNode);
        this.mAcslNode = aCSLNode;
    }

    public DecoratorNode(DecoratorNode decoratorNode, IASTNode iASTNode) {
        this(decoratorNode);
        this.mCNode = iASTNode;
    }

    public DecoratorNode(DecoratorNode decoratorNode) {
        this.mParent = decoratorNode;
    }

    public boolean hasChildren() {
        return !this.mChildren.isEmpty();
    }

    public void addChildren(DecoratorNode decoratorNode) {
        if (this.mAcslNode != null) {
            throw new IllegalArgumentException("DecoratorNode with ACSL can not have children!");
        }
        if (this.mCNode == null) {
            throw new IllegalArgumentException("Node has neither ACSL nor C!");
        }
        this.mChildren.add(decoratorNode);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.mCNode != null) {
            stringBuilder.append(this.mCNode);
        } else if (this.mAcslNode != null) {
            stringBuilder.append(this.mAcslNode);
        }
        return stringBuilder.toString();
    }

    public DecoratorNode getParent() {
        return this.mParent;
    }

    public ACSLNode getAcslNode() {
        return this.mAcslNode;
    }

    public IASTNode getCNode() {
        return this.mCNode;
    }

    @Override
    public Iterator<DecoratorNode> iterator() {
        return new DecoratorIteratorDepthFirstSearch(this);
    }

    public Iterator<DecoratorNode> iteratorBreadthFirst() {
        return new DecoratorIteratorBreadthFirstSearch(this);
    }

    public List<DecoratorNode> getChildren() {
        return this.mChildren;
    }

    public void addAllChildren(List<DecoratorNode> list) {
        if (this.mAcslNode != null) {
            throw new IllegalArgumentException("DecoratorNode with ACSL can not have children!");
        }
        if (this.mCNode == null) {
            throw new IllegalArgumentException("Node has neither ACSL nor C!");
        }
        this.mChildren.addAll(list);
    }
}

