/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.util;

import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeUtils {
    public static <V, E> List<V> getRoots(Forest<V, E> forest) {
        ArrayList<V> roots = new ArrayList<V>();
        for (Tree<V, E> tree : forest.getTrees()) {
            roots.add(tree.getRoot());
        }
        return roots;
    }

    public static <V, E> Tree<V, E> getSubTree(Forest<V, E> forest, V root) throws InstantiationException, IllegalAccessException {
        if (!forest.containsVertex(root)) {
            throw new IllegalArgumentException("Specified tree does not contain the specified root as a vertex");
        }
        Forest subforest = (Forest)forest.getClass().newInstance();
        subforest.addVertex(root);
        TreeUtils.growSubTree(forest, subforest, root);
        return subforest.getTrees().iterator().next();
    }

    public static <V, E> void growSubTree(Forest<V, E> tree, Forest<V, E> subTree, V root) {
        if (tree.getSuccessorCount(root) > 0) {
            Collection edges = tree.getOutEdges(root);
            for (Object e : edges) {
                subTree.addEdge(e, tree.getEndpoints(e));
            }
            Collection<V> kids = tree.getSuccessors(root);
            for (V kid : kids) {
                TreeUtils.growSubTree(tree, subTree, kid);
            }
        }
    }

    public static <V, E> void addSubTree(Forest<V, E> tree, Forest<V, E> subTree, V node, E connectingEdge) {
        if (node != null && !tree.containsVertex(node)) {
            throw new IllegalArgumentException("Specified tree does not contain the specified node as a vertex");
        }
        V root = subTree.getTrees().iterator().next().getRoot();
        TreeUtils.addFromSubTree(tree, subTree, connectingEdge, node, root);
    }

    public static <V, E> void addFromSubTree(Forest<V, E> tree, Forest<V, E> subTree, E edge, V parent, V root) {
        if (edge != null && parent != null) {
            tree.addEdge(edge, parent, root);
        } else {
            tree.addVertex(root);
        }
        Collection outEdges = subTree.getOutEdges(root);
        for (Object e : outEdges) {
            V opposite = subTree.getOpposite(root, e);
            TreeUtils.addFromSubTree(tree, subTree, e, root, opposite);
        }
    }
}

