/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.PolarPoint;
import edu.uci.ics.jung.algorithms.layout.RadialTreeLayout;
import edu.uci.ics.jung.algorithms.layout.TreeLayout;
import edu.uci.ics.jung.graph.DelegateForest;
import edu.uci.ics.jung.graph.DelegateTree;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.EllipseVertexShapeTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.subLayout.TreeCollapser;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;

public class TreeCollapseDemo
extends JApplet {
    Forest<String, Integer> graph;
    Factory<DirectedGraph<String, Integer>> graphFactory = new Factory<DirectedGraph<String, Integer>>(){

        @Override
        public DirectedGraph<String, Integer> create() {
            return new DirectedSparseMultigraph<String, Integer>();
        }
    };
    Factory<Tree<String, Integer>> treeFactory = new Factory<Tree<String, Integer>>(){

        @Override
        public Tree<String, Integer> create() {
            return new DelegateTree<String, Integer>(TreeCollapseDemo.this.graphFactory);
        }
    };
    Factory<Integer> edgeFactory = new Factory<Integer>(){
        int i = 0;

        @Override
        public Integer create() {
            return this.i++;
        }
    };
    Factory<String> vertexFactory = new Factory<String>(){
        int i = 0;

        @Override
        public String create() {
            return "V" + this.i++;
        }
    };
    VisualizationViewer<String, Integer> vv;
    VisualizationServer.Paintable rings;
    String root;
    TreeLayout<String, Integer> layout;
    FRLayout layout1;
    TreeCollapser collapser;
    RadialTreeLayout<String, Integer> radialLayout;

    public TreeCollapseDemo() {
        this.graph = new DelegateForest<String, Integer>();
        this.createTree();
        this.layout = new TreeLayout<String, Integer>(this.graph);
        this.collapser = new TreeCollapser();
        this.radialLayout = new RadialTreeLayout<String, Integer>(this.graph);
        this.radialLayout.setSize(new Dimension(600, 600));
        this.vv = new VisualizationViewer<String, Integer>(this.layout, new Dimension(600, 600));
        this.vv.setBackground(Color.white);
        this.vv.getRenderContext().setEdgeShapeTransformer(new EdgeShape.Line());
        this.vv.getRenderContext().setVertexLabelTransformer(new ToStringLabeller());
        this.vv.getRenderContext().setVertexShapeTransformer(new ClusterVertexShapeFunction());
        this.vv.setVertexToolTipTransformer(new ToStringLabeller());
        this.vv.getRenderContext().setArrowFillPaintTransformer(new ConstantTransformer<Paint>(Color.lightGray));
        this.rings = new Rings();
        Container content = this.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add(panel);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(graphMouse);
        JComboBox modeBox = graphMouse.getModeComboBox();
        modeBox.addItemListener(graphMouse.getModeListener());
        graphMouse.setMode(ModalGraphMouse.Mode.TRANSFORMING);
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(TreeCollapseDemo.this.vv, 1.1f, TreeCollapseDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(TreeCollapseDemo.this.vv, 0.9090909f, TreeCollapseDemo.this.vv.getCenter());
            }
        });
        JToggleButton radial = new JToggleButton("Radial");
        radial.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    TreeCollapseDemo.this.vv.setGraphLayout(TreeCollapseDemo.this.radialLayout);
                    TreeCollapseDemo.this.vv.getRenderContext().getMultiLayerTransformer().setToIdentity();
                    TreeCollapseDemo.this.vv.addPreRenderPaintable(TreeCollapseDemo.this.rings);
                } else {
                    TreeCollapseDemo.this.vv.setGraphLayout(TreeCollapseDemo.this.layout);
                    TreeCollapseDemo.this.vv.getRenderContext().getMultiLayerTransformer().setToIdentity();
                    TreeCollapseDemo.this.vv.removePreRenderPaintable(TreeCollapseDemo.this.rings);
                }
                TreeCollapseDemo.this.vv.repaint();
            }
        });
        JButton collapse = new JButton("Collapse");
        collapse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HashSet picked = new HashSet(TreeCollapseDemo.this.vv.getPickedVertexState().getPicked());
                if (picked.size() == 1) {
                    Object root = picked.iterator().next();
                    Forest inGraph = (Forest)TreeCollapseDemo.this.layout.getGraph();
                    try {
                        TreeCollapseDemo.this.collapser.collapse(TreeCollapseDemo.this.vv.getGraphLayout(), inGraph, root);
                    }
                    catch (InstantiationException e1) {
                        e1.printStackTrace();
                    }
                    catch (IllegalAccessException e1) {
                        e1.printStackTrace();
                    }
                    TreeCollapseDemo.this.vv.getPickedVertexState().clear();
                    TreeCollapseDemo.this.vv.repaint();
                }
            }
        });
        JButton expand = new JButton("Expand");
        expand.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Set picked = TreeCollapseDemo.this.vv.getPickedVertexState().getPicked();
                for (Object v : picked) {
                    if (v instanceof Forest) {
                        Forest inGraph = (Forest)TreeCollapseDemo.this.layout.getGraph();
                        TreeCollapseDemo.this.collapser.expand(inGraph, (Forest)v);
                    }
                    TreeCollapseDemo.this.vv.getPickedVertexState().clear();
                    TreeCollapseDemo.this.vv.repaint();
                }
            }
        });
        JPanel scaleGrid = new JPanel(new GridLayout(1, 0));
        scaleGrid.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel controls = new JPanel();
        scaleGrid.add(plus);
        scaleGrid.add(minus);
        controls.add(radial);
        controls.add(scaleGrid);
        controls.add(modeBox);
        controls.add(collapse);
        controls.add(expand);
        content.add((Component)controls, "South");
    }

    private void createTree() {
        this.graph.addVertex("V0");
        this.graph.addEdge(this.edgeFactory.create(), "V0", "V1");
        this.graph.addEdge(this.edgeFactory.create(), "V0", "V2");
        this.graph.addEdge(this.edgeFactory.create(), "V1", "V4");
        this.graph.addEdge(this.edgeFactory.create(), "V2", "V3");
        this.graph.addEdge(this.edgeFactory.create(), "V2", "V5");
        this.graph.addEdge(this.edgeFactory.create(), "V4", "V6");
        this.graph.addEdge(this.edgeFactory.create(), "V4", "V7");
        this.graph.addEdge(this.edgeFactory.create(), "V3", "V8");
        this.graph.addEdge(this.edgeFactory.create(), "V6", "V9");
        this.graph.addEdge(this.edgeFactory.create(), "V4", "V10");
        this.graph.addVertex("A0");
        this.graph.addEdge(this.edgeFactory.create(), "A0", "A1");
        this.graph.addEdge(this.edgeFactory.create(), "A0", "A2");
        this.graph.addEdge(this.edgeFactory.create(), "A0", "A3");
        this.graph.addVertex("B0");
        this.graph.addEdge(this.edgeFactory.create(), "B0", "B1");
        this.graph.addEdge(this.edgeFactory.create(), "B0", "B2");
        this.graph.addEdge(this.edgeFactory.create(), "B1", "B4");
        this.graph.addEdge(this.edgeFactory.create(), "B2", "B3");
        this.graph.addEdge(this.edgeFactory.create(), "B2", "B5");
        this.graph.addEdge(this.edgeFactory.create(), "B4", "B6");
        this.graph.addEdge(this.edgeFactory.create(), "B4", "B7");
        this.graph.addEdge(this.edgeFactory.create(), "B3", "B8");
        this.graph.addEdge(this.edgeFactory.create(), "B6", "B9");
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        frame.setDefaultCloseOperation(3);
        content.add(new TreeCollapseDemo());
        frame.pack();
        frame.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ClusterVertexSizeFunction<V>
    implements Transformer<V, Integer> {
        int size;

        public ClusterVertexSizeFunction(Integer size) {
            this.size = size;
        }

        @Override
        public Integer transform(V v) {
            if (v instanceof Graph) {
                return 30;
            }
            return this.size;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ClusterVertexShapeFunction<V>
    extends EllipseVertexShapeTransformer<V> {
        ClusterVertexShapeFunction() {
            this.setSizeTransformer(new ClusterVertexSizeFunction(20));
        }

        @Override
        public Shape transform(V v) {
            if (v instanceof Graph) {
                int size = ((Graph)v).getVertexCount();
                if (size < 8) {
                    int sides = Math.max(size, 3);
                    return this.factory.getRegularPolygon(v, sides);
                }
                return this.factory.getRegularStar(v, size);
            }
            return super.transform((Object)v);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Rings
    implements VisualizationServer.Paintable {
        Collection<Double> depths = this.getDepths();

        private Collection<Double> getDepths() {
            HashSet<Double> depths = new HashSet<Double>();
            Map<String, PolarPoint> polarLocations = TreeCollapseDemo.this.radialLayout.getPolarLocations();
            for (String v : TreeCollapseDemo.this.graph.getVertices()) {
                PolarPoint pp = polarLocations.get(v);
                depths.add(pp.getRadius());
            }
            return depths;
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(Color.lightGray);
            Graphics2D g2d = (Graphics2D)g;
            Point2D center = TreeCollapseDemo.this.radialLayout.getCenter();
            Ellipse2D.Double ellipse = new Ellipse2D.Double();
            for (double d : this.depths) {
                ellipse.setFrameFromDiagonal(center.getX() - d, center.getY() - d, center.getX() + d, center.getY() + d);
                Shape shape = TreeCollapseDemo.this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT).transform(ellipse);
                g2d.draw(shape);
            }
        }

        @Override
        public boolean useTransform() {
            return true;
        }
    }
}

