/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.jai;

import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.jai.AbstractPerspectiveTransformSupport;
import edu.uci.ics.jung.visualization.jai.PerspectiveShapeTransformer;
import edu.uci.ics.jung.visualization.jai.PerspectiveTransformSupport;
import edu.uci.ics.jung.visualization.picking.LayoutLensShapePickSupport;
import javax.media.jai.PerspectiveTransform;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PerspectiveLayoutTransformSupport<V, E>
extends AbstractPerspectiveTransformSupport<V, E>
implements PerspectiveTransformSupport {
    protected GraphElementAccessor<V, E> pickSupport;

    public PerspectiveLayoutTransformSupport(VisualizationViewer<V, E> vv) {
        super(vv);
        this.perspectiveTransformer = new PerspectiveShapeTransformer(new PerspectiveTransform(), vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.LAYOUT));
        this.pickSupport = vv.getPickSupport();
    }

    @Override
    public void activate() {
        this.lens = new AbstractPerspectiveTransformSupport.Lens(this.perspectiveTransformer, this.vv.getSize());
        this.vv.getRenderContext().setPickSupport(new LayoutLensShapePickSupport(this.vv));
        this.vv.getRenderContext().getMultiLayerTransformer().setTransformer(Layer.LAYOUT, this.perspectiveTransformer);
        this.vv.addPreRenderPaintable(this.lens);
        this.vv.setToolTipText("<html><center>The mouse mode button is<p>in the lower-right corner<p>of the scroll-pane.</center></html>");
        this.vv.repaint();
    }

    @Override
    public void deactivate() {
        this.vv.getRenderContext().setPickSupport(this.pickSupport);
        if (this.perspectiveTransformer != null) {
            this.vv.removePreRenderPaintable(this.lens);
            this.vv.getRenderContext().getMultiLayerTransformer().setTransformer(Layer.LAYOUT, this.perspectiveTransformer.getDelegate());
        }
        this.vv.setToolTipText(this.defaultToolTipText);
        this.vv.repaint();
    }
}

