/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.witnesschecking;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Call;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.CodeBlock;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.GotoEdge;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.ParallelComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Return;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.SequentialComposition;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.StatementSequence;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg.Summary;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessEdge;
import de.uni_freiburg.informatik.ultimate.witnessparser.graph.WitnessNode;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class WitnessLocationMatcher<LETTER extends IIcfgTransition<?>> {
    private final IUltimateServiceProvider mServices;
    private final Set<WitnessEdge> mPureAnnotationEdges = new HashSet<WitnessEdge>();
    private final HashRelation<Integer, WitnessEdge> mLineNumber2WitnessLetter = new HashRelation();
    private final HashRelation<ILocation, WitnessEdge> mSingleLineLocation2WitnessLetters = new HashRelation();
    private final HashRelation<WitnessEdge, ILocation> mWitnessLetters2SingleLineLocations = new HashRelation();
    private final Set<ILocation> mMultiLineLocations = new HashSet<ILocation>();
    private final ILogger mLogger;
    private final ArrayList<WitnessEdge> mUnmatchedWitnessLetters;

    public WitnessLocationMatcher(IUltimateServiceProvider iUltimateServiceProvider, INwaOutgoingLetterAndTransitionProvider<LETTER, IPredicate> iNwaOutgoingLetterAndTransitionProvider, INwaOutgoingLetterAndTransitionProvider<WitnessEdge, WitnessNode> iNwaOutgoingLetterAndTransitionProvider2) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.partitionEdges(iNwaOutgoingLetterAndTransitionProvider2.getVpAlphabet().getInternalAlphabet());
        this.matchLocations(iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet().getInternalAlphabet());
        this.matchLocations(iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet().getCallAlphabet());
        this.matchLocations(iNwaOutgoingLetterAndTransitionProvider.getVpAlphabet().getReturnAlphabet());
        this.mUnmatchedWitnessLetters = new ArrayList(iNwaOutgoingLetterAndTransitionProvider2.getVpAlphabet().getInternalAlphabet());
        this.mUnmatchedWitnessLetters.removeAll(this.mWitnessLetters2SingleLineLocations.getDomain());
        this.mLogger.info((Object)(iNwaOutgoingLetterAndTransitionProvider2.getVpAlphabet().getInternalAlphabet().size() + " witness edges"));
        this.mLogger.info((Object)(this.mPureAnnotationEdges.size() + " pure annotation edges"));
        this.mLogger.info((Object)(this.mUnmatchedWitnessLetters.size() + " unmatched witness edges"));
        this.mLogger.info((Object)(this.mWitnessLetters2SingleLineLocations.getDomain().size() + " matched witness edges"));
        this.mLogger.info((Object)(this.mSingleLineLocation2WitnessLetters.getDomain().size() + " single line locations"));
        this.mLogger.info((Object)(this.mMultiLineLocations.size() + " multi line locations"));
    }

    public boolean isMatchedWitnessEdge(WitnessEdge witnessEdge) {
        return this.mWitnessLetters2SingleLineLocations.getDomain().contains(witnessEdge);
    }

    public boolean isCompatible(ILocation iLocation, WitnessEdge witnessEdge) {
        return this.mSingleLineLocation2WitnessLetters.containsPair((Object)iLocation, (Object)witnessEdge);
    }

    public Set<ILocation> getCorrespondingLocations(WitnessEdge witnessEdge) {
        return this.mWitnessLetters2SingleLineLocations.getImage((Object)witnessEdge);
    }

    private void partitionEdges(Set<WitnessEdge> set) {
        for (WitnessEdge witnessEdge : set) {
            int n = witnessEdge.getLocation().getStartLine();
            this.mLineNumber2WitnessLetter.addPair((Object)n, (Object)witnessEdge);
        }
    }

    private void matchLocations(Set<? extends IIcfgTransition<?>> set) {
        for (IIcfgTransition<?> iIcfgTransition : set) {
            this.matchLocations(iIcfgTransition);
        }
    }

    private void matchLocations(IIcfgTransition<?> iIcfgTransition) {
        if (iIcfgTransition instanceof Call) {
            Call call = (Call)iIcfgTransition;
            this.matchLocations(call);
        } else if (iIcfgTransition instanceof ParallelComposition) {
            ParallelComposition parallelComposition = (ParallelComposition)iIcfgTransition;
            this.matchLocations(parallelComposition);
        } else if (iIcfgTransition instanceof Return) {
            Return return_ = (Return)iIcfgTransition;
            this.matchLocations(return_);
        } else if (iIcfgTransition instanceof SequentialComposition) {
            SequentialComposition sequentialComposition = (SequentialComposition)iIcfgTransition;
            this.matchLocations(sequentialComposition);
        } else if (iIcfgTransition instanceof StatementSequence) {
            StatementSequence statementSequence = (StatementSequence)iIcfgTransition;
            this.matchLocations(statementSequence);
        } else if (iIcfgTransition instanceof Summary) {
            Summary summary = (Summary)iIcfgTransition;
            this.matchLocations((Statement)summary.getCallStatement());
        } else if (iIcfgTransition instanceof GotoEdge) {
            this.matchLocations((GotoEdge)iIcfgTransition);
        } else {
            this.matchLocations(ILocation.getAnnotation(iIcfgTransition));
        }
    }

    private void matchLocations(Call call) {
        this.matchLocations((Statement)call.getCallStatement());
    }

    private void matchLocations(ParallelComposition parallelComposition) {
        for (CodeBlock codeBlock : parallelComposition.getCodeBlocks()) {
            this.matchLocations((IIcfgTransition<?>)codeBlock);
        }
    }

    private void matchLocations(Return return_) {
        this.matchLocations(ILocation.getAnnotation((IElement)return_));
    }

    private void matchLocations(GotoEdge gotoEdge) {
        this.matchLocations(ILocation.getAnnotation((IElement)gotoEdge));
    }

    private void matchLocations(SequentialComposition sequentialComposition) {
        for (CodeBlock codeBlock : sequentialComposition.getCodeBlocks()) {
            this.matchLocations((IIcfgTransition<?>)codeBlock);
        }
    }

    private void matchLocations(StatementSequence statementSequence) {
        for (Statement statement : statementSequence.getStatements()) {
            this.matchLocations(statement);
        }
    }

    private void matchLocations(Statement statement) {
        if (statement instanceof AssumeStatement) {
            AssumeStatement assumeStatement = (AssumeStatement)statement;
            this.matchLocations(assumeStatement.getFormula().getLocation());
        } else {
            this.matchLocations(statement.getLocation());
        }
    }

    private void matchLocations(ILocation iLocation) {
        if (iLocation == null) {
            return;
        }
        if (iLocation.getStartLine() == iLocation.getEndLine()) {
            Set set = this.mLineNumber2WitnessLetter.getImage((Object)iLocation.getStartLine());
            if (set != null) {
                for (WitnessEdge witnessEdge : set) {
                    this.mSingleLineLocation2WitnessLetters.addPair((Object)iLocation, (Object)witnessEdge);
                    this.mWitnessLetters2SingleLineLocations.addPair((Object)witnessEdge, (Object)iLocation);
                }
            }
        } else {
            this.mMultiLineLocations.add(iLocation);
        }
    }
}

