/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtLibUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.MultiElementCounter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ManagedScript {
    private static final String MANAGED_SCRIPT_LOCKED_BY = "ManagedScript locked by ";
    protected final IUltimateServiceProvider mServices;
    protected final Script mScript;
    protected final ILogger mLogger;
    protected final VariableManager mVariableManager;
    private final SkolemFunctionManager mSkolemFunctionManager;
    private Object mLockOwner;

    public ManagedScript(IUltimateServiceProvider iUltimateServiceProvider, Script script) {
        this.mServices = iUltimateServiceProvider;
        this.mScript = script;
        this.mLogger = this.mServices.getLoggingService().getLogger(SmtLibUtils.PLUGIN_ID);
        this.mVariableManager = new VariableManager();
        this.mSkolemFunctionManager = new SkolemFunctionManager();
    }

    public void lock(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("cannot be locked by null");
        }
        if (this.mLockOwner == null) {
            this.mLockOwner = object;
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)(MANAGED_SCRIPT_LOCKED_BY + object.toString()));
            }
        } else {
            throw new IllegalStateException("ManagedScript already locked by " + this.mLockOwner.toString());
        }
    }

    public void unlock(Object object) {
        if (this.mLockOwner == null) {
            throw new IllegalStateException("ManagedScript not locked");
        }
        if (this.mLockOwner == object) {
            this.mLockOwner = null;
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("ManagedScript unlocked by " + object.toString()));
            }
        } else {
            throw new IllegalStateException(MANAGED_SCRIPT_LOCKED_BY + this.mLockOwner.toString());
        }
    }

    public boolean isLocked() {
        return this.mLockOwner != null;
    }

    public void assertScriptNotLocked() throws AssertionError {
        if (this.isLocked()) {
            throw new AssertionError((Object)("Script currently locked by " + String.valueOf(this.mLockOwner)));
        }
    }

    public boolean requestLockRelease() {
        if (this.mLockOwner == null) {
            throw new IllegalStateException("ManagedScript not locked");
        }
        if (this.mLockOwner instanceof ILockHolderWithVoluntaryLockRelease) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Asking " + String.valueOf(this.mLockOwner) + " to release lock"));
            }
            ((ILockHolderWithVoluntaryLockRelease)this.mLockOwner).releaseLock();
            return true;
        }
        return false;
    }

    public boolean isLockOwner(Object object) {
        return object == this.mLockOwner;
    }

    public void push(Object object, int n) throws SMTLIBException {
        assert (object == this.mLockOwner) : ManagedScript.generateLockErrorMessage(object, this.mLockOwner);
        this.mScript.push(n);
    }

    public void pop(Object object, int n) throws SMTLIBException {
        assert (object == this.mLockOwner) : ManagedScript.generateLockErrorMessage(object, this.mLockOwner);
        this.mScript.pop(n);
    }

    public Script.LBool assertTerm(Object object, Term term) throws SMTLIBException {
        assert (object == this.mLockOwner) : ManagedScript.generateLockErrorMessage(object, this.mLockOwner);
        return this.mScript.assertTerm(term);
    }

    public Script.LBool checkSat(Object object) throws SMTLIBException {
        assert (object == this.mLockOwner) : ManagedScript.generateLockErrorMessage(object, this.mLockOwner);
        return this.mScript.checkSat();
    }

    public Term[] getUnsatCore(Object object) throws SMTLIBException, UnsupportedOperationException {
        assert (object == this.mLockOwner) : ManagedScript.generateLockErrorMessage(object, this.mLockOwner);
        return this.mScript.getUnsatCore();
    }

    public Term annotate(Object object, Term term, Annotation ... annotationArray) throws SMTLIBException {
        assert (object == this.mLockOwner) : ManagedScript.generateLockErrorMessage(object, this.mLockOwner);
        return this.mScript.annotate(term, annotationArray);
    }

    public Term term(Object object, String string, Term ... termArray) throws SMTLIBException {
        assert (object == this.mLockOwner) : ManagedScript.generateLockErrorMessage(object, this.mLockOwner);
        return this.mScript.term(string, termArray);
    }

    public Term term(Object object, String string, String[] stringArray, Sort sort, Term ... termArray) throws SMTLIBException {
        assert (object == this.mLockOwner) : ManagedScript.generateLockErrorMessage(object, this.mLockOwner);
        return this.mScript.term(string, stringArray, sort, termArray);
    }

    public Term let(Object object, TermVariable[] termVariableArray, Term[] termArray, Term term) throws SMTLIBException {
        assert (object == this.mLockOwner) : ManagedScript.generateLockErrorMessage(object, this.mLockOwner);
        return this.mScript.let(termVariableArray, termArray, term);
    }

    public void declareFun(Object object, String string, Sort[] sortArray, Sort sort) throws SMTLIBException {
        assert (object == this.mLockOwner) : ManagedScript.generateLockErrorMessage(object, this.mLockOwner);
        this.mScript.declareFun(string, sortArray, sort);
    }

    public QuotedObject echo(Object object, QuotedObject quotedObject) {
        assert (object == this.mLockOwner) : ManagedScript.generateLockErrorMessage(object, this.mLockOwner);
        return this.mScript.echo(quotedObject);
    }

    public Map<Term, Term> getValue(Object object, Term[] termArray) {
        assert (object == this.mLockOwner) : ManagedScript.generateLockErrorMessage(object, this.mLockOwner);
        return this.mScript.getValue(termArray);
    }

    public Script getScript() {
        return this.mScript;
    }

    public Term[] getInterpolants(Object object, Term[] termArray) throws SMTLIBException, UnsupportedOperationException {
        assert (object == this.mLockOwner) : ManagedScript.generateLockErrorMessage(object, this.mLockOwner);
        return this.mScript.getInterpolants(termArray);
    }

    public Term[] getInterpolants(Object object, Term[] termArray, int[] nArray) throws SMTLIBException, UnsupportedOperationException {
        assert (object == this.mLockOwner) : ManagedScript.generateLockErrorMessage(object, this.mLockOwner);
        return this.mScript.getInterpolants(termArray, nArray);
    }

    private static String generateLockErrorMessage(Object object, Object object2) {
        if (object2 == null) {
            return "A " + object.getClass().getSimpleName() + " wants to use this ManagedScript without locking";
        }
        return "A " + object.getClass().getSimpleName() + " wants to use this ManagedScript but it is locked by some " + object2.getClass().getSimpleName();
    }

    public TermVariable constructFreshTermVariable(String string, Sort sort) {
        return this.mVariableManager.constructFreshTermVariable(string, sort);
    }

    public TermVariable constructFreshCopy(TermVariable termVariable) {
        return this.mVariableManager.constructFreshCopy(termVariable);
    }

    public Map<TermVariable, TermVariable> constructFreshCopies(Set<TermVariable> set) {
        LinkedHashMap<TermVariable, TermVariable> linkedHashMap = new LinkedHashMap<TermVariable, TermVariable>();
        for (TermVariable termVariable : set) {
            linkedHashMap.put(termVariable, this.constructFreshCopy(termVariable));
        }
        return linkedHashMap;
    }

    public TermVariable variable(String string, Sort sort) {
        return this.mVariableManager.variable(string, sort);
    }

    public String constructFreshSkolemFunctionName(Sort[] sortArray, Sort sort) {
        return this.mSkolemFunctionManager.constructFreshSkolemFunctionName(sortArray, sort);
    }

    @FunctionalInterface
    public static interface ILockHolderWithVoluntaryLockRelease {
        public void releaseLock();
    }

    private static class SkolemFunctionManager {
        private static final String SKOLEM_PREFIX = "skolem";
        private int counter;

        private SkolemFunctionManager() {
        }

        public String constructFreshSkolemFunctionName(Sort[] sortArray, Sort sort) {
            return SKOLEM_PREFIX + this.counter++;
        }
    }

    private class VariableManager {
        private final MultiElementCounter<String> mTvForBasenameCounter = new MultiElementCounter();
        private final Map<TermVariable, String> mTv2Basename = new HashMap<TermVariable, String>();
        private final Set<String> mVariableNames = new HashSet<String>();

        private VariableManager() {
        }

        public TermVariable constructFreshTermVariable(String string, Sort sort) {
            if (string.contains("|")) {
                throw new IllegalArgumentException("Name contains SMT quote characters " + string);
            }
            Integer n = this.mTvForBasenameCounter.increment((Object)string);
            TermVariable termVariable = ManagedScript.this.mScript.variable("v_" + string + "_" + String.valueOf(n), sort);
            this.mTv2Basename.put(termVariable, string);
            return termVariable;
        }

        public TermVariable constructFreshCopy(TermVariable termVariable) {
            String string = this.mTv2Basename.get(termVariable);
            if (string == null) {
                ManagedScript.this.mLogger.warn((Object)("TermVariable " + String.valueOf(termVariable) + " not constructed by VariableManager. Cannot ensure absence of name clashes."));
                string = SmtUtils.removeSmtQuoteCharacters(termVariable.getName());
            }
            TermVariable termVariable2 = this.constructFreshTermVariable(string, termVariable.getSort());
            return termVariable2;
        }

        public TermVariable variable(String string, Sort sort) {
            if (this.mVariableNames.contains(string)) {
                throw new IllegalArgumentException("A variable with that name was already constructed: " + string);
            }
            TermVariable termVariable = ManagedScript.this.mScript.variable(string, sort);
            this.mTv2Basename.put(termVariable, string);
            return termVariable;
        }
    }
}

