/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.index.IIndexFileLocation;
import org.eclipse.cdt.core.index.IIndexLinkage;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.index.IndexFilter;
import org.eclipse.cdt.core.parser.ISignificantMacros;
import org.eclipse.cdt.internal.core.index.IIndexFragmentBinding;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFile;
import org.eclipse.cdt.internal.core.index.IIndexFragmentFileSet;
import org.eclipse.cdt.internal.core.index.IIndexFragmentInclude;
import org.eclipse.cdt.internal.core.index.IIndexFragmentName;
import org.eclipse.cdt.internal.core.index.IIndexScope;
import org.eclipse.cdt.internal.core.pdom.IPDOM;
import org.eclipse.cdt.internal.core.pdom.PDOM;
import org.eclipse.cdt.internal.core.pdom.PDOMFileSet;
import org.eclipse.cdt.internal.core.pdom.WritablePDOM;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

public class PDOMProxy
implements IPDOM {
    private PDOM fDelegate;
    private int fReadLockCount;
    private Set<PDOM.IListener> fListeners = new HashSet<PDOM.IListener>();
    private Map<Thread, PDOM.DebugLockInfo> fLockDebugging;

    public PDOMProxy() {
        if (PDOM.sDEBUG_LOCKS) {
            this.fLockDebugging = new HashMap<Thread, PDOM.DebugLockInfo>();
        }
    }

    @Override
    public synchronized void acquireReadLock() throws InterruptedException {
        if (this.fDelegate != null) {
            this.fDelegate.acquireReadLock();
        } else {
            ++this.fReadLockCount;
            if (PDOM.sDEBUG_LOCKS) {
                PDOM.incReadLock(this.fLockDebugging);
            }
        }
    }

    @Override
    public IIndexMacro[] findMacros(char[] name, boolean isPrefix, boolean caseSensitive, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.findMacros(name, isPrefix, caseSensitive, filter, monitor);
        }
        return IIndexMacro.EMPTY_INDEX_MACRO_ARRAY;
    }

    @Override
    public synchronized IIndexFragmentBinding adaptBinding(IBinding binding) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.adaptBinding(binding);
        }
        return null;
    }

    @Override
    public synchronized IIndexFragmentBinding findBinding(IASTName astName) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.findBinding(astName);
        }
        return null;
    }

    @Override
    public synchronized IIndexFragmentBinding[] findBindings(char[][] names, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.findBindings(names, filter, monitor);
        }
        return IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
    }

    @Override
    public synchronized IIndexFragmentBinding[] findBindings(Pattern[] patterns, boolean isFullyQualified, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.findBindings(patterns, isFullyQualified, filter, monitor);
        }
        return IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
    }

    @Override
    public synchronized IIndexFragmentBinding[] findBindings(char[] name, boolean filescope, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.findBindings(name, filescope, filter, monitor);
        }
        return IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
    }

    @Override
    public synchronized IIndexFragmentBinding[] findBindingsForPrefix(char[] prefix, boolean filescope, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.findBindingsForPrefix(prefix, filescope, filter, monitor);
        }
        return IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
    }

    @Override
    public synchronized IIndexFragmentBinding[] findBindingsForContentAssist(char[] prefix, boolean filescope, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.findBindingsForContentAssist(prefix, filescope, filter, monitor);
        }
        return IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
    }

    @Override
    public synchronized IIndexFragmentInclude[] findIncludedBy(IIndexFragmentFile file) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.findIncludedBy(file);
        }
        return new IIndexFragmentInclude[0];
    }

    @Override
    public synchronized IIndexFragmentName[] findNames(IBinding binding, int flags) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.findNames(binding, flags);
        }
        return IIndexFragmentName.EMPTY_NAME_ARRAY;
    }

    @Override
    public synchronized long getCacheHits() {
        if (this.fDelegate != null) {
            return this.fDelegate.getCacheHits();
        }
        return 0L;
    }

    @Override
    public synchronized long getCacheMisses() {
        if (this.fDelegate != null) {
            return this.fDelegate.getCacheMisses();
        }
        return 0L;
    }

    @Override
    @Deprecated
    public synchronized IIndexFragmentFile getFile(int linkageID, IIndexFileLocation location) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.getFile(linkageID, location);
        }
        return null;
    }

    @Override
    public IIndexFragmentFile getFile(int linkageID, IIndexFileLocation location, ISignificantMacros sigMacros) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.getFile(linkageID, location, sigMacros);
        }
        return null;
    }

    @Override
    public IIndexFragmentFile[] getFiles(int linkageID, IIndexFileLocation location) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.getFiles(linkageID, location);
        }
        return IIndexFragmentFile.EMPTY_ARRAY;
    }

    @Override
    public synchronized IIndexFragmentFile[] getFiles(IIndexFileLocation location) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.getFiles(location);
        }
        return IIndexFragmentFile.EMPTY_ARRAY;
    }

    @Override
    public synchronized long getLastWriteAccess() {
        if (this.fDelegate != null) {
            return this.fDelegate.getLastWriteAccess();
        }
        return 0L;
    }

    @Override
    public synchronized IIndexLinkage[] getLinkages() {
        if (this.fDelegate != null) {
            return this.fDelegate.getLinkages();
        }
        return new IIndexLinkage[0];
    }

    @Override
    public synchronized String getProperty(String propertyName) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.getProperty(propertyName);
        }
        return null;
    }

    @Override
    public synchronized void releaseReadLock() {
        if (this.fReadLockCount > 0) {
            --this.fReadLockCount;
            if (PDOM.sDEBUG_LOCKS) {
                PDOM.decReadLock(this.fLockDebugging);
            }
        } else if (this.fDelegate != null) {
            this.fDelegate.releaseReadLock();
        }
    }

    @Override
    public boolean hasWaitingReaders() {
        return this.fDelegate != null && this.fDelegate.hasWaitingReaders();
    }

    @Override
    public synchronized void resetCacheCounters() {
        if (this.fDelegate != null) {
            this.fDelegate.resetCacheCounters();
        }
    }

    public synchronized <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(PDOMProxy.class)) {
            return adapter.cast(this);
        }
        return null;
    }

    @Override
    public synchronized void addListener(PDOM.IListener listener) {
        if (this.fDelegate != null) {
            this.fDelegate.addListener(listener);
        } else {
            this.fListeners.add(listener);
        }
    }

    @Override
    public synchronized PDOMLinkage[] getLinkageImpls() {
        if (this.fDelegate != null) {
            return this.fDelegate.getLinkageImpls();
        }
        return new PDOMLinkage[0];
    }

    @Override
    public synchronized void removeListener(PDOM.IListener listener) {
        if (this.fDelegate != null) {
            this.fDelegate.removeListener(listener);
        } else {
            this.fListeners.remove(listener);
        }
    }

    public synchronized void setDelegate(WritablePDOM pdom) {
        this.fDelegate = pdom;
        try {
            while (this.fReadLockCount > 0) {
                pdom.acquireReadLock();
                --this.fReadLockCount;
            }
            if (PDOM.sDEBUG_LOCKS) {
                pdom.adjustThreadForReadLock(this.fLockDebugging);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        for (PDOM.IListener listener : this.fListeners) {
            pdom.addListener(listener);
        }
        PDOM.ChangeEvent event = new PDOM.ChangeEvent();
        event.setReloaded();
        for (PDOM.IListener listener : this.fListeners) {
            listener.handleChange(this.fDelegate, event);
        }
    }

    @Override
    public IIndexFragmentFileSet createFileSet() {
        return new PDOMFileSet();
    }

    @Override
    public synchronized IIndexFragmentFile[] getAllFiles() throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.getAllFiles();
        }
        return IIndexFragmentFile.EMPTY_ARRAY;
    }

    @Override
    public synchronized IIndexFragmentFile[] getDefectiveFiles() throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.getDefectiveFiles();
        }
        return IIndexFragmentFile.EMPTY_ARRAY;
    }

    @Override
    public synchronized IIndexFragmentFile[] getFilesWithUnresolvedIncludes() throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.getFilesWithUnresolvedIncludes();
        }
        return IIndexFragmentFile.EMPTY_ARRAY;
    }

    @Override
    public synchronized IIndexFragmentBinding[] findMacroContainers(Pattern pattern, IndexFilter filter, IProgressMonitor monitor) throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.findMacroContainers(pattern, filter, monitor);
        }
        return IIndexFragmentBinding.EMPTY_INDEX_BINDING_ARRAY;
    }

    @Override
    public Object getCachedResult(Object key) {
        return null;
    }

    @Override
    public Object putCachedResult(Object key, Object value, boolean replace) {
        return value;
    }

    @Override
    public void clearResultCache() {
        if (this.fDelegate != null) {
            this.fDelegate.clearResultCache();
        }
    }

    @Override
    public IIndexScope[] getInlineNamespaces() throws CoreException {
        if (this.fDelegate != null) {
            return this.fDelegate.getInlineNamespaces();
        }
        return IIndexScope.EMPTY_INDEX_SCOPE_ARRAY;
    }

    @Override
    public synchronized boolean isFullyInitialized() {
        return this.fDelegate != null;
    }
}

