/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.parser;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.internal.core.Cygwin;
import org.eclipse.cdt.internal.core.pdom.indexer.IndexerPreferences;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.jobs.Job;

public class ResourceHelper {
    private static final IProgressMonitor NULL_MONITOR = new NullProgressMonitor();
    private static final int MAX_RETRY = 5;
    private static final Set<String> externalFilesCreated = new HashSet<String>();
    private static final Set<IResource> resourcesCreated = new HashSet<IResource>();

    public static IProject createCDTProject(String string, String string2) throws OperationCanceledException, CoreException {
        return ResourceHelper.createCDTProject(string, string2, null);
    }

    public static IProject createCDTProject(String string, String string2, String[] stringArray) throws OperationCanceledException, CoreException {
        IPath iPath;
        CCorePlugin cCorePlugin = CCorePlugin.getDefault();
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
        IProject iProject = iWorkspaceRoot.getProject(string);
        IndexerPreferences.set((IProject)iProject, (String)"indexerId", (String)"org.eclipse.cdt.core.nullindexer");
        resourcesCreated.add((IResource)iProject);
        IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(string);
        if (string2 != null) {
            iPath = iWorkspaceRoot.getLocation().append(string2);
            iProjectDescription.setLocation(iPath);
        }
        if (stringArray != null && stringArray.length > 0) {
            iPath = cCorePlugin.getProjectDescriptionManager();
            iProject.create(NULL_MONITOR);
            iProject.open(NULL_MONITOR);
            ICProjectDescription iCProjectDescription = iPath.createProjectDescription(iProject, false);
            ICConfigurationDescription iCConfigurationDescription = cCorePlugin.getPreferenceConfiguration("123");
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string3 = stringArray2[n2];
                iCProjectDescription.createConfiguration(string3, string3 + " Name", iCConfigurationDescription);
                ++n2;
            }
            iPath.setProjectDescription(iProject, iCProjectDescription);
        }
        iProject = cCorePlugin.createCDTProject(iProjectDescription, iProject, NULL_MONITOR);
        ResourceHelper.waitForProjectRefreshToFinish();
        iProject.open(null);
        return iProject;
    }

    public static IProject createCDTProject(String string, URI uRI) throws OperationCanceledException, CoreException {
        IWorkspace iWorkspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot iWorkspaceRoot = iWorkspace.getRoot();
        IProject iProject = iWorkspaceRoot.getProject(string);
        IndexerPreferences.set((IProject)iProject, (String)"indexerId", (String)"org.eclipse.cdt.core.nullindexer");
        resourcesCreated.add((IResource)iProject);
        IProjectDescription iProjectDescription = iWorkspace.newProjectDescription(string);
        iProjectDescription.setLocationURI(uRI);
        iProject = CCorePlugin.getDefault().createCDTProject(iProjectDescription, iProject, NULL_MONITOR);
        ResourceHelper.waitForProjectRefreshToFinish();
        iProject.open(null);
        return iProject;
    }

    public static IProject createCDTProject(String string) throws OperationCanceledException, CoreException {
        return ResourceHelper.createCDTProject(string, null, null);
    }

    public static IProject createCDTProjectWithConfig(String string) throws Exception {
        IProject iProject = ResourceHelper.createCDTProject(string, null, new String[]{"org.eclipse.cdt.core.tests.configuration"});
        resourcesCreated.add((IResource)iProject);
        return iProject;
    }

    public static IProject createProject(String string) throws CoreException {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject = iWorkspaceRoot.getProject(string);
        if (!iProject.exists()) {
            iProject.create(NULL_MONITOR);
        } else {
            iProject.refreshLocal(2, null);
        }
        if (!iProject.isOpen()) {
            iProject.open(NULL_MONITOR);
        }
        resourcesCreated.add((IResource)iProject);
        return iProject;
    }

    public static void deleteProject(String string) throws CoreException {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IProject iProject = iWorkspaceRoot.getProject(string);
        if (iProject.exists()) {
            ResourceHelper.delete(iProject);
        }
    }

    public static void delete(IProject iProject) throws CoreException {
        ResourceHelper.delete(iProject, true);
    }

    public static void delete(IProject iProject, boolean bl) throws CoreException {
        int n = 0;
        while (n < 5) {
            try {
                iProject.delete(bl, true, NULL_MONITOR);
                n = 5;
            }
            catch (CoreException coreException) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            ++n;
        }
    }

    public static IFile createFile(IFile iFile, String string) throws CoreException {
        if (string == null) {
            string = "";
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        iFile.create((InputStream)byteArrayInputStream, true, NULL_MONITOR);
        resourcesCreated.add((IResource)iFile);
        return iFile;
    }

    public static IFile createFile(IProject iProject, String string) throws CoreException {
        if (new Path(string).segmentCount() > 1) {
            ResourceHelper.createFolder(iProject, new Path(string).removeLastSegments(1).toString());
        }
        return ResourceHelper.createFile(iProject.getFile(string), null);
    }

    public static IFile createFile(IProject iProject, File file) throws CoreException, FileNotFoundException {
        if (new Path(file.getName()).segmentCount() > 1) {
            ResourceHelper.createFolder(iProject, new Path(file.getName()).removeLastSegments(1).toString());
        }
        String string = new Scanner(file).useDelimiter("\\Z").next();
        return ResourceHelper.createFile(iProject.getFile(file.getName()), string);
    }

    public static IPath createWorkspaceFile(String string) throws CoreException, IOException {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IPath iPath = iWorkspaceRoot.getLocation().append(string);
        File file = new File(iPath.toOSString());
        if (!file.exists()) {
            file.createNewFile();
        }
        externalFilesCreated.add(iPath.toOSString());
        iWorkspaceRoot.refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        return iPath;
    }

    public static IFolder createFolder(IProject iProject, String string) throws CoreException {
        Path path = new Path(string);
        IProject iProject2 = iProject;
        String[] stringArray = path.segments();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String string2 = stringArray[n2];
            if (!(iProject2 = iProject2.getFolder((IPath)new Path(string2))).exists()) {
                ((IFolder)iProject2).create(true, true, NULL_MONITOR);
            }
            ++n2;
        }
        resourcesCreated.add((IResource)iProject2);
        return (IFolder)iProject2;
    }

    public static IPath createWorkspaceFolder(String string) throws CoreException, IOException {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        IPath iPath = iWorkspaceRoot.getLocation().append(string);
        File file = new File(iPath.toOSString());
        if (!file.exists()) {
            file.mkdirs();
        }
        externalFilesCreated.add(iPath.toOSString());
        iWorkspaceRoot.refreshLocal(2, NULL_MONITOR);
        return iPath;
    }

    public static IPath createTemporaryFolder() throws CoreException, IOException {
        return ResourceHelper.createWorkspaceFolder("tmp/" + System.currentTimeMillis() + "." + String.valueOf(UUID.randomUUID()));
    }

    public static IFile createLinkedFile(IProject iProject, String string, IPath iPath) throws CoreException {
        IFile iFile = iProject.getFile(string);
        iFile.createLink(iPath, 256, null);
        resourcesCreated.add((IResource)iFile);
        return iFile;
    }

    public static IFile createLinkedFile(IProject iProject, String string, String string2) throws CoreException {
        return ResourceHelper.createLinkedFile(iProject, string, (IPath)new Path(string2));
    }

    public static IFile createEfsFile(IProject iProject, String string, URI uRI) throws CoreException {
        IFile iFile = iProject.getFile(string);
        iFile.createLink(uRI, 16, NULL_MONITOR);
        resourcesCreated.add((IResource)iFile);
        return iFile;
    }

    public static IFile createEfsFile(IProject iProject, String string, String string2) throws CoreException, URISyntaxException {
        return ResourceHelper.createEfsFile(iProject, string, new URI(string2));
    }

    public static IFolder createLinkedFolder(IProject iProject, String string, IPath iPath) throws CoreException {
        IFolder iFolder = iProject.getFolder(string);
        iFolder.createLink(iPath, 272, null);
        resourcesCreated.add((IResource)iFolder);
        return iFolder;
    }

    public static IFolder createLinkedFolder(IProject iProject, String string, String string2) throws CoreException {
        return ResourceHelper.createLinkedFolder(iProject, string, (IPath)new Path(string2));
    }

    public static IFolder createEfsFolder(IProject iProject, String string, URI uRI) throws CoreException {
        IFolder iFolder = iProject.getFolder(string);
        if (iFolder.exists()) {
            System.out.println("Folder with the same name but different location already exists");
            return iFolder;
        }
        iFolder.createLink(uRI, 16, (IProgressMonitor)new NullProgressMonitor());
        resourcesCreated.add((IResource)iFolder);
        return iFolder;
    }

    public static IFolder createEfsFolder(IProject iProject, String string, String string2) throws CoreException, URISyntaxException {
        return ResourceHelper.createEfsFolder(iProject, string, new URI(string2));
    }

    public static boolean isSymbolicLinkSupported() {
        return !Platform.getOS().equals("win32");
    }

    public static String windowsToCygwinPath(String string) throws IOException, UnsupportedOperationException {
        return Cygwin.windowsToCygwinPath((String)string);
    }

    public static String cygwinToWindowsPath(String string) throws IOException, UnsupportedOperationException {
        return Cygwin.cygwinToWindowsPath((String)string);
    }

    public static String getContents(IPath iPath) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(iPath.toFile());){
            int n;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, Charset.defaultCharset()));
            StringBuilder stringBuilder = new StringBuilder();
            char[] cArray = new char[8192];
            while ((n = ((Reader)bufferedReader).read(cArray, 0, cArray.length)) > 0) {
                stringBuilder.append(cArray, 0, n);
            }
            String string = stringBuilder.toString();
            return string;
        }
    }

    public static String getContents(String string) throws IOException {
        return ResourceHelper.getContents((IPath)new Path(string));
    }

    @Deprecated
    public static void cleanUp() throws CoreException, IOException {
        ResourceHelper.cleanUp("<unknown>");
    }

    public static void cleanUp(String string) throws CoreException, IOException {
        IWorkspaceRoot iWorkspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        iWorkspaceRoot.refreshLocal(2, NULL_MONITOR);
        ResourceHelper.joinIndexerBeforeCleanup(string);
        for (String string2 : externalFilesCreated) {
            File file = new File(string2);
            if (!file.exists()) continue;
            ResourceHelper.deleteRecursive(file);
        }
        externalFilesCreated.clear();
        for (IResource iResource : resourcesCreated) {
            if (!iResource.exists()) continue;
            try {
                iResource.delete(true, NULL_MONITOR);
            }
            catch (CoreException coreException) {}
        }
        resourcesCreated.clear();
    }

    public static void joinIndexerBeforeCleanup(String string) {
        boolean bl;
        if (!CCorePlugin.getIndexManager().isIndexerIdle() && !(bl = CCorePlugin.getIndexManager().joinIndexer(2000, (IProgressMonitor)new NullProgressMonitor()))) {
            System.err.println("Indexer did not stop runing, possible deadlock about to happen. Running test " + string);
        }
    }

    private static void waitForProjectRefreshToFinish() {
        try {
            Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_REFRESH, null);
        }
        catch (Exception exception) {}
    }

    private static final void deleteRecursive(File file) throws IllegalArgumentException {
        if (!file.getAbsolutePath().startsWith(ResourcesPlugin.getWorkspace().getRoot().getLocation().toFile().getAbsolutePath())) {
            throw new IllegalArgumentException("File must exist within the workspace!");
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File file2 = fileArray[n2];
                ResourceHelper.deleteRecursive(file2);
                ++n2;
            }
        }
        file.delete();
    }

    public static void addResourceCreated(IResource iResource) {
        if (iResource != null) {
            resourcesCreated.add(iResource);
        }
    }
}

