/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.optncsb.inclusion;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

class StateContainer<LETTER, STATE> {
    protected final STATE mState;
    private Map<LETTER, Set<STATE>> mInternalOut = new HashMap<LETTER, Set<STATE>>();
    private Map<LETTER, Set<STATE>> mInternalIn = new HashMap<LETTER, Set<STATE>>();
    private final Set<LETTER> mEmptySetOfLetters = new HashSet<LETTER>(0);

    public StateContainer(STATE STATE) {
        this.mState = STATE;
    }

    protected STATE getState() {
        return this.mState;
    }

    protected void addInternalOutgoing(OutgoingInternalTransition<LETTER, STATE> outgoingInternalTransition) {
        Set<STATE> set;
        LETTER LETTER = outgoingInternalTransition.getLetter();
        STATE STATE = outgoingInternalTransition.getSucc();
        if (this.mInternalOut == null) {
            this.mInternalOut = new HashMap<LETTER, Set<STATE>>();
        }
        if ((set = this.mInternalOut.get(LETTER)) == null) {
            set = new HashSet<STATE>();
            this.mInternalOut.put(LETTER, set);
        }
        set.add(STATE);
    }

    protected void addInternalIncoming(IncomingInternalTransition<LETTER, STATE> incomingInternalTransition) {
        Set<STATE> set;
        LETTER LETTER = incomingInternalTransition.getLetter();
        STATE STATE = incomingInternalTransition.getPred();
        if (this.mInternalIn == null) {
            this.mInternalIn = new HashMap<LETTER, Set<STATE>>();
        }
        if ((set = this.mInternalIn.get(LETTER)) == null) {
            set = new HashSet<STATE>();
            this.mInternalIn.put(LETTER, set);
        }
        set.add(STATE);
    }

    protected void removeSuccessor(STATE STATE) {
        HashMap<LETTER, Set<STATE>> hashMap = new HashMap<LETTER, Set<STATE>>();
        for (Map.Entry<LETTER, Set<STATE>> entry : this.mInternalOut.entrySet()) {
            Set<STATE> set = entry.getValue();
            if (set.contains(STATE)) {
                set.remove(STATE);
            }
            if (set.isEmpty()) continue;
            hashMap.put(entry.getKey(), set);
        }
        this.mInternalOut = hashMap;
    }

    protected void removePredecessors(Set<STATE> set) {
        HashMap<LETTER, Set<STATE>> hashMap = new HashMap<LETTER, Set<STATE>>();
        for (Map.Entry<LETTER, Set<STATE>> entry : this.mInternalIn.entrySet()) {
            Set<STATE> set2 = entry.getValue();
            set2.removeAll(set);
            if (set2.isEmpty()) continue;
            hashMap.put(entry.getKey(), set2);
        }
        this.mInternalIn = hashMap;
    }

    protected LETTER getLetterOfSuccessor(STATE STATE) {
        for (Map.Entry<LETTER, Set<STATE>> entry : this.mInternalOut.entrySet()) {
            Set<STATE> set = entry.getValue();
            if (!set.contains(STATE)) continue;
            return entry.getKey();
        }
        return null;
    }

    protected LETTER getLetterOfPredecessor(STATE STATE) {
        for (Map.Entry<LETTER, Set<STATE>> entry : this.mInternalIn.entrySet()) {
            Set<STATE> set = entry.getValue();
            if (!set.contains(STATE)) continue;
            return entry.getKey();
        }
        return null;
    }

    protected boolean hashSelfloop() {
        for (Set<STATE> set : this.mInternalOut.values()) {
            if (!set.contains(this.mState)) continue;
            return true;
        }
        return false;
    }

    public Set<LETTER> lettersInternalIncoming() {
        Map<LETTER, Set<STATE>> map = this.mInternalIn;
        return map == null ? this.mEmptySetOfLetters : map.keySet();
    }

    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors() {
        return () -> new Iterator<OutgoingInternalTransition<LETTER, STATE>>(){
            private Iterator<LETTER> mLetterIterator;
            private LETTER mCurrentLetter;
            private Iterator<OutgoingInternalTransition<LETTER, STATE>> mCurrentIterator;
            {
                this.mLetterIterator = StateContainer.this.mInternalOut.keySet().iterator();
                this.nextLetter();
            }

            private void nextLetter() {
                if (this.mLetterIterator.hasNext()) {
                    do {
                        this.mCurrentLetter = this.mLetterIterator.next();
                        this.mCurrentIterator = StateContainer.this.internalSuccessors(this.mCurrentLetter).iterator();
                    } while (!this.mCurrentIterator.hasNext() && this.mLetterIterator.hasNext());
                    if (!this.mCurrentIterator.hasNext()) {
                        this.mCurrentLetter = null;
                        this.mCurrentIterator = null;
                    }
                } else {
                    this.mCurrentLetter = null;
                    this.mCurrentIterator = null;
                }
            }

            @Override
            public boolean hasNext() {
                return this.mCurrentLetter != null;
            }

            @Override
            public OutgoingInternalTransition<LETTER, STATE> next() {
                if (this.mCurrentLetter == null) {
                    throw new NoSuchElementException();
                }
                OutgoingInternalTransition outgoingInternalTransition = this.mCurrentIterator.next();
                if (!this.mCurrentIterator.hasNext()) {
                    this.nextLetter();
                }
                return outgoingInternalTransition;
            }
        };
    }

    public Iterable<OutgoingInternalTransition<LETTER, STATE>> internalSuccessors(final LETTER LETTER) {
        return () -> new Iterator<OutgoingInternalTransition<LETTER, STATE>>(){
            private final Iterator<STATE> mIterator = this.initialize();

            private Iterator<STATE> initialize() {
                Map map = StateContainer.this.mInternalOut;
                if (map != null && map.get(LETTER) != null) {
                    return map.get(LETTER).iterator();
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.mIterator != null && this.mIterator.hasNext();
            }

            @Override
            public OutgoingInternalTransition<LETTER, STATE> next() {
                if (this.mIterator == null) {
                    throw new NoSuchElementException();
                }
                Object STATE = this.mIterator.next();
                return new OutgoingInternalTransition(LETTER, STATE);
            }
        };
    }

    public Iterable<IncomingInternalTransition<LETTER, STATE>> internalPredecessors() {
        return () -> new Iterator<IncomingInternalTransition<LETTER, STATE>>(){
            private Iterator<LETTER> mLetterIterator;
            private LETTER mCurrentLetter;
            private Iterator<IncomingInternalTransition<LETTER, STATE>> mCurrentIterator;
            {
                this.mLetterIterator = StateContainer.this.lettersInternalIncoming().iterator();
                this.nextLetter();
            }

            private void nextLetter() {
                if (this.mLetterIterator.hasNext()) {
                    do {
                        this.mCurrentLetter = this.mLetterIterator.next();
                        this.mCurrentIterator = StateContainer.this.internalPredecessors(this.mCurrentLetter).iterator();
                    } while (!this.mCurrentIterator.hasNext() && this.mLetterIterator.hasNext());
                    if (!this.mCurrentIterator.hasNext()) {
                        this.mCurrentLetter = null;
                        this.mCurrentIterator = null;
                    }
                } else {
                    this.mCurrentLetter = null;
                    this.mCurrentIterator = null;
                }
            }

            @Override
            public boolean hasNext() {
                return this.mCurrentLetter != null;
            }

            @Override
            public IncomingInternalTransition<LETTER, STATE> next() {
                if (this.mCurrentLetter == null) {
                    throw new NoSuchElementException();
                }
                IncomingInternalTransition incomingInternalTransition = this.mCurrentIterator.next();
                if (!this.mCurrentIterator.hasNext()) {
                    this.nextLetter();
                }
                return incomingInternalTransition;
            }
        };
    }

    public Iterable<IncomingInternalTransition<LETTER, STATE>> internalPredecessors(final LETTER LETTER) {
        return () -> new Iterator<IncomingInternalTransition<LETTER, STATE>>(){
            private final Iterator<STATE> mIterator = this.initialize();

            private Iterator<STATE> initialize() {
                Map map = StateContainer.this.mInternalIn;
                if (map != null && map.get(LETTER) != null) {
                    return map.get(LETTER).iterator();
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return this.mIterator != null && this.mIterator.hasNext();
            }

            @Override
            public IncomingInternalTransition<LETTER, STATE> next() {
                if (this.mIterator == null) {
                    throw new NoSuchElementException();
                }
                Object STATE = this.mIterator.next();
                return new IncomingInternalTransition(STATE, LETTER);
            }
        };
    }
}

