/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant;

import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.convert.Clausifier;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.SourceAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantEquality;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.QuantifierTheory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.quant.SubstitutionHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class DestructiveEqualityReasoning {
    private final QuantifierTheory mQuantTheory;
    private final Clausifier mClausifier;
    private final TermVariable[] mVars;
    private final Literal[] mGroundLits;
    private final QuantLiteral[] mQuantLits;
    private final SourceAnnotation mSource;
    private final Map<TermVariable, Term> mSigma;
    private boolean mIsChanged;
    private DERResult mResult;

    DestructiveEqualityReasoning(QuantifierTheory quantifierTheory, TermVariable[] termVariableArray, Literal[] literalArray, QuantLiteral[] quantLiteralArray, SourceAnnotation sourceAnnotation) {
        this.mQuantTheory = quantifierTheory;
        this.mClausifier = quantifierTheory.getClausifier();
        this.mVars = termVariableArray;
        this.mGroundLits = literalArray;
        this.mQuantLits = quantLiteralArray;
        this.mSource = sourceAnnotation;
        this.mSigma = new LinkedHashMap<TermVariable, Term>();
        this.mIsChanged = false;
        this.mResult = null;
    }

    boolean applyDestructiveEqualityReasoning() {
        this.collectSubstitution();
        if (!this.mSigma.isEmpty()) {
            SubstitutionHelper substitutionHelper = new SubstitutionHelper(this.mQuantTheory, this.mGroundLits, this.mQuantLits, this.mSource, this.mSigma);
            SubstitutionHelper.SubstitutionResult substitutionResult = substitutionHelper.substituteInClause();
            Term[] termArray = new Term[this.mVars.length];
            int n = 0;
            while (n < termArray.length) {
                termArray[n] = this.mSigma.containsKey(this.mVars[n]) ? this.mSigma.get(this.mVars[n]) : this.mVars[n];
                ++n;
            }
            this.mResult = new DERResult(termArray, substitutionResult);
            this.mIsChanged = true;
        }
        return this.mIsChanged;
    }

    DERResult getResult() {
        assert (this.mIsChanged) : "Should only be called if DER has changed the clause.";
        return this.mResult;
    }

    private void collectSubstitution() {
        Object object;
        Object object2;
        TermVariable termVariable;
        Object object3;
        Object object42;
        LinkedHashMap<TermVariable, Object> linkedHashMap = new LinkedHashMap<TermVariable, Object>();
        LinkedHashMap linkedHashMap2 = new LinkedHashMap();
        Object object52 = this.mQuantLits;
        int n = this.mQuantLits.length;
        int n2 = 0;
        while (n2 < n) {
            object42 = object52[n2];
            if (((QuantLiteral)object42).mIsDERUsable) {
                Term term;
                assert (object42 instanceof QuantLiteral.NegQuantLiteral && ((QuantLiteral)object42).getAtom() instanceof QuantEquality);
                object3 = (QuantEquality)((QuantLiteral)object42).mAtom;
                assert (((QuantEquality)object3).getLhs() instanceof TermVariable);
                termVariable = (TermVariable)((QuantEquality)object3).getLhs();
                object2 = this.findRep(termVariable);
                object = ((QuantEquality)object3).getRhs();
                if (object2 instanceof TermVariable) {
                    if (object.getFreeVars().length == 0 || object instanceof TermVariable) {
                        linkedHashMap.put((TermVariable)object2, object);
                    } else {
                        if (!linkedHashMap2.containsKey(object2)) {
                            linkedHashMap2.put(termVariable, new ArrayList());
                        }
                        ((List)linkedHashMap2.get(termVariable)).add(object);
                    }
                } else if (object instanceof TermVariable && (term = this.findRep((TermVariable)object)) instanceof TermVariable) {
                    linkedHashMap.put((TermVariable)term, object2);
                }
            }
            ++n2;
        }
        if (!linkedHashMap.isEmpty()) {
            object42 = new HashSet();
            for (TermVariable termVariable2 : linkedHashMap.keySet()) {
                if (object42.contains(termVariable2)) continue;
                object52 = new LinkedHashSet();
                object3 = termVariable2;
                while (object3 instanceof TermVariable && !object42.contains(object3)) {
                    object42.add((TermVariable)object3);
                    object52.add((TermVariable)object3);
                    if (!linkedHashMap.containsKey(object3)) continue;
                    object3 = (Term)linkedHashMap.get(object3);
                }
                object2 = object52.iterator();
                while (object2.hasNext()) {
                    termVariable = (TermVariable)object2.next();
                    if (termVariable == object3) continue;
                    this.mSigma.put(termVariable, (Term)object3);
                    if (object3 instanceof TermVariable) continue;
                    linkedHashMap2.remove(termVariable);
                }
            }
        }
        if (!linkedHashMap2.isEmpty()) {
            for (Object object42 : linkedHashMap2.keySet()) {
                Term term = this.findRep((TermVariable)object42);
                if (!(term instanceof TermVariable)) continue;
                for (Object object52 : (List)linkedHashMap2.get(object42)) {
                    if (this.hasCycle((TermVariable)object42, (Term)object52)) continue;
                    termVariable = new FormulaUnLet();
                    termVariable.addSubstitutions(this.mSigma);
                    object2 = termVariable.unlet((Term)object52);
                    object = this.mClausifier.getTracker();
                    object2 = object.getProvedTerm(this.mClausifier.getTermCompiler().transform((Term)object2));
                    this.mSigma.put((TermVariable)term, (Term)object2);
                }
            }
        }
    }

    private Term findRep(TermVariable termVariable) {
        TermVariable termVariable2 = termVariable;
        while (this.mSigma.containsKey(termVariable2)) {
            Term term = this.mSigma.get(termVariable2);
            if (term instanceof TermVariable) {
                termVariable2 = (TermVariable)term;
                continue;
            }
            return term;
        }
        return termVariable2;
    }

    private boolean hasCycle(TermVariable termVariable, Term term) {
        assert (term.getFreeVars().length > 0);
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable termVariable2 = termVariableArray[n2];
            if (Arrays.asList(this.findRep(termVariable2).getFreeVars()).contains(termVariable)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static class DERResult
    extends SubstitutionHelper.SubstitutionResult {
        private final Term[] mSubs;

        protected DERResult(Term[] termArray, SubstitutionHelper.SubstitutionResult substitutionResult) {
            super(substitutionResult.mSubstituted, substitutionResult.mSimplified, substitutionResult.mGroundLits, substitutionResult.mQuantLits);
            this.mSubs = termArray;
        }

        public Term[] getSubs() {
            return this.mSubs;
        }
    }
}

