/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CuckooHashSet<E>
extends AbstractSet<E> {
    private static final int DEFAULT_SIZE_LOG_2 = 5;
    protected int mLog2buckets = 5;
    protected Object[] mBuckets;
    protected E mStash;
    private int mSize;

    public CuckooHashSet(int n) {
        this.mLog2buckets = CuckooHashSet.log2(2 * n);
        this.mBuckets = new Object[1 << this.mLog2buckets];
    }

    public CuckooHashSet() {
        this.mLog2buckets = 5;
        this.mBuckets = new Object[32];
    }

    protected int hash(Object object) {
        return CuckooHashSet.hashJenkins(object.hashCode());
    }

    protected static int hashJenkins(int n) {
        n += n << 12;
        n ^= n >>> 22;
        n += n << 4;
        n ^= n >>> 9;
        n += n << 10;
        n ^= n >>> 2;
        n += n << 7;
        n ^= n >>> 12;
        return n;
    }

    protected final int hash1(int n) {
        return n & this.mBuckets.length - 1;
    }

    protected final int hash2(int n) {
        n = CuckooHashSet.hashJenkins(n);
        n = (n >>> this.mLog2buckets & this.mBuckets.length - 1) + (n & this.mBuckets.length - 1) + 1;
        n = n + (n >>> this.mLog2buckets) & this.mBuckets.length - 1;
        return n;
    }

    private boolean containsStash(Object object) {
        return object.equals(this.mStash);
    }

    @Override
    public boolean contains(Object object) {
        int n = this.hash(object);
        int n2 = this.hash1(n);
        if (object.equals(this.mBuckets[n2])) {
            return true;
        }
        if (object.equals(this.mBuckets[this.hash2(n) ^ n2])) {
            return true;
        }
        return this.mStash != null && this.containsStash(object);
    }

    private void resize() {
        Object[] objectArray = this.mBuckets;
        E e = this.mStash;
        this.mStash = null;
        ++this.mLog2buckets;
        this.mBuckets = new Object[1 << this.mLog2buckets];
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] != null) {
                this.add_internal(this.hash1(this.hash(objectArray[n])), objectArray[n]);
            }
            ++n;
        }
        this.add_internal(this.hash1(this.hash(e)), e);
    }

    private void add_internal(int n, E object) {
        int n2 = this.mBuckets.length >> 2;
        boolean bl = false;
        while (true) {
            assert (this.checkpos(n));
            Object object2 = this.mBuckets[n];
            this.mBuckets[n] = object;
            assert (this.checkpos(n));
            if (object2 == null) {
                return;
            }
            object = object2;
            n ^= this.hash2(this.hash(object));
            if (n2-- != 0) continue;
            if (this.mStash == null) {
                this.mStash = object;
                return;
            }
            if (!bl) {
                E e = this.mStash;
                this.mStash = object;
                object = e;
                bl = true;
            } else {
                this.resize();
            }
            n2 = this.mBuckets.length >> 2;
            n = this.hash1(this.hash(object));
        }
    }

    private boolean checkpos(int n) {
        if (this.mBuckets[n] != null) {
            int n2 = this.hash(this.mBuckets[n]);
            int n3 = this.hash1(n2);
            int n4 = n3 ^ this.hash2(n2);
            assert (n3 == n || n4 == n);
        }
        return true;
    }

    private boolean invariant() {
        assert (this.mSize >= 0);
        int n = 0;
        int n2 = 0;
        while (n2 < this.mBuckets.length) {
            assert (this.checkpos(n2));
            if (this.mBuckets[n2] != null) {
                ++n;
            }
            ++n2;
        }
        if (this.mStash != null) {
            ++n;
        }
        assert (this.mSize == n);
        return true;
    }

    @Override
    public boolean add(E e) {
        int n = this.hash(e);
        int n2 = this.hash1(n);
        if (e.equals(this.mBuckets[n2])) {
            return false;
        }
        if (e.equals(this.mBuckets[this.hash2(n) ^ n2])) {
            return false;
        }
        if (this.mStash != null && this.containsStash(e)) {
            return false;
        }
        if (this.mBuckets[n2] == null) {
            this.mBuckets[n2] = e;
        } else {
            this.add_internal(n2, e);
        }
        ++this.mSize;
        return true;
    }

    @Override
    public boolean remove(Object object) {
        int n = this.hash(object);
        int n2 = this.hash1(n);
        if (object.equals(this.mBuckets[n2])) {
            --this.mSize;
            assert (this.mSize >= 0);
            this.mBuckets[n2] = null;
            return true;
        }
        if (object.equals(this.mBuckets[n2 ^= this.hash2(n)])) {
            --this.mSize;
            assert (this.mSize >= 0);
            this.mBuckets[n2] = null;
            return true;
        }
        if (this.mStash != null && object.equals(this.mStash)) {
            --this.mSize;
            assert (this.mSize >= 0);
            this.mStash = null;
            return true;
        }
        return false;
    }

    private static final int log2(int n) {
        int n2 = 4;
        int n3 = 2;
        while (n2 < n) {
            n2 += n2;
            ++n3;
        }
        return n3;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int mLastPos = -1;
            int mPos = 0;

            @Override
            public boolean hasNext() {
                while (this.mPos < CuckooHashSet.this.mBuckets.length && CuckooHashSet.this.mBuckets[this.mPos] == null) {
                    ++this.mPos;
                }
                if (this.mPos == CuckooHashSet.this.mBuckets.length && CuckooHashSet.this.mStash == null) {
                    ++this.mPos;
                }
                return this.mPos <= CuckooHashSet.this.mBuckets.length;
            }

            @Override
            public E next() {
                while (this.mPos < CuckooHashSet.this.mBuckets.length && CuckooHashSet.this.mBuckets[this.mPos] == null) {
                    ++this.mPos;
                }
                this.mLastPos = this.mPos;
                if (this.mPos < CuckooHashSet.this.mBuckets.length) {
                    return CuckooHashSet.this.mBuckets[this.mPos++];
                }
                if (this.mPos == CuckooHashSet.this.mBuckets.length && CuckooHashSet.this.mStash != null) {
                    ++this.mPos;
                    return CuckooHashSet.this.mStash;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (this.mLastPos < CuckooHashSet.this.mBuckets.length) {
                    CuckooHashSet.this.mBuckets[this.mLastPos] = null;
                } else {
                    CuckooHashSet.this.mStash = null;
                }
                --CuckooHashSet.this.mSize;
                if (!$assertionsDisabled && CuckooHashSet.this.mSize < 0) {
                    throw new AssertionError();
                }
            }
        };
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public void clear() {
        this.mSize = 0;
        int n = 0;
        while (n < this.mBuckets.length) {
            this.mBuckets[n] = null;
            ++n;
        }
        this.mStash = null;
    }

    public E removeSome() {
        if (this.mSize == 0) {
            return null;
        }
        --this.mSize;
        assert (this.mSize >= 0);
        if (this.mStash != null) {
            E e = this.mStash;
            this.mStash = null;
            return e;
        }
        int n = 0;
        while (true) {
            if (this.mBuckets[n] != null) {
                Object object = this.mBuckets[n];
                this.mBuckets[n] = null;
                return (E)object;
            }
            ++n;
        }
    }
}

