/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.logic;

import de.uni_freiburg.informatik.ultimate.logic.PrintTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnifyHash;
import java.util.Arrays;

public class SortSymbol {
    static final int INTERNAL = 1;
    static final int TYPEPARAM = 2;
    static final int INDEXED = 4;
    static final int NUMERIC = 8;
    static final int ARRAY = 16;
    static final int DATATYPE = 32;
    static final int FUNCTION = 64;
    final Theory mTheory;
    final String mName;
    final int mNumParams;
    final int mFlags;
    final Object mSorts;
    final Sort mSortDefinition;

    SortSymbol(Theory theory, String string, int n, Sort sort, int n2) {
        this.mTheory = theory;
        this.mName = string;
        this.mFlags = n2;
        this.mNumParams = n;
        this.mSortDefinition = sort;
        this.mSorts = (this.mFlags & 2) != 0 || (this.mFlags & 4) == 0 && this.mNumParams == 0 ? new Sort(this, null, new Sort[0]) : new UnifyHash();
    }

    public boolean isIntern() {
        return (this.mFlags & 1) != 0;
    }

    public String getName() {
        return this.mName;
    }

    public String toString() {
        return "(" + PrintTerm.quoteIdentifier(this.mName) + " " + this.mNumParams + ")";
    }

    public void checkArity(String[] stringArray, int n) {
        if (stringArray != null) {
            throw new IllegalArgumentException("Indexed Sort " + this.mName + " undefined");
        }
        if (n != ((this.mFlags & 2) == 0 ? this.mNumParams : 0)) {
            throw new IllegalArgumentException("Wrong number of arguments for sort " + this.mName);
        }
    }

    public Sort getSort(String[] stringArray, Sort ... sortArray) {
        Sort sort2;
        this.checkArity(stringArray, sortArray.length);
        if ((this.mFlags & 4) == 0 && sortArray.length == 0) {
            return (Sort)this.mSorts;
        }
        UnifyHash unifyHash = (UnifyHash)this.mSorts;
        int n = Arrays.hashCode(stringArray) ^ Arrays.hashCode(sortArray);
        for (Sort sort2 : unifyHash.iterateHashCode(n)) {
            if (!Arrays.equals(sort2.getArguments(), sortArray) || !Arrays.equals(sort2.getIndices(), stringArray)) continue;
            return sort2;
        }
        sort2 = new Sort(this, stringArray, sortArray);
        unifyHash.put(n, (Object)sort2);
        return sort2;
    }

    public boolean isSortVariable() {
        return (this.mFlags & 2) != 0;
    }

    public boolean isNumeric() {
        return (this.mFlags & 8) != 0;
    }

    public boolean isArray() {
        return (this.mFlags & 0x10) != 0;
    }

    public boolean isDatatype() {
        return (this.mFlags & 0x20) != 0;
    }

    public boolean isFunction() {
        return (this.mFlags & 0x40) != 0;
    }

    public int hashCode() {
        return this.mName.hashCode();
    }
}

