/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.ISymbolicIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IndependenceStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.KeyType;
import java.util.Objects;

public class ThreadSeparatingIndependenceRelation<S, L extends IAction>
implements IIndependenceRelation<S, L> {
    private final IIndependenceRelation<S, L> mUnderlying;
    private final SeparatingStatistics mStatistics;

    public ThreadSeparatingIndependenceRelation(IIndependenceRelation<S, L> iIndependenceRelation) {
        this.mUnderlying = iIndependenceRelation;
        this.mStatistics = new SeparatingStatistics();
    }

    public boolean isSymmetric() {
        return this.mUnderlying.isSymmetric();
    }

    public boolean isConditional() {
        return this.mUnderlying.isConditional();
    }

    public IIndependenceRelation.Dependence isIndependent(S s, L l, L l2) {
        if (this.fromSameThread(l, l2)) {
            this.mStatistics.reportSameThreadQuery(s != null);
            return IIndependenceRelation.Dependence.DEPENDENT;
        }
        IIndependenceRelation.Dependence dependence = this.mUnderlying.isIndependent(s, l, l2);
        this.mStatistics.reportQuery(dependence, s != null);
        return dependence;
    }

    private boolean fromSameThread(L l, L l2) {
        return Objects.equals(l.getPrecedingProcedure(), l2.getPrecedingProcedure());
    }

    public ISymbolicIndependenceRelation<L, S> getSymbolicRelation() {
        ISymbolicIndependenceRelation iSymbolicIndependenceRelation = this.mUnderlying.getSymbolicRelation();
        if (iSymbolicIndependenceRelation == null) {
            return null;
        }
        return new SymbolicThreadSeparatingIndependence(iSymbolicIndependenceRelation);
    }

    public IStatisticsDataProvider getStatistics() {
        return this.mStatistics;
    }

    private class SeparatingStatistics
    extends IndependenceStatisticsDataProvider {
        public static final String SAME_THREAD_QUERIES = "Independence queries for same thread";
        private int mSameThreadQueries;

        public SeparatingStatistics() {
            super(ThreadSeparatingIndependenceRelation.class, ThreadSeparatingIndependenceRelation.this.mUnderlying);
            this.declare(SAME_THREAD_QUERIES, () -> this.mSameThreadQueries, KeyType.COUNTER);
        }

        private void reportSameThreadQuery(boolean bl) {
            ++this.mSameThreadQueries;
            this.reportDependentQuery(bl);
        }
    }

    private class SymbolicThreadSeparatingIndependence
    implements ISymbolicIndependenceRelation<L, S> {
        private final ISymbolicIndependenceRelation<L, S> mUnderlyingSymbolic;

        public SymbolicThreadSeparatingIndependence(ISymbolicIndependenceRelation<L, S> iSymbolicIndependenceRelation) {
            this.mUnderlyingSymbolic = iSymbolicIndependenceRelation;
        }

        public S getCommutativityCondition(S s, L l, L l2) {
            if (ThreadSeparatingIndependenceRelation.this.fromSameThread(l, l2)) {
                return null;
            }
            return this.mUnderlyingSymbolic.getCommutativityCondition(s, l, l2);
        }

        public boolean isSymmetric() {
            return this.mUnderlyingSymbolic.isSymmetric();
        }

        public boolean isConditional() {
            return this.mUnderlyingSymbolic.isConditional();
        }
    }
}

