/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.ui.css.core.util.impl.resources;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.e4.ui.css.core.util.impl.resources.HttpResourcesLocatorImpl;
import org.eclipse.e4.ui.css.core.util.impl.resources.OSGiResourceLocator;
import org.eclipse.e4.ui.css.core.util.resources.IResourceLocator;
import org.eclipse.e4.ui.css.core.util.resources.IResourcesLocatorManager;
import org.eclipse.e4.ui.css.core.utils.StringUtils;

public class ResourcesLocatorManager
implements IResourcesLocatorManager {
    public static final IResourcesLocatorManager INSTANCE = new ResourcesLocatorManager();
    private List<IResourceLocator> uriResolvers;

    public ResourcesLocatorManager() {
        this.registerResourceLocator(new HttpResourcesLocatorImpl());
    }

    @Override
    public void registerResourceLocator(IResourceLocator resourceLocator) {
        if (this.uriResolvers == null) {
            this.uriResolvers = new ArrayList<IResourceLocator>();
        }
        if (resourceLocator instanceof OSGiResourceLocator) {
            this.uriResolvers.add(0, resourceLocator);
        } else {
            this.uriResolvers.add(resourceLocator);
        }
    }

    @Override
    public void unregisterResourceLocator(IResourceLocator resourceLocator) {
        if (this.uriResolvers == null) {
            return;
        }
        this.uriResolvers.remove(resourceLocator);
    }

    @Override
    public String resolve(String uri) {
        if (StringUtils.isEmpty(uri)) {
            return null;
        }
        if (this.uriResolvers == null) {
            return null;
        }
        for (IResourceLocator resolver : this.uriResolvers) {
            String s = resolver.resolve(uri);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    @Override
    public InputStream getInputStream(String uri) throws Exception {
        if (StringUtils.isEmpty(uri)) {
            return null;
        }
        if (this.uriResolvers == null) {
            return null;
        }
        for (IResourceLocator resolver : this.uriResolvers) {
            InputStream inputStream;
            String s = resolver.resolve(uri);
            if (s == null || (inputStream = resolver.getInputStream(uri)) == null) continue;
            return inputStream;
        }
        return null;
    }
}

