/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.exception.UnsupportedSyntaxException;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.preferences.CACSLPreferenceInitializer;
import java.util.Objects;
import java.util.Set;

public final class TranslationSettings {
    private final CACSLPreferenceInitializer.CheckMode mDivisionByZeroOfIntegerTypes;
    private final CACSLPreferenceInitializer.CheckMode mDivisionByZeroOfFloatingTypes;
    private final boolean mBitvectorTranslation;
    private final boolean mOverapproximateFloatingPointOperations;
    private final boolean mBitpreciseBitfields;
    private final boolean mInRange;
    private final CACSLPreferenceInitializer.PointerIntegerConversion mPointerIntegerConversion;
    private final boolean mCheckIfFreedPointerIsValid;
    private final CACSLPreferenceInitializer.CheckMode mCheckPointerDerefValidity;
    private final CACSLPreferenceInitializer.CheckMode mCheckPointerSubtractionAndComparisonValidity;
    private final Set<String> mFunctionsCheckedForMemoryNeutrality;
    private final CACSLPreferenceInitializer.MemoryModel mMemoryModelPreference;
    private final boolean mFpToIeeeBvExtension;
    private final boolean mSmtBoolArraysWorkaround;
    private final String mEntryFunction;
    private final boolean mCheckErrorFunction;
    private final boolean mCheckAssertions;
    private final boolean mCheckAcsl;
    private final boolean mIsSvcompMemtrackCompatibilityMode;
    private final CACSLPreferenceInitializer.CheckMode mCheckSignedIntegerBounds;
    private final boolean mCheckDataRaces;
    private final boolean mUseConstantArrays;
    private final boolean mUseStoreChains;
    private final boolean mEnableFesetround;
    private final CACSLPreferenceInitializer.FloatingPointRoundingMode mInitialRoundingMode;
    private final boolean mAdaptMemoryModelResolutionOnPointerCasts;
    private final int mStringOverapproximationThreshold;
    private final CACSLPreferenceInitializer.UndefinedFunctionBehaviour mUndefinedFunctionBehaviour;
    private final boolean mEnforceIfForConditional;

    public TranslationSettings(IPreferenceProvider iPreferenceProvider) {
        this.mCheckSignedIntegerBounds = (CACSLPreferenceInitializer.CheckMode)iPreferenceProvider.getEnum("Check absence of signed integer overflows", CACSLPreferenceInitializer.CheckMode.class);
        this.mCheckDataRaces = iPreferenceProvider.getBoolean("Check absence of data races in concurrent programs");
        this.mIsSvcompMemtrackCompatibilityMode = iPreferenceProvider.getBoolean("SV-COMP memtrack compatibility mode");
        this.mCheckAssertions = iPreferenceProvider.getBoolean("Check assertions from assert.h");
        this.mCheckAcsl = iPreferenceProvider.getBoolean("Check ACSL annotations");
        this.mEntryFunction = iPreferenceProvider.getString("Entry function");
        this.mCheckErrorFunction = iPreferenceProvider.getBoolean("Check unreachability of reach_error function");
        this.mSmtBoolArraysWorkaround = iPreferenceProvider.getBoolean("SMT bool arrays workaround");
        this.mCheckIfFreedPointerIsValid = iPreferenceProvider.getBoolean("Check if freed pointer was valid");
        this.mCheckPointerDerefValidity = (CACSLPreferenceInitializer.CheckMode)iPreferenceProvider.getEnum("Pointer dereference validity", CACSLPreferenceInitializer.CheckMode.class);
        this.mCheckPointerSubtractionAndComparisonValidity = (CACSLPreferenceInitializer.CheckMode)iPreferenceProvider.getEnum("If two pointers are subtracted or compared they have the same base address", CACSLPreferenceInitializer.CheckMode.class);
        String string = iPreferenceProvider.getString("Check memory neutrality");
        String string2 = string.replaceAll("\\s+", "");
        this.mFunctionsCheckedForMemoryNeutrality = Set.of(string2.split(","));
        this.mMemoryModelPreference = (CACSLPreferenceInitializer.MemoryModel)iPreferenceProvider.getEnum("Memory model", CACSLPreferenceInitializer.MemoryModel.class);
        this.mFpToIeeeBvExtension = iPreferenceProvider.getBoolean("Use Z3's non-standard fp.to_ieee_bv extension");
        this.mPointerIntegerConversion = (CACSLPreferenceInitializer.PointerIntegerConversion)iPreferenceProvider.getEnum("Pointer-integer casts", CACSLPreferenceInitializer.PointerIntegerConversion.class);
        this.mInRange = iPreferenceProvider.getBoolean("Assume nondeterminstic values are in range");
        this.mDivisionByZeroOfIntegerTypes = (CACSLPreferenceInitializer.CheckMode)iPreferenceProvider.getEnum("Check division by zero", CACSLPreferenceInitializer.CheckMode.class);
        this.mDivisionByZeroOfFloatingTypes = (CACSLPreferenceInitializer.CheckMode)iPreferenceProvider.getEnum("Check division by zero for floating types", CACSLPreferenceInitializer.CheckMode.class);
        this.mBitpreciseBitfields = iPreferenceProvider.getBoolean("Bitprecise bitfields");
        this.mBitvectorTranslation = iPreferenceProvider.getBoolean("Use bitvectors instead of ints");
        this.mOverapproximateFloatingPointOperations = iPreferenceProvider.getBoolean("Overapproximate operations on floating types");
        this.mUseConstantArrays = iPreferenceProvider.getBoolean("Use constant arrays");
        this.mUseStoreChains = iPreferenceProvider.getBoolean("Use store chains");
        this.mEnableFesetround = iPreferenceProvider.getBoolean("Let fesetround change the rounding mode");
        this.mInitialRoundingMode = (CACSLPreferenceInitializer.FloatingPointRoundingMode)iPreferenceProvider.getEnum("Initial rounding mode", CACSLPreferenceInitializer.FloatingPointRoundingMode.class);
        this.mAdaptMemoryModelResolutionOnPointerCasts = iPreferenceProvider.getBoolean("Adapt memory model on pointer casts if necessary");
        this.mStringOverapproximationThreshold = iPreferenceProvider.getInt("String overapproximation threshold");
        this.mUndefinedFunctionBehaviour = (CACSLPreferenceInitializer.UndefinedFunctionBehaviour)iPreferenceProvider.getEnum("Behaviour of calls to undefined functions", CACSLPreferenceInitializer.UndefinedFunctionBehaviour.class);
        this.mEnforceIfForConditional = iPreferenceProvider.getBoolean("Always translate conditional expressions to if-statements");
    }

    private TranslationSettings(CACSLPreferenceInitializer.CheckMode checkMode, CACSLPreferenceInitializer.CheckMode checkMode2, boolean bl, boolean bl2, boolean bl3, boolean bl4, CACSLPreferenceInitializer.PointerIntegerConversion pointerIntegerConversion, boolean bl5, CACSLPreferenceInitializer.CheckMode checkMode3, CACSLPreferenceInitializer.CheckMode checkMode4, CACSLPreferenceInitializer.MemoryModel memoryModel, boolean bl6, boolean bl7, String string, boolean bl8, boolean bl9, boolean bl10, boolean bl11, Set<String> set, CACSLPreferenceInitializer.CheckMode checkMode5, boolean bl12, boolean bl13, boolean bl14, boolean bl15, CACSLPreferenceInitializer.FloatingPointRoundingMode floatingPointRoundingMode, boolean bl16, int n, CACSLPreferenceInitializer.UndefinedFunctionBehaviour undefinedFunctionBehaviour, boolean bl17) {
        this.mDivisionByZeroOfIntegerTypes = checkMode;
        this.mDivisionByZeroOfFloatingTypes = checkMode2;
        this.mBitvectorTranslation = bl;
        this.mOverapproximateFloatingPointOperations = bl2;
        this.mBitpreciseBitfields = bl3;
        this.mInRange = bl4;
        this.mPointerIntegerConversion = pointerIntegerConversion;
        this.mCheckIfFreedPointerIsValid = bl5;
        this.mCheckPointerDerefValidity = checkMode3;
        this.mCheckPointerSubtractionAndComparisonValidity = checkMode4;
        this.mMemoryModelPreference = memoryModel;
        this.mFpToIeeeBvExtension = bl6;
        this.mSmtBoolArraysWorkaround = bl7;
        this.mEntryFunction = string;
        this.mCheckErrorFunction = bl8;
        this.mCheckAssertions = bl9;
        this.mCheckAcsl = bl10;
        this.mIsSvcompMemtrackCompatibilityMode = bl11;
        this.mFunctionsCheckedForMemoryNeutrality = set;
        this.mCheckSignedIntegerBounds = checkMode5;
        this.mCheckDataRaces = bl12;
        this.mUseConstantArrays = bl13;
        this.mUseStoreChains = bl14;
        this.mEnableFesetround = bl15;
        this.mInitialRoundingMode = floatingPointRoundingMode;
        this.mAdaptMemoryModelResolutionOnPointerCasts = bl16;
        this.mStringOverapproximationThreshold = n;
        this.mUndefinedFunctionBehaviour = undefinedFunctionBehaviour;
        this.mEnforceIfForConditional = bl17;
    }

    public CACSLPreferenceInitializer.PointerIntegerConversion getPointerIntegerCastMode() {
        return this.mPointerIntegerConversion;
    }

    public boolean assumeNondeterministicValuesInRange() {
        return this.mInRange;
    }

    public CACSLPreferenceInitializer.CheckMode getDivisionByZeroOfIntegerTypes() {
        return this.mDivisionByZeroOfIntegerTypes;
    }

    public CACSLPreferenceInitializer.CheckMode getDivisionByZeroOfFloatingTypes() {
        return this.mDivisionByZeroOfFloatingTypes;
    }

    public CPrimitive getCTypeOfPointerComponents() {
        return new CPrimitive(CPrimitive.CPrimitives.LONG);
    }

    public boolean isBitvectorTranslation() {
        return this.mBitvectorTranslation;
    }

    public boolean overapproximateFloatingPointOperations() {
        return this.mOverapproximateFloatingPointOperations;
    }

    public boolean useBitpreciseBitfields() {
        return this.mBitpreciseBitfields;
    }

    public CACSLPreferenceInitializer.MemoryModel getMemoryModelPreference() {
        return this.mMemoryModelPreference;
    }

    public boolean useFpToIeeeBvExtension() {
        return this.mFpToIeeeBvExtension;
    }

    public CACSLPreferenceInitializer.CheckMode checkPointerDerefValidity() {
        return this.mCheckPointerDerefValidity;
    }

    public boolean checkIfFreedPointerIsValid() {
        return this.mCheckIfFreedPointerIsValid;
    }

    public CACSLPreferenceInitializer.CheckMode getPointerSubtractionAndComparisonValidityCheckMode() {
        return this.mCheckPointerSubtractionAndComparisonValidity;
    }

    public boolean useSmtBoolArrayWorkaround() {
        return this.mSmtBoolArraysWorkaround;
    }

    public String getEntryFunction() {
        return this.mEntryFunction;
    }

    public boolean checkErrorFunction() {
        return this.mCheckErrorFunction;
    }

    public boolean checkAssertions() {
        return this.mCheckAssertions;
    }

    public boolean checkAcsl() {
        return this.mCheckAcsl;
    }

    public boolean isSvcompMemtrackCompatibilityMode() {
        return this.mIsSvcompMemtrackCompatibilityMode;
    }

    public Set<String> getFunctionsCheckedForMemoryNeutrality() {
        return this.mFunctionsCheckedForMemoryNeutrality;
    }

    public CACSLPreferenceInitializer.CheckMode checkSignedIntegerBounds() {
        return this.mCheckSignedIntegerBounds;
    }

    public boolean checkDataRaces() {
        return this.mCheckDataRaces;
    }

    public boolean useConstantArrays() {
        return this.mUseConstantArrays;
    }

    public boolean useStoreChains() {
        return this.mUseStoreChains;
    }

    public boolean isFesetroundEnabled() {
        return this.mEnableFesetround;
    }

    public CACSLPreferenceInitializer.FloatingPointRoundingMode getInitialRoundingMode() {
        return this.mInitialRoundingMode;
    }

    public boolean isAdaptMemoryModelResolutionOnPointerCasts() {
        return this.mAdaptMemoryModelResolutionOnPointerCasts;
    }

    public int getStringOverapproximationThreshold() {
        return this.mStringOverapproximationThreshold;
    }

    public CACSLPreferenceInitializer.UndefinedFunctionBehaviour getUndefinedFunctionBehaviour() {
        return this.mUndefinedFunctionBehaviour;
    }

    public boolean enforceIfForConditional() {
        return this.mEnforceIfForConditional;
    }

    public TranslationSettings setMemoryModelPreference(CACSLPreferenceInitializer.MemoryModel memoryModel) {
        return new TranslationSettings(this.mDivisionByZeroOfIntegerTypes, this.mDivisionByZeroOfFloatingTypes, this.mBitvectorTranslation, this.mOverapproximateFloatingPointOperations, this.mBitpreciseBitfields, this.mInRange, this.mPointerIntegerConversion, this.mCheckIfFreedPointerIsValid, this.mCheckPointerDerefValidity, this.mCheckPointerSubtractionAndComparisonValidity, memoryModel, this.mFpToIeeeBvExtension, this.mSmtBoolArraysWorkaround, this.mEntryFunction, this.mCheckErrorFunction, this.mCheckAssertions, this.mCheckAcsl, this.mIsSvcompMemtrackCompatibilityMode, this.mFunctionsCheckedForMemoryNeutrality, this.mCheckSignedIntegerBounds, this.mCheckDataRaces, this.mUseConstantArrays, this.mUseStoreChains, this.mEnableFesetround, this.mInitialRoundingMode, this.mAdaptMemoryModelResolutionOnPointerCasts, this.mStringOverapproximationThreshold, this.mUndefinedFunctionBehaviour, this.mEnforceIfForConditional);
    }

    public static final class SettingsChange {
        private final CACSLPreferenceInitializer.MemoryModel mNewPreferredMemoryModel;
        private final ILocation mLoc;
        private final String mMsg;

        public SettingsChange(ILocation iLocation, String string, CACSLPreferenceInitializer.MemoryModel memoryModel) {
            this.mNewPreferredMemoryModel = memoryModel;
            this.mLoc = iLocation;
            this.mMsg = string;
        }

        public TranslationSettings applyChangeTo(TranslationSettings translationSettings) {
            return translationSettings.setMemoryModelPreference(this.mNewPreferredMemoryModel);
        }

        public UnsupportedSyntaxException constructException(String string) {
            return new UnsupportedSyntaxException(this.mLoc, this.mMsg + " (while " + string + ")");
        }

        public String toString() {
            return "SettingsChange [mNewPreferredMemoryModel=" + String.valueOf((Object)this.mNewPreferredMemoryModel) + "]";
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.mNewPreferredMemoryModel});
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            SettingsChange settingsChange = (SettingsChange)object;
            return this.mNewPreferredMemoryModel == settingsChange.mNewPreferredMemoryModel;
        }
    }
}

