/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.initialabstraction;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.proofs.IProof;
import de.uni_freiburg.informatik.ultimate.lib.proofs.IProofProducer;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.Objects;
import java.util.function.Function;

public class BacktranslatingProofProducer<INPROOF extends IProof>
implements IProofProducer<IIcfg<IcfgLocation>, IProof> {
    private final IIcfg<IcfgLocation> mIcfg;
    private final IProofProducer<?, INPROOF> mUnderlying;
    private final Function<INPROOF, ? extends IProof> mBacktranslator;
    private IProof mBacktranslatedProof;

    public BacktranslatingProofProducer(IIcfg<IcfgLocation> iIcfg, IProofProducer<?, INPROOF> iProofProducer, Function<INPROOF, ? extends IProof> function) {
        this.mIcfg = iIcfg;
        this.mUnderlying = iProofProducer;
        this.mBacktranslator = Objects.requireNonNull(function);
    }

    public IIcfg<IcfgLocation> getProgram() {
        return this.mIcfg;
    }

    public boolean isReadyToComputeProof() {
        return this.mUnderlying.isReadyToComputeProof();
    }

    public IProof getOrComputeProof() {
        if (this.mBacktranslatedProof == null) {
            IProof iProof = this.mUnderlying.getOrComputeProof();
            this.mBacktranslatedProof = this.mBacktranslator.apply(iProof);
        }
        return this.mBacktranslatedProof;
    }

    public IStatisticsDataProvider getStatistics() {
        return this.mUnderlying.getStatistics();
    }
}

