/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval;

import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.BooleanValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.INonrelationalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval.IntervalValue;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.util.AbsIntUtil;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiFunction;

public class IntervalDomainValue
implements INonrelationalValue<IntervalDomainValue> {
    private final IntervalValue mLower;
    private final IntervalValue mUpper;
    private final boolean mIsBottom;

    public IntervalDomainValue() {
        this(false);
    }

    public IntervalDomainValue(boolean bl) {
        if (bl) {
            this.mLower = null;
            this.mUpper = null;
            this.mIsBottom = true;
        } else {
            this.mLower = new IntervalValue();
            this.mUpper = new IntervalValue();
            this.mIsBottom = false;
        }
    }

    public IntervalDomainValue(IntervalValue intervalValue, IntervalValue intervalValue2) {
        if (!intervalValue.isInfinity() && !intervalValue2.isInfinity() && intervalValue.getValue().compareTo(intervalValue2.getValue()) > 0) {
            this.mLower = null;
            this.mUpper = null;
            this.mIsBottom = true;
            return;
        }
        this.mLower = intervalValue;
        this.mUpper = intervalValue2;
        this.mIsBottom = false;
    }

    public IntervalDomainValue(int n, int n2) {
        this(new IntervalValue(n), new IntervalValue(n2));
    }

    public IntervalDomainValue(double d, double d2) {
        this(new IntervalValue(d), new IntervalValue(d2));
    }

    @Override
    public IntervalDomainValue copy() {
        if (this.mIsBottom) {
            return new IntervalDomainValue(true);
        }
        return new IntervalDomainValue(new IntervalValue(this.mLower), new IntervalValue(this.mUpper));
    }

    @Override
    public IntervalDomainValue greaterOrEqual(IntervalDomainValue intervalDomainValue) {
        assert (intervalDomainValue != null);
        if (this.mIsBottom) {
            return this;
        }
        if (intervalDomainValue.mIsBottom) {
            return intervalDomainValue;
        }
        IntervalValue intervalValue = this.mLower.isInfinity() && intervalDomainValue.mLower.isInfinity() ? new IntervalValue() : (this.mLower.isInfinity() ? new IntervalValue(intervalDomainValue.mLower) : (intervalDomainValue.mLower.isInfinity() ? new IntervalValue(this.mLower) : (this.mLower.getValue().compareTo(intervalDomainValue.mLower.getValue()) > 0 ? new IntervalValue(this.mLower) : new IntervalValue(intervalDomainValue.mLower))));
        if (!intervalValue.isInfinity() && intervalValue.compareTo(this.mUpper) > 0) {
            return new IntervalDomainValue(true);
        }
        return new IntervalDomainValue(intervalValue, new IntervalValue(this.mUpper));
    }

    @Override
    public IntervalDomainValue lessOrEqual(IntervalDomainValue intervalDomainValue) {
        assert (intervalDomainValue != null);
        if (this.mIsBottom) {
            return this;
        }
        if (intervalDomainValue.mIsBottom) {
            return intervalDomainValue;
        }
        IntervalValue intervalValue = this.mUpper.isInfinity() ? intervalDomainValue.mUpper : (intervalDomainValue.mUpper.isInfinity() ? this.mUpper : (this.mUpper.getValue().compareTo(intervalDomainValue.mUpper.getValue()) < 0 ? this.mUpper : intervalDomainValue.mUpper));
        if (!this.mLower.isInfinity() && this.mLower.compareTo(intervalValue) > 0) {
            return new IntervalDomainValue(true);
        }
        return new IntervalDomainValue(new IntervalValue(this.mLower), new IntervalValue(intervalValue));
    }

    @Override
    public boolean isAbstractionEqual(IntervalDomainValue intervalDomainValue) {
        if (intervalDomainValue == null) {
            return false;
        }
        if (intervalDomainValue == this) {
            return true;
        }
        if (this.mIsBottom || intervalDomainValue.mIsBottom) {
            return this.mIsBottom == intervalDomainValue.mIsBottom;
        }
        return this.mLower.equals(intervalDomainValue.mLower) && this.mUpper.equals(intervalDomainValue.mUpper);
    }

    public boolean isContainedInBoth(IntervalDomainValue intervalDomainValue) {
        assert (intervalDomainValue != null);
        if (this.isBottom() || intervalDomainValue.isBottom()) {
            return true;
        }
        if (this.isTop() || intervalDomainValue.isTop()) {
            return true;
        }
        if (this.mLower.isInfinity()) {
            return this.mUpper.compareTo(intervalDomainValue.mUpper) >= 0;
        }
        if (intervalDomainValue.mLower.isInfinity()) {
            return intervalDomainValue.mUpper.compareTo(this.mUpper) >= 0;
        }
        return this.mLower.compareTo(intervalDomainValue.mLower) <= 0 && this.mUpper.compareTo(intervalDomainValue.mUpper) >= 0 || intervalDomainValue.mLower.compareTo(this.mLower) <= 0 && intervalDomainValue.mUpper.compareTo(this.mUpper) >= 0;
    }

    @Override
    public boolean isContainedIn(IntervalDomainValue intervalDomainValue) {
        assert (intervalDomainValue != null);
        if (this.isBottom()) {
            return true;
        }
        if (intervalDomainValue.isBottom()) {
            return false;
        }
        if (intervalDomainValue.isTop()) {
            return true;
        }
        if (this.mLower.isInfinity() && !intervalDomainValue.mLower.isInfinity()) {
            return false;
        }
        if (intervalDomainValue.mLower.isInfinity()) {
            return this.mUpper.compareTo(intervalDomainValue.mUpper) <= 0;
        }
        if (!this.mLower.isInfinity() && !intervalDomainValue.mLower.isInfinity()) {
            return this.mLower.compareTo(intervalDomainValue.mLower) >= 0 && this.mUpper.compareTo(intervalDomainValue.mUpper) <= 0;
        }
        return this.mLower.compareTo(intervalDomainValue.mLower) >= 0 && this.mUpper.compareTo(intervalDomainValue.mUpper) <= 0;
    }

    public boolean isPointInterval() {
        return !this.mLower.isInfinity() && this.mLower.compareTo(this.mUpper) == 0;
    }

    public String toString() {
        if (this.mIsBottom) {
            return "{}";
        }
        String string = this.mLower.isInfinity() ? "-\\infty" : this.mLower.toString();
        String string2 = this.mUpper.isInfinity() ? "\\infty" : this.mUpper.toString();
        return '[' + string + ';' + string2 + ']';
    }

    public boolean containsZero() {
        if (this.mIsBottom) {
            return false;
        }
        if (this.isTop()) {
            return true;
        }
        return !(!this.mLower.isInfinity() && this.mLower.getValue().signum() > 0 || !this.mUpper.isInfinity() && this.mUpper.getValue().signum() < 0);
    }

    public IntervalValue getLower() {
        return this.mLower;
    }

    public IntervalValue getUpper() {
        return this.mUpper;
    }

    @Override
    public IntervalDomainValue intersect(IntervalDomainValue intervalDomainValue) {
        assert (intervalDomainValue != null);
        if (this.mIsBottom || intervalDomainValue.mIsBottom) {
            return new IntervalDomainValue(true);
        }
        if (this.isTop() && intervalDomainValue.isTop()) {
            return new IntervalDomainValue();
        }
        IntervalValue intervalValue = this.mLower.compareTo(intervalDomainValue.mLower) > 0 ? (this.mLower.isInfinity() ? new IntervalValue(intervalDomainValue.mLower.getValue()) : new IntervalValue(this.mLower.getValue())) : (this.mLower.compareTo(intervalDomainValue.mLower) == 0 ? (this.mLower.isInfinity() ? new IntervalValue() : new IntervalValue(this.mLower.getValue())) : (intervalDomainValue.mLower.isInfinity() ? new IntervalValue(this.mLower.getValue()) : new IntervalValue(intervalDomainValue.mLower.getValue())));
        IntervalValue intervalValue2 = this.mUpper.compareTo(intervalDomainValue.mUpper) < 0 ? new IntervalValue(this.mUpper.getValue()) : (this.mUpper.compareTo(intervalDomainValue.mUpper) == 0 ? (this.mUpper.isInfinity() ? new IntervalValue() : new IntervalValue(this.mUpper.getValue())) : new IntervalValue(intervalDomainValue.mUpper.getValue()));
        if (!intervalValue.isInfinity() && intervalValue.compareTo(intervalValue2) > 0) {
            return new IntervalDomainValue(true);
        }
        if (!intervalValue2.isInfinity() && !intervalValue.isInfinity() && intervalValue2.compareTo(intervalValue) < 0) {
            return new IntervalDomainValue(true);
        }
        return new IntervalDomainValue(intervalValue, intervalValue2);
    }

    @Override
    public IntervalDomainValue merge(IntervalDomainValue intervalDomainValue) {
        assert (intervalDomainValue != null);
        boolean bl = this.isBottom();
        boolean bl2 = intervalDomainValue.isBottom();
        if (bl && !bl2) {
            return intervalDomainValue.copy();
        }
        if (!bl && bl2) {
            return this.copy();
        }
        if (this.isAbstractionEqual(intervalDomainValue)) {
            if (bl) {
                return new IntervalDomainValue(true);
            }
            if (this.isTop()) {
                return new IntervalDomainValue(new IntervalValue(), new IntervalValue());
            }
            IntervalValue intervalValue = this.mLower.isInfinity() ? new IntervalValue() : new IntervalValue(this.mLower.getValue());
            IntervalValue intervalValue2 = this.mUpper.isInfinity() ? new IntervalValue() : new IntervalValue(this.mUpper.getValue());
            return new IntervalDomainValue(intervalValue, intervalValue2);
        }
        IntervalValue intervalValue = this.mLower.isInfinity() || intervalDomainValue.mLower.isInfinity() ? new IntervalValue() : (this.mLower.compareTo(intervalDomainValue.mLower) < 0 ? new IntervalValue(this.mLower.getValue()) : new IntervalValue(intervalDomainValue.mLower.getValue()));
        IntervalValue intervalValue3 = this.mUpper.isInfinity() || intervalDomainValue.mUpper.isInfinity() ? new IntervalValue() : (this.mUpper.compareTo(intervalDomainValue.mUpper) < 0 ? new IntervalValue(intervalDomainValue.mUpper.getValue()) : new IntervalValue(this.mUpper.getValue()));
        return new IntervalDomainValue(intervalValue, intervalValue3);
    }

    @Override
    public boolean isBottom() {
        return this.mIsBottom;
    }

    @Override
    public boolean isTop() {
        return !this.mIsBottom && this.mLower.isInfinity() && this.mUpper.isInfinity();
    }

    public boolean isUnbounded() {
        if (this.mIsBottom) {
            return false;
        }
        return this.mLower.isInfinity() || this.mUpper.isInfinity();
    }

    @Override
    public IntervalDomainValue multiply(IntervalDomainValue intervalDomainValue) {
        assert (intervalDomainValue != null);
        if (this.isBottom() || intervalDomainValue.isBottom()) {
            return new IntervalDomainValue(true);
        }
        if (this.isPointInterval() && intervalDomainValue.isPointInterval()) {
            IntervalValue intervalValue = new IntervalValue(this.getLower().getValue().multiply(intervalDomainValue.getLower().getValue()));
            return new IntervalDomainValue(intervalValue, intervalValue);
        }
        IntervalValue intervalValue = this.computeMinMult(intervalDomainValue);
        IntervalValue intervalValue2 = this.computeMaxMult(intervalDomainValue);
        return new IntervalDomainValue(intervalValue, intervalValue2);
    }

    @Override
    public IntervalDomainValue add(IntervalDomainValue intervalDomainValue3) {
        return this.addOrSubtract(intervalDomainValue3, (intervalDomainValue, intervalDomainValue2) -> intervalDomainValue.getLower().add(intervalDomainValue2.getLower()), (intervalDomainValue, intervalDomainValue2) -> intervalDomainValue.getUpper().add(intervalDomainValue2.getUpper()));
    }

    @Override
    public IntervalDomainValue subtract(IntervalDomainValue intervalDomainValue3) {
        return this.addOrSubtract(intervalDomainValue3, (intervalDomainValue, intervalDomainValue2) -> intervalDomainValue.getLower().subtract(intervalDomainValue2.getUpper()), (intervalDomainValue, intervalDomainValue2) -> intervalDomainValue.getUpper().subtract(intervalDomainValue2.getLower()));
    }

    private IntervalDomainValue addOrSubtract(IntervalDomainValue intervalDomainValue, BiFunction<IntervalDomainValue, IntervalDomainValue, IntervalValue> biFunction, BiFunction<IntervalDomainValue, IntervalDomainValue, IntervalValue> biFunction2) {
        assert (intervalDomainValue != null);
        if (this.isBottom()) {
            return this;
        }
        if (intervalDomainValue.isBottom()) {
            return intervalDomainValue;
        }
        if (this.isTop()) {
            return this;
        }
        if (intervalDomainValue.isTop()) {
            return intervalDomainValue;
        }
        IntervalValue intervalValue = this.getLower().isInfinity() || intervalDomainValue.getLower().isInfinity() ? new IntervalValue() : biFunction.apply(this, intervalDomainValue);
        IntervalValue intervalValue2 = this.getUpper().isInfinity() || intervalDomainValue.getUpper().isInfinity() ? new IntervalValue() : biFunction2.apply(this, intervalDomainValue);
        return new IntervalDomainValue(intervalValue, intervalValue2);
    }

    @Override
    public IntervalDomainValue modulo(IntervalDomainValue intervalDomainValue) {
        assert (intervalDomainValue != null);
        if (this.isBottom() || intervalDomainValue.isBottom()) {
            return new IntervalDomainValue(true);
        }
        if (intervalDomainValue.containsZero()) {
            return new IntervalDomainValue();
        }
        if (this.isPointInterval() && intervalDomainValue.isPointInterval()) {
            BigDecimal bigDecimal = AbsIntUtil.euclideanModulo(this.mLower.getValue(), intervalDomainValue.mLower.getValue());
            return new IntervalDomainValue(new IntervalValue(bigDecimal), new IntervalValue(bigDecimal));
        }
        IntervalDomainValue intervalDomainValue2 = intervalDomainValue.abs();
        if (!this.mLower.isInfinity() && !intervalDomainValue2.mLower.isInfinity() && new IntervalValue(0).compareTo(this.mLower) <= 0 && this.mUpper.compareTo(intervalDomainValue2.mLower) < 0) {
            return new IntervalDomainValue(this.mLower, this.mUpper);
        }
        IntervalValue intervalValue = new IntervalValue(0);
        IntervalValue intervalValue2 = intervalDomainValue2.mUpper.isInfinity() ? intervalDomainValue2.mUpper : new IntervalValue(intervalDomainValue2.mUpper.getValue().subtract(BigDecimal.ONE));
        return new IntervalDomainValue(intervalValue, intervalValue2);
    }

    public IntervalDomainValue abs() {
        IntervalValue intervalValue;
        IntervalValue intervalValue2;
        if (this.isBottom()) {
            return new IntervalDomainValue(true);
        }
        boolean bl = this.mLower.isInfinity();
        boolean bl2 = this.mUpper.isInfinity();
        if (bl || bl2) {
            intervalValue2 = new IntervalValue();
            intervalValue = this.containsZero() || bl && bl2 ? new IntervalValue(0) : (bl ? new IntervalValue(this.mUpper.getValue().abs()) : new IntervalValue(this.mLower.getValue().abs()));
        } else {
            BigDecimal bigDecimal = this.mLower.getValue().abs();
            BigDecimal bigDecimal2 = this.mUpper.getValue().abs();
            intervalValue = new IntervalValue(this.containsZero() ? BigDecimal.ZERO : bigDecimal.min(bigDecimal2));
            intervalValue2 = new IntervalValue(bigDecimal.max(bigDecimal2));
        }
        return new IntervalDomainValue(intervalValue, intervalValue2);
    }

    @Override
    public IntervalDomainValue negate() {
        if (this.isBottom()) {
            return new IntervalDomainValue(true);
        }
        if (this.getLower().isInfinity() && this.getUpper().isInfinity()) {
            return new IntervalDomainValue();
        }
        if (this.getLower().isInfinity()) {
            return new IntervalDomainValue(new IntervalValue(this.getUpper().getValue().negate()), new IntervalValue());
        }
        if (this.getUpper().isInfinity()) {
            return new IntervalDomainValue(new IntervalValue(), new IntervalValue(this.getLower().getValue().negate()));
        }
        return new IntervalDomainValue(new IntervalValue(this.getUpper().getValue().negate()), new IntervalValue(this.getLower().getValue().negate()));
    }

    @Override
    public Term getTerm(Script script, Sort sort, Term term) {
        assert (sort.isNumericSort());
        if (this.isBottom()) {
            return script.term("false", new Term[0]);
        }
        if (this.mLower.isInfinity() && this.mUpper.isInfinity()) {
            return script.term("true", new Term[0]);
        }
        if (this.mLower.isInfinity()) {
            Term term2 = this.mUpper.getTerm(sort, script);
            return script.term("<=", new Term[]{term, term2});
        }
        if (this.mUpper.isInfinity()) {
            Term term3 = this.mLower.getTerm(sort, script);
            return script.term(">=", new Term[]{term, term3});
        }
        int n = this.mUpper.compareTo(this.mLower);
        if (n == 0) {
            Term term4 = this.mLower.getTerm(sort, script);
            return script.term("=", new Term[]{term, term4});
        }
        if (n < 0) {
            return script.term("false", new Term[0]);
        }
        Term term5 = script.term("<=", new Term[]{term, this.mUpper.getTerm(sort, script)});
        Term term6 = script.term(">=", new Term[]{term, this.mLower.getTerm(sort, script)});
        return script.term("and", new Term[]{term6, term5});
    }

    private IntervalValue computeMaxMult(IntervalDomainValue intervalDomainValue) {
        IntervalValue intervalValue = new IntervalValue();
        boolean bl = false;
        if (this.isTop() && intervalDomainValue.isTop()) {
            return new IntervalValue();
        }
        if (this.getLower().isInfinity()) {
            if (intervalDomainValue.getLower().isInfinity()) {
                return new IntervalValue();
            }
            if (intervalDomainValue.getLower().getValue().signum() < 0) {
                return new IntervalValue();
            }
            if (intervalDomainValue.getLower().getValue().signum() == 0) {
                intervalValue = IntervalDomainValue.updateIfLarger(intervalValue, BigDecimal.ZERO, bl);
                bl = true;
            }
        } else if (intervalDomainValue.getLower().isInfinity()) {
            if (this.getLower().getValue().signum() < 0) {
                return new IntervalValue();
            }
            if (this.getLower().getValue().signum() == 0) {
                intervalValue = IntervalDomainValue.updateIfLarger(intervalValue, BigDecimal.ZERO, bl);
                bl = true;
            }
        } else {
            intervalValue = IntervalDomainValue.updateIfLarger(intervalValue, this.getLower().getValue().multiply(intervalDomainValue.getLower().getValue()), bl);
            bl = true;
        }
        if (this.getLower().isInfinity()) {
            if (!intervalDomainValue.getUpper().isInfinity()) {
                if (intervalDomainValue.getUpper().getValue().signum() < 0) {
                    return new IntervalValue();
                }
                if (intervalDomainValue.getUpper().getValue().signum() == 0) {
                    intervalValue = IntervalDomainValue.updateIfLarger(intervalValue, BigDecimal.ZERO, bl);
                    bl = true;
                }
            }
        } else if (intervalDomainValue.getUpper().isInfinity()) {
            if (this.getLower().getValue().signum() > 0) {
                return new IntervalValue();
            }
            if (this.getLower().getValue().signum() == 0) {
                intervalValue = IntervalDomainValue.updateIfLarger(intervalValue, BigDecimal.ZERO, bl);
                bl = true;
            }
        } else {
            intervalValue = IntervalDomainValue.updateIfLarger(intervalValue, this.getLower().getValue().multiply(intervalDomainValue.getUpper().getValue()), bl);
            bl = true;
        }
        if (this.getUpper().isInfinity()) {
            if (!intervalDomainValue.getLower().isInfinity()) {
                if (intervalDomainValue.getLower().getValue().signum() > 0) {
                    return new IntervalValue();
                }
                if (intervalDomainValue.getLower().getValue().signum() == 0) {
                    intervalValue = IntervalDomainValue.updateIfLarger(intervalValue, BigDecimal.ZERO, bl);
                    bl = true;
                }
            }
        } else if (intervalDomainValue.getLower().isInfinity()) {
            if (this.getUpper().getValue().signum() < 0) {
                return new IntervalValue();
            }
            if (this.getUpper().getValue().signum() == 0) {
                intervalValue = IntervalDomainValue.updateIfLarger(intervalValue, BigDecimal.ZERO, bl);
                bl = true;
            }
        } else {
            intervalValue = IntervalDomainValue.updateIfLarger(intervalValue, this.getUpper().getValue().multiply(intervalDomainValue.getLower().getValue()), bl);
            bl = true;
        }
        if (this.getUpper().isInfinity()) {
            if (intervalDomainValue.getUpper().isInfinity()) {
                return new IntervalValue();
            }
            if (intervalDomainValue.getUpper().getValue().signum() > 0) {
                return new IntervalValue();
            }
            if (intervalDomainValue.getUpper().getValue().signum() == 0) {
                intervalValue = IntervalDomainValue.updateIfLarger(intervalValue, BigDecimal.ZERO, bl);
                bl = true;
            }
        } else if (intervalDomainValue.getUpper().isInfinity()) {
            if (this.getUpper().getValue().signum() > 0) {
                return new IntervalValue();
            }
            if (this.getUpper().getValue().signum() == 0) {
                intervalValue = IntervalDomainValue.updateIfLarger(intervalValue, BigDecimal.ZERO, bl);
                bl = true;
            }
        } else {
            intervalValue = IntervalDomainValue.updateIfLarger(intervalValue, this.getUpper().getValue().multiply(intervalDomainValue.getUpper().getValue()), bl);
            bl = true;
        }
        assert (bl);
        return intervalValue;
    }

    private IntervalValue computeMinMult(IntervalDomainValue intervalDomainValue) {
        IntervalValue intervalValue = new IntervalValue();
        boolean bl = false;
        if (this.isTop() && intervalDomainValue.isTop()) {
            return new IntervalValue();
        }
        if (this.getLower().isInfinity()) {
            if (!intervalDomainValue.getLower().isInfinity()) {
                if (intervalDomainValue.getLower().getValue().signum() > 0) {
                    return new IntervalValue();
                }
                if (intervalDomainValue.getLower().getValue().signum() == 0) {
                    intervalValue = IntervalDomainValue.updateIfSmaller(intervalValue, BigDecimal.ZERO, bl);
                    bl = true;
                }
            }
        } else if (this.getLower().getValue().signum() == 0) {
            intervalValue = IntervalDomainValue.updateIfSmaller(intervalValue, BigDecimal.ZERO, bl);
            bl = true;
        } else if (intervalDomainValue.getLower().isInfinity()) {
            if (this.getLower().getValue().signum() > 0) {
                return new IntervalValue();
            }
        } else {
            intervalValue = IntervalDomainValue.updateIfSmaller(intervalValue, this.getLower().getValue().multiply(intervalDomainValue.getLower().getValue()), bl);
            bl = true;
        }
        if (this.getLower().isInfinity()) {
            if (intervalDomainValue.getUpper().isInfinity()) {
                return new IntervalValue();
            }
            if (intervalDomainValue.getUpper().getValue().signum() > 0) {
                return new IntervalValue();
            }
            if (intervalDomainValue.getUpper().getValue().signum() == 0) {
                intervalValue = IntervalDomainValue.updateIfSmaller(intervalValue, BigDecimal.ZERO, bl);
                bl = true;
            }
        } else if (this.getLower().getValue().signum() == 0) {
            intervalValue = IntervalDomainValue.updateIfSmaller(intervalValue, BigDecimal.ZERO, bl);
            bl = true;
        } else if (intervalDomainValue.getUpper().isInfinity()) {
            if (this.getLower().getValue().signum() < 0) {
                return new IntervalValue();
            }
        } else {
            intervalValue = IntervalDomainValue.updateIfSmaller(intervalValue, this.getLower().getValue().multiply(intervalDomainValue.getUpper().getValue()), bl);
            bl = true;
        }
        if (this.getUpper().isInfinity()) {
            if (intervalDomainValue.getLower().isInfinity()) {
                return new IntervalValue();
            }
            if (intervalDomainValue.getLower().getValue().signum() < 0) {
                return new IntervalValue();
            }
            if (intervalDomainValue.getLower().getValue().signum() == 0) {
                intervalValue = IntervalDomainValue.updateIfSmaller(intervalValue, BigDecimal.ZERO, bl);
                bl = true;
            }
        } else if (intervalDomainValue.getLower().isInfinity()) {
            if (this.getUpper().getValue().signum() > 0) {
                return new IntervalValue();
            }
            if (this.getUpper().getValue().signum() == 0) {
                intervalValue = IntervalDomainValue.updateIfSmaller(intervalValue, BigDecimal.ZERO, bl);
                bl = true;
            }
        } else {
            intervalValue = IntervalDomainValue.updateIfSmaller(intervalValue, this.getUpper().getValue().multiply(intervalDomainValue.getLower().getValue()), bl);
            bl = true;
        }
        if (this.getUpper().isInfinity()) {
            if (!intervalDomainValue.getUpper().isInfinity()) {
                if (intervalDomainValue.getUpper().getValue().signum() < 0) {
                    return new IntervalValue();
                }
                if (intervalDomainValue.getUpper().getValue().signum() == 0) {
                    intervalValue = IntervalDomainValue.updateIfSmaller(intervalValue, BigDecimal.ZERO, bl);
                    bl = true;
                }
            }
        } else if (intervalDomainValue.getUpper().isInfinity()) {
            if (this.getUpper().getValue().signum() < 0) {
                return new IntervalValue();
            }
            if (this.getUpper().getValue().signum() == 0) {
                intervalValue = IntervalDomainValue.updateIfSmaller(intervalValue, BigDecimal.ZERO, bl);
                bl = true;
            }
        } else {
            intervalValue = IntervalDomainValue.updateIfSmaller(intervalValue, this.getUpper().getValue().multiply(intervalDomainValue.getUpper().getValue()), bl);
            bl = true;
        }
        assert (bl);
        return intervalValue;
    }

    private static IntervalValue updateIfLarger(IntervalValue intervalValue, BigDecimal bigDecimal, boolean bl) {
        if (bl) {
            if (intervalValue.getValue().compareTo(bigDecimal) <= 0) {
                return new IntervalValue(bigDecimal);
            }
            return intervalValue;
        }
        return new IntervalValue(bigDecimal);
    }

    private static IntervalValue updateIfSmaller(IntervalValue intervalValue, BigDecimal bigDecimal, boolean bl) {
        if (bl) {
            if (intervalValue.getValue().compareTo(bigDecimal) >= 0) {
                return new IntervalValue(bigDecimal);
            }
            return intervalValue;
        }
        return new IntervalValue(bigDecimal);
    }

    @Override
    public IntervalDomainValue divideReal(IntervalDomainValue intervalDomainValue) {
        return this.divideInternally(intervalDomainValue);
    }

    @Override
    public IntervalDomainValue divideInteger(IntervalDomainValue intervalDomainValue) {
        if (intervalDomainValue.containsZero() && intervalDomainValue.isPointInterval()) {
            return new IntervalDomainValue(true);
        }
        IntervalDomainValue intervalDomainValue2 = this.divideInternally(intervalDomainValue);
        if (intervalDomainValue2.isBottom() || intervalDomainValue2.isTop()) {
            return intervalDomainValue2;
        }
        IntervalValue intervalValue = intervalDomainValue2.getLower();
        IntervalValue intervalValue2 = intervalDomainValue2.getUpper();
        IntervalValue intervalValue3 = intervalValue.isInfinity() ? intervalValue : new IntervalValue(intervalValue.getValue().setScale(0, RoundingMode.FLOOR));
        IntervalValue intervalValue4 = intervalValue2.isInfinity() ? intervalValue2 : new IntervalValue(intervalValue2.getValue().setScale(0, RoundingMode.CEILING));
        return new IntervalDomainValue(intervalValue3, intervalValue4);
    }

    private IntervalDomainValue divideInternally(IntervalDomainValue intervalDomainValue) {
        assert (intervalDomainValue != null);
        if (this.isBottom() || intervalDomainValue.isBottom()) {
            return new IntervalDomainValue(true);
        }
        if (this.isPointInterval() && intervalDomainValue.isPointInterval()) {
            if (intervalDomainValue.getLower().getValue().signum() == 0) {
                return new IntervalDomainValue(true);
            }
            IntervalValue intervalValue = new IntervalValue(IntervalDomainValue.divide(this.getLower().getValue(), intervalDomainValue.getLower().getValue()));
            return new IntervalDomainValue(intervalValue, intervalValue);
        }
        if (intervalDomainValue.containsZero()) {
            return new IntervalDomainValue();
        }
        IntervalValue intervalValue = this.computeMinDiv(intervalDomainValue);
        IntervalValue intervalValue2 = this.computeMaxDiv(intervalDomainValue);
        return new IntervalDomainValue(intervalValue, intervalValue2);
    }

    private IntervalValue computeMinDiv(IntervalDomainValue intervalDomainValue) {
        if (this.isTop() && intervalDomainValue.isTop()) {
            return new IntervalValue();
        }
        IntervalValue intervalValue = new IntervalValue();
        boolean bl = false;
        IntervalValue intervalValue2 = this.getLower();
        IntervalValue intervalValue3 = this.getUpper();
        IntervalValue intervalValue4 = intervalDomainValue.getLower();
        IntervalValue intervalValue5 = intervalDomainValue.getUpper();
        if (intervalValue4.isInfinity() || intervalValue5.isInfinity()) {
            intervalValue = IntervalDomainValue.updateIfSmaller(intervalValue, BigDecimal.ZERO, bl);
            bl = true;
        }
        if (intervalValue2.isInfinity()) {
            if (!intervalValue4.isInfinity() && intervalValue4.getValue().signum() > 0) {
                return new IntervalValue();
            }
        } else if (intervalValue2.getValue().signum() == 0) {
            intervalValue = IntervalDomainValue.updateIfSmaller(intervalValue, BigDecimal.ZERO, bl);
            bl = true;
        } else if (intervalValue4.isInfinity()) {
            if (intervalValue2.getValue().signum() > 0) {
                return new IntervalValue();
            }
        } else {
            intervalValue = IntervalDomainValue.updateIfSmaller(intervalValue, IntervalDomainValue.divide(intervalValue2.getValue(), intervalValue4.getValue()), bl);
            bl = true;
        }
        if (intervalValue2.isInfinity()) {
            if (intervalValue5.isInfinity()) {
                return new IntervalValue();
            }
            if (intervalValue5.getValue().signum() > 0) {
                return new IntervalValue();
            }
        } else if (intervalValue2.getValue().signum() == 0) {
            intervalValue = IntervalDomainValue.updateIfSmaller(intervalValue, BigDecimal.ZERO, bl);
            bl = true;
        } else if (intervalValue5.isInfinity()) {
            if (intervalValue2.getValue().signum() < 0) {
                return new IntervalValue();
            }
        } else {
            intervalValue = IntervalDomainValue.updateIfSmaller(intervalValue, IntervalDomainValue.divide(intervalValue2.getValue(), intervalValue5.getValue()), bl);
        }
        if (intervalValue3.isInfinity()) {
            if (intervalValue4.isInfinity()) {
                return new IntervalValue();
            }
            if (intervalValue4.getValue().signum() < 0) {
                return new IntervalValue();
            }
        } else if (intervalValue4.isInfinity()) {
            if (intervalValue3.getValue().signum() > 0) {
                return new IntervalValue();
            }
            if (intervalValue3.getValue().signum() == 0) {
                intervalValue = IntervalDomainValue.updateIfSmaller(intervalValue, BigDecimal.ZERO, bl);
                bl = true;
            }
        } else {
            intervalValue = IntervalDomainValue.updateIfSmaller(intervalValue, IntervalDomainValue.divide(intervalValue3.getValue(), intervalValue4.getValue()), bl);
            bl = true;
        }
        if (intervalValue3.isInfinity()) {
            if (!intervalValue5.isInfinity() && intervalValue5.getValue().signum() < 0) {
                return new IntervalValue();
            }
        } else if (intervalValue5.isInfinity()) {
            if (intervalValue3.getValue().signum() < 0) {
                return new IntervalValue();
            }
            if (intervalValue3.getValue().signum() == 0) {
                intervalValue = IntervalDomainValue.updateIfSmaller(intervalValue, BigDecimal.ZERO, bl);
                bl = true;
            }
        } else {
            intervalValue = IntervalDomainValue.updateIfSmaller(intervalValue, IntervalDomainValue.divide(intervalValue3.getValue(), intervalValue5.getValue()), bl);
            bl = true;
        }
        assert (bl);
        return intervalValue;
    }

    private static BigDecimal divide(BigDecimal bigDecimal, BigDecimal bigDecimal2) {
        try {
            return bigDecimal.divide(bigDecimal2);
        }
        catch (ArithmeticException arithmeticException) {
            return bigDecimal.divide(bigDecimal2, MathContext.DECIMAL128);
        }
    }

    private IntervalValue computeMaxDiv(IntervalDomainValue intervalDomainValue) {
        if (this.isTop() && intervalDomainValue.isTop()) {
            return new IntervalValue();
        }
        IntervalValue intervalValue = new IntervalValue();
        boolean bl = false;
        IntervalValue intervalValue2 = this.getLower();
        IntervalValue intervalValue3 = this.getUpper();
        IntervalValue intervalValue4 = intervalDomainValue.getLower();
        IntervalValue intervalValue5 = intervalDomainValue.getUpper();
        if (intervalDomainValue.containsZero()) {
            return new IntervalValue();
        }
        if (intervalValue2.isInfinity()) {
            if (intervalValue4.isInfinity()) {
                return new IntervalValue();
            }
            if (intervalValue4.getValue().signum() < 0) {
                return new IntervalValue();
            }
        } else if (intervalValue4.isInfinity()) {
            if (intervalValue2.getValue().signum() < 0) {
                return new IntervalValue();
            }
            if (intervalValue2.getValue().signum() == 0) {
                intervalValue = IntervalDomainValue.updateIfLarger(intervalValue, BigDecimal.ZERO, bl);
                bl = true;
            }
        } else {
            intervalValue = IntervalDomainValue.updateIfLarger(intervalValue, IntervalDomainValue.divide(intervalValue2.getValue(), intervalValue4.getValue()), bl);
            bl = true;
        }
        if (intervalValue2.isInfinity()) {
            if (!intervalValue5.isInfinity() && intervalValue5.getValue().signum() < 0) {
                return new IntervalValue();
            }
        } else if (intervalValue5.isInfinity()) {
            if (intervalValue2.getValue().signum() > 0) {
                return new IntervalValue();
            }
            if (intervalValue2.getValue().signum() == 0) {
                intervalValue = IntervalDomainValue.updateIfLarger(intervalValue, BigDecimal.ZERO, bl);
                bl = true;
            }
        } else {
            intervalValue = IntervalDomainValue.updateIfLarger(intervalValue, IntervalDomainValue.divide(intervalValue2.getValue(), intervalValue5.getValue()), bl);
            bl = true;
        }
        if (intervalValue3.isInfinity()) {
            if (!intervalValue4.isInfinity() && intervalValue4.getValue().signum() > 0) {
                return new IntervalValue();
            }
        } else if (intervalValue4.isInfinity()) {
            if (intervalValue3.getValue().signum() < 0) {
                return new IntervalValue();
            }
            if (intervalValue3.getValue().signum() == 0) {
                intervalValue = IntervalDomainValue.updateIfLarger(intervalValue, BigDecimal.ZERO, bl);
                bl = true;
            }
        } else {
            intervalValue = IntervalDomainValue.updateIfLarger(intervalValue, IntervalDomainValue.divide(intervalValue3.getValue(), intervalValue4.getValue()), bl);
            bl = true;
        }
        if (intervalValue3.isInfinity()) {
            if (intervalValue5.isInfinity()) {
                return new IntervalValue();
            }
            if (intervalValue5.getValue().signum() > 0) {
                return new IntervalValue();
            }
        } else if (intervalValue5.isInfinity()) {
            if (intervalValue3.getValue().signum() > 0) {
                return new IntervalValue();
            }
            if (intervalValue3.getValue().signum() == 0) {
                intervalValue = IntervalDomainValue.updateIfLarger(intervalValue, BigDecimal.ZERO, bl);
                bl = true;
            }
        } else {
            intervalValue = IntervalDomainValue.updateIfLarger(intervalValue, IntervalDomainValue.divide(intervalValue3.getValue(), intervalValue5.getValue()), bl);
            bl = true;
        }
        assert (bl);
        return intervalValue;
    }

    @Override
    public IntervalDomainValue greaterThan(IntervalDomainValue intervalDomainValue) {
        return this.greaterOrEqual(intervalDomainValue);
    }

    @Override
    public BooleanValue isGreaterThan(IntervalDomainValue intervalDomainValue) {
        return this.isGreaterOrEqual(intervalDomainValue);
    }

    @Override
    public BooleanValue isGreaterOrEqual(IntervalDomainValue intervalDomainValue) {
        IntervalDomainValue intervalDomainValue2 = this.greaterOrEqual(intervalDomainValue);
        if (intervalDomainValue2.isBottom() || intervalDomainValue2.isPointInterval()) {
            return BooleanValue.TRUE;
        }
        return BooleanValue.TOP;
    }

    @Override
    public IntervalDomainValue lessThan(IntervalDomainValue intervalDomainValue) {
        return this.lessOrEqual(intervalDomainValue);
    }

    @Override
    public BooleanValue isLessThan(IntervalDomainValue intervalDomainValue) {
        return this.isLessOrEqual(intervalDomainValue);
    }

    @Override
    public BooleanValue isLessOrEqual(IntervalDomainValue intervalDomainValue) {
        if (intervalDomainValue.isTop() || this.isTop()) {
            return BooleanValue.TOP;
        }
        IntervalDomainValue intervalDomainValue2 = this.lessOrEqual(intervalDomainValue);
        if (intervalDomainValue2.isAbstractionEqual(this)) {
            return BooleanValue.TRUE;
        }
        if (intervalDomainValue2.isBottom()) {
            return BooleanValue.FALSE;
        }
        return BooleanValue.TOP;
    }

    @Override
    public BooleanValue isEqual(IntervalDomainValue intervalDomainValue) {
        if (intervalDomainValue.isTop() || this.isTop()) {
            return BooleanValue.TOP;
        }
        if (this.isPointInterval() && this.isAbstractionEqual(intervalDomainValue)) {
            return BooleanValue.TRUE;
        }
        IntervalDomainValue intervalDomainValue2 = this.intersect(intervalDomainValue);
        if (intervalDomainValue2.isBottom()) {
            return BooleanValue.FALSE;
        }
        return BooleanValue.TOP;
    }

    @Override
    public BooleanValue isNotEqual(IntervalDomainValue intervalDomainValue) {
        throw new UnsupportedOperationException("Not equals expressions should have been removed during expression normalization.");
    }

    @Override
    public IntervalDomainValue inverseModulo(IntervalDomainValue intervalDomainValue, IntervalDomainValue intervalDomainValue2, boolean bl) {
        return intervalDomainValue2;
    }

    @Override
    public IntervalDomainValue inverseEquality(IntervalDomainValue intervalDomainValue, IntervalDomainValue intervalDomainValue2) {
        return intervalDomainValue2;
    }

    @Override
    public IntervalDomainValue inverseLessOrEqual(IntervalDomainValue intervalDomainValue, boolean bl) {
        IntervalDomainValue intervalDomainValue2 = bl ? new IntervalDomainValue(new IntervalValue(), this.getUpper()) : new IntervalDomainValue(this.getLower(), new IntervalValue());
        return intervalDomainValue2.intersect(intervalDomainValue);
    }

    @Override
    public IntervalDomainValue inverseLessThan(IntervalDomainValue intervalDomainValue, boolean bl) {
        return this.inverseLessOrEqual(intervalDomainValue, bl);
    }

    @Override
    public IntervalDomainValue inverseGreaterOrEqual(IntervalDomainValue intervalDomainValue, boolean bl) {
        IntervalDomainValue intervalDomainValue2 = bl ? new IntervalDomainValue(this.getLower(), new IntervalValue()) : new IntervalDomainValue(new IntervalValue(), this.getUpper());
        return intervalDomainValue2.intersect(intervalDomainValue);
    }

    @Override
    public IntervalDomainValue inverseGreaterThan(IntervalDomainValue intervalDomainValue, boolean bl) {
        return this.inverseGreaterOrEqual(intervalDomainValue, bl);
    }

    @Override
    public IntervalDomainValue inverseNotEqual(IntervalDomainValue intervalDomainValue, IntervalDomainValue intervalDomainValue2) {
        return intervalDomainValue2;
    }

    @Override
    public boolean canHandleReals() {
        return false;
    }

    @Override
    public boolean canHandleModulo() {
        return false;
    }

    @Override
    public Collection<IntervalDomainValue> complement() {
        if (this.isBottom()) {
            return Collections.singleton(new IntervalDomainValue());
        }
        if (this.getLower().isInfinity() && this.getUpper().isInfinity()) {
            return Collections.singleton(new IntervalDomainValue(true));
        }
        if (this.getLower().isInfinity()) {
            return Collections.singleton(new IntervalDomainValue(new IntervalValue(this.getUpper().getValue()), new IntervalValue()));
        }
        if (this.getUpper().isInfinity()) {
            return Collections.singleton(new IntervalDomainValue(new IntervalValue(), new IntervalValue(this.getLower().getValue())));
        }
        ArrayList<IntervalDomainValue> arrayList = new ArrayList<IntervalDomainValue>();
        arrayList.add(new IntervalDomainValue(new IntervalValue(this.getUpper().getValue()), new IntervalValue()));
        arrayList.add(new IntervalDomainValue(new IntervalValue(), new IntervalValue(this.getLower().getValue())));
        return arrayList;
    }

    @Override
    public Collection<IntervalDomainValue> complementInteger() {
        if (this.isBottom()) {
            return Collections.singleton(new IntervalDomainValue());
        }
        if (this.getLower().isInfinity() && this.getUpper().isInfinity()) {
            return Collections.singleton(new IntervalDomainValue(true));
        }
        if (this.getLower().isInfinity()) {
            return Collections.singleton(new IntervalDomainValue(new IntervalValue(this.getUpper().getValue()), new IntervalValue()));
        }
        if (this.getUpper().isInfinity()) {
            return Collections.singleton(new IntervalDomainValue(new IntervalValue(), new IntervalValue(this.getLower().getValue())));
        }
        ArrayList<IntervalDomainValue> arrayList = new ArrayList<IntervalDomainValue>();
        arrayList.add(new IntervalDomainValue(new IntervalValue(this.getUpper().getValue().add(BigDecimal.ONE)), new IntervalValue()));
        arrayList.add(new IntervalDomainValue(new IntervalValue(), new IntervalValue(this.getLower().getValue().subtract(BigDecimal.ONE))));
        return arrayList;
    }
}

