/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.type;

import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;

public class BoogieTypeConstructor
implements Serializable {
    private static final long serialVersionUID = 4794962965656111904L;
    private final String name;
    private final boolean isFinite;
    private final int paramCount;
    private final int[] paramOrder;
    private final BoogieType synonym;

    public BoogieTypeConstructor(String string, boolean bl, int n, int[] nArray) {
        this(string, bl, n, nArray, null);
    }

    public BoogieTypeConstructor(String string, boolean bl, int n, int[] nArray, BoogieType boogieType) {
        this.name = string;
        this.isFinite = bl;
        this.paramCount = n;
        this.paramOrder = nArray;
        this.synonym = boogieType;
    }

    public String getName() {
        return this.name;
    }

    public int getParamCount() {
        return this.paramCount;
    }

    public int[] getParamOrder() {
        return this.paramOrder;
    }

    public BoogieType getSynonym() {
        return this.synonym;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name);
        if (this.paramOrder.length > 0) {
            stringBuilder.append('<');
            String string = "";
            int[] nArray = this.paramOrder;
            int n = this.paramOrder.length;
            int n2 = 0;
            while (n2 < n) {
                int n3 = nArray[n2];
                stringBuilder.append(string).append(n3);
                string = ",";
                ++n2;
            }
            stringBuilder.append('>');
        }
        if (this.synonym != null) {
            stringBuilder.append('=').append(this.synonym);
        }
        return stringBuilder.toString();
    }

    public boolean isFinite() {
        return this.isFinite;
    }

    public int hashCode() {
        return Objects.hash(this.isFinite, this.name, this.paramCount, Arrays.hashCode(this.paramOrder), this.synonym);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        BoogieTypeConstructor boogieTypeConstructor = (BoogieTypeConstructor)object;
        if (this.isFinite != boogieTypeConstructor.isFinite) {
            return false;
        }
        if (this.name == null ? boogieTypeConstructor.name != null : !this.name.equals(boogieTypeConstructor.name)) {
            return false;
        }
        if (this.paramCount != boogieTypeConstructor.paramCount) {
            return false;
        }
        if (!Arrays.equals(this.paramOrder, boogieTypeConstructor.paramOrder)) {
            return false;
        }
        return !(this.synonym == null ? boogieTypeConstructor.synonym != null : !this.synonym.equals(boogieTypeConstructor.synonym));
    }
}

