/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.preprocessor;

import de.uni_freiburg.informatik.ultimate.boogie.preferences.PreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.Activator;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.BoogiePreprocessorBacktranslator;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.ConstExpander;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.EnsureBoogieModelObserver;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.FunctionInliner;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.LTLStepAnnotator;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.ReplaceArrayAssignments;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.Simplifier;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.StructExpander;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.TypeChecker;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.UnstructureCode;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.memoryslicer.MemorySlicer;
import de.uni_freiburg.informatik.ultimate.boogie.symboltable.BoogieSymbolTableConstructor;
import de.uni_freiburg.informatik.ultimate.core.model.IAnalysis;
import de.uni_freiburg.informatik.ultimate.core.model.ITool;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IObserver;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.ITranslator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BoogiePreprocessor
implements IAnalysis {
    private IUltimateServiceProvider mServices;

    public String getPluginName() {
        return "Boogie Preprocessor";
    }

    public String getPluginID() {
        return Activator.PLUGIN_ID;
    }

    public void init() {
    }

    public ITool.ModelQuery getModelQuery() {
        return ITool.ModelQuery.LAST;
    }

    public List<String> getDesiredToolIds() {
        return Collections.emptyList();
    }

    public ModelType getOutputDefinition() {
        return null;
    }

    public void setInputDefinition(ModelType modelType) {
    }

    public List<IObserver> getObservers() {
        BoogiePreprocessorBacktranslator boogiePreprocessorBacktranslator = new BoogiePreprocessorBacktranslator(this.mServices);
        this.mServices.getBacktranslationService().addTranslator((ITranslator)boogiePreprocessorBacktranslator);
        boolean bl = this.mServices.getPreferenceProvider(this.getPluginID()).getBoolean("Simplify expressions");
        boolean bl2 = this.mServices.getPreferenceProvider(this.getPluginID()).getBoolean("Use memory slicer");
        boolean bl3 = this.mServices.getPreferenceProvider(this.getPluginID()).getBoolean("Replace while statements and if-then-else statements");
        ILogger iLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        BoogieSymbolTableConstructor boogieSymbolTableConstructor = new BoogieSymbolTableConstructor(iLogger);
        boogiePreprocessorBacktranslator.setSymbolTable(boogieSymbolTableConstructor.getSymbolTable());
        ArrayList<IObserver> arrayList = new ArrayList<IObserver>();
        arrayList.add((IObserver)new EnsureBoogieModelObserver());
        arrayList.add((IObserver)new TypeChecker(this.mServices));
        if (bl2) {
            arrayList.add((IObserver)new MemorySlicer(boogiePreprocessorBacktranslator, iLogger));
        }
        arrayList.add((IObserver)new ConstExpander(boogiePreprocessorBacktranslator));
        arrayList.add((IObserver)new StructExpander(boogiePreprocessorBacktranslator, iLogger));
        arrayList.add((IObserver)new ReplaceArrayAssignments(boogiePreprocessorBacktranslator));
        if (bl3) {
            arrayList.add((IObserver)new UnstructureCode(boogiePreprocessorBacktranslator));
        }
        arrayList.add((IObserver)new FunctionInliner(iLogger));
        arrayList.add((IObserver)new LTLStepAnnotator());
        if (bl) {
            arrayList.add((IObserver)new Simplifier(boogiePreprocessorBacktranslator));
        }
        arrayList.add((IObserver)boogieSymbolTableConstructor);
        return arrayList;
    }

    public boolean isGuiRequired() {
        return false;
    }

    public IPreferenceInitializer getPreferences() {
        return new PreferenceInitializer();
    }

    public void setServices(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
    }

    public void finish() {
    }
}

