/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.tree.operations.minimization.hopcroft;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IIntersectionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IMergeStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.ISinkStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.StringFactory;
import de.uni_freiburg.informatik.ultimate.automata.tree.IRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.ITreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.StringRankedLetter;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonRule;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.IsEquivalent;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.minimization.hopcroft.RuleContext;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.minimization.performance.SinkMergeIntersectStateFactory;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.ToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class MinimizeNftaHopcroft<LETTER extends IRankedLetter, STATE>
extends GeneralOperation<LETTER, STATE, IStateFactory<STATE>> {
    private final LinkedHashMap<STATE, LinkedHashSet<STATE>> mCompoundBlocks;
    private boolean mNoFinalStates;
    private final ITreeAutomatonBU<LETTER, STATE> mOperand;
    private UnionFind<STATE> mPartition;
    private STATE mPossiblyLastRoundBlockRepresentative;
    private final UnionFind<STATE> mProgressPartition;
    private ITreeAutomatonBU<LETTER, STATE> mResult;
    private final SinkMergeIntersectStateFactory<STATE> mSinkMergeIntersectFactory;

    public static void main(String[] stringArray) throws AutomataOperationCanceledException {
        AutomataLibraryServices automataLibraryServices = new AutomataLibraryServices((IUltimateServiceProvider)new ToolchainStorage());
        StringFactory stringFactory = new StringFactory();
        TreeAutomatonBU<StringRankedLetter, String> treeAutomatonBU = new TreeAutomatonBU<StringRankedLetter, String>();
        treeAutomatonBU.addState("q1");
        treeAutomatonBU.addState("q2");
        treeAutomatonBU.addState("q3");
        treeAutomatonBU.addState("q4");
        treeAutomatonBU.addState("q7");
        treeAutomatonBU.addFinalState("q5");
        treeAutomatonBU.addFinalState("q6");
        StringRankedLetter stringRankedLetter = new StringRankedLetter("a", 0);
        StringRankedLetter stringRankedLetter2 = new StringRankedLetter("g", 1);
        StringRankedLetter stringRankedLetter3 = new StringRankedLetter("f", 2);
        treeAutomatonBU.addLetter(stringRankedLetter);
        treeAutomatonBU.addLetter(stringRankedLetter3);
        treeAutomatonBU.addLetter(stringRankedLetter2);
        treeAutomatonBU.addRule(new TreeAutomatonRule<StringRankedLetter, String>(stringRankedLetter, Collections.emptyList(), "q1"));
        treeAutomatonBU.addRule(new TreeAutomatonRule<StringRankedLetter, String>(stringRankedLetter, Collections.emptyList(), "q2"));
        treeAutomatonBU.addRule(new TreeAutomatonRule<StringRankedLetter, String>(stringRankedLetter, Collections.emptyList(), "q3"));
        treeAutomatonBU.addRule(new TreeAutomatonRule<StringRankedLetter, String>(stringRankedLetter, Collections.emptyList(), "q4"));
        treeAutomatonBU.addRule(new TreeAutomatonRule<StringRankedLetter, String>(stringRankedLetter2, Collections.singletonList("q3"), "q7"));
        treeAutomatonBU.addRule(new TreeAutomatonRule<StringRankedLetter, String>(stringRankedLetter3, Arrays.asList("q1", "q2"), "q5"));
        treeAutomatonBU.addRule(new TreeAutomatonRule<StringRankedLetter, String>(stringRankedLetter3, Arrays.asList("q3", "q4"), "q6"));
        System.out.println("Tree before minimization: " + String.valueOf(treeAutomatonBU));
        Object object = new MinimizeNftaHopcroft(automataLibraryServices, stringFactory, treeAutomatonBU).getResult();
        System.out.println();
        System.out.println("Tree after minimization: " + String.valueOf(object));
    }

    public <SF extends IMergeStateFactory<STATE> & ISinkStateFactory<STATE>> MinimizeNftaHopcroft(AutomataLibraryServices automataLibraryServices, SF SF, ITreeAutomatonBU<LETTER, STATE> iTreeAutomatonBU) throws AutomataOperationCanceledException {
        super(automataLibraryServices);
        this.mSinkMergeIntersectFactory = new SinkMergeIntersectStateFactory<STATE>(SF, SF, (IIntersectionStateFactory)SF);
        this.mOperand = iTreeAutomatonBU;
        this.mResult = null;
        this.mCompoundBlocks = new LinkedHashMap();
        this.mProgressPartition = new UnionFind();
        this.mNoFinalStates = false;
        this.mPossiblyLastRoundBlockRepresentative = null;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)this.startMessage());
        }
        this.mResult = this.doOperation();
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)this.exitMessage());
        }
    }

    @Override
    public boolean checkResult(IStateFactory<STATE> iStateFactory) throws AutomataLibraryException {
        IsEquivalent<LETTER, STATE> isEquivalent = new IsEquivalent<LETTER, STATE>(this.mServices, this.mSinkMergeIntersectFactory, this.mOperand, this.mResult);
        boolean bl = isEquivalent.getResult();
        if (!bl && this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Counterexample: " + String.valueOf(isEquivalent.getCounterexample().get())));
        }
        return bl;
    }

    @Override
    public ITreeAutomatonBU<LETTER, STATE> getResult() {
        return this.mResult;
    }

    private ITreeAutomatonBU<LETTER, STATE> buildEmptyLanguageTree() {
        return new TreeAutomatonBU();
    }

    private Iterator<RuleContext<LETTER, STATE>> collectContexts(Set<STATE> set) throws AutomataOperationCanceledException {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Starting to collect contexts");
        }
        Object object = this.mPartition.find(set.iterator().next());
        NestedMap2 nestedMap2 = new NestedMap2();
        for (STATE STATE : set) {
            Map map = ((TreeAutomatonBU)this.mOperand).getPredecessors(STATE);
            for (IRankedLetter iRankedLetter : map.keySet()) {
                if (iRankedLetter.getRank() == 0) continue;
                Iterable<List<STATE>> iterable = map.get(iRankedLetter);
                for (List<STATE> list : iterable) {
                    Object object22;
                    if (this.mLogger.isDebugEnabled()) {
                        this.mLogger.debug((Object)("Looking at rule: " + String.valueOf(list) + " -" + String.valueOf(iRankedLetter) + "-> " + String.valueOf(STATE)));
                    }
                    ArrayList<Object> arrayList = new ArrayList<Object>(list.size());
                    for (Object object22 : list) {
                        Object object3 = this.mPartition.find(object22);
                        arrayList.add(object3);
                    }
                    object22 = (RuleContext)nestedMap2.get((Object)iRankedLetter, arrayList);
                    if (object22 == null) {
                        object22 = new RuleContext<IRankedLetter, Object>(arrayList, iRankedLetter, object);
                        nestedMap2.put((Object)iRankedLetter, arrayList, object22);
                    }
                    ((RuleContext)object22).addSource(list);
                    if (this.mLogger.isDebugEnabled()) {
                        this.mLogger.debug((Object)("Added rule to context: " + String.valueOf(object22)));
                    }
                    if (this.mServices.getProgressAwareTimer() == null || !this.isCancellationRequested()) continue;
                    this.mLogger.debug((Object)"Stopped at collecting contexts");
                    throw new AutomataOperationCanceledException(this.getClass());
                }
            }
        }
        return nestedMap2.values().iterator();
    }

    private ITreeAutomatonBU<LETTER, STATE> doOperation() throws AutomataOperationCanceledException {
        this.initPartition();
        if (this.mNoFinalStates) {
            return this.buildEmptyLanguageTree();
        }
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = !this.mCompoundBlocks.isEmpty();
        while (bl3) {
            STATE STATE;
            if (this.mLogger.isDebugEnabled()) {
                if (bl) {
                    this.mLogger.debug((Object)"Starting initial round");
                } else if (bl2) {
                    this.mLogger.debug((Object)"Starting last round");
                } else {
                    this.mLogger.debug((Object)"Starting round");
                }
            }
            if (!bl2) {
                STATE = this.selectBlockForRound(bl);
            } else {
                STATE = this.mPossiblyLastRoundBlockRepresentative;
                if (this.mLogger.isDebugEnabled()) {
                    this.mLogger.debug((Object)("Selected block of " + String.valueOf(STATE) + " for last round"));
                }
            }
            ImmutableSet immutableSet = this.mPartition.getContainingSet(STATE);
            Iterator<RuleContext<LETTER, STATE>> iterator = this.collectContexts((Set<STATE>)immutableSet);
            this.refineBasedOnContexts(iterator, immutableSet, bl2);
            if (bl) {
                bl = false;
            }
            if (this.mCompoundBlocks.isEmpty() && !bl2) {
                bl2 = true;
            } else if (bl2) {
                bl3 = false;
            }
            if (this.mServices.getProgressAwareTimer() == null || !this.isCancellationRequested()) continue;
            this.mLogger.debug((Object)"Stopped at end of round");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        return this.mergeUsingPartition(this.mPartition);
    }

    private void initPartition() throws AutomataOperationCanceledException {
        Object object2;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Creating initial partition");
        }
        HashSet<STATE> hashSet = new HashSet<STATE>();
        HashSet<STATE> hashSet2 = new HashSet<STATE>();
        for (Object object2 : this.mOperand.getStates()) {
            if (this.mOperand.isFinalState(object2)) {
                hashSet.add(object2);
            } else {
                hashSet2.add(object2);
            }
            if (this.mServices.getProgressAwareTimer() == null || !this.isCancellationRequested()) continue;
            this.mLogger.debug((Object)"Stopped at creating initial partition/block creation");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        if (hashSet.isEmpty()) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)"There are no final states, returning");
            }
            this.mNoFinalStates = true;
            return;
        }
        this.mPartition = new UnionFind();
        this.mPartition.addEquivalenceClass(ImmutableSet.of(hashSet));
        this.mPartition.addEquivalenceClass(ImmutableSet.of(hashSet2));
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Initial partition is: " + String.valueOf(this.mPartition)));
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Creating initial progress partition");
        }
        this.mProgressPartition.addEquivalenceClass(ImmutableSet.of(this.mOperand.getStates()));
        object2 = this.mProgressPartition.getAllRepresentatives().stream().findFirst().get();
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Initial progress partition is: " + String.valueOf(this.mProgressPartition)));
        }
        LinkedHashSet linkedHashSet = new LinkedHashSet(this.mPartition.getAllRepresentatives());
        this.mCompoundBlocks.put(object2, linkedHashSet);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Initial compound blocks are: " + String.valueOf(this.mCompoundBlocks)));
        }
    }

    private ITreeAutomatonBU<LETTER, STATE> mergeUsingPartition(UnionFind<STATE> unionFind) throws AutomataOperationCanceledException {
        Object object;
        Object object2;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Starting to construct the result");
        }
        HashMap hashMap = new HashMap();
        TreeAutomatonBU<IRankedLetter, STATE> treeAutomatonBU = new TreeAutomatonBU<IRankedLetter, STATE>();
        for (Object object3 : unionFind.getAllRepresentatives()) {
            object2 = unionFind.getEquivalenceClassMembers(object3);
            object = this.mSinkMergeIntersectFactory.merge((Collection<STATE>)object2);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Merged " + String.valueOf(object2) + " to " + String.valueOf(object)));
            }
            hashMap.put(object3, object);
            if (this.mOperand.isFinalState(object3)) {
                treeAutomatonBU.addFinalState(object);
            } else {
                treeAutomatonBU.addState(object);
            }
            if (this.mServices.getProgressAwareTimer() == null || !this.isCancellationRequested()) continue;
            this.mLogger.debug((Object)"Stopped at creating result/merging states");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        for (IRankedLetter iRankedLetter : this.mOperand.getAlphabet()) {
            treeAutomatonBU.addLetter(iRankedLetter);
            if (!this.mLogger.isDebugEnabled()) continue;
            this.mLogger.debug((Object)("Added letter: " + String.valueOf(iRankedLetter)));
        }
        for (TreeAutomatonRule treeAutomatonRule : ((TreeAutomatonBU)this.mOperand).getRules()) {
            Object object3;
            object2 = treeAutomatonRule.getSource();
            object = new ArrayList(object2.size());
            Object object4 = object2.iterator();
            while (object4.hasNext()) {
                object3 = object4.next();
                Object v = hashMap.get(unionFind.find(object3));
                object.add(v);
            }
            object3 = hashMap.get(unionFind.find(treeAutomatonRule.getDest()));
            object4 = new TreeAutomatonRule(treeAutomatonRule.getLetter(), object, object3);
            treeAutomatonBU.addRule((TreeAutomatonRule<IRankedLetter, STATE>)object4);
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Merged rule=" + String.valueOf(treeAutomatonRule) + " to mergedRule=" + String.valueOf(object4)));
            }
            if (this.mServices.getProgressAwareTimer() == null || !this.isCancellationRequested()) continue;
            this.mLogger.debug((Object)"Stopped at creating result/adding rules");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        return treeAutomatonBU;
    }

    private void refineBasedOnContexts(Iterator<RuleContext<LETTER, STATE>> iterator, ImmutableSet<STATE> immutableSet, boolean bl) throws AutomataOperationCanceledException {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Starting to refine based on contexts");
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Starting to refine partition");
            this.mLogger.debug((Object)("Partition before update is: " + String.valueOf(this.mPartition)));
        }
        UnionFind unionFind = null;
        while (iterator.hasNext()) {
            RuleContext<LETTER, STATE> ruleContext = iterator.next();
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Looking at context: " + String.valueOf(ruleContext)));
            }
            int n = 0;
            while (n < ruleContext.getSourceSize()) {
                HashSet<Object> hashSet;
                if (this.mServices.getProgressAwareTimer() != null && this.isCancellationRequested()) {
                    this.mLogger.debug((Object)"Stopped at refining based on contexts/refining relation");
                    throw new AutomataOperationCanceledException(this.getClass());
                }
                Set<STATE> set = ruleContext.getSourceStatesAtPosition(n);
                STATE STATE = ruleContext.getSourceRepresentativeAtPosition(n);
                ImmutableSet immutableSet2 = this.mPartition.getContainingSet(STATE);
                if (this.mLogger.isDebugEnabled()) {
                    hashSet = new HashSet<Object>(immutableSet2.size() - set.size());
                    for (Object e : immutableSet2) {
                        if (set.contains(e)) continue;
                        hashSet.add(e);
                    }
                    this.mLogger.debug((Object)("At position " + n + " statesAt=" + String.valueOf(set) + ", statesNotAt=" + String.valueOf(hashSet)));
                }
                if (set.size() == immutableSet2.size()) {
                    if (this.mLogger.isDebugEnabled()) {
                        this.mLogger.debug((Object)"Source position does not yield changes");
                    }
                } else {
                    Object object;
                    if (unionFind == null) {
                        unionFind = this.mPartition.clone();
                    }
                    hashSet = new HashSet();
                    for (Object e : immutableSet2) {
                        object = unionFind.find(e);
                        hashSet.add(object);
                    }
                    for (Object e : hashSet) {
                        object = unionFind.getContainingSet(e);
                        HashSet hashSet2 = new HashSet();
                        HashSet hashSet3 = new HashSet();
                        Iterator iterator2 = object.iterator();
                        while (iterator2.hasNext()) {
                            Object e2 = iterator2.next();
                            if (set.contains(e2)) {
                                hashSet2.add(e2);
                                continue;
                            }
                            hashSet3.add(e2);
                        }
                        if (hashSet2.isEmpty() || hashSet3.isEmpty()) continue;
                        unionFind.removeAll((Collection)object);
                        unionFind.addEquivalenceClass(ImmutableSet.of(hashSet2));
                        unionFind.addEquivalenceClass(ImmutableSet.of(hashSet3));
                        if (!this.mLogger.isDebugEnabled()) continue;
                        this.mLogger.debug((Object)("Split block into: " + String.valueOf(hashSet2) + " and " + String.valueOf(hashSet3)));
                    }
                }
                ++n;
            }
        }
        if (unionFind != null) {
            this.mPartition = unionFind;
        } else if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Contexts did not yield any changes, partition was not refined");
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Partition after update is: " + String.valueOf(this.mPartition)));
        }
        if (this.mServices.getProgressAwareTimer() != null && this.isCancellationRequested()) {
            this.mLogger.debug((Object)"Stopped at refining based on contexts/after updating partition");
            throw new AutomataOperationCanceledException(this.getClass());
        }
        if (bl) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)"Last round, skipping update of compound blocks and progress partition");
            }
            return;
        }
        this.updateCompoundBlocksAndProgressPartition(immutableSet);
    }

    private STATE selectBlockForRound(boolean bl) {
        int n;
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Selecting a compound block for this round");
        }
        LinkedHashSet<STATE> linkedHashSet = this.mCompoundBlocks.values().stream().findFirst().get();
        if (bl) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)"Round is initial");
            }
            assert (linkedHashSet.size() == 2);
            STATE STATE = null;
            Object var4_5 = null;
            for (Object e : linkedHashSet) {
                if (this.mOperand.isFinalState(e)) {
                    STATE = (STATE)e;
                    continue;
                }
                var4_5 = e;
            }
            assert (STATE != null && var4_5 != null);
            this.mPossiblyLastRoundBlockRepresentative = var4_5;
            return STATE;
        }
        Iterator iterator = linkedHashSet.iterator();
        Object e = iterator.next();
        Object e2 = iterator.next();
        int n2 = this.mPartition.getContainingSet(e).size();
        if (n2 < (n = this.mPartition.getContainingSet(e2).size())) {
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Block of " + String.valueOf(e) + " is smaller than block of " + String.valueOf(e2)));
            }
            this.mPossiblyLastRoundBlockRepresentative = e2;
            return (STATE)e;
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Block of " + String.valueOf(e2) + " is smaller than block of " + String.valueOf(e)));
        }
        this.mPossiblyLastRoundBlockRepresentative = e;
        return (STATE)e2;
    }

    private void updateCompoundBlocksAndProgressPartition(ImmutableSet<STATE> immutableSet) throws AutomataOperationCanceledException {
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Starting to update compound blocks and progress partition");
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Progress partition before update is: " + String.valueOf(this.mProgressPartition)));
        }
        this.mProgressPartition.removeAll(immutableSet);
        this.mProgressPartition.addEquivalenceClass(immutableSet);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Progress partition after update is: " + String.valueOf(this.mProgressPartition)));
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Compound blocks before update are: " + String.valueOf(this.mCompoundBlocks)));
        }
        this.mCompoundBlocks.clear();
        HashMap hashMap = new HashMap();
        for (Object e : this.mPartition.getAllRepresentatives()) {
            Object object;
            Object v;
            if (this.mServices.getProgressAwareTimer() != null && this.isCancellationRequested()) {
                this.mLogger.debug((Object)"Stopped at updating compound blocks");
                throw new AutomataOperationCanceledException(this.getClass());
            }
            if (this.mLogger.isDebugEnabled()) {
                this.mLogger.debug((Object)("Looking at partition block of " + String.valueOf(e)));
            }
            if ((v = hashMap.get(object = this.mProgressPartition.find(e))) == null) {
                hashMap.put(object, e);
                if (!this.mLogger.isDebugEnabled()) continue;
                this.mLogger.debug((Object)("Block was first for progress block " + String.valueOf(object)));
                continue;
            }
            LinkedHashSet<Object> linkedHashSet = this.mCompoundBlocks.get(object);
            if (linkedHashSet == null) {
                linkedHashSet = new LinkedHashSet();
                linkedHashSet.add(v);
                this.mCompoundBlocks.put(object, linkedHashSet);
            }
            linkedHashSet.add(e);
            if (!this.mLogger.isDebugEnabled()) continue;
            this.mLogger.debug((Object)("Progress block " + String.valueOf(object) + " is compound, currently is: " + String.valueOf(linkedHashSet)));
        }
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Compound blocks after update are: " + String.valueOf(this.mCompoundBlocks)));
        }
    }

    protected ITreeAutomatonBU<LETTER, STATE> getOperand() {
        return this.mOperand;
    }
}

