/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.relation;

import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.AbstractRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class SymmetricHashRelation<E>
extends HashRelation<E, E> {
    public SymmetricHashRelation() {
    }

    public SymmetricHashRelation(AbstractRelation<E, E, ?, ?> abstractRelation) {
        super(abstractRelation);
    }

    @Override
    public boolean addPair(E e, E e2) {
        boolean bl = super.addPair(e, e2);
        super.addPair(e2, e);
        return bl;
    }

    @Override
    public boolean removePair(E e, E e2) {
        boolean bl = super.removePair(e, e2);
        boolean bl2 = super.removePair(e2, e);
        assert (bl == bl2);
        return bl;
    }

    public Set<Doubleton<E>> buildSetOfDoubletons() {
        HashSet hashSet = new HashSet();
        for (Map.Entry entry : this.getSetOfPairs()) {
            hashSet.add(new Doubleton(entry.getKey(), entry.getValue()));
        }
        return hashSet;
    }

    public Set<Doubleton<E>> buildSetOfNonSymmetricDoubletons() {
        HashSet hashSet = new HashSet();
        for (Map.Entry entry : this.getSetOfPairs()) {
            if (entry.getKey().equals(entry.getValue())) continue;
            hashSet.add(new Doubleton(entry.getKey(), entry.getValue()));
        }
        return hashSet;
    }

    public Set<Doubleton<E>> makeTransitive() {
        HashSet<Doubleton<Doubleton<E>>> hashSet = new HashSet<Doubleton<Doubleton<E>>>();
        Set<Doubleton<E>> set = this.buildSetOfDoubletons();
        while (!set.isEmpty()) {
            HashSet<Doubleton<Doubleton<E>>> hashSet2 = new HashSet<Doubleton<Doubleton<E>>>();
            for (Doubleton<E> doubleton : set) {
                for (Object r : this.getImage(doubleton.getOneElement())) {
                    if (this.containsPair(doubleton.getOtherElement(), r)) continue;
                    hashSet2.add(new Doubleton<E>(doubleton.getOtherElement(), r));
                }
                for (Object r : this.getImage(doubleton.getOtherElement())) {
                    if (this.containsPair(doubleton.getOneElement(), r)) continue;
                    hashSet2.add(new Doubleton<E>(doubleton.getOneElement(), r));
                }
            }
            set = hashSet2;
            for (Doubleton<E> doubleton : hashSet2) {
                this.addPair(doubleton.getOneElement(), doubleton.getOtherElement());
            }
            hashSet.addAll(hashSet2);
        }
        return hashSet;
    }
}

