/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.dpll;

import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.Theory;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.ClauseDeletionHook;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleListable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofLiteral;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofRules;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import java.util.Arrays;

public class Clause
extends SimpleListable<Clause> {
    Literal[] mLiterals;
    Clause mNextFirstWatch;
    Clause mNextSecondWatch;
    int mNextIsSecond;
    double mActivity;
    final int mStacklevel;
    ProofNode mProof;
    ClauseDeletionHook mCleanupHook;

    public int getSize() {
        return this.mLiterals.length;
    }

    public Literal getLiteral(int n) {
        return this.mLiterals[n];
    }

    public Clause(Literal[] literalArray) {
        this.mLiterals = literalArray;
        this.mStacklevel = this.computeStackLevel();
    }

    public Clause(Literal[] literalArray, ProofNode proofNode) {
        this.mLiterals = literalArray;
        this.mProof = proofNode;
        this.mStacklevel = this.computeStackLevel();
    }

    public Clause(Literal[] literalArray, int n) {
        this.mLiterals = literalArray;
        this.mStacklevel = Math.max(n, this.computeStackLevel());
    }

    public Clause(Literal[] literalArray, ResolutionNode resolutionNode, int n) {
        this.mLiterals = literalArray;
        this.mProof = resolutionNode;
        this.mStacklevel = Math.max(n, this.computeStackLevel());
    }

    private final int computeStackLevel() {
        int n = 0;
        Literal[] literalArray = this.mLiterals;
        int n2 = this.mLiterals.length;
        int n3 = 0;
        while (n3 < n2) {
            Literal literal = literalArray[n3];
            if (literal.getAtom().mAssertionstacklevel > n) {
                n = literal.getAtom().mAssertionstacklevel;
            }
            ++n3;
        }
        return n;
    }

    public String toString() {
        return Arrays.toString(this.mLiterals);
    }

    public void setActivityInfinite() {
        this.mActivity = Double.POSITIVE_INFINITY;
    }

    public void setProof(ProofNode proofNode) {
        this.mProof = proofNode;
    }

    public ProofNode getProof() {
        return this.mProof;
    }

    public void setDeletionHook(ClauseDeletionHook clauseDeletionHook) {
        this.mCleanupHook = clauseDeletionHook;
    }

    public boolean doCleanup(DPLLEngine dPLLEngine) {
        return this.mCleanupHook == null ? true : this.mCleanupHook.clauseDeleted(this, dPLLEngine);
    }

    public boolean contains(Literal literal) {
        Literal[] literalArray = this.mLiterals;
        int n = this.mLiterals.length;
        int n2 = 0;
        while (n2 < n) {
            Literal literal2 = literalArray[n2];
            if (literal2 == literal) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Term toTerm(Theory theory) {
        if (this.mLiterals.length == 0) {
            return theory.mFalse;
        }
        if (this.mLiterals.length == 1) {
            return this.mLiterals[0].getSMTFormula(theory);
        }
        Term[] termArray = new Term[this.mLiterals.length];
        int n = 0;
        while (n < this.mLiterals.length) {
            termArray[n] = this.mLiterals[n].getSMTFormula(theory);
            ++n;
        }
        return theory.term("or", termArray);
    }

    public Term[] toTermArray(Theory theory) {
        Term[] termArray = new Term[this.mLiterals.length];
        int n = 0;
        while (n < this.mLiterals.length) {
            termArray[n] = this.mLiterals[n].getSMTFormula(theory);
            ++n;
        }
        return termArray;
    }

    public ProofLiteral[] toProofLiterals(ProofRules proofRules) {
        ProofLiteral[] proofLiteralArray = new ProofLiteral[this.mLiterals.length];
        int n = 0;
        while (n < proofLiteralArray.length) {
            Literal literal = this.mLiterals[n];
            proofLiteralArray[n] = new ProofLiteral(literal.getAtom().getSMTFormula(proofRules.getTheory()), literal == literal.getAtom());
            ++n;
        }
        return proofLiteralArray;
    }

    static final class WatchList {
        Clause mHead = null;
        int mHeadIndex;
        Clause mTail = null;
        int mTailIndex;
        int mSize;

        public boolean isEmpty() {
            return this.mHead == null;
        }

        public int size() {
            return this.mSize;
        }

        public void prepend(Clause clause, int n) {
            if (this.mHead == null) {
                this.mTail = clause;
                this.mTailIndex = n;
            } else if (n == 0) {
                assert (clause.mNextFirstWatch == null);
                clause.mNextFirstWatch = this.mHead;
                clause.mNextIsSecond |= this.mHeadIndex;
            } else {
                assert (clause.mNextSecondWatch == null);
                clause.mNextSecondWatch = this.mHead;
                clause.mNextIsSecond |= this.mHeadIndex << 1;
            }
            this.mHead = clause;
            this.mHeadIndex = n;
            ++this.mSize;
        }

        public void append(Clause clause, int n) {
            if (this.mHead == null) {
                this.mHead = clause;
                this.mHeadIndex = n;
            } else {
                Clause clause2 = this.mTail;
                if (this.mTailIndex == 0) {
                    assert (clause2.mNextFirstWatch == null);
                    clause2.mNextFirstWatch = clause;
                    clause2.mNextIsSecond |= n;
                } else {
                    assert (clause2.mNextSecondWatch == null);
                    clause2.mNextSecondWatch = clause;
                    clause2.mNextIsSecond |= n << 1;
                }
            }
            this.mTail = clause;
            this.mTailIndex = n;
            ++this.mSize;
        }

        public int getIndex() {
            return this.mHeadIndex;
        }

        public Clause removeFirst() {
            Clause clause = this.mHead;
            if (this.mHeadIndex == 0) {
                this.mHead = clause.mNextFirstWatch;
                this.mHeadIndex = clause.mNextIsSecond & 1;
                clause.mNextFirstWatch = null;
                clause.mNextIsSecond &= 2;
            } else {
                this.mHead = clause.mNextSecondWatch;
                this.mHeadIndex = (clause.mNextIsSecond & 2) >> 1;
                clause.mNextSecondWatch = null;
                clause.mNextIsSecond &= 1;
            }
            if (this.mHead == null) {
                this.mTail = null;
                this.mTailIndex = 0;
            }
            --this.mSize;
            return clause;
        }

        public void moveAll(WatchList watchList) {
            if (watchList.mHead == null) {
                return;
            }
            this.append(watchList.mHead, watchList.mHeadIndex);
            this.mSize += watchList.mSize - 1;
            this.mTail = watchList.mTail;
            this.mTailIndex = watchList.mTailIndex;
            watchList.mHead = null;
            watchList.mHeadIndex = 0;
            watchList.mTail = null;
            watchList.mTailIndex = 0;
            watchList.mSize = 0;
        }
    }
}

