/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.test_generator;

import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.LogProxy;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.SimpleList;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;
import de.uni_freiburg.informatik.ultimate.smtinterpol.test_generator.Generator;
import java.io.PrintWriter;
import java.util.ArrayList;

public class TBenchmark
extends SMTInterpol {
    Generator mGenerator;

    public TBenchmark(LogProxy logProxy, PrintWriter printWriter) {
        super(logProxy);
        this.mGenerator = new Generator(printWriter);
        this.setOption(":regular-output-channel", "stderr");
        this.setOption(":interactive-mode", true);
        this.setOption(":print-success", false);
    }

    @Override
    public void push(int n) throws SMTLIBException {
        super.push(n);
        this.mGenerator.addPush(n);
    }

    @Override
    public void pop(int n) throws SMTLIBException {
        super.pop(n);
        this.mGenerator.addPop(n);
    }

    @Override
    public Script.LBool checkSat() throws SMTLIBException {
        this.generate();
        return Script.LBool.UNKNOWN;
    }

    @Override
    public void setLogic(String string) throws UnsupportedOperationException, SMTLIBException {
        super.setLogic(Logics.valueOf((String)string));
        this.mGenerator.setLogic(string);
    }

    @Override
    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        Script.LBool lBool = super.assertTerm(term);
        return lBool;
    }

    @Override
    public void declareFun(String string, Sort[] sortArray, Sort sort) throws SMTLIBException {
        super.declareFun(string, sortArray, sort);
        this.mGenerator.addFuncDec(string, sortArray, sort);
    }

    public void declareSort(String string, int n) throws SMTLIBException {
        super.declareSort(string, n);
        this.mGenerator.addSortDec(string, n);
    }

    public void defineFun(String string, TermVariable[] termVariableArray, Sort sort, Term term) throws SMTLIBException {
        super.defineFun(string, termVariableArray, sort, term);
        this.mGenerator.addFuncDef(string, termVariableArray, sort, term);
    }

    public void defineSort(String string, Sort[] sortArray, Sort sort) throws SMTLIBException {
        super.defineSort(string, sortArray, sort);
        this.mGenerator.addSortDef(string, sortArray, sort);
    }

    public void exit() {
        super.exit();
        this.mGenerator.exit();
    }

    public void generate() throws SMTLIBException {
        this.getAssertions();
        SimpleList<Clause> simpleList = this.getEngine().getClauses();
        ArrayList<Clause> arrayList = new ArrayList<Clause>();
        for (Clause clause : simpleList) {
            arrayList.add(clause);
        }
    }
}

