/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures.relation;

import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.IsContained;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Quad;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class HashRelation3<K1, K2, K3>
implements Iterable<Triple<K1, K2, K3>> {
    private final NestedMap3<K1, K2, K3, IsContained> mBackingMap = new NestedMap3();

    public boolean isEmpty() {
        return this.mBackingMap.size() == 0;
    }

    public boolean addTriple(K1 K1, K2 K2, K3 K3) {
        IsContained isContained = this.mBackingMap.put(K1, K2, K3, IsContained.IsContained);
        return isContained == IsContained.IsContained;
    }

    public void addAllTriples(K1 K1, K2 K2, Collection<K3> collection) {
        for (K3 K3 : collection) {
            this.addTriple(K1, K2, K3);
        }
    }

    public boolean containsTriple(K1 K1, K2 K2, K3 K3) {
        IsContained isContained = this.mBackingMap.get(K1, K2, K3);
        return isContained == IsContained.IsContained;
    }

    public Set<K1> projectToFst() {
        return this.mBackingMap.keySet();
    }

    public Set<K2> projectToSnd(K1 K1) {
        NestedMap2<K2, K3, IsContained> nestedMap2 = this.mBackingMap.get(K1);
        if (nestedMap2 == null) {
            return Collections.emptySet();
        }
        return nestedMap2.keySet();
    }

    public Set<K3> projectToTrd(K1 K1, K2 K2) {
        Map<K3, IsContained> map = this.mBackingMap.get(K1, K2);
        if (map == null) {
            return Collections.emptySet();
        }
        return map.keySet();
    }

    @Override
    public Iterator<Triple<K1, K2, K3>> iterator() {
        return new Iterator<Triple<K1, K2, K3>>(){
            Iterator<Quad<K1, K2, K3, IsContained>> mBackingMapIterator;
            private Triple<K1, K2, K3> mNext;
            {
                this.mBackingMapIterator = HashRelation3.this.mBackingMap.entrySet().iterator();
            }

            @Override
            public boolean hasNext() {
                if (this.mNext != null) {
                    return true;
                }
                this.findNext();
                return this.mNext != null;
            }

            private void findNext() {
                if (this.mNext != null) {
                    return;
                }
                Quad quad = null;
                while (this.mBackingMapIterator.hasNext()) {
                    Quad quad2 = this.mBackingMapIterator.next();
                    if (quad2.getFourth() == null) continue;
                    quad = quad2;
                    break;
                }
                if (quad != null) {
                    if (!$assertionsDisabled && quad.getFourth() == null) {
                        throw new AssertionError();
                    }
                    this.mNext = new Triple(quad.getFirst(), quad.getSecond(), quad.getThird());
                } else {
                    this.mNext = null;
                }
            }

            @Override
            public Triple<K1, K2, K3> next() {
                this.findNext();
                if (this.mNext == null) {
                    throw new UnsupportedOperationException("check hasNext first");
                }
                Triple triple = this.mNext;
                this.mNext = null;
                return triple;
            }
        };
    }

    public Iterator<Triple<K1, K2, K3>> iterator(K1 K1) {
        return new Iterator<Triple<K1, K2, K3>>(K1){
            Iterator<Quad<K1, K2, K3, IsContained>> mBackingMapIterator;
            {
                this.mBackingMapIterator = HashRelation3.this.mBackingMap.entries(object).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mBackingMapIterator.hasNext();
            }

            @Override
            public Triple<K1, K2, K3> next() {
                Quad quad = this.mBackingMapIterator.next();
                return new Triple(quad.getFirst(), quad.getSecond(), quad.getThird());
            }
        };
    }

    public String toStringAsTable() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Triple<K1, K2, K3> triple : this) {
            stringBuilder.append(String.valueOf(triple.getFirst()) + ", " + String.valueOf(triple.getSecond()) + ", " + String.valueOf(triple.getThird()) + System.lineSeparator());
        }
        return stringBuilder.toString();
    }
}

