/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.services;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.UltimateCore;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.exceptions.LogfileException;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.preferences.CorePreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.Log4JWrapper;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.KeyValueUtil;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILoggingService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IStorable;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.preferences.RcpPreferenceProvider;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggerRepository;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public final class Log4JLoggingService
implements IStorable,
ILoggingService {
    private static final String APPENDER_NAME_CONSOLE = "ConsoleAppender";
    private static final String APPENDER_NAME_LOGFILE = "LogfileAppender";
    private static final String APPENDER_NAME_CONTROLLER = "ControllerAppender";
    private static final String LOGGER_NAME_CONTROLLER = "controller";
    private static final String LOGGER_NAME_NONCONTROLLER = "noncontroller";
    private static final String LOGGER_NAME_CORE = "noncontroller.de.uni_freiburg.informatik.ultimate.core";
    private static final String LOGGER_NAME_TOOLS = "noncontroller.tools";
    private static final String LOGGER_NAME_PLUGINS = "noncontroller.plugins";
    private static final String LOGGER_NAME_PREFIX_TOOLS = "external.";
    private static final String STORE_KEY = "LoggingService";
    private final RcpPreferenceProvider mPreferenceStore = new RcpPreferenceProvider("de.uni_freiburg.informatik.ultimate.core");
    private final IEclipsePreferences.IPreferenceChangeListener mRefreshingListener;
    private final Set<Appender> mRootAppenders = new HashSet<Appender>();
    private final Set<Appender> mControllerAppenders = new HashSet<Appender>();
    private String mCurrentControllerName;
    private boolean mIsAttached;
    private Map<String, Level> mSettingsLogger2LogLevel;
    private Set<String> mRelevantSettings;
    private List<String> mPluginSpecificLogLevelSettingLabels;

    private Log4JLoggingService() {
        this.resetLoggerLevels();
        this.reinitializeDefaultAppenders();
        this.reattachAppenders();
        this.mRefreshingListener = new RefreshingPreferenceChangeListener();
        this.mPreferenceStore.addPreferenceChangeListener(this.mRefreshingListener);
        this.mIsAttached = true;
    }

    public void reloadLoggers() {
        this.resetLoggerLevels();
        this.reinitializeDefaultAppenders();
        this.reattachAppenders();
        this.getLogger("de.uni_freiburg.informatik.ultimate.core").debug((Object)"Logger refreshed");
    }

    private void reinitializeDefaultAppenders() {
        this.mRootAppenders.clear();
        this.mControllerAppenders.clear();
        PatternLayout patternLayout = new PatternLayout(this.mPreferenceStore.getString("Logger pattern"));
        ConsoleAppender consoleAppender = new ConsoleAppender((Layout)patternLayout);
        consoleAppender.setName(APPENDER_NAME_CONSOLE);
        this.mRootAppenders.add((Appender)consoleAppender);
        PatternLayout patternLayout2 = new PatternLayout(this.mPreferenceStore.getString("UI logger pattern"));
        ConsoleAppender consoleAppender2 = new ConsoleAppender((Layout)patternLayout2);
        consoleAppender2.setName(APPENDER_NAME_CONTROLLER);
        this.mControllerAppenders.add((Appender)consoleAppender2);
        if (this.mPreferenceStore.getBoolean("Create a Logfile")) {
            String string = this.mPreferenceStore.getString("Name of the log file");
            String string2 = this.mPreferenceStore.getString("Directory (default: instance location)");
            String string3 = this.mPreferenceStore.getString("Logger pattern");
            boolean bl = this.mPreferenceStore.getBoolean("Append to exisiting log file");
            String string4 = string2 + File.separator + string + ".log";
            PatternLayout patternLayout3 = new PatternLayout(string3);
            try {
                FileAppender fileAppender = new FileAppender((Layout)patternLayout3, string4, bl);
                fileAppender.setName(APPENDER_NAME_LOGFILE);
                this.mRootAppenders.add((Appender)fileAppender);
                this.mControllerAppenders.add((Appender)fileAppender);
            }
            catch (IOException iOException) {
                throw new LogfileException(iOException);
            }
        }
    }

    private void reattachAppenders() {
        Log4JLoggingService.reattachAppenders(Logger.getLogger((String)LOGGER_NAME_NONCONTROLLER), this.mRootAppenders);
        Log4JLoggingService.reattachAppenders(Logger.getLogger((String)LOGGER_NAME_CONTROLLER), this.mControllerAppenders);
    }

    private static void reattachAppenders(Logger logger, Collection<Appender> collection) {
        for (Appender appender : collection) {
            logger.removeAppender(appender.getName());
            logger.addAppender(appender);
        }
    }

    private void resetLoggerLevels() {
        Logger logger = Log4JLoggingService.getLog4JRootLogger();
        Level level = this.getLogLevelPreference("Root log level");
        logger.setLevel(level);
        this.mSettingsLogger2LogLevel = this.getSettingsLogger2Level();
        LoggerRepository loggerRepository = logger.getLoggerRepository();
        for (Map.Entry<String, Level> entry : this.mSettingsLogger2LogLevel.entrySet()) {
            loggerRepository.getLogger(entry.getKey()).setLevel(entry.getValue());
        }
    }

    private Map<String, Level> getSettingsLogger2Level() {
        Map.Entry<String, Level> entry22;
        HashMap<String, Level> hashMap = new HashMap<String, Level>();
        hashMap.put(LOGGER_NAME_CONTROLLER, this.getLogLevelPreference("Log level for controller plugin"));
        hashMap.put(LOGGER_NAME_NONCONTROLLER, this.getLogLevelPreference("Root log level"));
        hashMap.put(LOGGER_NAME_PLUGINS, this.getLogLevelPreference("Log level for plugins"));
        hashMap.put(LOGGER_NAME_TOOLS, this.getLogLevelPreference("Log level for external tools"));
        hashMap.put(LOGGER_NAME_CORE, this.getLogLevelPreference("Log level for core plugin"));
        Map<String, Level> map = this.getSettingPluginSpecificLogLevels();
        for (Map.Entry<String, Level> object2 : map.entrySet()) {
            hashMap.put(Log4JLoggingService.getPluginLoggerName(object2.getKey()), object2.getValue());
        }
        Map<String, Level> map2 = this.getSettingToolSpecificLogLevels("Log level for specific external tool");
        for (Map.Entry<String, Level> entry22 : map2.entrySet()) {
            hashMap.put(Log4JLoggingService.getToolLoggerName(entry22.getKey()), entry22.getValue());
        }
        entry22 = this.getSettingToolSpecificLogLevels("Log level for class");
        for (Map.Entry entry : entry22.entrySet()) {
            hashMap.put(Log4JLoggingService.getPluginLoggerName((String)entry.getKey()), (Level)entry.getValue());
        }
        return hashMap;
    }

    private Level getLogLevelPreference(String string) {
        return Level.toLevel((String)this.mPreferenceStore.getString(string));
    }

    private static boolean isExternalTool(String string) {
        return string.startsWith(LOGGER_NAME_PREFIX_TOOLS);
    }

    private Logger lookupLoggerInHierarchy(String string) {
        String string2 = this.getActualLoggerName(string);
        Logger logger = Logger.getLogger((String)string2);
        Level level = this.mSettingsLogger2LogLevel.get(string2);
        logger.setLevel(level);
        return logger;
    }

    private String getActualLoggerName(String string) {
        if (string.equals("de.uni_freiburg.informatik.ultimate.core")) {
            return LOGGER_NAME_CORE;
        }
        assert (this.mCurrentControllerName != null) : "There is no controller";
        if (string.equals(this.mCurrentControllerName) || string.equals(LOGGER_NAME_CONTROLLER)) {
            return LOGGER_NAME_CONTROLLER;
        }
        if (Log4JLoggingService.isExternalTool(string)) {
            return Log4JLoggingService.getToolLoggerName(string);
        }
        return Log4JLoggingService.getPluginLoggerName(string);
    }

    private static String getToolLoggerName(String string) {
        return "noncontroller.tools.external." + string;
    }

    private static String getPluginLoggerName(String string) {
        return "noncontroller.plugins." + string;
    }

    public void setCurrentControllerID(String string) {
        this.mCurrentControllerName = string;
    }

    public void destroy() {
        this.mPreferenceStore.removePreferenceChangeListener(this.mRefreshingListener);
        this.mIsAttached = false;
    }

    public ILogger getLogger(String string) {
        return Log4JLoggingService.wrapLogger(this.lookupLoggerInHierarchy(string));
    }

    public ILogger getLogger(Class<?> clazz) {
        return this.getLogger(clazz.getName());
    }

    public ILogger getLoggerForExternalTool(String string) {
        return this.getLogger(LOGGER_NAME_PREFIX_TOOLS + string);
    }

    public ILogger getControllerLogger() {
        return this.getLogger(LOGGER_NAME_CONTROLLER);
    }

    private static Logger getLog4JRootLogger() {
        return Logger.getRootLogger();
    }

    public void addWriter(Writer writer, String string) {
        Log4JAppenderWrapper log4JAppenderWrapper = new Log4JAppenderWrapper(writer, string);
        if (!this.mRootAppenders.add((Appender)log4JAppenderWrapper)) {
            return;
        }
        Log4JLoggingService.getLog4JRootLogger().addAppender((Appender)log4JAppenderWrapper);
    }

    public void removeWriter(Writer writer) {
        Log4JAppenderWrapper log4JAppenderWrapper = new Log4JAppenderWrapper(writer, null);
        this.mRootAppenders.remove((Object)log4JAppenderWrapper);
        Log4JLoggingService.getLog4JRootLogger().removeAppender((Appender)log4JAppenderWrapper);
    }

    private Map<String, Level> getSettingPluginSpecificLogLevels() {
        LinkedHashMap<String, Level> linkedHashMap = new LinkedHashMap<String, Level>();
        for (String string : this.getPluginSpecificLogLevelSettingLabels()) {
            CorePreferenceInitializer.InheritableLogLevel inheritableLogLevel = this.mPreferenceStore.getEnum(string, CorePreferenceInitializer.InheritableLogLevel.class);
            if (inheritableLogLevel == CorePreferenceInitializer.InheritableLogLevel.INHERITED) continue;
            linkedHashMap.put(CorePreferenceInitializer.getPluginIdFromLabelLogLevelForSpecificPlugin(string), Level.toLevel((String)inheritableLogLevel.toString()));
        }
        return linkedHashMap;
    }

    private Map<String, Level> getSettingToolSpecificLogLevels(String string) {
        Map map = KeyValueUtil.toMap((String)this.mPreferenceStore.getString(string));
        LinkedHashMap<String, Level> linkedHashMap = new LinkedHashMap<String, Level>();
        for (Map.Entry entry : map.entrySet()) {
            linkedHashMap.put((String)entry.getKey(), Level.toLevel((String)((String)entry.getValue())));
        }
        return linkedHashMap;
    }

    private static ILogger wrapLogger(Logger logger) {
        return new Log4JWrapper(logger);
    }

    public Object getBacking(ILogger iLogger, Class<?> clazz) {
        if (iLogger == null || clazz == null) {
            return null;
        }
        if (Logger.class.isAssignableFrom(clazz) && iLogger instanceof Log4JWrapper) {
            Log4JWrapper log4JWrapper = (Log4JWrapper)iLogger;
            return log4JWrapper.getBacking();
        }
        return null;
    }

    static Log4JLoggingService getService(IToolchainStorage iToolchainStorage) {
        assert (iToolchainStorage != null);
        IStorable iStorable = iToolchainStorage.getStorable(STORE_KEY);
        if (iStorable == null) {
            iStorable = new Log4JLoggingService();
            iToolchainStorage.putStorable(STORE_KEY, iStorable);
        }
        return (Log4JLoggingService)iStorable;
    }

    public void store(IToolchainStorage iToolchainStorage) {
        iToolchainStorage.putStorable(STORE_KEY, (IStorable)this);
        if (!this.mIsAttached) {
            this.mPreferenceStore.addPreferenceChangeListener(this.mRefreshingListener);
            this.reloadLoggers();
        }
    }

    public void setLogLevel(Class<?> clazz, ILogger.LogLevel logLevel) {
        this.setLogLevel(clazz.getName(), logLevel);
    }

    public void setLogLevel(String string, ILogger.LogLevel logLevel) {
        this.mSettingsLogger2LogLevel.put(Log4JLoggingService.getPluginLoggerName(string), Level.toLevel((String)logLevel.toString()));
    }

    private List<String> getPluginSpecificLogLevelSettingLabels() {
        if (this.mPluginSpecificLogLevelSettingLabels == null) {
            this.mPluginSpecificLogLevelSettingLabels = Arrays.stream(UltimateCore.getPluginNames()).map(CorePreferenceInitializer::getLabelLogLevelForSpecificPlugin).collect(Collectors.toList());
        }
        return this.mPluginSpecificLogLevelSettingLabels;
    }

    private Set<String> getRelevantSettings() {
        if (this.mRelevantSettings == null) {
            this.mRelevantSettings = new HashSet<String>();
            this.mRelevantSettings.addAll(this.getPluginSpecificLogLevelSettingLabels());
            this.mRelevantSettings.add("Logger pattern");
            this.mRelevantSettings.add("Create a Logfile");
            this.mRelevantSettings.add("Name of the log file");
            this.mRelevantSettings.add("Directory (default: instance location)");
            this.mRelevantSettings.add("Append to exisiting log file");
            this.mRelevantSettings.add("Root log level");
            this.mRelevantSettings.add("Log level for external tools");
            this.mRelevantSettings.add("Log level for core plugin");
            this.mRelevantSettings.add("Log level for controller plugin");
            this.mRelevantSettings.add("Log level for plugins");
            this.mRelevantSettings.add("Debug log message color");
            this.mRelevantSettings.add("Info log message color");
            this.mRelevantSettings.add("Warning log message color");
            this.mRelevantSettings.add("Error log message color");
            this.mRelevantSettings.add("Fatal log message color");
            this.mRelevantSettings.add("UI logger pattern");
            this.mRelevantSettings.add("Log level for class");
            this.mRelevantSettings.add("Log level for specific external tool");
        }
        return this.mRelevantSettings;
    }

    private static final class Log4JAppenderWrapper
    extends WriterAppender {
        private final Writer mWriter;

        private Log4JAppenderWrapper(Writer writer, String string) {
            this.mWriter = writer;
            this.setWriter(writer);
            if (string != null) {
                this.setLayout((Layout)new PatternLayout(string));
            }
            this.setImmediateFlush(true);
        }

        public int hashCode() {
            return Objects.hash(this.mWriter);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != object.getClass()) {
                return false;
            }
            Log4JAppenderWrapper log4JAppenderWrapper = (Log4JAppenderWrapper)((Object)object);
            return !(this.mWriter == null ? log4JAppenderWrapper.mWriter != null : !this.mWriter.equals(log4JAppenderWrapper.mWriter));
        }
    }

    private final class RefreshingPreferenceChangeListener
    implements IEclipsePreferences.IPreferenceChangeListener {
        private RefreshingPreferenceChangeListener() {
        }

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent preferenceChangeEvent) {
            Object object = preferenceChangeEvent.getNewValue();
            Object object2 = preferenceChangeEvent.getOldValue();
            if (object == null && object2 == null) {
                return;
            }
            if (object != null && object.equals(object2)) {
                return;
            }
            String string = preferenceChangeEvent.getKey();
            if (!Log4JLoggingService.this.getRelevantSettings().contains(string)) {
                return;
            }
            Log4JLoggingService.this.reloadLoggers();
        }
    }
}

