/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLAtom;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.DPLLEngine;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.LeafNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.CompositeReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAAnnotation;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinArSolve;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LiteralReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MutableAffineTerm;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Map;

public class Explainer {
    private final LinArSolve mSolver;
    private final Map<LAReason, LAAnnotation> mSubReasons;
    private final Literal mExplainedLiteral;
    private final ArrayDeque<LAAnnotation> mAnnotationStack;

    public Explainer(LinArSolve linArSolve, boolean bl, Literal literal) {
        this.mSolver = linArSolve;
        this.mExplainedLiteral = literal;
        this.mSubReasons = new HashMap<LAReason, LAAnnotation>();
        this.mAnnotationStack = new ArrayDeque();
        this.mAnnotationStack.add(new LAAnnotation());
    }

    public boolean canExplainWith(Literal literal) {
        DPLLAtom dPLLAtom = literal.getAtom();
        return dPLLAtom.getStackPosition() >= 0 && (this.mExplainedLiteral == null || this.mExplainedLiteral.getAtom().getStackPosition() == -1 || dPLLAtom.getStackPosition() < this.mExplainedLiteral.getAtom().getStackPosition());
    }

    public void addAnnotation(LAReason lAReason, Rational rational) {
        assert (rational.signum() > 0 == lAReason.isUpper());
        Rational rational2 = Rational.valueOf((long)rational.signum(), (long)1L);
        LAAnnotation lAAnnotation = this.mSubReasons.get(lAReason);
        if (lAAnnotation == null) {
            lAAnnotation = new LAAnnotation(lAReason);
            if (this.mAnnotationStack != null) {
                this.mAnnotationStack.addLast(lAAnnotation);
            }
            lAReason.explain(this, lAReason.getVar().getEpsilon(), rational2);
            if (this.mAnnotationStack != null) {
                this.mAnnotationStack.removeLast();
            }
            if (!this.mSubReasons.containsKey(lAReason)) {
                this.mSubReasons.put(lAReason, lAAnnotation);
            }
        }
        if (this.mAnnotationStack != null) {
            this.mAnnotationStack.getLast().addFarkas(lAAnnotation, rational);
        }
    }

    public void addEQAnnotation(LiteralReason literalReason, Rational rational) {
        assert (rational.signum() > 0 == literalReason.isUpper());
        Rational rational2 = Rational.valueOf((long)rational.signum(), (long)1L);
        LAAnnotation lAAnnotation = this.mSubReasons.get(literalReason);
        if (lAAnnotation == null) {
            lAAnnotation = new LAAnnotation(literalReason);
            this.mAnnotationStack.addLast(lAAnnotation);
            this.addAnnotation(literalReason.getOldReason(), rational2);
            this.addLiteral(literalReason.getLiteral().negate(), rational2);
            this.mAnnotationStack.removeLast();
            this.mSubReasons.put(literalReason, lAAnnotation);
        }
        this.mAnnotationStack.getLast().addFarkas(lAAnnotation, rational);
    }

    public void addLiteral(Literal literal, Rational rational) {
        if (this.mAnnotationStack != null) {
            this.mAnnotationStack.getLast().addFarkas(literal, rational);
        }
    }

    private boolean validClause() {
        if (this.mAnnotationStack == null) {
            return true;
        }
        assert (this.mAnnotationStack.size() == 1);
        MutableAffineTerm mutableAffineTerm = this.mAnnotationStack.getFirst().addLiterals();
        assert (mutableAffineTerm.isConstant() && InfinitesimalNumber.ZERO.less(mutableAffineTerm.getConstant()));
        for (Map.Entry<LAReason, LAAnnotation> entry : this.mSubReasons.entrySet()) {
            LAReason lAReason = entry.getKey();
            mutableAffineTerm = entry.getValue().addLiterals();
            Rational rational = lAReason.isUpper() ? Rational.MONE : Rational.ONE;
            mutableAffineTerm.add(rational, lAReason.getVar());
            mutableAffineTerm.add(lAReason.getBound().mul(rational.negate()));
            mutableAffineTerm.add(lAReason.getVar().getEpsilon());
            assert (mutableAffineTerm.isConstant() && InfinitesimalNumber.ZERO.less(mutableAffineTerm.getConstant()));
        }
        return true;
    }

    public Clause createClause(DPLLEngine dPLLEngine) {
        assert (this.mAnnotationStack.size() == 1);
        LAAnnotation lAAnnotation = this.mAnnotationStack.getLast();
        Literal[] literalArray = lAAnnotation.collectLiterals();
        Clause clause = new Clause(literalArray);
        if (dPLLEngine.isProofGenerationEnabled()) {
            clause.setProof(new LeafNode(-4, lAAnnotation));
        }
        assert (this.validClause());
        return clause;
    }

    public int getDecideLevel() {
        return this.mExplainedLiteral == null ? this.mSolver.getEngine().getDecideLevel() : this.mExplainedLiteral.getAtom().getDecideLevel();
    }

    public Literal createComposite(CompositeReason compositeReason) {
        return this.mSolver.createCompositeLiteral(compositeReason, this.mExplainedLiteral);
    }

    public boolean checkSlack(InfinitesimalNumber infinitesimalNumber) {
        assert (this.mAnnotationStack.size() == 1);
        assert (infinitesimalNumber.signum() > 0);
        MutableAffineTerm mutableAffineTerm = this.mAnnotationStack.getFirst().addLiterals();
        assert (mutableAffineTerm.isConstant() && mutableAffineTerm.getConstant().signum() > 0);
        assert (mutableAffineTerm.getConstant().sub(infinitesimalNumber).signum() >= 0 && mutableAffineTerm.getConstant().mReal.equals((Object)infinitesimalNumber.mReal));
        return true;
    }
}

