/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.petrinet.operations;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.GeneralOperation;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsIncludedBuchi;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.IPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.BoundedPetriNet;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.PetriNetUtils;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.netdatastructures.Transition;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.operations.BuchiPetriNet2FiniteAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBlackWhiteStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IBuchiIntersectStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IPetriNet2FiniteAutomatonStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BuchiIntersect<LETTER, PLACE>
extends GeneralOperation<LETTER, PLACE, IPetriNet2FiniteAutomatonStateFactory<PLACE>> {
    private final IPetriNet<LETTER, PLACE> mPetriNet;
    private final INestedWordAutomaton<LETTER, PLACE> mBuchiAutomata;
    private final IBlackWhiteStateFactory<PLACE> mLabeledBuchiPlaceFactory;
    private final Map<PLACE, PLACE> mInputQGetQ1 = new HashMap<PLACE, PLACE>();
    private final Map<PLACE, PLACE> mInputQGetQ2 = new HashMap<PLACE, PLACE>();
    private final Map<PLACE, PLACE> mInputQ2GetQ = new HashMap<PLACE, PLACE>();
    private final BoundedPetriNet<LETTER, PLACE> mIntersectionNet;

    public BuchiIntersect(AutomataLibraryServices automataLibraryServices, IBlackWhiteStateFactory<PLACE> iBlackWhiteStateFactory, IPetriNet<LETTER, PLACE> iPetriNet, INestedWordAutomaton<LETTER, PLACE> iNestedWordAutomaton) {
        super(automataLibraryServices);
        this.mPetriNet = iPetriNet;
        this.mBuchiAutomata = iNestedWordAutomaton;
        this.mLogger.info((Object)this.startMessage());
        if (iNestedWordAutomaton.getInitialStates().size() != 1) {
            throw new IllegalArgumentException("Buchi with multiple initial states not supported.");
        }
        this.mLabeledBuchiPlaceFactory = iBlackWhiteStateFactory;
        this.mIntersectionNet = new BoundedPetriNet(automataLibraryServices, iPetriNet.getAlphabet(), false);
        this.constructIntersectionNet();
        this.mLogger.info((Object)this.exitMessage());
    }

    private final void constructIntersectionNet() {
        this.addPlacesToIntersectionNet();
        this.addTransitionsToIntersectionNet();
    }

    private final void addPlacesToIntersectionNet() {
        this.addOriginalPetriPlaces();
        this.addOriginalBuchiPlaces();
    }

    private final void addOriginalPetriPlaces() {
        for (PLACE PLACE : this.mPetriNet.getPlaces()) {
            this.mIntersectionNet.addPlace(PLACE, this.mPetriNet.getInitialPlaces().contains(PLACE), false);
        }
    }

    private final void addOriginalBuchiPlaces() {
        for (PLACE PLACE : this.mBuchiAutomata.getStates()) {
            PLACE PLACE2 = this.mLabeledBuchiPlaceFactory.getWhiteContent(PLACE);
            PLACE PLACE3 = this.mLabeledBuchiPlaceFactory.getBlackContent(PLACE);
            this.mIntersectionNet.addPlace(PLACE2, this.mBuchiAutomata.isInitial(PLACE), false);
            this.mIntersectionNet.addPlace(PLACE3, false, this.mBuchiAutomata.isFinal(PLACE));
            this.mInputQGetQ1.put(PLACE, PLACE2);
            this.mInputQGetQ2.put(PLACE, PLACE3);
            this.mInputQ2GetQ.put(PLACE3, PLACE);
        }
    }

    private final void addTransitionsToIntersectionNet() {
        for (Transition<LETTER, PLACE> transition : this.mPetriNet.getTransitions()) {
            for (PLACE PLACE : this.mBuchiAutomata.getStates()) {
                for (OutgoingInternalTransition<LETTER, PLACE> outgoingInternalTransition : this.mBuchiAutomata.internalSuccessors(PLACE, transition.getSymbol())) {
                    this.addStateOneAndTwoTransition(transition, outgoingInternalTransition, PLACE);
                }
            }
        }
    }

    private final void addStateOneAndTwoTransition(Transition<LETTER, PLACE> transition, OutgoingInternalTransition<LETTER, PLACE> outgoingInternalTransition, PLACE PLACE) {
        Set<PLACE> set = this.getTransitionPredecessors(transition, PLACE, true);
        Set<PLACE> set2 = this.getTransitionSuccessors(transition, outgoingInternalTransition, set, true);
        this.mIntersectionNet.addTransition(transition.getSymbol(), ImmutableSet.of(set), ImmutableSet.of(set2));
        set = this.getTransitionPredecessors(transition, PLACE, false);
        set2 = this.getTransitionSuccessors(transition, outgoingInternalTransition, set, false);
        this.mIntersectionNet.addTransition(transition.getSymbol(), ImmutableSet.of(set), ImmutableSet.of(set2));
    }

    private final Set<PLACE> getTransitionPredecessors(Transition<LETTER, PLACE> transition, PLACE PLACE, boolean bl) {
        HashSet<PLACE> hashSet = new HashSet<PLACE>(transition.getPredecessors());
        if (bl) {
            hashSet.add(this.mInputQGetQ1.get(PLACE));
        } else {
            hashSet.add(this.mInputQGetQ2.get(PLACE));
        }
        return hashSet;
    }

    private final Set<PLACE> getTransitionSuccessors(Transition<LETTER, PLACE> transition, OutgoingInternalTransition<LETTER, PLACE> outgoingInternalTransition, Set<PLACE> set, boolean bl) {
        HashSet<PLACE> hashSet = new HashSet<PLACE>(transition.getSuccessors());
        if (bl) {
            hashSet.add(this.getQSuccesorForStateOneTransition(transition, outgoingInternalTransition));
        } else {
            hashSet.add(this.getQSuccesorForStateTwoTransition(set, outgoingInternalTransition));
        }
        return hashSet;
    }

    private PLACE getQSuccesorForStateOneTransition(Transition<LETTER, PLACE> transition, OutgoingInternalTransition<LETTER, PLACE> outgoingInternalTransition) {
        for (Object e : transition.getSuccessors()) {
            if (!this.mPetriNet.getAcceptingPlaces().contains(e)) continue;
            return this.mInputQGetQ2.get(outgoingInternalTransition.getSucc());
        }
        return this.mInputQGetQ1.get(outgoingInternalTransition.getSucc());
    }

    private PLACE getQSuccesorForStateTwoTransition(Set<PLACE> set, OutgoingInternalTransition<LETTER, PLACE> outgoingInternalTransition) {
        for (PLACE PLACE : set) {
            if (!this.mInputQ2GetQ.containsKey(PLACE) || !this.mBuchiAutomata.getFinalStates().contains(this.mInputQ2GetQ.get(PLACE))) continue;
            return this.mInputQGetQ1.get(outgoingInternalTransition.getSucc());
        }
        return this.mInputQGetQ2.get(outgoingInternalTransition.getSucc());
    }

    @Override
    public String startMessage() {
        return "Starting Intersection";
    }

    @Override
    public String exitMessage() {
        return "Exiting Intersection";
    }

    @Override
    public IPetriNet<LETTER, PLACE> getResult() {
        return this.mIntersectionNet;
    }

    @Override
    public boolean checkResult(IPetriNet2FiniteAutomatonStateFactory<PLACE> iPetriNet2FiniteAutomatonStateFactory) throws AutomataLibraryException {
        Object object;
        Object object2;
        Object object3;
        Object object4 = new BuchiPetriNet2FiniteAutomaton<LETTER, PLACE>(this.mServices, iPetriNet2FiniteAutomatonStateFactory, (IBlackWhiteStateFactory)((Object)iPetriNet2FiniteAutomatonStateFactory), this.mPetriNet).getResult();
        Object object5 = new BuchiPetriNet2FiniteAutomaton<LETTER, PLACE>(this.mServices, iPetriNet2FiniteAutomatonStateFactory, (IBlackWhiteStateFactory)((Object)iPetriNet2FiniteAutomatonStateFactory), this.mIntersectionNet).getResult();
        IsIncludedBuchi isIncludedBuchi = new IsIncludedBuchi(this.mServices, (INwaInclusionStateFactory)((Object)iPetriNet2FiniteAutomatonStateFactory), object5, object3 = new de.uni_freiburg.informatik.ultimate.automata.nestedword.buchi.BuchiIntersect<LETTER, PLACE>(this.mServices, (IBuchiIntersectStateFactory)((Object)iPetriNet2FiniteAutomatonStateFactory), object4, this.mBuchiAutomata).getResult());
        if (!isIncludedBuchi.getResult().booleanValue()) {
            object2 = isIncludedBuchi.getCounterexample().getNestedLassoWord();
            object = this.mServices.getLoggingService().getLogger(PetriNetUtils.class);
            object.error((Object)("Intersection recognizes incorrect word : " + String.valueOf(object2)));
        }
        if (!((IsIncludedBuchi)(object2 = new IsIncludedBuchi(this.mServices, (INwaInclusionStateFactory)((Object)iPetriNet2FiniteAutomatonStateFactory), object3, object5))).getResult().booleanValue()) {
            object = ((IsIncludedBuchi)object2).getCounterexample().getNestedLassoWord();
            ILogger iLogger = this.mServices.getLoggingService().getLogger(PetriNetUtils.class);
            iLogger.error((Object)("Intersection not recognizing word of correct intersection : " + String.valueOf(object)));
        }
        return isIncludedBuchi.getResult() != false && ((IsIncludedBuchi)object2).getResult() != false;
    }
}

